C +++
C
C Source: src/utils/pre/histo3.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	histo3.F
C Revision 1.7  92/01/16  14:50:27  cwelnak
C 6000 changes
C 
C Revision 1.6  91/12/18  21:50:27  khan
C fixed the array dimensions to be correct ones to pass to RBEAM()
C 
C Revision 1.5  1991/07/06  19:20:42  khan
C Grenoble Changes ...
C
C Revision 1.4  91/04/05  15:57:20  cwelnak
C changed quotes on #includes
C 
C Revision 1.3  91/03/25  16:24:54  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.2  91/01/25  16:50:26  khan
C Ported to Ultrix
C 
C Revision 1.1  90/10/10  13:12:56  khan
C Added Pre-processor directives for Unix/VMS compilations
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C
C	PROGRAM		HISTO3
C
C	PURPOSE		Generates a three-dimensional histogram from an
C			output file of SHADOW. The purpose is that of
C			optimizing the source. In some optical systems the
C			number of rays traced through may be very small
C			because of the mismatch between a standard source
C			and the system etendue. This program defines the
C			fraction of phase space that generates ``good''
C			rays and limits the source generation to that 
C			volume. Notice that HISTO3 assumes that the
C			variables (x,y,z) are independent.
C
C	INPUT		A ray file generated by SHADOWIT or REFLAG containing the
C			BEGIN.DAT file with the lost rays so labeled. 
C
C	OUTPUT		A file for use by SHADOW in the SOURCE 
C			generation.
C
C	ALGORITHM	The program will create three arrays that
C			are filled with 1's when at least one ray falls
C			within the limits.
C---
	IMPLICIT 	REAL*8 	(A-H,O-Z)
#if defined(unix) || HAVE_F77_CPP
#   	include		<dim.par>
#elif defined(vms)
    	INCLUDE		'SHADOW$INC:DIM.PAR/LIST'
#endif
     	CHARACTER*80	INFILE, OUTFILE, RSTRING
     	DIMENSION	IX(101,101), IY(101,101), IZ(101,101)
     	DIMENSION	RAY (12, N_DIM), PHASE(3, N_DIM)
	DIMENSION	AP(3, N_DIM), TEST(6)
C
C Inquires about ray file
C
     	INFILE	=  RSTRING ('Input  file ? ')
     	OUTFILE =  RSTRING ('Output      ? ')
C
C Open file and read it
C
     	CALL RBEAM (INFILE, RAY, PHASE, AP, NCOL, NPOINT, IFLAG, IERR)
     	IF (IERR.NE.0) STOP
C
C Prepare arrays
C
	KOUNT = 0
     	DO 11 I=1,NPOINT
     	 IF (RAY(10,I).LT.0.0) KOUNT = KOUNT + 1
11     	CONTINUE
	WRITE(6,*)'Found ',(NPOINT-KOUNT),' good points out of',NPOINT
     	XMIN =   1.0D+20
     	XMAX = - 1.0D+20
     	YMIN =   1.0D+20
     	YMAX = - 1.0D+20
     	ZMIN =   1.0D+20
     	ZMAX = - 1.0D+20

     	X1MIN =   1.0D+20
     	X1MAX = - 1.0D+20
     	Y1MIN =   1.0D+20
     	Y1MAX = - 1.0D+20
     	Z1MIN =   1.0D+20
     	Z1MAX = - 1.0D+20
     	DO 300 I=1,NPOINT
	   IF (RAY(10,I).LT.0.0D0)   GO TO 300
     	TEST(1)	=   RAY(1,I)
     	TEST(2)	=   RAY(2,I)
     	TEST(3)	=   RAY(3,I)
     	TEST(4)	=   RAY(4,I)
     	TEST(5)	=   RAY(5,I)
     	TEST(6)	=   RAY(6,I)
     	XMIN = MIN(XMIN,TEST(1))
     	XMAX = MAX(XMAX,TEST(1))
     	YMIN = MIN(YMIN,TEST(2))
     	YMAX = MAX(YMAX,TEST(2))
     	ZMIN = MIN(ZMIN,TEST(3))
        ZMAX = MAX(ZMAX,TEST(3))
     	X1MIN = MIN(X1MIN,TEST(4))
     	X1MAX = MAX(X1MAX,TEST(4))
     	Y1MIN = MIN(Y1MIN,TEST(5))
     	Y1MAX = MAX(Y1MAX,TEST(5))
     	Z1MIN = MIN(Z1MIN,TEST(6))
300     Z1MAX = MAX(Z1MAX,TEST(6))

     	WRITE(6,*)'Here we are.'

     	WRITE(6,*)'X max is',XMAX
     	WRITE(6,*)'X min is',XMIN
     	WRITE(6,*)'Y max is',YMAX
     	WRITE(6,*)'Y min is',YMIN
     	WRITE(6,*)'Z max is',ZMAX
     	WRITE(6,*)'Z min is',ZMIN

     	WRITE(6,*)'X prime max is',X1MAX
     	WRITE(6,*)'X prime min is',X1MIN
     	WRITE(6,*)'Y prime max is',Y1MAX
     	WRITE(6,*)'Y prime min is',Y1MIN
     	WRITE(6,*)'Z prime max is',Z1MAX
     	WRITE(6,*)'Z prime min is',Z1MIN
C
C Inquire about the histogram size
C
     	NX  = IRINT ('How many bins in X  [ default 25 ] ? ')
     	IF (NX.EQ.0) NX = 25
     	NX1 = IRINT ('How many bins in X` 		 ? ')
     	IF (NX1.EQ.0) NX1 = 25
     	NY  = IRINT ('How many bins in Y  		 ? ')
     	IF (NY.EQ.0) NY = 25
     	NY1 = IRINT ('How many bins in Y` 		 ? ')
     	IF (NY1.EQ.0) NY1 = 25
     	NZ  = IRINT ('How many bins in Z  		 ? ')
     	IF (NZ.EQ.0) NZ = 25
     	NZ1 = IRINT ('How many bins in Z` 		 ? ')
     	IF (NZ1.EQ.0) NZ1 = 25
C
C Compute histogram steps
C
     	XS	=  (XMAX - XMIN)    /NX
     	XS1	=  (X1MAX - X1MIN)/NX1
     	YS	=  (YMAX - YMIN)    /NY
     	YS1	=  (Y1MAX - Y1MIN)/NY1
     	ZS	=  (ZMAX - ZMIN)    /NZ
     	ZS1	=  (Z1MAX - Z1MIN)/NZ1
C
C Build now the arrays
C
     	DO 12 I=1,NPOINT
     	 IF (RAY(10,I).GE.0.0) THEN
      	   JX  = 1
     	   JY  = 1
     	   JZ  = 1
     	   JX1 = 1
     	   JY1 = 1
     	   JZ1 = 1
     	  IF (ABS(XS).GT.1.0D-10)  JX  = (RAY(1,I) - XMIN)   /XS  + 1
     	  IF (ABS(XS1).GT.1.0D-10) JX1 = (RAY(4,I) - X1MIN) /XS1 + 1
     	  IF (ABS(YS).GT.1.0D-10)  JY  = (RAY(2,I) - YMIN)   /YS  + 1
     	  IF (ABS(YS1).GT.1.0D-10) JY1 = (RAY(5,I) - Y1MIN) /YS1 + 1
     	  IF (ABS(ZS).GT.1.0D-10)  JZ  = (RAY(3,I) - ZMIN)   /ZS  + 1
     	  IF (ABS(ZS1).GT.1.0D-10) JZ1 = (RAY(6,I) - Z1MIN) /ZS1 + 1
     	   IX (JX,JX1) = 1
     	   IY (JY,JY1) = 1
     	   IZ (JZ,JZ1) = 1
     	 END IF
12     	CONTINUE
C
C Write out arrays
C
     	OPEN (21, FILE=OUTFILE, STATUS='UNKNOWN', FORM='UNFORMATTED')
	REWIND (21)
     	WRITE (21) NX,  XMIN,   XS
     	WRITE (21) NX1, X1MIN, XS1
     	WRITE (21) NY,  YMIN,   YS
     	WRITE (21) NY1, Y1MIN, YS1
     	WRITE (21) NZ,  ZMIN,   ZS
     	WRITE (21) NZ1, Z1MIN, ZS1
     	DO 13 I=1,NX
     	  WRITE (21) (IX(I,J),J=1,NX1)
13     	CONTINUE
     	DO 14 I=1,NY
     	  WRITE (21) (IY(I,J),J=1,NY1)
14     	CONTINUE
     	DO 16 I=1,NZ
     	  WRITE (21) (IZ(I,J),J=1,NZ1)
16     	CONTINUE
     	CLOSE (21)
C
C All done. Wrap up and go home.
C
D     	WRITE (21,*) NX,  XMIN,   XS
D     	WRITE (21,*) NX1, X1MIN, XS1
D     	WRITE (21,*) NY,  YMIN,   YS
D     	WRITE (21,*) NY1, Y1MIN, YS1
D     	WRITE (21,*) NZ,  ZMIN,   ZS
D     	WRITE (21,*) NZ1, Z1MIN, ZS1
D     	DO I=1,NX
D     	  WRITE (21,1000) (IX(I,J),J=1,NX1)
D     	CONTINUE
D     	WRITE (21,*)
D     	DO I=1,NY
D     	  WRITE (21,1000) (IY(I,J),J=1,NY1)
D     	CONTINUE
D     	WRITE (21,*)
D     	DO I=1,NZ
D     	  WRITE (21,1000) (IZ(I,J),J=1,NZ1)
D     	CONTINUE
D1000	FORMAT (1X,<NX>(1X,I2))
C
     	STOP
     	END
