C+++
C	PROGRAM		GRADE_MLAYER
c
c	PURPOSE		To compute bi-cubic splines fitting a user
C			supplied multilayer.  The spline fitting is adapted
C			directly from PRESURFACE.FOR.
C
C	INPUT		Files (2) in the format:
C				Nx, Ny
C				Y(1),...,Y(Ny)
C				X(1),F(1,1),...,F(1,Ny)
C				.....
C				X(Nx),F(Nx,1),...,F(Nx,Ny)
C			where F(i,j) will be the thickness factor for the first 
C			file, and the gamma factor for the second file.
C
C	Output		A file containing the spline array prepared by
C			IMSL function IBCCCU
C---
     	IMPLICIT	REAL*8	(A-H,O-Z)
     	CHARACTER*80	INFILE,OUTFILE,RSTRING
     	DIMENSION	CSPL (2,101,2,101), WK (20602)
     	DIMENSION	X(101),Y(101),F(101,101)

	WRITE(6,*) 'For a graded multilayer, you will specify the '
        WRITE(6,*) 'factor MULTIPLYING the thickness'
     	WRITE(6,*) 't and the gamma ratio, across the optical surface.'
     	WRITE(6,*) 'In PRE_MLAYER, you have already defined the nominal'
        WRITE(6,*) ' t and gamma AT THE ORIGIN.  Here you will specify'
	WRITE(6,*) 'their multiplication factor F(x,y).  For non-graded'
	WRITE(6,*) 'multilayer, F(x,y) = 1.0.'
	WRITE(6,*) '***************************************************'

	ITER	= 1
     	OUTFILE	=   RSTRING ('Enter file-name for output: ')
#ifdef vms
     	OPEN (21, FILE=OUTFILE, STATUS='NEW', FORM='UNFORMATTED')
#else
     	OPEN (21, FILE=OUTFILE, STATUS='UNKNOWN', FORM='UNFORMATTED')
	REWIND (21)
#endif

15	WRITE(6,*) ' '
	IF (ITER.EQ.1) THEN
     	  INFILE = RSTRING ('File containing the t factor mesh : ')
	ELSE
	  INFILE = RSTRING ('File containing the gamma factor mesh : ')
	END IF

#ifdef vms
     	OPEN	(20, FILE=INFILE, STATUS='OLD', READONLY, IOSTAT = IERR)
#else
     	OPEN	(20, FILE=INFILE, STATUS='OLD', IOSTAT = IERR)
#endif

     	IF (IERR.NE.0) THEN
     	  WRITE(6,*) 'Cannot access ',INFILE
     	  IWHAT = IYES ('Retry ? ')
     	 IF (IWHAT.EQ.1) GOTO 15
     	  CALL EXIT
     	END IF
     	READ (20,*) NX, NY
     	IF (NX.GT.101.OR.NY.GT.101) THEN
     	  WRITE(6,*) 'Arrays too large. Maximum allowed is 101 points.'
     	  STOP 'Please retry with smaller arrays.'
     	END IF
     	IF (NX.LT.4.OR.NY.LT.4) THEN
     	  WRITE(6,*) 'Not enough points to define arrays. Must be at',
     $		' least 4 points in each direction.'
     	  STOP 'Please retry with larger arrays.'
     	END IF
     	WRITE(6,*) 'Setting up ',NX,' by ',NY,' array.'
C
C Reads in Y array
C
     	READ (20,*) (Y(I),I=1,NY)
C
C Now read X and F arrays
C
     	DO I=1,NX
     	  READ (20,*) X(I),(F(I,J),J=1,NY)
     	END DO
     	CLOSE (20)
     	WRITE(6,*) 'Array read correctly. Compute spline.'
C
C Call IMSL routine to compute spline
C
     	CALL	IBCCCU ( F, X, NX, Y, NY, CSPL, 101, WK, IER)
     	IF (IER.EQ.132) THEN
     	  WRITE(6,*) 'The X and/or Y array are not ordered properly. 
     $ Please check data in ',INFILE
     	 CALL EXIT
     	END IF
     	WRITE(6,*) 'Spline succesfully completed.'
     	 WRITE (21)	NX, NY
     	 WRITE (21)	X,Y
	 DO 299 I = 1, NX
	 DO 299 J = 1, NY
     	 WRITE (21)	CSPL(1,I,1,J), CSPL(1,I,2,J), 
     $		CSPL(2,I,1,J), CSPL(2,I,2,J)
299	 CONTINUE
C     	 WRITE (21)	(((CSPL(1,I,1,J), CSPL(1,I,2,J), 
C     $		CSPL(2,I,1,J), CSPL(2,I,2,J)), J = 1,NY), I = 1,NX)

	IF (ITER.EQ.1) THEN
	  ITER   = 2
	  GO TO 15
	END IF
	CLOSE	(21)
     	WRITE(6,*) 'Task completed. Spline stored in ',OUTFILE
     	CALL	EXIT
     	END
