C +++
C
C Source: src/utils/post/sourcinfo.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: sourcinfo.F
C Revision 1.6  1992/01/16  11:02:24  cwelnak
C 6000 changes
C
C Revision 1.5  91/07/06  19:43:52  khan
C Grenoble Changes ...
C 
C Revision 1.4  91/04/05  15:50:57  cwelnak
C changed quotes in #includes
C 
C Revision 1.3  91/03/25  15:56:36  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.2  91/01/25  16:47:59  khan
C Ported to Ultrix
C 
C Revision 1.1  90/10/08  17:03:49  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	PROGRAM		SOURCE_INFO
C
C	PURPOSE		Create a 'nice' printable file with complete
C			source specifications.
C
C	INPUT		A STARTxx.DAT file.
C
C---
     	PROGRAM		SOURCE_INFO
#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../../include/common.blk'
c	INCLUDE         './../../include/namelist.blk'
c
c
#	include		<common.blk>
#	include		<namelist.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
     	INCLUDE		'SHADOW$INC:NAMELIST.BLK/LIST'
#endif
     	CHARACTER *80	COMMENT,TITLE
     	DIMENSION	WAVE(10)
     	CHARACTER *71	TOPLIN
     	DATA	TOPLIN	/
     $'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'/
     	CHARACTER * 32 		FILE_OUT
     	CHARACTER * 60		FILETEXT
     	CHARACTER * 17		DATETEXT
     	CHARACTER *20		BREAK, TANG(12), TSPATIAL(12)
     	CHARACTER *12		TPOL (3), TPHOT(12), TDEPTH(12)
     	CHARACTER *80		INFILE
     	DATA	TSPATIAL(1)	/'POINT       '/
     	DATA	TSPATIAL(4)	/'GAUSSIAN    '/
     	DATA	TSPATIAL(2)	/'RECTANGULAR '/
     	DATA	TSPATIAL(3)	/'ELLIPTICAL  '/
	DATA	TSPATIAL(5)	/'PHASE SPACE ELLIPSE'/
     	DATA	TDEPTH(1)	/'DEPTH OFF   '/
     	DATA	TDEPTH(2)	/'DEPTH ON    '/
     	DATA	TDEPTH(3) 	/'RECTANGULAR '/
     	DATA	TDEPTH(4) 	/'GAUSSIAN    '/
     	DATA	TDEPTH(5)	/'SYNCHROTRON '/
     	DATA	TANG(1)		/'UNIFORM     '/
     	DATA	TANG(2)		/'LAMBERTIAN  '/
     	DATA	TANG(3)		/'GAUSSIAN    '/
     	DATA	TANG(4)		/'SYNCHROTRON '/
     	DATA	TANG(5)		/'CONICAL     '/
	DATA	TANG(6)		/'SYNCHROTRON (exact)'/
	DATA	TANG(7)		/'PHASE SPACE ELLIPSE'/
     	DATA	TPHOT(1)	/'PHOTON OFF  '/
     	DATA	TPHOT(2)	/'PHOTON ON   '/
     	DATA	TPHOT(3)	/'SINGLE LINE '/
     	DATA	TPHOT(4)	/'MULTI LINE  '/
     	DATA	TPHOT(5)	/'BOX DISTR.  '/
     	DATA	TPOL(1)		/'SR PARALLEL '/
     	DATA	TPOL(2)		/'SR PERPEND  '/
     	DATA	TPOL(3)		/'SR TOTAL    '/
     	DATA	BREAK	/'    ----------------'/
C#if vms
C     	CALL	LIB$ERASE_PAGE(1,1)
C#elif unix
C        CALL system('clear') 
C#endif
	CALL CLSCREEN
     	WRITE(6,*) 
     $'------------------ S O U R C I N F O --------------------'
     	WRITE(6,*) 
     $'                  vs. 2.01   Feb 1989'
     	WRITE(6,*) ' '
     	GO TO 1
20	WRITE(6,*) 'Error reading the NAMELIST.'
     	STOP
10     	WRITE(6,*) 'Error opening: ',INFILE
1     	CALL ALINE ('INPUT> File containing source specs ?',INFILE)
     	CALL	ALINE ('INPUT> Title ? ',TITLE)
     	CALL	ALINE ('INPUT> Comment ? ',COMMENT)
     	CALL	ALINE ('INPUT> Output file-name ? ',FILE_OUT)
     	WRITE(6,*) 'SYSINF> Prepare output to file : ',FILE_OUT
#ifdef vms
     	OPEN (30,FILE=FILE_OUT,STATUS='NEW',CARRIAGECONTROL='LIST')
#else
     	OPEN (30,FILE=FILE_OUT,STATUS='UNKNOWN')
	REWIND (30)
#endif
     	WRITE (30,*) TOPLIN
     	WRITE (30,*)
     $'**************  S O U R C E       ',
     $'D E S C R I P T I O N  **************'
     	WRITE (30,*) TITLE
     	WRITE (30,*) COMMENT
     	WRITE (30,*) TOPLIN
     	WRITE (30,*) 'Input file specified:',INFILE
#ifdef vms
     	  CALL	FILEINFO  (INFILE)
     	  CALL	NEXTFILE  (FILETEXT,DATETEXT)
#else
	filetext = ' '
	call get_file_text(filetext,INFILE)
	DATETEXT = ' '
#endif
	  WRITE (30,1500)	FILETEXT
1500	FORMAT (1X,'Full file Specification :',A)
     	  WRITE (30,1501)	DATETEXT
1501	FORMAT (1X,'Creation Date           :',A)
     	  WRITE (30,*)	TOPLIN
     	IDUMM = 1
     	CALL	RWNAME ( INFILE,'R_SOUR', IDUMM)
     	IF (IDUMM.EQ.-1) GO TO 20
     	IF (IDUMM.EQ.-2) GO TO 10
     	WRITE(6,*) 'SOURCE_INFO> File ',INFILE,' read correctly.'
C
C Prepares now the output to the file.
C
C
C Type of computation
C
     	IF (FGRID.EQ.0) THEN
     	  WRITE (30,2000)  
2000	FORMAT (1X,'Random Source.')
     	ELSE IF (FGRID.EQ.1) THEN
     	  WRITE (30,2001) 
2001	FORMAT (1X,'Grid Source.')
     	ELSE IF (FGRID.EQ.2) THEN
     	  WRITE (30,2002)
2002	FORMAT (1X,'Mixed Type Source. Spatial: GRID  ,
     $ directions: RANDOM')
     	ELSE IF (FGRID.EQ.3) THEN
     	  WRITE (30,2003)
2003	FORMAT (1X,'Mixed Type Source. Spatial: RANDOM,
     $ directions: GRID')
	ELSE IF (FGRID.EQ.4) THEN
	  WRITE (30,2004)
2004	FORMAT (1X,'Phase space ellipses. RANDOM around each ellipse.')
	ELSE IF (FGRID.EQ.5) THEN
	  WRITE (30,2005)
2005	FORMAT (1X,'Phase space ellipses. GRID around each ellipse.')
     	END IF
	WRITE (30,2006) NPOINT
2006	FORMAT (1X,'Generated total ',I12,' rays.')
C
C SOURCE as of Nov. 1985 is independent of SHADOW and always generates a 
C new source.
C
C Old/New SOURCE
C
C     	IF (F_NEW.EQ.0) THEN
C     	WRITE (30,*) 'Used an OLD source file. Complete file specs
C     $ follow.'
C     	  CALL	FILEINFO  (FILE_SOURCE)
C     	  CALL	NEXTFILE  (FILETEXT,DATETEXT)
C	  WRITE (30,1500)	FILETEXT
C     	  WRITE (30,1501)	DATETEXT
C     	WRITE (30,*) TOPLIN
C     	CALL	EXIT
C     	END IF
C
C Spatial type and values
C
     	IF (FSOURCE_DEPTH.EQ.1) THEN
     	  WRITE (30,2008)
2008	FORMAT (1X,'Source assumed BIDIMENSIONAL (flat).')
     	ELSE
     	  WRITE (30,2009)
2009	FORMAT (1X,'Source assumed TRIDIMENSIONAL.')
     	END IF
     	WRITE (30,2010) 	TSPATIAL (FSOUR+1)
2010	FORMAT (1X,'Source Spatial Characteristics: ',A20)
     	IF (FSOUR.EQ.1.OR.FSOUR.EQ.2) THEN 
     	  WRITE (30,2020) WXSOU,WZSOU
2020	FORMAT (1X,'Source Width: ',G17.9,' and Height: ',G17.9)
     	ELSE IF (FSOUR.EQ.3.OR.FSOUR.EQ.4) THEN
     	  WRITE (30,2030) SIGMAX,SIGMAZ
2030	FORMAT (1X,'Sigma X     : ',G17.9,' Sigma Z   : ',G17.9)
     	END IF
     	IF (FSOURCE_DEPTH.EQ.2) THEN
     	  WRITE (30,2040) WYSOU
2040	FORMAT (1X,'Depth:  UNIFORM      Value   : ',G17.9)
     	ELSE IF (FSOURCE_DEPTH.EQ.3) THEN
     	  WRITE (30,2050) SIGMAY
2050	FORMAT (1X,'Depth:  GAUSSIAN.    Sigma-y : ',G17.9)
     	ELSE IF (FSOURCE_DEPTH.EQ.4) THEN
     	  WRITE (30,2055)
2055	FORMAT (1X,'Depth:  SYNCHROTRON SOURCE.')
     	END IF
C
C Source Emission
C
     	WRITE (30,*) TOPLIN
     	WRITE (30,*) 'Source Emission Characteristics'
     	WRITE (30,3000)  TANG (FDISTR)
3000	FORMAT (1X,'Distribution Type: ',A20)
     	IF (FDISTR.NE.5) THEN
     	  WRITE (30,3010)	 HDIV1,HDIV2
     	  WRITE (30,3020)  	 VDIV1,VDIV2
3010	FORMAT (1X,'Distribution Limits. +X : ',G17.9,' -X: ',G17.9,
     $' rad')
3020	FORMAT (1X,'                     +Z : ',G17.9,' -Z: ',G17.9,
     $' rad')
     	IF (FDISTR.EQ.3.OR.FDISTR.EQ.7) THEN
     	  WRITE (30,3026)	SIGDIX
     	  WRITE (30,3027) 	SIGDIZ
3026	FORMAT	(1X,'Horiz. StDev : ',G17.9)
3027	FORMAT	(1X,'Verti. StDev : ',G17.9)
	END IF
     	ELSE IF (FDISTR.EQ.5) THEN
     	  WRITE (30,3025)	 CONE_MAX,CONE_MIN
3025	FORMAT (1X,'Cone Outer Aperture : ',G17.9,
     $' Inner Aperture : ',G17.9)
     	END IF
C
C Synchrotron Case
C
     	IF (FDISTR.EQ.4.OR.FDISTR.EQ.6) THEN
     	  WRITE (30,3030) R_MAGNET,BENER
3030	FORMAT (1X,'Magnetic Radius = ',G17.9,' m.  Beam Energy = ',
     $G12.5,' GeV.')
     	  WRITE (30,3040) EPSI_X,EPSI_Z
     	  WRITE (30,3050) EPSI_DX,EPSI_DZ
3040	FORMAT (1X,'Beam Emittancies. EPSI_X: ',G17.9,' EPSI_Z: ',
     $G17.9)
3050	FORMAT (1X,'Distance from Waist.   X: ',G17.9,'      Z: ',
     $G17.9)
     	  WRITE (30,3070) TPOL(F_POL)
3070	FORMAT (1X,'Polarization Used: ',A12)
     	END IF
C
C Photon Energy 
C
     	 IF (F_COLOR.NE.0) THEN
     	   WRITE (30,*) TOPLIN
     	   WRITE (30,3080) TPHOT (F_COLOR+2)
     	   PHOTON(1) = PH1
     	   PHOTON(2) = PH2
     	   PHOTON(3) = PH3
     	   PHOTON(4) = PH4
     	   PHOTON(5) = PH5
     	   PHOTON(6) = PH6
     	   PHOTON(7) = PH7
     	   PHOTON(8) = PH8
     	   PHOTON(9) = PH9
     	   PHOTON(10) = PH10
     	   WAVE(1) = PH1
     	   WAVE(2) = PH2
     	   WAVE(3) = PH3
     	   WAVE(4) = PH4
     	   WAVE(5) = PH5
     	   WAVE(6) = PH6
     	   WAVE(7) = PH7
     	   WAVE(8) = PH8
     	   WAVE(9) = PH9
     	   WAVE(10) = PH10
3080	FORMAT (1X,'Source Photon Energy Distribution: ',A12)
     	  IF (F_COLOR.EQ.1) THEN
     	   IF (F_PHOT.EQ.0) WAVE(1) = TOANGS/PHOTON(1)
     	   IF (F_PHOT.EQ.1) PHOTON(1) = TOANGS/WAVE(1)
     	    WRITE (30,3090) PHOTON(1),WAVE(1)
3090	FORMAT (1X,'Photon Energy: ',G12.5,' eV, or ',G12.5,' Angs.')
     	  ELSE IF (F_COLOR.EQ.2) THEN
     	   DO 11 J=1,N_COLOR
     	    IF (F_PHOT.EQ.0) WAVE(J) = TOANGS/PHOTON(J)
     	    IF (F_PHOT.EQ.1) PHOTON(J) = TOANGS/WAVE(J)
     	     WRITE (30,3090) PHOTON(J),WAVE(J)
11        CONTINUE
     	  ELSE
     	   IF (F_PHOT.EQ.0) WAVE(1) = TOANGS/PHOTON(1)
     	   IF (F_PHOT.EQ.1) PHOTON(1) = TOANGS/WAVE(1)
     	    WRITE (30,3100) PHOTON(1),WAVE(1)
     	   IF (F_PHOT.EQ.0) WAVE(2) = TOANGS/PHOTON(2)
     	   IF (F_PHOT.EQ.1) PHOTON(2) = TOANGS/WAVE(2)
     	    WRITE (30,3110) PHOTON(2),WAVE(2)
3100	FORMAT (1X,'From Photon Energy: ',G17.9,' or ',G17.9,' Angs.')
3110	FORMAT (1X,' to  Photon Energy: ',G17.9,' or ',G17.9,' Angs.')
     	  END IF
	END IF
     	  IF (F_POLAR.EQ.1) THEN
     	    WRITE (30,3130) POL_ANGLE*TODEG
3130	FORMAT (1X,'Angular difference in phase is ',G12.5)
     	    WRITE (30,3140) POL_DEG
3140	FORMAT (1X,'Degree of polarization is ',G12.5)
	    IF (F_COHER.EQ.0) THEN
	      WRITE (30,*) 'Source points have INCOHERENT phase.'
	    ELSE
	      WRITE (30,*) 'Source points have COHERENT phase.'
	    END IF
     	  END IF
C
C All completed.
C
     	WRITE (30,*)	TOPLIN
     	WRITE (30,*)
     $'***************                 E N',
     $' D                  ***************'
     	WRITE (30,*)	TOPLIN
	CLOSE (30)
     	CALL EXIT (0)
     	END

	BLOCK DATA
	IMPLICIT        REAL*8          (A-E,G-H,O-Z)
	IMPLICIT        INTEGER*4       (F,I-N)
	COMMON  /MATHBLK/ PI,TWOPI,PIHALF,TODEG,TORAD,ORIGIN(3),
     $		 X_VRS(3),Y_VRS(3),Z_VRS(3),TOCM,TOANGS
     	DATA	PI     	/  3.1415 92653 58979 32384 62643 D0 /
     	DATA	PIHALF 	/  1.5707 96326 79489 66192 31322 D0 /
     	DATA	TWOPI 	/  6.2831 85307 17958 64679 25287 D0 /
     	DATA	TODEG 	/ 57.2957 79513 08232 08767 98155 D0 /
     	DATA	TORAD	/  0.0174 53292 51994 32957 69237 D0 /
	DATA	TOCM	/  1.239 852	D-4		     /
	DATA	TOANGS 	/  1.239 852    D+4		     /

	END
