C +++
C
C Source: src/utils/post/seed.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	seed.F
C Revision 1.7  92/01/16  10:52:05  cwelnak
C 6000 changes
C 
C Revision 1.6  91/07/06  19:43:52  khan
C Grenoble Changes ...
C 
C Revision 1.5  91/07/06  14:06:57  khan
C Grenoble changes...
C 
C Revision 1.4  91/04/05  15:50:55  cwelnak
C changed quotes in #includes
C 
C Revision 1.3  91/03/25  16:08:47  khan
C PROGRAM SEED statement MUST be present before any INCLUDE statement.
C 
C Revision 1.2  91/03/25  15:56:33  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.1  91/02/11  17:13:36  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	PROGRAM		SEED
C
C	PURPOSE		To read in the last random seed in END.00 file and put
C			it in START.00.
C---
	PROGRAM		SEED
#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../../include/common.blk'
c	INCLUDE         './../../include/namelist.blk'
c
c
#	include		<common.blk>
#	include		<namelist.blk>
#elif defined(vms)
	INCLUDE	'SHADOW$INC:COMMON.BLK/LIST'
	INCLUDE	'SHADOW$INC:NAMELIST.BLK/LIST'
#endif
	CHARACTER*20	FILE,IWHAT
     	CHARACTER*80	SFILE, RSTRING
C
C Reads in the source status on exit from last run
C
#ifdef vms
	FILE	= 'END.00'
#else
	FILE	= 'end.00'
#endif
	IWHAT	= 'R_SOUR'
	CALL	RWNAME	(FILE,IWHAT,IDUMM)
C
C ISTAR1 is the value of the seed for the random number generator on
C exit.
C
	IEND	= ISTAR1
C Since we are using srand and rand on the 6000, must update the seed by
C hand.  This is done by using the random number generated by ISTAR1
C as the new seed.
#ifdef rs6000
	X = WRAN(IEND)
	IX = INT(X*1.0E6)
	IEND = IX
#endif
C
C reads in the input parameters file
C
#ifndef vms
	NUMARG = IARGC ()
	IF (NUMARG .GT. 0) THEN
	    CALL GETARG (1, SFILE)
	ELSE
	    SFILE = RSTRING ('Start file for SOURCE [ START.00 ] ? ')
	ENDIF
#elif defined(vms)
	SFILE	= RSTRING ('Start file for SOURCE [ START.00 ] ? ')
#endif
	IWHAT	= 'R_SOUR'
	CALL	RWNAME	(SFILE,IWHAT,IDUMM)
C
C Verification; ISTAR1 now is the seed that started the seesion; the
C numbers must be different
C
     	WRITE	(6,*)	'Start seed found: ',ISTAR1
     	WRITE	(6,*)	'End seed found:   ',IEND
     	IF (IEND.EQ.ISTAR1) THEN
     	  WRITE	(6,*)	
     $'                       Error in random number generator update.'
     	  WRITE	(6,*)   
     $'                 Check the definitions of filenames for SOURCE.'
     	  CALL	EXIT (4)
     	END IF
	ISTAR1	= IEND
	IWHAT	= 'W_SOUR'
	CALL	RWNAME	(SFILE,IWHAT,IDUMM)
	END		
