C +++
C
C Source: src/utils/post/retrace.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	retrace.F
C Revision 1.6  92/01/16  10:48:51  cwelnak
C 6000 changes
C 
C Revision 1.5  1991/07/06  19:43:52  khan
C Grenoble Changes ...
C
C Revision 1.4  91/04/05  15:50:54  cwelnak
C changed quotes in #includes
C 
C Revision 1.3  91/03/25  15:56:30  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.2  91/01/25  16:47:54  khan
C Ported to Ultrix
C 
C Revision 1.1  90/10/08  17:03:48  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	PROGRAM		RETRACE
C
C	PURPOSE		Create a new RAY file (e.g., image plane) from
C			an old one at a different position
C
C	ALGORITHM	Direct computation
C
C			x(i) = x0(i) + distance*vx(i)
C---
     	PROGRAM		RETRACE
    	IMPLICIT	REAL*8	(A-H,O-Z)
#if defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#elif defined(vms)
        INCLUDE	        'SHADOW$INC:DIM.PAR/LIST'
#endif
C    	IMPLICIT	REAL*8	(A-H,O-Z)
     	CHARACTER * 80 	FILEIN,FILEOUT,FPIN,FPOUT,RSTRING
     	REAL	*8	OLD(12,N_DIM),DIST,PHASE(3,N_DIM),AP(3,N_DIM)
C
2    	FILEIN  = RSTRING ('RETRACE> Ray input file ? ')
     	FILEOUT = RSTRING ('RETRACE> Ray output file ? ')
     	CALL	RBEAM	( FILEIN,OLD,PHASE,AP,NCOL,NPOINT,IFLAG,IERR)
     	DIST	=  RNUMBER ('RETRACE> Distance ? ')
     	WRITE(6,*)'Read ',NPOINT,' rays.'
C
C
     	DO 10 I=1,NPOINT
	   IF (ABS(OLD(5,I)).LT.1.0D-16) THEN
	     RDIST = 0
	   ELSE
     	     RDIST = DIST/OLD(5,I)
	   END IF
     	   OLD (1,I) = OLD(1,I) + RDIST*OLD(4,I)
     	   OLD (2,I) = OLD(2,I) + RDIST*OLD(5,I)
     	   OLD (3,I) = OLD(3,I) + RDIST*OLD(6,I)
	   IF (NCOL.GT.12) PHASE(1,I) = PHASE(1,I) + RDIST
10     	CONTINUE
C  
        IFORM = 0
     	CALL 	WRITE_OFF (FILEOUT,OLD,PHASE,AP,NCOL,NPOINT,
     $                         IFLAG,IFORM,IERR)
     	IF (IERR.NE.0) STOP 'Error creating output ray file'
C
     	GO TO (1,2) IYES('Another run [ Y/N ] ?')+1
1     	STOP
C
     	END
