C +++
C
C Source: src/utils/post/pwr_dens.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: pwr_dens.F
C Revision 1.12  1994/02/08  15:27:06  cwelnak
C implicit in wrong place in writegfile
C
C Revision 1.11  1994/01/24  17:28:22  khan
C fixed missing IMPLICIT in BLOCK DATA statement.
C
C Revision 1.10  1994/01/13  17:25:51  khan
C added support for g-files to run under EXCON
C
C Revision 1.8  1992/01/16  10:33:21  cwelnak
C 6000 changes
C
C Revision 1.7  91/07/06  19:43:52  khan
C Grenoble Changes ...
C 
C Revision 1.6  91/04/05  15:50:52  cwelnak
C changed quotes in #includes
C 
C Revision 1.5  91/03/25  15:56:24  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.4  91/02/14  14:18:52  khan
C No more ANSYS format!!!
C 
C Revision 1.3  91/02/13  14:17:53  khan
C KACT was never set to 3.
C 
C Revision 1.2  91/01/25  16:47:48  khan
C Ported to Ultrix
C 
C Revision 1.1  90/10/08  17:03:47  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C
C	PROGRAM		PWR_DENS
C
C	PURPOSE		Generates a two-dimensional histogram from an
C			output file of SHADOW containing the power
C			density.
C
C	OUTPUT		A grid file suitable for further processing.
C			
C---
	IMPLICIT REAL*8 (A-H,O-Z)
#if defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#elif defined(vms)
        INCLUDE	        'SHADOW$INC:DIM.PAR/LIST'
#endif
     	DATA	TWOPI 	/  6.2831 85307 17958 64679 25287 D0 /
	DATA	TOCM	/  1.239 852	D-4		     /
	DATA	TOANGS 	/  1.239 852    D+4		     /

	CHARACTER *80 	INFIL0,INFIL1,INFIL2,INFIL3,INFIL4,OUTFIL,
     $			XFIL,YFIL,ZFIL,RSTRING
     	CHARACTER * 80		FILE_IN
     	CHARACTER * 60		FILETEXT
     	CHARACTER * 17		DATETEXT

#ifndef vms
	CHARACTER * 132	FNAME
#endif

     	REAL *8		RAY(18,N_DIM), RAY2(18,N_DIM)
     	DIMENSION	PIXEL (52,52), XSID(52), YSID(52), TEST(7),
     $			PHOT(2001),SPWR(2001),NHIT(52,52),POLD(52,52),
     $			NOLD(52,52)
	NAMELIST	/SAVE_PAR/	IGO,PWRT,INFIL0,INFIL1,INFIL2,
     $			INFIL3,INFIL4,OUTFIL,K_LOSS,CHECK,XMIN,XMAX,N_X,
     $			YMIN,YMAX,N_Y,
     $			I_X,I_Y,ISCALE,K_ACT,ITER,IANSW,ILOOP
C23456789112345678921234567893123456789412345678951234567896123456789712
#ifndef vms
	character*132	gfilename, stategfile
	common	/gfiledata/igo,idummy, pwrt,infil0,infil1,infil2,infil3,
     $			infil4,outfil,k_loss,idummy2,check,xmin,xmax,
     $			idummy3,n_x,ymin,ymax,n_y, i_x,i_y,iscale,k_act,
     $			iter,iansw,iloop,gfilename,stategfile
	logical		usegfile, usenml
#endif
C
C Under unix, we check if a file is supplied on the command line. If so,
C simply run the program in the namelist mode [1] with the argument as
C the namelist file.
C
#ifndef vms
	call getparams(usegfile, usenml, gfilename)
	if (usegfile) then
	    iname = 2
	    call gfile(gfilename)
c
c get the number of previous runs. if > 0, then use the gfile specified
c in the g-file supplied by EXCON.
c
	    call gstring('statefile', 'Saved Gfile? ', stategfile)
	    if (iter.gt.0) then
		call gclose()
		call gfile(stategfile)
	    endif
c
	    call gint('iter', 
     $		'No. of time this power density case has run : ', iter)
	    call gint('igo', 
     $		'Source file [0] or total power [1] : ', igo)
	    call gnumber('pwrt', 'Total power in Watt : ', pwrt)
     	    call gstring('infil0',
     $		'File with Source spectrum ? ', infil0)
    	    call gstring('infil1', 
     $		'SOURCE array (e.g., BEGIN.DAT) ', infil1)
	    call gstring('infil2', 'File for analysis ? ', infil2)
		
     	    call gstring('infil3', 'File to use for Io ? ', infil3)
	    call gstring('infil4', 
     $		'File of previous results : ', infil4)
     	    call gstring('outfil', 'Output file ? ', outfil)
	    call gint('k_loss', 'k_loss : ', k_loss)
     	    call gnumber('check', 'Check ? ', check)

     	    call gnumber('xmin', 'XMIN ? ', xmin)
     	    call gnumber('xmax', 'XMAX ? ', xmax)
     	    call gint('n_x', 'N_X ? ', n_x)
c
     	    call gnumber('ymin', 'YMIN ? ', ymin)
     	    call gnumber('ymax', 'YMAX ? ', ymax)
     	    call gint('n_y', 'N_Y ? ', n_y)
c
	    call gint('i_x', 'I_X ? ', i_x)
	    call gint('i_y', 'I_Y ? ', i_y)
c
	    call gint('iscale', 
     $		'Automatic [0] or external [1] scaling ? ', iscale)
c
	    call gint('k_act', 'k_ack ? ', k_act)
c
	    call gint('iansw', 
     $		'TOPDRAWER[0], NCAR[1], Generic[2], ANSYS[3]? ', iansw)
     	    call gint('iloop', 
     $		'How many times will you be looping through ? ', iloop)
c
	else if (usenml) then
	    iname = 1
	    fname = gfilename
	else
	    iname = irint ('Interactive [0] or namelist mode [1] : ')
	    fname = 'PWR_DENS_PAR'
	ENDIF

	IF (INAME.EQ.1) THEN
	  OPEN	(20,FILE=FNAME,STATUS='OLD')
#elif defined(vms)
	INAME	= IRINT	('Interactive [0] or namelist mode [1] : ')
	IF (INAME.EQ.1) THEN
	  OPEN	(20,FILE='PWR_DENS_PAR',STATUS='OLD')
#endif
	  READ	(20,NML=SAVE_PAR)
	  CLOSE	(20)
C
C The program switches to ANSYS format for the last time through the
C loop.
C
C     	  IF (ITER.EQ.ILOOP) IANSW = 3
C	ELSE	
	ELSE IF (INAME.EQ.0) THEN
     	  WRITE(6,*) 'This program needs a file containing the source',
     $' spectrum computed within the limits used. Or you can ',
     $' specify the total power.'
     	  IGO	= IYES ('Source file [0] or total power [1] : ')
     	  IF (IGO.EQ.1) THEN
	   PWRT	= RNUMBER ('Total power in Watt : ')
	  ELSE
     	   INFIL0  = RSTRING ('File with Source spectrum ? ')
	  END IF
	END IF
C
	IF (IGO.EQ.0) THEN
#ifdef vms
     	 OPEN (20, FILE=INFIL0, STATUS='OLD', READONLY)
#else
     	 OPEN (20, FILE=INFIL0, STATUS='OLD')
#endif
     	 I = 0
     	 PWRT = 0.0D0
C     	 DO WHILE (IERR.EQ.0) 
 19	 CONTINUE
     	  I = I + 1
     	  READ (20,*,IOSTAT=IERR) PHOT(I),SPWR(I)
	  IF (IERR.NE.0) THEN
	      GOTO 29
	  ELSE 
	      GOTO 19
	  ENDIF
 29	 CONTINUE
C    	 END DO
     	 WRITE(6,*) 'Read ',I-1,' records.'
     	 NP = I - 1
     	 PSTEP = PHOT(2) - PHOT(1)
     	 DO I=1,NP-1
     	  PWRT = PWRT + (SPWR(I)+SPWR(I+1))*0.5D0*PSTEP
     	 END DO
     	 WRITE(6,*) 'The file corresponds to a total power of '
     	 WRITE(6,*) PWRT,' Watts.'
	END IF
C
	IF (INAME.EQ.0) THEN
     	 WRITE(6,*) ' '
     	 WRITE(6,*) 'Please specify now the file containing the SOURCE',
     $' array (e.g., BEGIN.DAT) '
     	 INFIL1	= RSTRING ('Then ? ')
	END IF
	CALL	RBEAM18	(INFIL1,RAY,NCOL,NPOINT,IFLAG,IERR)
     	WRITE(6,*) 
     $	    'Read ',NPOINT,' rays. The file has ',NCOL,' columns.'
     	WRITE(6,*) 'Computing renormalizing factor.'
	WRITE(6,*) ' '
     	PWR = 0.0D0
     	DO I=1,NPOINT
     	  T_PWR = RAY(7,I)**2 + RAY(8,I)**2 + RAY(9,I)**2
     	 IF (NCOL.EQ.18) THEN
     	   T_PWR = T_PWR + RAY(16,I)**2 + RAY(17,I)**2 + RAY(18,I)**2
     	 END IF
     	  T_PWR = T_PWR*TOCM/TWOPI*RAY(11,I)*1.602D-19
     	  PWR = PWR + T_PWR
     	END DO
     	FACTOR	=  PWRT/PWR
C
	WRITE(6,*) 'All preliminaries completed. '
     	WRITE(6,*) 'Ready to proceed with density analysis.'
     	WRITE(6,*) ' '
	IF (INAME.EQ.0)	INFIL2	= RSTRING ('File for analysis ? ')
	CALL	RBEAM18	(INFIL2,RAY,NCOL,NPOINT,IFLAG,IERR)
	IF (IERR.NE.0) STOP 'Error reading ray file.'
#ifdef vms
     	CALL	FILEINFO  (FILE_IN)
     	CALL	NEXTFILE  (FILETEXT,DATETEXT)
#else
	filetext = ' '
	datetext = ' '
	call get_file_text(filetext,FILE_IN)
#endif
	WRITE(6,*) 'Data ready. Read ',NPOINT,' points.'
	IF (INAME.EQ.0) THEN
	 WRITE(6,*) 'Options --- Enter'
     	 WRITE(6,*) '0 for excluding the losses'
     	 WRITE(6,*) '1 for including losses at a particular O.E.'
     	 WRITE(6,*) '2 for including all the losses.'
     	 K_LOSS	=   IRINT ('Then ? ')
     	 IF (K_LOSS.EQ.1) THEN
     	  WRITE(6,*) 
     $	'Flag value ( -11000 first O.E., -22000 sec O.E., etc.) ?'
     	  CHECK	=   RNUMBER ('Then ? ')
     	 ELSE
     	 END IF
	END IF
	KOUNT	=   0
     	DO I=1,NPOINT
     	 IF (RAY(10,I).LT.0.0) KOUNT = KOUNT + 1
     	END DO
100     CONTINUE
     	WRITE(6,*) '***********'
     	WRITE(6,*) 'File examined is :'
     	WRITE(6,*) FILETEXT
     	WRITE(6,*) 'Was created :'
     	WRITE(6,*) DATETEXT
     	WRITE(6,*) '***********'
	WRITE(6,*) 'Found ',(NPOINT-KOUNT),' good points out of',NPOINT
     	X_MIN =   1.0D+20
     	X_MAX = - 1.0D+20
     	Y_MIN =   1.0D+20
     	Y_MAX = - 1.0D+20
     	Z_MIN =   1.0D+20
     	Z_MAX = - 1.0D+20

     	X_1_MIN =   1.0D+20
     	X_1_MAX = - 1.0D+20
     	Y_1_MIN =   1.0D+20
     	Y_1_MAX = - 1.0D+20
     	Z_1_MIN =   1.0D+20
     	Z_1_MAX = - 1.0D+20
     	P_MIN	=   1.0D+20
     	P_MAX	= - 1.0D+20
     	DO I=1,NPOINT
	 IF (K_LOSS.EQ.0) THEN
	   IF (RAY(10,I).LT.0.0D0)   GO TO 300
	 ELSE IF (K_LOSS.EQ.1) THEN
     	   IF (RAY(10,I).LT.0.0D0.AND.RAY(10,I).NE.CHECK) GO TO 300
     	 END IF
     	TEST(1)		=   RAY(1,I)
     	 TEST(2)	=   RAY(2,I)
     	  TEST(3)	=   RAY(3,I)
     	   TEST(4)	=   RAY(4,I)
     	    TEST(5)	=   RAY(5,I)
     	     TEST(6)	=   RAY(6,I)
     	      TEST(7) 	=   RAY(11,I)
     	X_MIN = MIN(X_MIN,TEST(1))
     	 X_MAX = MAX(X_MAX,TEST(1))
     	Y_MIN = MIN(Y_MIN,TEST(2))
     	 Y_MAX = MAX(Y_MAX,TEST(2))
     	Z_MIN = MIN(Z_MIN,TEST(3))
         Z_MAX = MAX(Z_MAX,TEST(3))
     	P_MIN = MIN(P_MIN,TEST(7))
         P_MAX = MAX(P_MAX,TEST(7))
300	CONTINUE
    	END DO

     	WRITE(6,*) 'Found: '

     	WRITE(6,*) 'Column 1: X max is',X_MAX
     	WRITE(6,*) '       1: X min is',X_MIN
     	WRITE(6,*) '       2: Y max is',Y_MAX
     	WRITE(6,*) '       2: Y min is',Y_MIN
     	WRITE(6,*) '       3: Z max is',Z_MAX
     	WRITE(6,*) '       3: Z min is',Z_MIN

     	WRITE(6,*) ' for a photon energy range: '
     	P_MIN = TOCM*P_MIN/TWOPI 
     	P_MAX = TOCM*P_MAX/TWOPI
     	WRITE(6,*) P_MIN,' to ',P_MAX

	IF (INAME.EQ.1 .OR. INAME.EQ.2) GO TO 200
     	WRITE(6,*) 'I need to define the two-dimensional histogram for',
     $' the power density. Please specify: '
     	WRITE(6,*) 'Columns for x-axis and y-axis?'
     	READ(5,*) I_X,I_Y
     	WRITE(6,*) 'Limits to use for the histogram. '
     	WRITE(6,*) 'To use           scaling, enter: '
     	WRITE(6,*) '       automatic                 0'
     	WRITE(6,*) '       external                  1'
     	ISCALE	=   IRINT ('Then? ')
     	IF (ISCALE.EQ.1) THEN
     	  WRITE(6,*) 'X min, X max and number of bins [ max 51 ] :'
     	  READ(*,*) XMIN,XMAX,N_X
     	  WRITE(6,*) 'Y min, Y max and number of bins [ max 51 ] :'
     	  READ(*,*) YMIN,YMAX,N_Y
     	ELSE
     	  N_X = IRINT ('Number of bins in X [ max 51 ] ? ')
     	  N_Y = IRINT ('                  Y [ max 51 ] ? ')
	END IF
     	  IF (N_X.GT.51) THEN
     	    N_X = 51
     	    WRITE(6,*) 'Too many bins in X. Reset at 51.'
     	  END IF
     	  IF (N_Y.GT.51) THEN
     	    N_Y = 51
     	    WRITE(6,*) 'Too many bins in Y. Reset at 51.'
     	  END IF
200	IF (ISCALE.EQ.0) THEN
     	      IF (I_X.EQ.1) THEN
     	   XMIN = X_MIN
     	   XMAX = X_MAX
     	 ELSE IF (I_X.EQ.2) THEN
     	   XMIN = Y_MIN
     	   XMAX = Y_MAX
     	 ELSE IF (I_X.EQ.3) THEN
     	   XMIN = Z_MIN
     	   XMAX = Z_MAX
     	 END IF
     	      IF (I_Y.EQ.1) THEN
     	   YMIN = X_MIN
     	   YMAX = X_MAX
     	 ELSE IF (I_Y.EQ.2) THEN
     	   YMIN = Y_MIN
     	   YMAX = Y_MAX
     	 ELSE IF (I_Y.EQ.3) THEN
     	   YMIN = Z_MIN
     	   YMAX = Z_MAX
     	 END IF
     	END IF
     	K_REFL	= 1
	IF (INAME.EQ.1 .OR. INAME.EQ.2) GO TO 400
     	WRITE(6,*) 'Optical Properties options.'
     	WRITE(6,*) ' '
     	WRITE(6,*) 'To select                          enter'
     	WRITE(6,*) ' '
     	WRITE(6,*) 'Power transmitted/reflected ........ 0'
     	WRITE(6,*) 'Power absorbed ..................... 1'
     	WRITE(6,*) 'Local reflectivity/transmission .... 2'
     	WRITE(6,*) 'Incoming Power ..................... 3'
     	WRITE(6,*) ' '
     	WRITE(6,*) 'Then ?'
     	  READ(*,*) K_ACT
     	  NORMAL	=  0
     	 IF (K_ACT.NE.0) THEN
     	  INFIL3 = RSTRING ('File to use for Io ? ')
	 END IF
400	IF (K_ACT.NE.0) THEN
	  CALL	RBEAM18	(INFIL3,RAY2,NCOL2,NPOINT2,IFLAG,IERR)
	  IF (IERR.NE.0) STOP 'Error reading ray file.'
	  IF (NPOINT2.NE.NPOINT)	STOP
     $'Io file does not have the same number of rays as the input file.'
C
C Compute now the total power in the Io file
C
     	CPWR = 0.0D0
     	DO I=1,NPOINT
     	  CT_PWR = RAY2(7,I)**2 + RAY2(8,I)**2 + RAY2(9,I)**2
     	 IF (NCOL.EQ.18) THEN
     	   CT_PWR = CT_PWR + RAY2(16,I)**2 + RAY2(17,I)**2 + 
     $							RAY2(18,I)**2
     	 END IF
     	  CT_PWR = CT_PWR*TOCM/TWOPI*RAY2(11,I)*1.602D-19
     	  CPWR = CPWR + CT_PWR
     	END DO
C
C Scale it to the power in the source
C
C remember that     	FACTOR	=  PWRT/PWR
C
     	CTOT	=  FACTOR*CPWR
C
     	 END IF
C	
	IF (INAME.EQ.0) THEN
     	  WRITE(6,*) 
     $'The program need to know how many iterations have',
     $' been already performed. Enter [ 0 ] if this is the first time.'
	  ITER	= 
     $	    IRINT ('No. of time this power density case has run : ')
	  IF (ITER.GT.0) THEN
     		INFIL4 = RSTRING ('File of previous results : ')
     	  END IF
     	  ILOOP	= 
     $	    IRINT ('How many times will you be looping through ? ')
	END  IF
	ITER	= ITER + 1
	IF (ITER.GT.1) THEN
	  OPEN	(35, FILE=INFIL4, STATUS='OLD')
	  DO I = 1, N_X
	    DO J = 1, N_Y
	      READ (35,*)	XSID(I),YSID(J),POLD(I,J),NOLD(I,J)
	    END DO
	  END DO
	  CLOSE	(35)
	END IF

     	X_WID	=   (XMAX - XMIN)
     	Y_WID	=   (YMAX - YMIN)
     	X_STEP	=   X_WID/N_X
     	Y_STEP  =   Y_WID/N_Y
     	AREA	=   X_STEP*Y_STEP
     	FACTOR	=   FACTOR/AREA
C
C Initialize the grid array PIXEL and NHIT 
C
	DO I = 1, N_X
	  DO J = 1, N_Y
	    PIXEL(I,J)	= 0.0D0
	    NHIT(I,J)	= 0
	  END DO 
	END DO
C
C Prepare the 'sides' of the histogram. 
C
     	DO I=1,N_X
     		XSID(I)	=   XMIN + X_STEP*(I-1) + X_STEP/2.0D0
     	END DO
     	DO J=1,N_Y
     		YSID(J)	=   YMIN + Y_STEP*(J-1) + Y_STEP/2.0D0
     	END DO
     	I_BAD	=   0
C
C Begins to fill the array
C
     	DO K=1,NPOINT
         IF (RAY(10,K).LT.0.0) THEN
     	   I_BAD   =   I_BAD + 1
     	   GO TO 101
     	 END IF
C
	  ARG_X	=   (RAY(I_X,K) - XMIN)/X_STEP + 1
     	  ARG_Y	=   (RAY(I_Y,K) - YMIN)/Y_STEP + 1
       	  I_BIN	=    ARG_X
     	 IF (I_BIN.GT.52.OR.I_BIN.LT.1) GO TO 101
     	  J_BIN	=    ARG_Y
     	 IF (J_BIN.GT.52.OR.J_BIN.LT.1) GO TO 101
     	  ARG1	=   RAY(7,K)**2 + RAY(8,K)**2 + RAY(9,K)**2
	 IF (NCOL.EQ.18) THEN
     	   ARG1	=   ARG1 + RAY(16,K)**2 + RAY(17,K)**2 + RAY(18,K)**2
     	 END IF
     	  ARG1	=   ARG1*FACTOR*TOCM/TWOPI*RAY(11,K)*1.602D-19
C	
C	AUGUST 10, 1989
C	CHANGED NEXT IF STATEMENT TO INCLUDE K_ACT=3
C	CLW
C
     	IF (K_ACT.NE.0) THEN
     	  ARG2	=   RAY2(7,K)**2 + RAY2(8,K)**2 + RAY2(9,K)**2
	 IF (NCOL.EQ.18) THEN
     	   ARG2	=   ARG2 + RAY2(16,K)**2 + RAY2(17,K)**2 + RAY2(18,K)**2
     	 END IF
     	  ARG2	=   ARG2*FACTOR*TOCM/TWOPI*RAY2(11,K)*1.602D-19
     	END IF
C
C     	WRITE(6,*) 'Power transmitted/reflected ........ 0'
C     	WRITE(6,*) 'Power absorbed ..................... 1'
C     	WRITE(6,*) 'Local reflectivity/transmission .... 2'
C
     	     IF (K_ACT.EQ.0) THEN
     	  PIXEL (I_BIN,J_BIN) =   PIXEL(I_BIN,J_BIN) + ARG1
     	ELSE IF (K_ACT.EQ.1) THEN
     	  PIXEL (I_BIN,J_BIN) =   PIXEL(I_BIN,J_BIN) + ARG2-ARG1
     	ELSE IF (K_ACT.EQ.2) THEN
     	  PIXEL (I_BIN,J_BIN) =   PIXEL(I_BIN,J_BIN) + ARG1/ARG2
     	ELSE IF (K_ACT.EQ.3) THEN
     	  PIXEL (I_BIN,J_BIN) =   PIXEL(I_BIN,J_BIN) + ARG2
     	END IF
	NHIT(I_BIN,J_BIN) = NHIT(I_BIN,J_BIN) + 1
     
101	  CONTINUE
     	END DO	
C
     	WRITE(6,*) 'There were ',I_BAD,' lost out of ',NPOINT,' rays.'
     	WRITE(6,*) 'Begin verification.'
C
     	TPWR = 0.0D0
     	DO I=1,N_X
     	 DO J=1,N_Y
     	   TPWR = TPWR + PIXEL(I,J)*AREA
     	 END DO
     	END DO
C
     	WRITE(6,*) ' '
     	WRITE(6,*) '------------------------------------------------'
     	WRITE(6,*) ' '
     	IF (K_ACT.EQ.0) WRITE(6,*) 'Power TRANSMITTED/ REFLECTED'
     	IF (K_ACT.EQ.1) WRITE(6,*) 'Power ABSORBED'
     	IF (K_ACT.EQ.2) WRITE(6,*) 'Local only'
     	IF (K_ACT.EQ.3) WRITE(6,*) 'Incoming power only'
     	WRITE(6,*) 'Total power in file: ',TPWR
     	WRITE(6,*) 'Source power:        ',PWRT
     	WRITE(6,*) 'Incoming power:      ',CTOT
C
C Now average it with the old power density.
C
	IF (ITER.GT.1) THEN
	 DO I = 1, N_X
	  DO J = 1, N_Y
	    PIXEL(I,J)	= (PIXEL(I,J) + (ITER-1)*POLD(I,J))/ITER
	    NHIT(I,J)	= NHIT(I,J) + NOLD(I,J)
	  END DO
	 END DO
	END IF
	
	IF (INAME.EQ.0) THEN
     	 WRITE(6,*) 'Computations done. Ready to store output data. The'
     	 WRITE(6,*) ' files contain the power density at the nodes but'
     	 WRITE(6,*) ' for the case of ANSYS, that stores total power.'
     	 WRITE(6,*) 'File for: '
         WRITE(6,*) ' TOP DRAWER          [ 0 ] '
     	 WRITE(6,*) ' NCAR                [ 1 ] '
     	 WRITE(6,*) ' Generic             [ 2 ] ** to be used for loop'
     	 WRITE(6,*) ' For ANSYS           [ 3 ] '
     	 READ(*,*) IANSW
     	 IF (IANSW.EQ.1) THEN
     	  WRITE(6,*) 'Enter filenames for X,Y, Z(X,Y) arrays.'
     	  XFIL = RSTRING ('X ? ')
     	  YFIL = RSTRING ('Y? ')
     	  ZFIL = RSTRING ('Z(X,Y) ? ')
	 ELSE IF (IANSW.GE.2) THEN
     	  OUTFIL = RSTRING ('Output file ? ')
     	  IF (ITER.EQ.1) INFIL4 = OUTFIL
	 END IF
	END IF
	
	IF (IANSW.EQ.1) THEN
#ifdef vms
     	  OPEN (21,FILE=XFIL,STATUS='NEW')
#else
     	  OPEN (21,FILE=XFIL,STATUS='UNKNOWN')
	  REWIND (21)
#endif
     	 DO I=1,N_X
     	   WRITE (21,*) XSID(I)
     	 END DO
     	  CLOSE (21)
#ifdef vms
     	  OPEN (22,FILE=YFIL,STATUS='NEW')
#else
     	  OPEN (22,FILE=YFIL,STATUS='UNKNOWN')
	  REWIND (22)
#endif
     	 DO I=1,N_Y
     	   WRITE (22,*) YSID(I)
     	 END DO
     	  CLOSE (22)
#ifdef vms
     	  OPEN (23,FILE=ZFIL,STATUS='NEW')
#else
     	  OPEN (23,FILE=ZFIL,STATUS='UNKNOWN')
	  REWIND (23)
#endif
     	 DO I=1,N_X
       	   WRITE (23,*) (PIXEL (I,J),J=1,N_Y)
     	 END DO
     	  CLOSE (23)

     	ELSE IF (IANSW.EQ.0) THEN
C
#ifdef vms
     	  OPEN (37,FILE='MESH.PLT',STATUS='NEW')
#else
     	  OPEN (37,FILE='MESH.PLT',STATUS='UNKNOWN')
	  REWIND (37)
#endif
	  WRITE (37,180)
	  WRITE (37,201) (XSID(I),I=1,N_X)
C
C
	 DO K=1,N_Y
	   WRITE (37,203) YSID(K)
	   WRITE (37,230) (PIXEL(I,K),I=1,N_X)
     	 END DO
C
C
     	  CLOSE (37)
     	ELSE IF (IANSW.EQ.2) THEN
#ifdef vms
     	  OPEN (20, FILE=OUTFIL, STATUS='NEW')
#else
     	  OPEN (20, FILE=OUTFIL, STATUS='UNKNOWN')
	  REWIND (20)
#endif
     	 DO I=1,N_X
     	  DO J=1,N_Y
     	    WRITE (20,'(1X,2(G12.5,1X),G15.8,1X,I8)') 
     $		XSID(I), YSID(J), PIXEL(I,J), NHIT(I,J)
     	  END DO
     	 END DO
     	  CLOSE (20)
     	ELSE IF (IANSW.EQ.3) THEN
#ifdef vms
     	  OPEN (20, FILE=OUTFIL, STATUS='NEW', CARRIAGECONTROL='LIST')
#else
     	  OPEN (20, FILE=OUTFIL, STATUS='UNKNOWN')
	  REWIND (20)
#endif
     	  INODE = 0
     	 DO I=1,N_X
     	  DO J=1,N_Y
     	    INODE = INODE + 1
     	    WRITE (20,1120)
     $		INODE, PIXEL(I,J)*AREA, XSID(I), YSID(J)
     	  END DO
     	 END DO
     	  CLOSE (20)
     	END IF
1120	FORMAT (1X,'HFLOW,',I4,',HEAT,',G12.5,' * AT (',G12.5,' , ',
     $	G12.5,')') 
C
C Write out the namelist, after cleaning up the file-names
C
     	INFIL0 =  INFIL0(1:LTRIM(INFIL0))
     	INFIL1 =  INFIL1(1:LTRIM(INFIL1))
     	INFIL2 =  INFIL2(1:LTRIM(INFIL2))
     	INFIL3 =  INFIL3(1:LTRIM(INFIL3))
     	INFIL4 =  INFIL4(1:LTRIM(INFIL4))
     	OUTFIL =  OUTFIL(1:LTRIM(OUTFIL))

#ifndef unix
cc
c write out the gfile with the modified values. Right now it is ALWAYS
c written out just like the modified namelist.
cc
	write(*,*) 'PWR_DENS: G-file (excon statefile) saved in ' // 
     $		stategfile(1:ltrim(stategfile))
	call writegfile(stategfile)
#endif

#ifdef vms
	OPEN	(36,FILE='PWR_DENS_PAR',STATUS='NEW')
#else
C	OPEN	(36,FILE=FNAME,STATUS='UNKNOWN')
	OPEN	(36,FILE='PWR_DENS_PAR',STATUS='UNKNOWN')
	REWIND  (36)
#endif
	WRITE	(36,NML=SAVE_PAR)
	CLOSE	(36)
	WRITE(6,*) 'All done.'
     	CALL	EXIT (0)
C
180	FORMAT('READ MESH')
201	FORMAT('X = ',8(1PE14.6)/(4X,8E14.6))
203	FORMAT('Y = ',1PE14.6)
230	FORMAT('Z = ',8(1PE14.6)/(4X,8E14.6))
C
     	END

#ifndef vms
c
c get the command line args.
c
	subroutine getparams(usegfile, usenml, fname)
	logical usegfile, usenml
	character*(*) fname
c
	integer nargs
	character*80 arg
	external iargc, getarg
	logical error
c
	error = .false.
	nargs = iargc()
	if (nargs .eq. 0) then
	    usenml = .false.
	    usegfile = .false.
	    fname = ' '
	else if (nargs .eq. 1) then
	    usenml = .true.
 	    call getarg (1, fname)
	else if (nargs .eq. 2) then
	    call getarg(1, arg)
	    if (arg(1:3) .eq. '-g') then
		usegfile = .true.
		call getarg(2, fname)
	    else
		error = .true.
	    endif
	else
	    error = .true.
	endif

	if (error) then
	    call usage
	    call exit(1)
	endif
	return
	end
c
c spit out an annoying message if command line args are not correct.
c
        subroutine usage ()
c
        write (*,*)
        write (*,*)'Usage : pwr_dens [-h] [gfile]'
        write (*,*)
        write (*,*)' -h    : display this info'
        write (*,*)' gfile : optional gfile name'
        write (*,*)
        return
        end
c
c write the g-parameters back to gfile
c
	subroutine writegfile(gf)
	implicit real*8 (a-h,o-z)
	character*(*) gf
c
	character *80 	infil0,infil1,infil2,infil3,infil4,outfil

	character*132	stategfile, gfilename
	common	/gfiledata/igo,idummy, pwrt,infil0,infil1,infil2,infil3,
     $			infil4,outfil,k_loss,idummy2,check,xmin,xmax,
     $			idummy3,n_x,ymin,ymax,n_y, i_x,i_y,iscale,k_act,
     $			iter,iansw,iloop,gfilename,stategfile
c

	open(24, file=gf, status='unknown', err=1002)
	goto 1003

 1002	write(*,*) 'pwr_dens: error re-opening output file ', gf
	call exit(1)

 1003	continue
c
	write(24,*) 'statefile  = '// stategfile(1:ltrim(stategfile))
c
	write(24,*) 'igo        = ', igo
	write(24,*) 'pwrt       = ', pwrt
c
	write(24,*) 'infil0     = '// infil0(1:ltrim(infil0))
	write(24,*) 'infil1     = '// infil1(1:ltrim(infil1))
	write(24,*) 'infil2     = '// infil2(1:ltrim(infil2))
	write(24,*) 'infil3     = '// infil3(1:ltrim(infil3))
	write(24,*) 'infil4     = '// infil4(1:ltrim(infil4))
c
	write(24,*) 'outfil     = '// outfil(1:ltrim(outfil))
c
	write(24,*) 'k_loss     = ', k_loss
	write(24,*) 'check      = ', check
c
	write(24,*) 'xmin       = ', xmin
	write(24,*) 'xmax       = ', xmax
	write(24,*) 'n_x        = ', n_x
c
	write(24,*) 'ymin       = ', ymin
	write(24,*) 'ymax       = ', ymax
	write(24,*) 'n_y        = ', n_y
c
	write(24,*) 'i_x        = ', i_x
	write(24,*) 'i_y        = ', i_y
c
	write(24,*) 'iscale     = ', iscale
c
	write(24,*) 'k_act      = ', k_act
c
	write(24,*) 'iter       = ', iter 
c
	write(24,*) 'iansw      = ', iansw
	write(24,*) 'iloop      = ', iloop
c
	close(24)
	return
	end

#endif /*unix*/


#ifndef vms
        block data
	implicit real*8 (a-h,o-z)
	common	/gfiledata/igo,idummy, pwrt,infil0,infil1,infil2,infil3,
     $			infil4,outfil,k_loss,idummy2,check,xmin,xmax,
     $			idummy3,n_x,ymin,ymax,n_y, i_x,i_y,iscale,k_act,
     $			iter,iansw,iloop,gfilename,stategfile

	character *80 	infil0,infil1,infil2,infil3,infil4,outfil
	character*132	gfilename, stategfile

	DATA    INFIL0  / 'NONE SPECIFIED' /
	DATA    INFIL1  / 'NONE SPECIFIED' /
	DATA    INFIL2  / 'NONE SPECIFIED' /
	DATA    INFIL3  / 'NONE SPECIFIED' /
	DATA    INFIL4  / 'NONE SPECIFIED' /
	DATA    OUTFIL  / 'NONE SPECIFIED' /

	data 	gfilename / 'pwr_dens.G' /
	data 	stategfile/ 'pwr_dens.state.g' /
 
        END

#endif

