C +++
C
C Source: src/utils/post/old-graphics/preplot2.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: preplot2.F
C Revision 1.6  1992/01/16  09:50:59  cwelnak
C 6000 changes
C
C Revision 1.5  91/07/06  19:43:52  khan
C Grenoble Changes ...
C 
C Revision 1.4  91/04/05  15:50:50  cwelnak
C changed quotes in #includes
C 
C Revision 1.3  91/03/25  15:56:19  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.2  91/01/25  16:47:41  khan
C Ported to Ultrix
C 
C Revision 1.1  90/10/08  17:03:46  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	PROGRAM		PREPLOT2
C
C	PURPOSE		To generate a plottable file from any two or 
C			three rows of unformatted data.
C			The input may be from two different files, for
C			example a MIRR.01 and STAR.01. In this way it will
C			be possible to study the correlation between
C			different sections of the OS.
C
C	Link using GRA:GRALIB.LNK or GRA:TDSHARE.LNK 
C---
     	PROGRAM 	PREPLOT2
     	IMPLICIT	REAL*8		(A-E,G-H,O-Z)
#if defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#elif defined(vms)
        INCLUDE	        'SHADOW$INC:DIM.PAR/LIST'
C
C CHECK/FIXME:
C The X and Y vectors need to "REAL" for VMS for the Topdrawer calls,
C but REAL*8 for Unix and the rest of the civilized world.
C
	REAL		X, Y
#endif
     	REAL*8		RAY1(18,N_DIM),RAY2(18,N_DIM)
	REAL*8		X(N_DIM),Y(N_DIM),TEST(2)
     	INTEGER		CHECK
     	CHARACTER*80 	FILEIN1,FILEIN2,FILEOUT
     	CHARACTER*80	RSTRING
     	EXTERNAL	RSTRING

#ifndef vms
	CHARACTER*1024	PRIMVS
	CHARACTER*1024	PRIMVSPATH
#endif
C
     	WRITE(6,*)
     $      'All the losses will be determined by the SECOND file.'
     	FILEIN1 = RSTRING ('First file to be prepared ? ')
     	FILEIN2 = RSTRING ('Second file to be prepared ? ')
     	WRITE(6,*)'Columns to write out from file ',FILEIN1
     	KOL1	= IRINT (' ')
     	WRITE(6,*)'Columns to write out from file ',FILEIN2
     	KOL2	= IRINT (' ')
C
     	CALL	RBEAM18 (FILEIN1,RAY1,NCOL1,NPOINT,IFLAG,IERR)
     	IF (IERR.NE.0) STOP 'Error in file // 1 '
	IF (KOL1.GT.NCOL1) then
	  WRITE(6,*)'First file only has ',NCOL1,' columns.'
	  STOP
	END IF
     	CALL	RBEAM18 (FILEIN2,RAY2,NCOL2,NPOINT,IFLAG,IERR)
     	IF (IERR.NE.0) STOP 'Error in file // 2 '
	IF (KOL2.GT.NCOL2) then
	  WRITE(6,*)'Second file only has ',NCOL2,' columns.'
	  STOP
	END IF
C
	WRITE(6,*)'Options --- Enter'
     	WRITE(6,*)'0 for excluding the losses'
     	WRITE(6,*)' '
     	WRITE(6,*)'1 for including losses at a particular O.E.'
     	WRITE(6,*)'2 for plotting all the rays.'
     	WRITE(6,*)' '
     	WRITE(6,*)'3 for plotting ONLY the losses (all of them)'
     	WRITE(6,*)'4 for plotting ONLY the losses at a given O.E.'
	KLOSS = irint ('? ')
     	IF (KLOSS.EQ.1.OR.KLOSS.EQ.4) THEN
     	WRITE(6,*)
     $	'Flag value ( -11000 first O.E., -22000 sec O.E., etc.) ?'
     	CHECK	=  IRINT (' ? ')
     	ELSE
     	END IF
C
	KOUNT	=   0
     	DO 11 I=1,NPOINT
     	IF (RAY2(10,I).LT.0.0) KOUNT = KOUNT + 1
11     	CONTINUE
100     CONTINUE
     	WRITE(6,*)'***********'
	WRITE(6,*)'Found ',(NPOINT-KOUNT),' good points out of',NPOINT
C
#ifdef vms
	WRITE(6,*)'Output options :'
	WRITE(6,*)'  [ 0 ] store rays in a file'
	WRITE(6,*)'  [ 1 ] plot directly on screen'
	WRITE(6,*)'  [ 2 ] both'
	IOUT	= IRINT ('Then ? ')
	IF (IOUT.EQ.0.OR.IOUT.EQ.2) THEN
     	  FILEOUT = RSTRING ('Output file ? ')
	END IF
	IF (IOUT.EQ.1.OR.IOUT.EQ.2) THEN
	  CALL	SET_SCREEN	(' ',0,ITERM)
	END IF
#else /*!vms*/
	  WRITE(6,*) 'Display type:'
#if HAVE_XWINDOWS
	  WRITE(6,*) '  [ 0 ] Xwindow'
#endif
	  WRITE(6,*) '  [ 1 ] Tektronix'
	  WRITE(6,*) '  [ 2 ] Postscript file'
	  WRITE(6,*) '  [ 3 ] ASCII file'
	  ITERM = IRINT ('Terminal type:  ')
#if !HAVE_XWINDOWS
	  IF (ITERM.EQ.0) THEN
	      WRITE (*,*) 'No X Windows support. Using Postscript file'
	      ITERM=2
	  ENDIF
#endif
	  IF (ITERM.LT.0 .OR. ITERM.GT.3) THEN
	      WRITE (*,*) 'Invalid device Id. Using Postscript file'
	      ITERM=2
	  ENDIF
C
	  IOUT = 0
#endif/*unix*/
C
	NOUT	= 0
     	DO 300 I=1,NPOINT
	 IF (KLOSS.EQ.0) THEN
	  IF (RAY2(10,I).LT.0.0D0)   GO TO 300
	 ELSE IF (KLOSS.EQ.1) THEN
     	  IF (RAY2(10,I).LT.0.0D0.AND.INT(RAY2(10,I)).NE.CHECK) 
     $		GO TO 300
     	 ELSE IF (KLOSS.EQ.3) THEN
	  IF (RAY2(10,I).GE.0.0D0) GO TO 300
      	 ELSE IF (KLOSS.EQ.4) THEN
     	  IF (RAY2(10,I).LT.0.0D0.AND.INT(RAY2(10,I)).EQ.CHECK) THEN
	  ELSE
	    GO TO 300
     	  END IF
     	 ELSE
     	 END IF
	 NOUT	= NOUT + 1
	 X(NOUT)	= RAY1(KOL1,I)
	 Y(NOUT)	= RAY2(KOL2,I)
300     CONTINUE
C
C Ready for output.
C
#ifdef vms
	IF (IOUT.EQ.0.OR.IOUT.EQ.2) THEN
     	  OPEN (22,FILE=FILEOUT,STATUS='NEW')
     	    DO 12 I=1,NOUT
     	      WRITE (22,*)	X(I),Y(I)
12     	    CONTINUE
     	  CLOSE (22)
	END IF
	IF (IOUT.EQ.1.OR.IOUT.EQ.2) THEN
	  CALL TDNEWP
	  CALL TDPLOT (NOUT,X,Y)
	  CALL SET_SCREEN	(' ',1,ITERM)
	END IF
#else /*!vms*/
C write out preplot.dat file
C
     	   OPEN (22,FILE='preplot2.dat',STATUS='UNKNOWN',
     $		FORM='FORMATTED')
     	    DO 15 I=1,NOUT
     	      WRITE (22,4500)	X(I),Y(I)
15     	    CONTINUE
     	   CLOSE (22)
C	IF (IOUT.EQ.3) THEN
C
C Write preplot.prm (primvs commands)
C don't need to write out command file for ascii only output
C
	IF (ITERM.NE.3) THEN
	   XMIN = 1.0D20
	   XMAX = -1.0D20
	   YMIN = 1.0D20
	   YMAX = -1.0D20

	   DO 1019 I = 1,NOUT
	      TEST(1) = X(I)
	      TEST(2) = Y(I)
	      XMIN = MIN(XMIN,TEST(1))
	      XMAX = MAX(XMAX,TEST(1))
	      YMIN = MIN(YMIN,TEST(2))
	      YMAX = MAX(YMAX,TEST(2))
1019	   CONTINUE
	   DELX = XMAX - XMIN
	   DELY = YMAX - YMIN
	   XCEN = (XMAX + XMIN)/2.0D0
	   YCEN = (YMAX + YMIN)/2.0D0
	   XLOW = XCEN - 0.6125D0*DELX
	   XUPP = XCEN + 0.6125D0*DELX
	   YLOW = YCEN - 0.6125D0*DELY
	   YUPP = YCEN + 0.6125D0*DELY
C now write out primvs command file
	   OPEN (23,FILE='preplot2.prm',STATUS='UNKNOWN',
     $		FORM='FORMATTED')
	   WRITE (23,*) '# Primvs command file to plot PREPLOT2 output'
	   IF      (ITERM.EQ.0) THEN
	     WRITE (23,*) '# Initialize Xwindow display'
	     WRITE (23,*) ' '
	     WRITE (23,*) 'initpage(xwin)'
	   ELSE IF (ITERM.EQ.1) THEN
	     WRITE (23,*) '# Initialize Tektronix display'
	     WRITE (23,*) ' '
	     WRITE (23,*) 'initpage(tekt)'
	   ELSE IF (ITERM.EQ.2) THEN
	     WRITE (23,*) '# Initialize Postscript file'
	     WRITE (23,*) ' '
	     WRITE (23,*) 'setcolor(0)'
	     WRITE (23,*) 'initpage(ps,"preplot2.ps")'
	   END IF
	   WRITE (23,*) '# Set limits on viewing window, plot, and '
	   WRITE (23,*) '# character size.'
	   WRITE (23,*) 'regionr(0.1,0.1,0.9,0.9,1.0)'
	   WRITE (23,3030) XLOW,XUPP,YLOW,YUPP
	   WRITE (23,*) 'color(green)'
	   WRITE (23,*) 'symbol(1)'
	   WRITE (23,*) 'scalechr(0.8)'
	   WRITE (23,*) ' '
	   WRITE (23,*) '# Plot data points from preplot2.dat '
	   WRITE (23,*) 'plotp("preplot2.dat")'
	   WRITE (23,*) '# Draw axes and tickmarks'
	   WRITE (23,*) 'box("bcnst",0,0,"bcnstv",0,0)'
	   WRITE (23,*) 'closepage'
	   WRITE (23,*) 'exit'
	   CLOSE (23)
C	ENDIF
3030	FORMAT ('xyrange(',E15.8,',',E15.8,',',E15.8,',',E15.8,')')
C
C
	IFLAG = 0
	CALL PROGPATH ('primvs', PRIMVS, IFLAG)
	PRIMVSPATH = PRIMVS(1:IBLANK(PRIMVS)) // ' -i preplot2.prm'
	WRITE(*,*) 'Executing program: ' // 
     $		PRIMVSPATH(1:IBLANK(PRIMVSPATH))
#if !defined(__CYGWIN32__)
	CALL SYSTEM (PRIMVSPATH)
#else
	IFLAG = 0
	CALL RUNPRIMVS (PRIMVS(1:IBLANK(PRIMVS)),'preplot2.prm',iflag)
#endif
	ENDIF

#endif /*unix*/

4500	format (g21.14,g21.14)
     	END


