C +++
C
C Source: src/utils/post/comb_ray.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: comb_ray.F
C Revision 1.6  1991/07/06  19:43:52  khan
C Grenoble Changes ...
C
C Revision 1.5  91/04/05  15:50:38  cwelnak
C changed quotes in #includes
C 
C Revision 1.4  91/03/25  16:05:17  khan
C PROGRAM COMB_RAY statement MUST be present before any INCLUDE statement.
C 
C Revision 1.3  91/03/25  15:55:53  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.2  91/01/25  16:47:08  khan
C Ported to Ultrix
C 
C Revision 1.1  90/10/08  17:03:39  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	PROGRAM		COMBRAY
C
C	PURPOSE		To combine two ray files into one.
C
C---
	PROGRAM		COMBRAY
#if defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#elif defined(vms)
        INCLUDE	        'SHADOW$INC:DIM.PAR/LIST'
#endif
	REAL*8		RAY2(12,N_DIM), RAY(12,N_DIM)
	REAL*8		AP2(3,N_DIM),AP(3,N_DIM)
	REAL*8		PHASE2(3,N_DIM),PHASE(3,N_DIM)
	CHARACTER*80	FIN1,FIN2,FOUT,RSTRING
	FIN1	= RSTRING ('Input file 1 : ')
	FIN2	= RSTRING ('Input file 2 : ')
	FOUT	= RSTRING ('Output file : ')
	CALL	RBEAM	(FIN1,RAY,PHASE,AP,NCOL1,NP1,IFLAG,IERR)
	CALL	RBEAM	(FIN2,RAY2,PHASE2,AP2,NCOL2,NP2,IFLAG,IERR)
	IF (NCOL1.NE.NCOL2) THEN	
     	  WRITE(6,*)
     $	'Warning ! File 1 and 2 has different number of columns.'
	  NCOL	= MAX(NCOL1,NCOL2)
	ELSE
	  NCOL	= NCOL1
	END IF
	NP	= NP1 + NP2
	IF (NP.GT.N_DIM)	
     $	    WRITE(6,*)'Warning ! More than a total of ',N_DIM, ' rays.'
	DO 10 I = 1, NP2
	  DO 5 J = 1, 11
	    RAY	(J, NP1+I)	= RAY2(J,I)
5	  CONTINUE
	    RAY	(12,NP1+I)	= NP1+I
10	CONTINUE
	IF (NCOL.EQ.13) THEN
	  DO 20 I = 1, NP2
	    PHASE (1,NP1+I)	= PHASE2(1,I)
20	  CONTINUE
	ELSE IF (NCOL.EQ.18) THEN
	  DO 30 I = 1, NP2
	    DO 25 J = 1, 3
	      PHASE (J,NP1+I)	= PHASE2(J,I)
	      AP    (J,NP1+I)	= AP2   (J,I)
25	    CONTINUE
30	  CONTINUE
	END IF
        IFORM = 0
	CALL WRITE_OFF (FOUT,RAY,PHASE,AP,NCOL,NP,IFLAG,IFORM,IERR)
	END
