C +++
C
C Source: src/utils/optics/transmit.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: transmit.F
C Revision 1.6  1991/07/06  19:42:54  khan
C Grenoble Changes ...
C
C Revision 1.5  91/04/05  15:21:25  cwelnak
C changed quotes in #includes
C 
C Revision 1.4  91/03/25  15:52:15  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.3  91/03/25  15:48:53  khan
C Getting ready for SUN port ...
C 
C Revision 1.2  90/10/10  13:36:19  khan
C Added conditional compilation statements to avoid VMS specific stuff.
C 
C 
C Revision 1.1  90/10/10  13:32:54  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	PROGRAM		TRANS
C
C	Purpose		To compute the transmission of a beamline from
C			the universal SR curve, the reflectivities and
C			transmission coefficient as obtained from the 
C			Fresnel equations and the Los Alamos database.
C
C---
     	PROGRAM		TRANSMIT
     	CHARACTER*75	HEADER
     	CHARACTER*80	FILEOUT(20),LINE,COMMENT,RSTRING, TMPSTR
     	CHARACTER*9	ROOT_DAT,ROOT_CUM,FILE_LOG
	REAL*8		RNUMBER
     	COMMON	/OP_CON	/  ESTART,EFINAL,ESTEP,NP,IUNIT
     	COMMON	/DAT	/  X(10000), YACT(10000)
     	DIMENSION	YOLD (10000)
     	DATA	ROOT_DAT 	/ '000000'/
     	DATA	ROOT_CUM	/ '000000'/
C
	CHARACTER*132	SRCOMP
	DATA		SRCOMP	/ 'SRCOMP' /
C
C Define the useful parameters
C
     	DO 31 I=1,75
     	  HEADER(I:I) = '+'
31      CONTINUE
#ifdef vms
     	OPEN	(33, FILE='TRANSMIT', STATUS='NEW')
#else
     	OPEN	(33, FILE='TRANSMIT', STATUS='UNKNOWN')
	REWIND(33)
#endif
     	TMPSTR	= RSTRING('DATA file roots for local properties : ')
	ILEN = LTRIM (TMPSTR)
	DO 199 I = 1, ILEN
	    ROOT_DAT (I:I) = TMPSTR (I:I)
 199	CONTINUE
D     	ROOT_DAT	= RSTRING('DATA file roots for local properties : ')
     	TMPSTR	= RSTRING('CUMULATIVE DATA file roots : ')
	ILEN = LTRIM (TMPSTR)
	DO 299 I = 1, ILEN
	    ROOT_CUM (I:I) = TMPSTR (I:I)
 299	CONTINUE
D     	ROOT_CUM	= RSTRING('CUMULATIVE DATA file roots : ')

     	RNORM = 1.0
     	INORM = 
     $	IYES('Do you want a conversion to Watts/cm^2 ? [Y/N] ? > ')
     	IF (INORM.EQ.1) THEN
     	  WRITE(6,*)'Please enter the vertically scanned height ',
     $ '(including overshoot) in CM.'
     	  HEIGHT = RNUMBER ('> ')
     	  WRITE(6,*)
     $'The program will assume that you have used 1 mrad of orbit. If',
     $' you have specified 1 mrad when creating the source,',
     $' simply enter 1. If not, enter the ',
     $'number of milliradians you used.'
     	  ANGLE = RNUMBER ('Number of milliradians used: ')
     	  WRITE(6,*)'Please enter the horizontal dimension of the',
     $' exposed field [cm].'
     	  HORIZ = RNUMBER('> ')
     	  AREA	= HORIZ*HEIGHT
     	  WRITE(6,*)'Distance from the tangent point [m] ? '
     	  DIST	=  RNUMBER ('> ')
     	  RANGLE= HORIZ/DIST/100.0*1000 !Subtended milliradians
     	  RNORM = 1.0/ANGLE		!Power per mrad from source file
     	  RNORM = RNORM*RANGLE		!Total power accepted
     	  RNORM = RNORM/AREA		!Power/cm^2, which is independent
     					!of horizontal size.
     	  WRITE(6,*)'Total area is: ',AREA
     	  WRITE(6,*)'All set. '
     	END IF
	IUNIT	= IRINT 
     $('Is the source spectrum in function of : [1] eV  [2] Angs ? ')
#ifdef vms
     	OPEN	(20, FILE=SRCOMP, STATUS='OLD', READONLY)
#else
     	OPEN	(20, FILE=SRCOMP, STATUS='OLD')
#endif
     	 DO 32 I=1,10000
     	   READ (20,*,ERR=11,END=11) X(I),YOLD(I)
     	   YOLD(I) = YOLD(I)*RNORM
32       CONTINUE
11	 NP = I - 1
     	CLOSE (20)
     	WRITE(6,*)'Read ',NP,' records.'
     	CALL	INTEGR	(X, YOLD, NP, RES)
     	ESTART = X(1)
     	EFINAL = X(NP)
     	ESTEP = X(2) - X(1)
     	WRITE (33,*) HEADER
     	WRITE (33,*) 
     $'         PROGRAM   TRANSMIT V1.0 -- SEPTEMBER 1984  '
     	WRITE (33,*) HEADER
     	WRITE (33,'(1X,//)')
	IF (IUNIT.EQ.1) THEN
          WRITE (33,*) 'Photon energy range used:'
	ELSE
	  WRITE (33,*) 'Wavelength (Angs) range used :'
	END IF
     	WRITE (33,*) '       start            : ',ESTART
     	WRITE (33,*) '       end              : ',EFINAL
        WRITE (33,*) '       step             : ',ESTEP
     	IF (INORM.EQ.1) THEN
     	  WRITE (33,'(1x,/)')
     	  WRITE (33,*) 'Results are in Watts/cm^2.'
     	  WRITE (33,'(1x,/)')
     	  WRITE (33,*) 'Power in source file [W] = ',RES/RNORM
     	  WRITE (33,*) 'Full power in W/cm^2 = ',RES
     	  WRITE (33,'(1x,/)')
     	  WRITE (33,*) 'Exposure field is defined by: '
     	  WRITE (33,'(1X,/)')
     	  WRITE (33,*) 'Horizontal [cm] = ',HORIZ
     	  WRITE (33,*) 'Vertical   [cm] = ',HEIGHT
     	  WRITE (33,*) 'Area       [cm] = ',AREA
     	  WRITE (33,*) 'Milliradians    = ',RANGLE
     	  WRITE (33,*) 'Distance   [m ] = ',DIST
     	  WRITE (33,'(1X,/)')
     	ELSE
     	  WRITE (33,'(1X,/)')
     	  WRITE (33,*) 'Incoming power          : ',RES/RNORM
     	  WRITE (33,'(1X,/)')
     	END IF
     	WRITE(6,*)'Initial power is: ',RES
10     	WRITE(6,FMT='(/,1X,A,2X,I4,/)')'Currently at Element N. ',IELEM
     	IELEM	= IRINT
     $       ('Enter a negative number to exit, zero to cancel; OE ? ')
     	IF (IELEM.LT.0)	CALL EXIT (0)
     	IF (IELEM.EQ.0) GO TO 10
     	I_MAT	= IRINT
     $		('Enter [ 0 ] for pure element, [ 1 ] for compound: ')
C
C Writes out the log file
C
     	WRITE (33,*) '==============================================='
     	WRITE (33,*) '==============================================='
     	WRITE (33,*) 'Optical Element : ',IELEM
     	IF (I_MAT.EQ.0) THEN
     	  CALL	OPT_PROP_ELEM (ISTAT)
     	ELSE
     	  CALL	OPT_PROP_COMP (ISTAT)
     	END IF
     	IF (ISTAT.LT.0.0) THEN
     	  LINE	= '>>> Element canceled.'
     	  GO TO 10
     	END IF
C
C Writes out the local data
C
     	WRITE (ROOT_DAT(7:9),1030) IELEM
1030	FORMAT (I3.3)
#ifdef vms
     	OPEN (20, FILE=ROOT_DAT, STATUS='NEW')
#else
     	OPEN (20, FILE=ROOT_DAT, STATUS='UNKNOWN')
	REWIND(20)
#endif
     	 DO 13 I=1,NP
     	  WRITE (20,*)	X(I),YACT(I)
13       CONTINUE
     	CLOSE (20)
C
C Multiply old file by new one: YOLD = yold * yact
C
     	CALL 	MULTI	(YOLD,YACT,NP)
C
C Evaluates total flux
C
     	CALL	INTEGR	(X, YOLD, NP, RES)
     	IF (INORM.NE.1) THEN
     	  WRITE (6,*) 'OUT > Total flux is: ',RES
     	ELSE
     	  WRITE (6,*) 'OUT > Power density [W/cm^2] is ',RES
     	END IF
     	COMMENT = RSTRING ('Comment for this OE > ')
     	WRITE (33,'(1x,/,1x,A)') '---------------------------'
     	WRITE (33,*) 'OE # ',IELEM 
     	WRITE (33,*) COMMENT
     	IF (INORM.NE.1) THEN
     	  WRITE (33,*) 'OUT > Total flux is: ',RES
     	ELSE
     	  WRITE (33,*) 'OUT > Power density [W/cm^2] is ',RES
     	END IF
     	WRITE (33,'(1X,/)')
C
C Writes out all results
C
     	WRITE (ROOT_CUM(7:9),1030) IELEM
#ifdef vms
     	OPEN (20, FILE=ROOT_CUM, STATUS='NEW')
#else
     	OPEN (20, FILE=ROOT_CUM, STATUS='UNKNOWN')
	REWIND(20)
#endif
     	 DO 14 I=1,NP
     	  WRITE (20,*)	X(I),YOLD(I)
14	 CONTINUE
     	CLOSE (20)
     	GO TO 10
1000	FORMAT (1X,': ',A,/,1x,'> ',$)
     	END
C+++
C	SUBROUTINE	OPT_PROP_ELEM	(ISTAT)
C
C	Purpose		Returns either the reflectivity of a mirror 
C			or the transmission of a film, depending on the
C			
C	Arguments	ISTAT = 0 , normal completion
C			      = -1, error return
C			      = -2, impossible to read data
C---
     	SUBROUTINE	OPT_PROP_ELEM	( istat )

     	DIMENSION	OUTFIL(420,2),ENERGY(420),RF1(420),RF2(420)
	EQUIVALENCE	(OUTFIL(1,1),RF1(1))
	EQUIVALENCE	(OUTFIL(1,2),RF2(1))
	REAL*8		RNUMBER
     	INTEGER *4 NUMBER
	CHARACTER*2	ELEMENT
	CHARACTER*80	RSTRING
     	COMMON	/OP_CON	/  ESTART,EFINAL,ESTEP,NPOINT,IUNIT
     	COMMON	/DAT	/  X(10000), YACT(10000)
     	DATA	PI     	/  3.1415 92653 58979 32384 62643 D0 /
     	DATA	PIHALF 	/  1.5707 96326 79489 66192 31322 D0 /
     	DATA	TWOPI 	/  6.2831 85307 17958 64679 25287 D0 /
     	DATA	TODEG 	/ 57.2957 79513 08232 08767 98155 D0 /
     	DATA	TORAD	/  0.0174 53292 51994 32957 69237 D0 /
	DATA	TOCM	/  1.239 852	D-4		     /
	DATA	TOANGS 	/  1.239 852    D+4		     /
     	DATA	RADIUS	/  2.817939     E-13		     /
     	DATA	AVOG	/  6.022098     E+23 		     /
     	ISTAT	=  0
     	ELEMENT	= RSTRING('Enter atomic symbol (capitalized) : ')
     	DENSITY	= RNUMBER('Density : ')
     	IWHAT	= IRINT('Mirror [ 1 ] or filter [ 0 ] : ')
     	IF (IWHAT.EQ.1) THEN
     	  THETAD	= RNUMBER('Incidence angle [ degrees ] : ')
     	  WRITE (33,'(1x,a,G12.5,a)') 
     $'Defined MIRROR at ',THETAD,' degrees'
     	ELSE
     	  THICK		= RNUMBER('Thickness (microns) : ')
     	  WRITE (33,'(1x,a,G12.5,a)') 
     $'Defined FILTER ',THICK,' microns thick'
     	  THICK	=   THICK/10000
     	END IF
** Get the data
	CALL 	READLIB(ELEMENT,NUMBER,ATWT,RMU,EMF,ENERGY,RF1,RF2)
** Computes atomic concentration
     	ATOMS	=   DENSITY/ATWT*AVOG
     	WRITE (33,'(1X,A,I3,A,1A2)') 
     $'Working with    Z = ',NUMBER,
     $'       Symbol: ',ELEMENT
     	WRITE (33,*) 'Atomic Weight: ',ATWT,' and density ',DENSITY,
     $' g/cm3'
** Computes the ALPHA and gamma coefficients.
*** Finds and interpolate for the photon energy.
	ELFACTOR	= LOG10(1.0D4/30.0D0)/300.0
     	DO 16 I=1,NPOINT
	IF (IUNIT.EQ.2) THEN
	  PHOTON	= TOANGS/X(I)
	ELSE
     	  PHOTON	=  X(I)
	END IF
	NENER 	=   LOG10(PHOTON/30.0D0)/ELFACTOR + 1
     	F1	=   OUTFIL(NENER,1) + 
     $	(OUTFIL(NENER+1,1) - OUTFIL(NENER,1))*(PHOTON - ENERGY(NENER))/
     $	(ENERGY(NENER+1) - ENERGY(NENER))
     	F2	=   OUTFIL(NENER,2) + 
     $	(OUTFIL(NENER+1,2) - OUTFIL(NENER,2))*(PHOTON - ENERGY(NENER))/
     $	(ENERGY(NENER+1) - ENERGY(NENER))
*** Computes now ALPHA and gamma
     	WAVE	=   TOCM/PHOTON
     	  IF (IWHAT.EQ.1) THEN
     	ALPHA	=   RADIUS/PI*(WAVE**2)*ATOMS*F1
     	GAMMA	=   RADIUS/PI*(WAVE**2)*ATOMS*F2
** Computes the optical coefficients.
     	THETA	=   TORAD*THETAD
     	DELTA	=   PIHALF - THETA
     	RHO	=   (SIN(DELTA))**2 - ALPHA
     	RHO	=   RHO + SQRT ((SIN(DELTA)**2 - ALPHA)**2 + GAMMA**2)
     	RHO	=   SQRT(RHO/2)
** Computes now the reflectivity for s-pol
     	RS1	=   4*(RHO**2)*(SIN(DELTA)-RHO)**2 + GAMMA**2
     	RS2	=   4*(RHO**2)*(SIN(DELTA)+RHO)**2 + GAMMA**2
     	RS	=   RS1/RS2
** Computes now the polarization ratio
     	RATIO1	=   4*RHO**2*(RHO*SIN(DELTA)-COS(DELTA)**2)**2 +
     $		    GAMMA**2*SIN(DELTA)**2
     	RATIO2	=   4*RHO**2*(RHO*SIN(DELTA)+COS(DELTA)**2)**2 +
     $		    GAMMA**2*SIN(DELTA)**2
     	RATIO	=   RATIO1/RATIO2
** The reflectivity for p light will be
     	RP	=   RS*RATIO
** For an unpolarized beam we have
     	RUNP	=   0.5*(RS+RP)
     	YACT(I)	=   RUNP
     	 ELSE
        ABSORP	=  2*RADIUS*WAVE*ATOMS*F2
** Computes the film absorption
     	ABSOR	=   EXP(-THICK*ABSORP)
     	YACT(I)	=   ABSOR
     	 END IF
16     	CONTINUE
     	RETURN
1000	CONTINUE
     	ISTAT = -1
     	RETURN
1010	CONTINUE
     	ISTAT = -2
     	RETURN
     	END
C+++
C	SUBROUTINE	OPT_PROP_COMP
C
C---
     	SUBROUTINE	OPT_PROP_COMP	( ISTAT )
     	DIMENSION	OUTFIL(420,2),ENERGY(420),IREL(5)
	REAL*8		RNUMBER
     	INTEGER *4 	NUMBER,NATOM(5)
	CHARACTER*2	ELEMENT(5),ELE
	CHARACTER*80	RSTRING
     	COMMON	/OP_CON	/  ESTART,EFINAL,ESTEP,NPOINT,IUNIT
     	COMMON	/DAT	/  X(10000), YACT(10000)
     	DIMENSION	OUTFIL11(420),OUTFIL12(420)
     	DIMENSION	OUTFIL21(420),OUTFIL22(420)
     	DIMENSION	OUTFIL31(420),OUTFIL32(420)
     	DIMENSION	OUTFIL41(420),OUTFIL42(420)
     	DIMENSION	OUTFIL51(420),OUTFIL52(420)
     	DIMENSION	AT(5),RREL(5)
     	DATA	PI     	/  3.1415 92653 58979 32384 62643 D0 /
     	DATA	PIHALF 	/  1.5707 96326 79489 66192 31322 D0 /
     	DATA	TWOPI 	/  6.2831 85307 17958 64679 25287 D0 /
     	DATA	TODEG 	/ 57.2957 79513 08232 08767 98155 D0 /
     	DATA	TORAD	/  0.0174 53292 51994 32957 69237 D0 /
	DATA	TOCM	/  1.239 852	D-4		     /
	DATA	TOANGS 	/  1.239 852    D+4		     /
     	DATA	IREL	/ 5*0	/
     	RADIUS	=   2.817939 E-13
     	AVOG	=   6.022098 E+23
     	ISTATUS	= 0
     	DENSITY	= RNUMBER('Density [ g/cm3 ] : ')
     	IWHAT	= IRINT('Mirror [ 1 ] or filter [ 0 ] : ')
     	IF (IWHAT.EQ.0) THEN
     	  THICK		= RNUMBER('Thickness (microns) : ')
     	  WRITE (33,'(1x,a,g12.5,a)') 
     $'Defined FILTER ',THICK,' microns thick'
     	  THICK	=   THICK/10000
      	ELSE
     	  THETAD	= RNUMBER('Incidence angle : ')
     	  WRITE (33,'(1x,a,G12.5,a)') 
     $'Defined MIRROR at ',THETAD,' degrees'
      	END IF
     	DO 17 I = 1,5
     	  IREL(I) = 0
     	  RREL(I) = 0.0
17	CONTINUE
     	WRITE(6,*)'The program is setup to compute optical constants of'
     	WRITE(6,*)'compounds with up to 5 elements.'
     	NATOMS	= IRINT('How many atomic species ? ')
     	NTOT = 0
     	WRITE(6,*)'H2O would be: H, 2 and O, 1.'
     	DO 18 I = 1,NATOMS
     	  WRITE(6,*)'Enter atomic symbol (capitalized) and ',
     $'formula index for : ',I
	  ELEMENT(I) = RSTRING(' ')
     	  IREL(I)    = IRINT(' ')
     	  NTOT = NTOT + IREL(I)
18	CONTINUE
     	DO 19 I=1,NATOMS
     	  RREL(I) = FLOAT(IREL(I))/NTOT
19	CONTINUE
** Get the data. F1 and F2 are then 'averaged' together
     	RMOL	= 0.0
     	GO TO (55,44,33,22,11)	NATOMS
11	ELE	= ELEMENT(5)
	CALL READLIB(ELE,NUMBER,ATWT,RMU,EMF,ENERGY,OUTFIL51,OUTFIL52)
	NATOM(5)	= NUMBER
     	RMOL	=          ATWT*IREL(5)
22	ELE	= ELEMENT(4)
	CALL READLIB(ELE,NUMBER,ATWT,RMU,EMF,ENERGY,OUTFIL41,OUTFIL42)
	NATOM(4)	= NUMBER
     	RMOL	= RMOL+          ATWT*IREL(4)
33	ELE	= ELEMENT(3)
	CALL READLIB(ELE,NUMBER,ATWT,RMU,EMF,ENERGY,OUTFIL31,OUTFIL32)
	NATOM(3)	= NUMBER
     	RMOL	= RMOL+         ATWT*IREL(3)
44	ELE	= ELEMENT(2)
	CALL READLIB(ELE,NUMBER,ATWT,RMU,EMF,ENERGY,OUTFIL21,OUTFIL22)
	NATOM(2)	= NUMBER
     	RMOL	= RMOL+         ATWT*IREL(2)
55	ELE	= ELEMENT(1)
	CALL READLIB(ELE,NUMBER,ATWT,RMU,EMF,ENERGY,OUTFIL11,OUTFIL12)
	NATOM(1)	= NUMBER
     	RMOL	= RMOL+         ATWT*IREL(1)
     	WRITE (33,1110)
     	DO 21 I=1,NATOMS
     	WRITE (33,1111) ELEMENT(I),IREL(I)
21	CONTINUE
1110	FORMAT (1X,'Formula:  ',$)
1111	FORMAT ('+',A2,'(',I2,') ',$)
     	WRITE (33,*)
** Computes atomic concentrations and molecular weigth
     	RMOLEC	=   DENSITY/RMOL*AVOG	! This is the number of molecules
     	WRITE (33,*)
     $'Molecular weight is : ',RMOL,' Number of molecules/cm3: ',RMOLEC
     	AT1	=   RMOLEC*irel(1)
     	AT(1)	=   AT1
     	AT2	=   RMOLEC*irel(2)
     	AT(2)	=   AT2
     	AT3	=   RMOLEC*irel(3)
     	AT(3)	=   AT3
     	AT4	=   RMOLEC*irel(4)
     	AT(4)	=   AT4
     	AT5	=   RMOLEC*irel(5)
     	AT(5)	=   AT5
     	WRITE (33,*) 'Atoms/Cm3 of each species:'
     	WRITE (33,1112) (ELEMENT(I),I=1,NATOMS)
     	WRITE (33,1113) (AT(I),I=1,NATOMS)
1112	FORMAT (5X,A2,T20,A1,A1,T35,A1,A1,T50,A1,A1,T65,A1,A1)
1113	FORMAT (1X,G12.5,T15,G12.5,T30,G12.5,T45,G12.5,T60,G12.5)
     	WRITE (33,*) ' Density ',DENSITY,' g/cm3'
** Computes now the effective F1 and F2
     	DO 42 I = 1,420
     	F1	=   0.0
     	F2	=   0.0
     	GO TO (155,144,133,122,111)	NATOMS
111	F1	=        OUTFIL51(I)*AT5
     	F2	=        OUTFIL52(I)*AT5
122	F1	=   F1 + OUTFIL41(I)*AT4
     	F2	=   F2 + OUTFIL42(I)*AT4
133	F1	=   F1 + OUTFIL31(I)*AT3
     	F2	=   F2 + OUTFIL32(I)*AT3
144	F1	=   F1 + OUTFIL21(I)*AT2
     	F2	=   F2 + OUTFIL22(I)*AT2
155	F1	=   F1 + OUTFIL11(I)*AT1
     	F2	=   F2 + OUTFIL12(I)*AT1
     	OUTFIL(I,1)	=   F1
     	OUTFIL(I,2)	=   F2
42      CONTINUE 
** Computes the ALPHA and gamma coefficients.
*** Finds and interpolate for the photon energy.
	ELFACTOR	= LOG10(1.0D4/30.0D0)/300.0
     	DO 23 I=1,NPOINT
	IF (IUNIT.EQ.2) THEN
	  PHOTON	= TOANGS/X(I)
	ELSE
     	  PHOTON	=   X(I)
	END IF
	NENER	=   LOG10(PHOTON/30.0D0)/ELFACTOR + 1
     	F1	=   OUTFIL(NENER,1) + 
     $	(OUTFIL(NENER+1,1) - OUTFIL(NENER,1))*(PHOTON - ENERGY(NENER))/
     $	(ENERGY(NENER+1) - ENERGY(NENER))
     	F2	=   OUTFIL(NENER,2) + 
     $	(OUTFIL(NENER+1,2) - OUTFIL(NENER,2))*(PHOTON - ENERGY(NENER))/
     $	(ENERGY(NENER+1) - ENERGY(NENER))
*** Computes now ALPHA and gamma
     	WAVE	=   TOCM/PHOTON
     	ALPHA	=   RADIUS/PI*(WAVE**2)*F1
     	GAMMA	=   RADIUS/PI*(WAVE**2)*F2
     	  IF (IWHAT.EQ.1) THEN
** Computes the optical coefficients.
     	THETA	=   TORAD*THETAD
     	DELTA	=   PIHALF - THETA
     	RHO	=   (SIN(DELTA))**2 - ALPHA
     	RHO	=   RHO + SQRT ((SIN(DELTA)**2 - ALPHA)**2 + GAMMA**2)
     	RHO	=   SQRT(RHO/2)
** Computes now the reflectivity for s-pol
     	RS1	=   4*(RHO**2)*(SIN(DELTA)-RHO)**2 + GAMMA**2
     	RS2	=   4*(RHO**2)*(SIN(DELTA)+RHO)**2 + GAMMA**2
     	RS	=   RS1/RS2
** Computes now the polarization ratio
     	RATIO1	=   4*RHO**2*(RHO*SIN(DELTA)-COS(DELTA)**2)**2 +
     $		    GAMMA**2*SIN(DELTA)**2
     	RATIO2	=   4*RHO**2*(RHO*SIN(DELTA)+COS(DELTA)**2)**2 +
     $		    GAMMA**2*SIN(DELTA)**2
     	RATIO	=   RATIO1/RATIO2
** The reflectivity for p light will be
     	RP	=   RS*RATIO
** For an unpolarized beam we have
     	RUNP	=   0.5*(RS+RP)
        YACT(I)=   RUNP
** Computes now the penetration depth
     	  ELSE
C
C     	DEPTH	=   WAVE/TWOPI/GAMMA
C     	ABSORP	=   1/DEPTH
C
	ABSORP  =   TWOPI*GAMMA/WAVE
** Computes the film absorption
     	ABSOR	=   EXP(-THICK*ABSORP)
     	YACT (I) = ABSOR
     	  END IF
23	CONTINUE
	RETURN
     	END
C+++
C	SUBROUTINE	MULTI
C
C	PURPOSE		Multiply two arrays, same length
C---
     	SUBROUTINE	MULTI	(Y1, Y2, N1)
     	DIMENSION	Y1(1), Y2(1)
     	DO 24 I=1,N1
     	  Y1(I) = Y1(I)*Y2(I)
24	CONTINUE
     	RETURN
     	END
C+++
C	SUBROUTINE	INTEGR
C
C	PURPOSE		Performs a trapezoidal integration of an array
C
C---
     	SUBROUTINE	INTEGR	(X, Y, N, RES)
     	DIMENSION	X(N), Y(N)
     	RES = 0.0
     	 DO 26 I=2,N
     	   YAVER = 0.5*( Y(I) + Y(I-1) )
     	   DELTA = X(I) - X(I-1)
     	   RES = RES + YAVER*DELTA
26	 CONTINUE
     	RETURN
     	END
