C +++
C
C Source: src/utils/optics/grating_set.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: grating_set.F
C Revision 1.6  1992/01/15  16:18:11  cwelnak
C 6000 changes
C
C Revision 1.5  91/07/06  19:42:54  khan
C Grenoble Changes ...
C 
C Revision 1.4  91/04/05  15:21:22  cwelnak
C changed quotes in #includes
C 
C Revision 1.3  91/03/25  15:52:09  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.2  91/03/25  15:48:46  khan
C Getting ready for SUN port ...
C 
C Revision 1.1  90/10/10  13:32:53  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	PROGRAM		GratingSet
C
C	PURPOSE		To compute important angles for diffraction
C			gratings. In particular diffraction angles, 
C			rotation angles, etc.
C
C	ALGORITHM	Direct Calculation
C
C	INPUT		From keyboard
C
C	OUTPUT		To keyboard and files
C
C---
     	IMPLICIT REAL*8 (A-H,O-Z)
     	
     	DATA	PI	/  3.1415 92653 58979 32384 62643 D0 /
     	DATA	PIHALF 	/  1.5707 96326 79489 66192 31322 D0 /
     	DATA	TWOPI 	/  6.2831 85307 17958 64679 25287 D0 /
     	DATA	TODEG 	/ 57.2957 79513 08232 08767 98155 D0 /
     	DATA    TORAD	/  0.0174 53292 51994 32957 69237 D0 /
	DATA	TOANGS	/  1.239 852	D4		     /

        IANSW = IYES ('File out the results ? ')
        IF (IANSW.EQ.1) THEN
#ifdef vms
     	  OPEN (20,FILE='DIFFRAC',STATUS='NEW')
#else
     	  OPEN (20,FILE='DIFFRAC',STATUS='UNKNOWN')
	  REWIND(20)
#endif
     	END IF
C
1     	WRITE(6,*)'Options:'
     	WRITE(6,*)'Diffraction angles for given blaze..... [ 0 ]'
     	WRITE(6,*)'             fixed incidence angle..... [ 1 ]'
     	WRITE(6,*)'              fixed included angle..... [ 2 ]'
     	WRITE(6,*)' '
     	ITYPE = IRINT ('Choice ? ')
     	WRITE(6,*)'Do you want to use eV [ 0 ] or Angstroms [ 1 ] ? '
     	IPHOT	=  IRINT ('Choice ? ')
     	IF (IPHOT.EQ.1) THEN
     	  RLAM = RNUMBER ('Wavelength ? ')
     	  PHOT	= TOANGS/RLAM
     	ELSE
     	  PHOT	= RNUMBER ('Photon Energy ? ')
     	  RLAM	= TOANGS/PHOT
     	END IF
C
     	RULING	= RNUMBER ('Grating Line Density [ Lines / mm ] ? ')
     	SPACING	=  0.1D0/RULING
     	ORDER	= RNUMBER ('Order [ negatives are inside ] ? ')
C
C Begin calculations
C
     	IF (ITYPE.EQ.0) THEN
     	  BLAZE = RNUMBER ('Blaze angle [ degrees ]: ')
     	  ALPHA = BLAZE 
     $      + TODEG*(ACOS(-ORDER*RLAM*1.0D-7/2*RULING/SIN(TORAD*BLAZE)))
     	  BETA	=   ALPHA - 2*BLAZE
     	 IF (ABS(SINBETA).GE.1.0D0)	THEN
		WRITE(6,*)
     $'**************************************************************'
     $,'*********************     WARNING   **************************'
     $,'**************************************************************'
     $,'SINBETA larger than 1.0 >>>>>> ',SINBETA
     $,'**************************************************************'
		GO TO 1
      	 END IF
     	  WRITE(6,*)'Incidence angle   ALPHA: ', ALPHA
     	  WRITE(6,*)'Diffraction angle BETA:  ', BETA
     	 IF (IANSW.EQ.1) THEN
     	   WRITE (20,*) '-------------------------------------------'
     	   WRITE (20,*) '-------------------------------------------'
     	   WRITE (20,*) '         Blazed Grating Case.'
     	   WRITE (20,*) '-------------------------------------------'
     	   WRITE (20,*) 'Photon Energy       [ eV ]: ',PHOT
     	   WRITE (20,*) '       Wavelength [ Angs ]: ',RLAM
     	   WRITE (20,*) 'Line density      [ mm-1 ]: ',RULING
     	   WRITE (20,*) 'Order                     : ',ORDER
     	   WRITE (20,*) 'Blaze Angle       [ degs ]: ',BLAZE
     	   WRITE (20,*)
     	   WRITE (20,*) 'Incidence Angle   [ degs ]: ',ALPHA
     	   WRITE (20,*) 'Diffraction Angle [ degs ]: ',BETA
     	   WRITE (20,*) '-------------------------------------------'
     	   WRITE (20,*) '                 end'
     	   WRITE (20,*) '-------------------------------------------'
     	 END IF
     	ELSE IF (ITYPE.EQ.1) THEN
     	  THETA	=   RNUMBER ('Incidence Angle [ degrees ]? ')
     	  THETA	=   THETA*TORAD
     	  SINBETA = SIN(THETA) + ORDER*RLAM*RULING*1.0D-7
     	 IF (ABS(SINBETA).GE.1.0D0)	THEN
		WRITE(6,*)
     $'**************************************************************'
     $,'*********************     WARNING   **************************'
     $,'**************************************************************'
     $,'SINBETA larger than 1.0 >>>>>> ',SINBETA
     $,'**************************************************************'
		GO TO 1
     	 END IF
     	  BETA	=   ASIN(SINBETA)
     	  WRITE(6,*)'Diffraction angle BETA: ',BETA*TODEG
     	 IF (IANSW.EQ.1) THEN
     	   WRITE (20,*) '-------------------------------------------'
     	   WRITE (20,*) '-------------------------------------------'
     	   WRITE (20,*) '         Fixed Incidence Case.'
     	   WRITE (20,*) '-------------------------------------------'
     	   WRITE (20,*) 'Photon Energy       [ eV ]: ',PHOT
     	   WRITE (20,*) '       Wavelength [ Angs ]: ',RLAM
     	   WRITE (20,*) 'Line density      [ mm-1 ]: ',RULING
     	   WRITE (20,*) 'Order                     : ',ORDER
     	   WRITE (20,*) 'Incidence Angle   [ degs ]: ',THETA*TODEG
     	   WRITE (20,*)
     	   WRITE (20,*) 'Diffraction Angle [ degs ]: ',BETA*TODEG
     	   WRITE (20,*) '-------------------------------------------'
     	   WRITE (20,*) '                 end'
     	   WRITE (20,*) '-------------------------------------------'
     	 END IF
C
C Constant angle
C
     	ELSE IF (ITYPE.EQ.2) THEN
C
     	  THETA	=   RNUMBER ('Included Angle [ degs ]? ')
     	  THETA	=   THETA*TORAD/2
     	  SINXROT =  - ORDER*RLAM*1.0D-7*RULING/2/COS(THETA)
     	 IF (ABS(SINXROT).GE.1.0D0)	THEN
		WRITE(6,*)
     $'**************************************************************'
     $,'*********************     WARNING   **************************'
     $,'**************************************************************'
     $,'            DIFFRACTION    ANGLE  IS  COMPLEX	              '
     $,'**************************************************************'
     	 	GO TO 1
     	 END IF
     	  XROT	=   ASIN(SINXROT)
     	  XROT	=   XROT*TODEG
     	  ALPHA	=   THETA*TODEG + XROT
     	  BETA	=   THETA*TODEG - XROT
     	  WRITE(6,*)'Incidence   Angle [ degs ]: ',ALPHA
     	  WRITE(6,*)'Diffraction Angle [ degs ]: ',BETA
     	  WRITE(6,*)'Rotation    Angle [ degs ]: ',XROT
     	 IF (IANSW.EQ.1) THEN
     	   WRITE (20,*) '-------------------------------------------'
     	   WRITE (20,*) '-------------------------------------------'
     	   WRITE (20,*) '         Fixed Included Angle.'
     	   WRITE (20,*) '-------------------------------------------'
     	   WRITE (20,*) 'Photon Energy       [ eV ]: ',PHOT
     	   WRITE (20,*) '       Wavelength [ Angs ]: ',RLAM
     	   WRITE (20,*) 'Line density      [ mm-1 ]: ',RULING
     	   WRITE (20,*) 'Order                     : ',ORDER
     	   WRITE (20,*) 'Included Angle    [ degs ]: ',THETA
     	   WRITE (20,*)
     	   WRITE (20,*) 'Incidence   Angle [ degs ]: ',ALPHA
     	   WRITE (20,*) 'Diffraction Angle [ degs ]: ',BETA
     	   WRITE (20,*) 'Rotation angle    [ degs ]: ',XROT
     	   WRITE (20,*) '-------------------------------------------'
     	   WRITE (20,*) '                 end'
     	   WRITE (20,*) '-------------------------------------------'
     	 END IF
     	END IF
C
C Continue to next case
C
     	GO TO 1
     	END
