C
C Source: src/utils/optics/cutoff.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	cutoff.F
C Revision 1.6  92/01/15  15:54:50  cwelnak
C 6000 changes
C 
C Revision 1.5  91/07/06  19:42:54  khan
C Grenoble Changes ...
C 
C Revision 1.4  91/04/05  15:21:21  cwelnak
C changed quotes in #includes
C 
C Revision 1.3  91/03/25  15:52:06  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.2  91/03/25  15:48:43  khan
C Getting ready for SUN port ...
C 
C Revision 1.1  90/10/10  13:32:52  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif
***********************************************************************
*	program 	CUTOFF					      *
*								      *
*	F.Cerrina,	SRC - June 1983				      *
*			modified July 1986			      *
*								      *
* This program is based on the compilation of atomic scattering factors
* of B.Henke, Low Energy X-Ray Diagnostics - 1981 and formulaes therein
* The photon energy range is 30-100000 eV, for all elements.	      *
* 								      *
* The program is self-explanatory and needs no particular explanation *
* The output will be both at the default output device (tt:) and to a *
* file labeled CUTOFF.DAT.					      *
*								      *
C	Link with READLIB.OBJ
***********************************************************************
     	PROGRAM		CUTOFF
     	DIMENSION	OUTFIL(420,2),ENERGY(420),RF1(420),RF2(420)
	EQUIVALENCE	(OUTFIL(1,1),RF1(1))
	EQUIVALENCE	(OUTFIL(1,2),RF2(1))
     	INTEGER *4 	NUMBER
	CHARACTER*2	ELEMENT
	CHARACTER*80	RSTRING
        REAL*8		RNUMBER
     	DATA	PI     	/  3.1415 92653 58979 32384 62643 D0 /
     	DATA	PIHALF 	/  1.5707 96326 79489 66192 31322 D0 /
     	DATA	TWOPI 	/  6.2831 85307 17958 64679 25287 D0 /
     	DATA	TODEG 	/ 57.2957 79513 08232 08767 98155 D0 /
     	DATA	TORAD	/  0.0174 53292 51994 32957 69237 D0 /
	DATA	TOCM	/  1.239 852	D-4		     /
	DATA	TOANGS 	/  1.239 852    D+4		     /

     	RADIUS	=   2.817939 E-13
     	AVOG	=   6.022098 E+23
     	ELEMENT	= RSTRING('Enter atomic symbol (capitalized) : ')
     	DENSITY	= RNUMBER('Density : ')
     	WRITE(6,*) 'Enter starting photon energy,end and step'
     	READ(*,*) ESTART,EFINAL,ESTEP
     	NPOINT	=  (EFINAL-ESTART)/ESTEP + 1
** Get the data
	CALL	READLIB(ELEMENT,NUMBER,ATWT,RMU,EMF,ENERGY,RF1,RF2)
** Computes atomic concentration
     	ATOMS	=   DENSITY/ATWT*AVOG
** Computes the ALPHA and gamma coefficients.
*** Finds and interpolate for the photon energy.
#ifdef vms
     	OPEN (21,FILE='CUTOFF',STATUS='NEW')
     	OPEN (22,FILE='CUTOFFDEG',STATUS='NEW')
#else
     	OPEN (21,FILE='CUTOFF',STATUS='UNKNOWN')
	REWIND (21)
     	OPEN (22,FILE='CUTOFFDEG',STATUS='UNKNOWN')
	REWIND (22)
#endif
	ELFACTOR	= LOG10(1.0E4/30.0)/300.0
     	DO 11 I=1,NPOINT
     	PHOTON	=   ESTART + (I-1)*ESTEP
	NENER	=   LOG10(PHOTON/30.0E0)/ELFACTOR + 1
     	F1	=   OUTFIL(NENER,1) + 
     $	(OUTFIL(NENER+1,1) - OUTFIL(NENER,1))*(PHOTON - ENERGY(NENER))/
     $	(ENERGY(NENER+1) - ENERGY(NENER))
     	F2	=   OUTFIL(NENER,2) + 
     $	(OUTFIL(NENER+1,2) - OUTFIL(NENER,2))*(PHOTON - ENERGY(NENER))/
     $	(ENERGY(NENER+1) - ENERGY(NENER))
*** Computes now ALPHA and gamma
     	WAVE	=   TOCM/PHOTON
     	ALPHA	=   RADIUS/PI*(WAVE**2)*ATOMS*F1
     	GAMMA	=   RADIUS/PI*(WAVE**2)*ATOMS*F2
** Computes the complex refraction index
     	BETA	=   GAMMA/2
     	DELTA	=   ALPHA/2
     	ANGLE	=   SQRT(DELTA)*2
     	ANGLEDEG=   TODEG*ANGLE
     	 WRITE (21,*) PHOTON,ANGLE
     	 WRITE (22,*) PHOTON,ANGLEDEG
11     	CONTINUE
     	CLOSE (21)
     	CLOSE (22)
     	CALL	EXIT (0)
     	END
