C +++
C
C Source: src/utils/gen/variance.f
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: variance.f
C Revision 1.2  1991/07/06  19:40:17  khan
C Grenoble Changes ...
C
C Revision 1.1  90/10/08  15:01:17  khan
C Initial revision
C 
C 
C ---

C+++
C		PROGRAM		VARIANCE
C
C		PURPOSE		Finds the mean and the variance of a
C				distribution of points; may compute
C				the relative Gaussain curve.
C
C		INPUT		A 2-D tabular file
C
C		OUTPUT		TT: and a log file.
C---
     	PROGRAM		VARIANCE
	IMPLICIT REAL*8 (A-H,O-Z)
	CHARACTER *80 	FILEIN,LOGFIL,RSTRING
     	DIMENSION	XIN (2,10000)
     	WRITE(6,*)'Log file ?'
     	READ (5,3333) LOGFIL
#ifdef vms
     	OPEN (30,FILE=LOGFIL,STATUS='NEW')
#elif unix
     	OPEN (30,FILE=LOGFIL,STATUS='UNKNOWN')
	REWIND (30)
#endif
1	FILEIN = RSTRING ('File for analysis ? ')
3333	FORMAT (A)
#ifdef vms
	OPEN (UNIT=20,FILE=FILEIN,STATUS='OLD',READONLY)
#elif unix
	OPEN (UNIT=20,FILE=FILEIN,STATUS='OLD')
#endif
     	DO 10 I=1,10000
     	READ (20,*,ERR=111) XIN(1,I),XIN(2,I)
10      CONTINUE
111     CLOSE (20)
     	NPOINT 	= I - 1
     	WRITE (30,*) 'Read ',NPOINT,' from ',FILEIN
	WRITE(6,*)'Read ',NPOINT,' from ',FILEIN
C
C Finds the mean and variance
C
2	NCOL = IRINT('Column to analyze ? ')
     	 XMEAN	= 0.0D0
     	 VAR	= 0.0D0
     	DO 20 I=1,NPOINT
     	  XMEAN = XMEAN + XIN(NCOL,I)
     	  VAR	= VAR + XIN(NCOL,I)**2
20      CONTINUE
     	 XMEAN = XMEAN/NPOINT
     	 VAR   = VAR/NPOINT - XMEAN**2
     	 STDEV = SQRT(VAR)
     	WRITE(6,*)' '
     	WRITE(6,*)'Results from column ',NCOL
     	WRITE(6,*)'Mean value: ',XMEAN
     	WRITE(6,*)'Variance  : ',VAR
     	WRITE(6,*)'Standard deviation : ',STDEV
     	WRITE(6,*)' '
     	WRITE (30,*)' '
     	WRITE (30,*)'Results from column ',NCOL
     	WRITE (30,*)'Mean value: ',XMEAN
     	WRITE (30,*)'Variance  : ',VAR
     	WRITE (30,*)'Standard deviation : ',STDEV
     	WRITE (30,*)' '
5     	WRITE(6,*)'Enter:'
     	WRITE(6,*)'0    to exit'
     	WRITE(6,*)'1    new file'
     	WRITE(6,*)'2    new column (same file)'
     	WRITE(6,*)'3    best fit (plottable)'
     	IANSW = IRINT ('? ')
     	GO TO (3,1,2,4) IANSW+1
3     	STOP
4	CONTINUE
c
c computes a gaussain best fit
c
     	CALL	TGAUSS (XMEAN,STDEV)
     	GO TO 5
     	END
C+++
C
C	PROGRAM		TGAUSS
C
C	PURPOSE		Create a array X(I),Y(I) with  a gaussian fucntion
C			    Y(I) = exp(-x(I)**2/(2*sigma**2))/(sigma*(2PI)**.5)
C
C	ALGORITHM	Direct computation
C
C---
     	SUBROUTINE	TGAUSS (XMEAN,SIG)
	IMPLICIT REAL*8 (A-H,O-Z)
     	DIMENSION	X(1000),Y(1000)
     	CHARACTER*20	OUTFIL
     	PARAMETER	(SQRT2PI	=   2.5066283D0)
     	WRITE(6,*)'Output file name ?'
     	READ (5,1000) OUTFIL
1000	FORMAT (A)
     	WRITE(6,*)'Enter interval width,number of points'
     	WID	=  RNUMBER ('Interval width ? ')
     	XCEN	=  RNUMBER ('Interval center ? ')
     	NN	=  IRINT   ('Number of points ? ')
     	INOR	=  IYES    ('Area = 1 ? ')
     	IF (INOR.EQ.0) THEN
     	  WRITE(6,*)'Normalization choice: '
     	  WRITE(6,*)'Value at peak                 ...........  0'
     	  WRITE(6,*)'             / '
     	  WRITE(6,*)'Total area   |  Ydx = A       ...........  1'
     	  WRITE(6,*)'             / '
     	  WRITE(6,*)'              '
     	  WRITE(6,*)'              \ '
     	  WRITE(6,*)'Total counts   >   Y(i) = A   ...........  2'
     	  WRITE(6,*)'              / '
     	  WRITE(6,*)'              --- '
     	  IWHAT = IRINT ('Then ? ')
     	 IF (IWHAT.EQ.0) THEN
     	   RNORM = RNUMBER ('Amplitude at maximum ? ')
     	 ELSE IF (IWHAT.EQ.1) THEN
     	   RNORM = RNUMBER ('Total area ? ')
     	 ELSE IF (IWHAT.EQ.2) THEN
     	   RNORM = RNUMBER ('Total counts ? ')
     	 END IF
     	END IF
     	STEP	=   WID/(NN-1)
     	XMIN	=   XCEN - WID/2
     	YMAX	=   0
     	YCUM	=   0
     	DO 30 I=1,NN
     	  X(I)	=   XMIN + STEP*(I-1)
     	  X(I)  =   X(I) - XMEAN
     	 IF (INOR.EQ.1) THEN
	   Y(I)	=   (EXP(-0.5D0*(X(I)**2/SIG**2)))/(SIG*SQRT2PI)
	 ELSE
     	  IF (IWHAT.EQ.0) THEN
	    Y(I)	=   RNORM*EXP(-0.5D0*(X(I)**2/SIG**2))
     	  ELSE IF (IWHAT.EQ.1) THEN
	   Y(I)	=   EXP(-0.5D0*(X(I)**2/SIG**2))
     	   Y(I) =   Y(I)*RNORM/STEP/(SIG*SQRT2PI)
     	  ELSE IF (IWHAT.EQ.2) THEN
	   Y(I)	=   EXP(-0.5D0*(X(I)**2/SIG**2))
     	   YCUM =   YCUM + Y(I) 
     	  END IF
	 END IF
30      CONTINUE
     	IF (INOR.NE.1.AND.IWHAT.EQ.2) THEN
     	  RNORM = RNORM/YCUM
     	 DO 40 I=1,NN
     	   Y(I) = Y(I) * RNORM
40       CONTINUE
     	END IF
    	OPEN (20,FILE=OUTFIL,STATUS='NEW')
     	 DO 50 I=1,NN
     	  WRITE (20,*)	XMEAN + X(I), Y(I)
50       CONTINUE
     	CLOSE (20)
     	END
