C -----------------------------------------------------------------------
C
C +++
C	Subroutine 	TRACE_STEP
C	Purpose		Traces the current state.
C ---
C
	SUBROUTINE TRACE_STEP (NSAVE,ICOUNT, IPASS, RAY, PHASE, AP)
#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c	INCLUDE         './../include/warning.blk'
c
c
#	include		<common.blk>
#	include		<warning.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
	INCLUDE		'SHADOW$INC:NAMELIST.BLK/LIST'
#endif
C
	DIMENSION 	RAY(12,N_DIM), PHASE (3,N_DIM), AP(3,N_DIM)
C
	NCOL	= NSAVE
C
C Let the user know where we are
C
     	WRITE(6,*)'Tracing optical element # ',ICOUNT
C
C Defines the source parameters
C
     	CALL SETSOUR
C
C Compute the (x,y) reference frame on the image plane
C
	CALL IMREF
C
C Compute the parameters defining the central ray 
C
	CALL OPTAXIS (ICOUNT)
C
C Compute the mirror, if needed
C
	CALL MSETUP (ICOUNT)
C
C Reads in the file containing the source beam
C
     	IF (IPASS.EQ.1) THEN
          CALL RBEAM (FILE_SOURCE,RAY,PHASE,AP,NCOL,NPOINT,IFLAG,IERR)
	  IF (IERR.NE.0) THEN
	    CALL LEAVE ('TRACE_STEP',
     $		'Error reading source image "' //
     $		FILE_SOURCE(1:IBLANK(FILE_SOURCE)) // '".',
     $		IERR)
     	  ENDIF
	  NSAVE	= NCOL
C
C If full polarization is not selected, AP should be initialized to zero.
C
	  IF (NCOL.NE.18) THEN
	    DO  10 I = 1, NPOINT
	      AP(1,I)	= 0.0D0
	      AP(2,I)	= 0.0D0
	      AP(3,I)	= 0.0D0
 10	    CONTINUE
	  END IF
C     	 IF (IERR.NE.0) THEN
C     	  CALL  MSSG	('TRACE: Unable to open ',FILESOURCE, IERR)
C     	  STOP
C     	 END IF
     	  IPASS = 0
     	END IF
C
C This call rotates the last RAY file in the new MIRROR reference
C frame
C
	CALL RESTART (RAY,PHASE,AP)
C
C Check if any screens are present ahead of the mirror.
C
     	DO  20 I=1,N_SCREEN
     	IF (F_SCREEN.EQ.1.AND.I_SCREEN(I).EQ.1) 
     $  	CALL  SCREEN (RAY,AP,PHASE,I,ICOUNT)
 20    	CONTINUE
C
C Computes now the intersections onto the mirror and the new rays
C
        IF (F_KOMA.EQ.1) THEN
		CALL KUMAKHOV(RAY,AP,PHASE,ICOUNT)
	ELSE
		CALL MIRROR1 (RAY,AP,PHASE,ICOUNT)
	ENDIF
C
C Computes other screens and stops.
C
     	DO  30 I=1,N_SCREEN
     	IF (F_SCREEN.EQ.1.AND.I_SCREEN(I).EQ.0) 
     $	CALL  SCREEN (RAY,AP,PHASE,I,ICOUNT)
 30    	CONTINUE
C
C Computes the intersections on the image plane
C
	CALL IMAGE1 (RAY,AP,PHASE,ICOUNT)
C
C This file will contain the status of the parameters at the exit
C from this optical element.
C
#ifdef vms
     	CALL	FNAME	(FFILE, 'END', ICOUNT, 2)
#else
     	CALL	FNAME	(FFILE, 'end', ICOUNT, 2)
#endif
     	IDUMM = 0
     	CALL	RWNAME  ( FFILE, 'W_OE', IDUMM)
     	IF (IDUMM.NE.0) CALL LEAVE
     $		 ('TRACE','Error writing NAMELIST',IDUMM)
	RETURN
	END

