C +++
C
C Source: src/trace/trace.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: trace.F
C Revision 1.11  1991/07/06  20:07:38  khan
C Grenoble and after. Minor changes
C
C Revision 1.10  91/04/05  15:06:11  cwelnak
C changed quotes on #includes
C 
C Revision 1.9  91/03/22  11:26:35  cwelnak
C SUN version -- INCLUDe to #include
C 
C Revision 1.8  90/11/13  14:02:04  khan
C Cleanup and SAVE statements
C 
C Revision 1.7  90/07/19  21:38:11  khan
C Put #ifdef's to make it work on BOTH VMS and Ultrix
C 
C Revision 1.6  90/07/18  18:43:23  khan
C Moved the arrays RAY, PHASE, AP to the main program, and in doing so,
C some mysterious bugs were fixed!!! Before doing this, the arrays were
C declared in TRACE_STEP, and some traces (schwartzchild objective) were
C dying after the 4994th ray. Oh well.
C 
C Revision 1.5  90/07/16  17:07:29  khan
C Minor bug fix with NCOL being reset in TRACE_STEP by NSAVE=1. Fixed.
C 
C Revision 1.4  90/07/14  22:51:27  khan
C All public include files (common.blk, etc) are now in ./../include/ dir.
C 
C Revision 1.3  90/07/14  12:46:41  khan
C Added GETMODE to get the operating mode of trace from command line. The
C allowed modes are BATCH & PROMPT. [-m mode] mode case insensitive.
C 
C Revision 1.2  90/07/14  12:19:22  khan
C Renamed TRACE from SHADOW as in VMS.
C Moved much of the code in the main program to TRACE_STEP, so the LOOP
C is only around a few lines of code in TRACE.
C 
C Revision 1.1  90/07/10  14:56:58  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	PROGRAM		TRACE
C
C	PURPOSE		Main program. Handles the switchboard.
C
C---
     	PROGRAM		TRACE
	IMPLICIT	NONE
#if defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#elif defined(vms)
	INCLUDE		'SHADOW$INC:DIM.PAR/LIST'
#endif
C
#ifdef IEEE_HANDLER
	external	myhandler
#endif
	CHARACTER*80	MODE
	REAL*8		RAY, PHASE, AP
	DIMENSION 	RAY(12,N_DIM), PHASE (3,N_DIM), AP(3,N_DIM)
	INTEGER*4	ICOUNT, IPASS, NSAVE
C
C Save the large arrays to avoid killing the stack; ie., use the heap.
C
	SAVE		RAY, PHASE, AP
C
C
C Get the command line of the program to find out what the mode is. The
C allowed modes are:
C 		MENU
C 		BATCH
C		PROMPT
C If no mode is specified, the default mode is PROMPT.
C
#ifndef vms
	CALL 	GETMODE (MODE)
#endif
C
C For SunOS, use the abrupt_underflow call to make the results the same
C as that of VAX FORTRAN and also improve performance a bit.
C
#if ABRUPT_UNDERFLOW
	call	abrupt_underflow 
#endif
#if IEEE_HANDLER
	call	ieee_handler ('set', 'invalid', myhandler)
	call	ieee_handler ('set', 'division', myhandler)
	call	ieee_handler ('set', 'overflow', myhandler)
	call	ieee_handler ('set', 'underflow', myhandler)
#endif
C
	ICOUNT = 0
     	IPASS  = 1
	NSAVE = 0
C
C Start by inquiring about the optical system
C
 100	CONTINUE
#ifndef vms
	CALL SWITCH_INP (MODE,ICOUNT)
#else
	CALL SWITCH_INP (ICOUNT)
#endif
	CALL TRACE_STEP (NSAVE, ICOUNT, IPASS, RAY, PHASE, AP)
	GOTO 100
	END
C
C -----------------------------------------------------------------------
C
C +++
C	Subroutine 	GETMODE
C	
C	Purpose		Gets the mode option from the command line of trace.
C	Input		None
C	Output		Returns the mode.
C			The legal modes are: MENU, PROMPT, BATCH
C ---
C
#ifndef vms
	SUBROUTINE	GETMODE	(MODE)
C
	CHARACTER*(*)	MODE
	CHARACTER*80	ARG
C
	NUMARGS = IARGC ()
	IF (NUMARGS.GE.2) THEN
	    CALL GETARG (1,ARG)
	    IF (ARG(1:2).EQ.'-m') THEN
		CALL GETARG (2, ARG)
		IF (ARG.EQ.'MENU'.OR.ARG.EQ.'menu') THEN
		    MODE = 'MENU'
		ELSEIF (ARG.EQ.'PROMPT'.OR.ARG.EQ.'prompt') THEN
		    MODE = 'PROMPT'
		ELSEIF (ARG.EQ.'BATCH'.OR.ARG.EQ.'batch') THEN
		    MODE = 'BATCH'
		ELSE
		    CALL USAGE ()
		    CALL EXIT (1)
		ENDIF
	    ELSE
		CALL USAGE ()
		CALL EXIT (1)
	    ENDIF
	ELSE
	    MODE = 'PROMPT'
	ENDIF
C
	RETURN
	END
#endif
C
C -----------------------------------------------------------------------
C
C +++
C	Subroutine	USAGE
C
C	Purpose		Prints out a few lines describing the command line
C			options of the program.
C	Input		None
C	Output		None
C
C ---
	SUBROUTINE	USAGE
C
	WRITE (*,*)
	WRITE (*,*) 'Usage: trace [-m mode]'
	WRITE (*,*) '   -m: The mode trace will run.'
	WRITE (*,*)
	WRITE (*,*) 'The allowed modes are: MENU, BATCH, PROMPT. The '
	WRITE (*,*) 'modes names are case-insensitive. If no mode is '
	WRITE (*,*) 'specified, the default mode is PROMPT'
	WRITE (*,*)
	RETURN
	END
C

	BLOCK DATA 
     	IMPLICIT	REAL*8		(A-E,G-H,O-Z)
     	IMPLICIT	INTEGER*4	(F,I-N)
     	COMMON	/MATHBLK/	PI,TWOPI,PIHALF,TODEG,TORAD,ORIGIN(3),
     $				X_VRS(3),Y_VRS(3),Z_VRS(3),TOCM,TOANGS
     	COMMON	/CALC	/	NPOINT,NCOL,ISTAR1,IDO_X_S,IDO_Z_S,
     $				IDO_Y_S,IDO_VZ,IDO_VX,IDO_XL,IDO_XN,
     $				IDO_ZL,IDO_ZN,N_PLATES,IG_SEED,N_COLOR,
     $				N_CIRCLE,N_CONE,N_SCREEN,I_SCREEN(10),
     $				I_SLIT(10),K_SLIT(10),I_STOP(10),
     $				I_ABS(10),MPURGE(2),NDEG,MOSAIC_SEED

     	DATA	PI     	/  3.1415 92653 58979 32384 62643 D0 /
     	DATA	PIHALF 	/  1.5707 96326 79489 66192 31322 D0 /
     	DATA	TWOPI 	/  6.2831 85307 17958 64769 25287 D0 /
     	DATA	TODEG 	/ 57.2957 79513 08232 08767 98155 D0 /
     	DATA	TORAD	/  0.0174 53292 51994 32957 69237 D0 /
     	DATA	ORIGIN	/   .0D0, .0D0, .0D0		     /

     	DATA	X_VRS	/  1.0D0,  .0D0,  .0D0		     /
     	DATA	Y_VRS	/   .0D0, 1.0D0,  .0D0		     /
     	DATA	Z_VRS	/   .0D0,  .0D0, 1.0D0		     /
	DATA	TOCM	/  1.239 852	D-4		     /
	DATA	TOANGS 	/  1.239 852    D+4		     /

     	DATA	IDO_X_S,IDO_Y_S,IDO_Z_S,IDO_VX,IDO_VZ	/1,1,1,1,1/
     	DATA	ISTAR1		/ 12345701 /

	END
