C +++
C
C Source: src/trace/switchinp.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: switchinp.F
C Revision 1.11  1991/07/06  20:07:38  khan
C Grenoble and after. Minor changes
C
C Revision 1.10  91/04/05  15:06:10  cwelnak
C changed quotes on #includes
C 
C Revision 1.9  91/03/22  11:08:54  cwelnak
C SUN version -- INCLUDe to #include
C 
C Revision 1.8  90/11/17  12:54:22  khan
C Took out MENU option from MODE checking block of code for SHADOW/Unix.
C MENU Valid only ofor SHADOW/VMS.
C 
C Revision 1.7  90/11/13  14:02:03  khan
C Cleanup and SAVE statements
C 
C Revision 1.6  90/07/20  22:19:14  khan
C Added #if unix ... to make it work on both unix and vms
C 
C Revision 1.5  90/07/19  21:38:10  khan
C Put #ifdef's to make it work on BOTH VMS and Ultrix
C 
C Revision 1.4  90/07/14  22:51:26  khan
C All public include files (common.blk, etc) are now in ./../include/ dir.
C 
C Revision 1.3  90/07/14  12:47:24  khan
C switch_inp now takes another argument, the MODE, instead of trying to
C find it in a LOGICAL, as in VMS. The mode is passed in from TRACE.
C 
C Revision 1.2  90/07/14  12:17:59  khan
C Added command line option to pick MODE (PROMPT or BATCH). default PROMPT.
C Files opened with STATUS=UNKNOWN.
C Using the VMS input_oe instead of the curses one. It's bug-free.
C 
C Revision 1.1  90/07/10  14:57:11  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	SUBROUTINE	SWITCH_INP
C
C	PURPOSE		To select different I/O modes for SHADOW
C
C	ALGORITHM	Tests the symbol 'MENU_STAT' in the symbol table.
C			Recognized values are
C				MENU
C				PROMPT
C				BATCH
C
C---
#if defined(unix) || HAVE_F77_CPP
     	SUBROUTINE	SWITCH_INP (OUTP,IFLAG)
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c	INCLUDE         './../include/namelist.blk'
c
c
#	include		<common.blk>
#	include		<namelist.blk>
	CHARACTER*(*)	OUTP
#elif defined(vms)
     	SUBROUTINE	SWITCH_INP (IFLAG)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
     	INCLUDE		'SHADOW$INC:NAMELIST.BLK/LIST'
	CHARACTER*80	OUTP
#endif
     	CHARACTER*80	ARG,RSTRING, INFILE
	CHARACTER*80	FILESOURCE
	LOGICAL		IRET
	INTEGER		IPASS
	DATA 	IPASS	/ 0 /
        SAVE		IPASS
C
C Clears all variable to avoid cross talks
C
     	CALL	RESET
C
C Tests for selected mode
C
#ifdef vms
   	IRET	=   LIB$GET_SYMBOL ('MENU_STAT', OUTP)
     	IF (.NOT.IRET) CALL LEAVE
     $	('SWITCHINP','SHADOW setup not run.',IRET)
#endif
	CALL CLSCREEN
C
C Tests for continuation or new optical system
C
     	IF (IFLAG.EQ.0) THEN
     	WRITE(6,*)'Mode selected is: ',OUTP
      	WRITE(6,*)'Options: to start anew                 [ 0 ] ' 
	WRITE(6,*)'            to restart from a given OE [ 1 ] '
      	IRESTART 	=   IRINT ('Then ? ')
      	 IF (IRESTART.EQ.0) THEN
     	   IFLAG = 1
      	 ELSE
      	   IREST =   IRINT ('Previous element number: ')
      	   CALL	READ_AXIS  (IREST)
      	   IFLAG =   IREST + 1
     	   FILESOURCE = RSTRING
     $		('Image file of the previous OE ? ')
      	   F_NEW = 0
      	 END IF
     	ELSE
C
C Increments counter
C
     	  IFLAG = IFLAG + 1
	END IF
     	
C
C Parses for matches
C
	IF (OUTP.EQ.'MENU') THEN
C-------------------------------------------------------------
C
C   MENU  case
C
	IF (IPASS.EQ.0) THEN
C
#ifndef vms
C
	   OPEN (37, FILE='systemfile.dat', STATUS='old', 
     $		IOSTAT=IWHAT)
C
#elif defined(vms)
C
C First call; must seek the files list
C
	   OPEN (37, FILE='SYSTEMFILE', STATUS='OLD', READONLY, 
     $		IOSTAT=IWHAT)
#endif
C
C Tests if files found; if not, return to main program
C
	    IF (IWHAT.NE.0) THEN
		CALL  LEAVE 
     $('SWITCHINPUT-E-error:', 'SYSTEMFILE not found',
     $			  idumm)
     	    ELSE
		IPASS = 1
     	    END IF
	END IF
C
C System file found and opened succesfully; read in OE filename
C
        READ (37, 1000, IOSTAT=IEND) INFILE
C
C No more files to input; end of OS
C
        IF (IEND.NE.0) STOP
C
C read in NAMELIST block
C
        IDUMM = 0
	IF (IFLAG.GT.1) THEN
	     NOLD	= NPOINT
     	     CALL RWNAME (INFILE,'R_OE', IDUMM)
	     NPOINT	= NOLD
	ELSE
     	     CALL RWNAME (INFILE,'R_OE', IDUMM)
	END IF
     	IF (IDUMM.NE.0) THEN
     	     WRITE(6,*)'Error reading from file ',INFILE
     	     CALL LEAVE ('SWITCHINP',
     $		'Check contents of SYSTEMFILE',IDUMM)
     	END IF
	GO TO 2000

     	END IF
C
C This cannot be a MENU case
C
	IF (IFLAG.GT.1) THEN
     	  IDUMM	=   IYES ('Do you want to change input mode ? ')
     	  IF (IDUMM.EQ.1) THEN
10     	    WRITE(6,*)'Enter 1 for PROMPT, 2 for BATCH'
     	    IDUMM = IRINT ('Then ? ')
     	   IF (IDUMM.EQ.1) THEN
     	     OUTP = 'PROMPT'
     	   ELSE IF (IDUMM.EQ.2) THEN
     	     OUTP = 'BATCH'
     	   ELSE
     	     WRITE(6,*)'What ?? '
     	     GO TO 10
     	   END IF
     	  END IF
	END IF
     	IF (OUTP.EQ.'PROMPT') THEN
C--------------------------------------------------------------
C     	 
C   PROMPT  CASE
C
C IFLAG represents the OE #
C
     	CALL	INPUT_OE (IFLAG)
C
     	ELSE IF (OUTP.EQ.'BATCH') THEN
C
C--------------------------------------------------------------
C
C   NAMELIST CASE
C
C
#ifndef vms
     	  INFILE = 
     $	  RSTRING ('Input file [ EXIT terminates OS ] ?')
C
C If ^Z detected, assumes end of system
C
     	 IF (INFILE(1:5).EQ.'EXIT'.OR.INFILE(1:5).EQ.'exit') STOP
#elif defined(vms)
     	  INFILE = 
     $	  RSTRING ('Input file [ ^Z or %EXIT terminates OS ] ?')
C
C If ^Z detected, assumes end of system
C
     	 IF (INFILE(1:2).EQ.'^Z') STOP
     	 IF (INFILE(1:5).EQ.'%EXIT')  STOP
#endif
C
C Valid element; read in NAMELIST block
C
     	  IDUMM	= 0
	  IF (IFLAG.GT.1) THEN
	    NOLD	= NPOINT
     	    CALL RWNAME (INFILE,'R_OE', IDUMM)
	    NPOINT	= NOLD
	  ELSE
     	    CALL RWNAME (INFILE,'R_OE', IDUMM)
	  END IF
     	  IF (IDUMM.NE.0) CALL LEAVE
     $	   ('SWITCHINP','Error reading from file ',IDUMM)
C
     	ELSE
C
C------------------------------------------------------------------
C
C   UNRECOGNIZED  INPUT
C
     	  WRITE(6,*)'ERROR:: SHADOW not activated properly.'
     	  WRITE(6,*)'...Execute the $@SETUP command, then $GO.'
     	  WRITE(6,*)'ERROR:: string was: ',OUTP
     	  CALL LEAVE ('SWITCHINP','Error in MENU_STAT',0)
     	END IF
C+++
C Check for last minute changes of mind
C
C     	I_ANSW = IYES ('Do you want to modify some inputs ? ')
C     	IF (I_ANSW.NE.0) THEN
C     	  I_ANSW = IYES ('Do you want a typing of the NAMELIST file ? ')
C     	 IF (I_ANSW.EQ.1) THEN
C     	   IDUMM = 1
C     	   CALL RWNAME ( 'TT:','W_OE', IDUMM)
C     	 END IF
C112	  TYPE 
C     $*,'Enter now the new values. The NAMELIST block name is $TOTAL'
C     	  IDUMM = 0
C     	  CALL RWNAME ( 'TT:','R_OE', IDUMM)
C     	 IF (IDUMM.LT.0) THEN
C   	   CALL	LIB$ERASE_PAGE (5,1)
C  	   WRITE(6,*)'NAMELIST error. '
C     	   WRITE(6,*)'Enter:  0 to keep going (ignore error)'
C     	   WRITE(6,*)'        1 to restart NAMELIST'
C     	   WRITE(6,*)'        2 to EXIT (i.e. STOP)'
C     	   I_ANSW = IRINT ('Then ? ')
C     	  IF (I_ANSW.EQ.2) STOP
C     	  IF (I_ANSW.EQ.0) RETURN
C     	  IF (I_ANSW.EQ.1) GO TO 112
C     	 END IF
C     	END IF
C---
C
C
2000	CONTINUE
C 
C If restart from the middle of an OS, then the source files should be the ones
C specified in the beginning of this subroutine.
C
	IF (IRESTART.EQ.1) 	  FILE_SOURCE	= FILESOURCE
C
C Data are ready; can start execution
C
     	RETURN
1000	FORMAT (A)
     	END
