C +++
C
C Source: src/trace/surface.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: surface.F
C Revision 1.7  1991/07/06  20:07:38  khan
C Grenoble and after. Minor changes
C
C Revision 1.6  91/04/05  15:06:08  cwelnak
C changed quotes on #includes
C 
C Revision 1.5  91/03/22  11:06:33  cwelnak
C SUN version -- INCLUDe to #include
C 
C Revision 1.4  90/11/13  14:02:02  khan
C Cleanup and SAVE statements
C 
C Revision 1.3  90/07/19  21:38:09  khan
C Put #ifdef's to make it work on BOTH VMS and Ultrix
C 
C Revision 1.2  90/07/14  22:51:23  khan
C All public include files (common.blk, etc) are now in ./../include/ dir.
C 
C Revision 1.1  90/07/10  14:57:10  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	SUBROUTINE	SURFACE
C
C	PURPOSE		To compute the offset in z at (x,y) due to the 
C			ripple.
C
C	Inputs:		
C
C---
** WARNING : To simplify problems, the sigma are really 1/sigma

     	SUBROUTINE  SURFACE	(P_IN,P_DISPL,V_NORMAL,SPLERR)
#if defined(unix) || HAVE_F77_CPP

C This subroutine has been modified to take the additional parameter 
C SPLERR to keep track of errors in spline calulations.
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c
c
#	include		<common.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
#endif
	
	INTEGER		SPLERR
     	DIMENSION	P_IN(3),P_DISPL(3),V_NORMAL(3),V_USE(3),
     $			V_CORR(3)

	IF (F_G_S.EQ.2) THEN
	  XIN	= P_IN(1)
	  YIN	= P_IN(2)
	  IERR	= 0

C  Here SUR_SPLINE now returns a value for SPLERR which indicates whether
C  errors occured when calculating the intersection of the ray with the
C  mirror surface as represented as a spline surface generated by
C  the utility PRESURFACE.

	  CALL	SUR_SPLINE (XIN, YIN, ZOUT, V_CORR, IERR, SPLERR)
	  P_DISPL(1)	= P_IN(1)
	  P_DISPL(2)	= P_IN(2)
	  P_DISPL(3)	= P_IN(3) + ZOUT
	  GO TO 300
	END IF
** Computes the amplitude of the ripple in P_IN
     	IF (F_G_S.EQ.0) THEN     ! Sinusoidal ripples

     	IF (X_RIP_WAV.NE.0.D0) THEN
     	 CORR_X	=   X_RIP_AMP*COS( TWOPI*P_IN(1)/X_RIP_WAV + X_PHASE )
     	ELSE
     	 CORR_X  =   .0D0
     	END IF

     	IF (Y_RIP_WAV.NE..0D0) THEN
     	 CORR_Y	=   Y_RIP_AMP*COS( TWOPI*P_IN(2)/Y_RIP_WAV + Y_PHASE )
     	ELSE
     	 CORR_Y =   .0D0
     	END IF
C
C Creates the first output vector.
C
     	P_DISPL(1)	=   P_IN(1)
     	P_DISPL(2)	=   P_IN(2)
     	P_DISPL(3)	=   P_IN(3) + CORR_X + CORR_Y

     	ELSE				! Gaussian case

     	CORR = 0.0D0

     	DO 100	I=1,N_RIP

     	CORR	=   CORR 
     $ + SIGNUM(I)*AMPLI(I)*EXP( - (P_IN(1) - X_GR(I))**2*SIG_X(I)**2
     $		 		-  (P_IN(2) - Y_GR(I))**2*SIG_Y(I)**2 )
100	CONTINUE

     	P_DISPL(1)	=   P_IN(1)
     	P_DISPL(2)	=   P_IN(2)
     	P_DISPL(3)	=   P_IN(3) + CORR
     	END IF

** Computes now the normal of the ripple. The two expressions cannot
** be separated in the calculation and must be normalized together, as
**
** 	Normal	=   GRADIENT ( F(x,y,z) + G(x,y,z) )
**
C
C NOTICE THAT THE NORMALS ARE DEFINED AS IN MIRROR, I.E, UPWARD
C
     	IF (F_G_S.EQ.0) THEN
     	  IF (X_RIP_WAV.NE.0.0D0) THEN
     	V_CORR(1)    =  TWOPI*X_RIP_AMP/X_RIP_WAV*
     $			SIN( TWOPI*P_IN(1)/X_RIP_WAV + X_PHASE )
     	  ELSE
     	V_CORR(1)    =    0.0D0
     	  END IF
     	  IF (Y_RIP_WAV.NE.0.0D0) THEN
     	V_CORR(2)    =  TWOPI*Y_RIP_AMP/Y_RIP_WAV*
     $			SIN( TWOPI*P_IN(2)/Y_RIP_WAV + Y_PHASE ) 
     	  ELSE
     	V_CORR(2)    =    0.0D0
     	  END IF

     	ELSE
	
	V_CORR(1)	= 0.0D0
	V_CORR(2)	= 0.0D0
	V_CORR(3)	= 0.0D0

     	DO 200 I=1,N_RIP
     	V_CORR(1) = V_CORR(1) + 2*SIG_X(I)**2*( P_IN(1) - X_GR(I))*
     $   SIGNUM(I)*AMPLI(I)*EXP( - SIG_X(I)**2*(P_IN(1) - X_GR(I))**2
     $		 		- SIG_Y(I)**2*(P_IN(2) - Y_GR(I))**2 )
     	V_CORR(2) = V_CORR(2) + 2*SIG_Y(I)**2*( P_IN(2) - Y_GR(I))*
     $   SIGNUM(I)*AMPLI(I)*EXP( - SIG_X(I)**2*(P_IN(1) - X_GR(I))**2
     $		 		- SIG_Y(I)**2*(P_IN(2) - Y_GR(I))**2 )
200	CONTINUE

     	END IF
C
C ideal surface gradient
C
300	CALL NORMAL 	(P_IN,V_USE)

     	IF (F_CONVEX.EQ.0) CALL SCALAR (V_USE,-1.0D0,V_USE)

      	V_USE(1) =  V_USE(1)/V_USE(3)
     	V_USE(2) =  V_USE(2)/V_USE(3)
 
     	V_NORMAL(1) =   V_USE(1) + V_CORR(1)
     	V_NORMAL(2) =   V_USE(2) + V_CORR(2)
     	V_NORMAL(3) =   1.0D0

     	CALL NORM ( V_NORMAL, V_NORMAL)

     	RETURN

     	END
