C +++
C
C Source: src/trace/sur_spline.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: sur_spline.F
C Revision 1.8  1991/07/06  20:07:38  khan
C Grenoble and after. Minor changes
C
C Revision 1.7  91/04/05  15:06:08  cwelnak
C changed quotes on #includes
C 
C Revision 1.6  91/03/22  11:05:07  cwelnak
C SUN version -- INCLUDE to #include
C 
C Revision 1.5  90/11/13  14:02:01  khan
C Cleanup and SAVE statements
C 
C Revision 1.4  90/10/24  13:41:44  khan
C Added SAVE statement to make certain variables static.
C 
C Revision 1.3  90/07/19  21:38:08  khan
C Put #ifdef's to make it work on BOTH VMS and Ultrix
C 
C Revision 1.2  90/07/14  22:51:22  khan
C All public include files (common.blk, etc) are now in ./../include/ dir.
C 
C Revision 1.1  90/07/10  14:57:09  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	SUBROUTINE	SUR_SPLINE
C
C	PURPOSE		To compute the interpolated surface from a 
C			bi-cubic spline.
C
C	INPUT		An unformatted file prepared by PRESURFACE.
C
C	ARGUMENTS	Input:
C			 {x,y} 	coordinates
C			 IFlag: -1, readin file from FILESURF
C			         0, compute z
C				-2, clear arrays
C			Output:
C			 z	value of z at {x.y}
C			 v[3]	normal to surface at {x,y,z}
C			 Iflag:  0, normal completion
C			        -1, out of bounds
C			serr: surface spline error (-9 is bad)
C
C---
     	SUBROUTINE	SUR_SPLINE	(XIN, YIN, ZOUT, VVOUT, 
     $					IERR, SERR)
#if defined(unix) || HAVE_F77_CPP

C This routine now takes an additional parameter SERR which indiates
C whether errors occur when calculating the ray's intersection with the
C mirror as specified by a PRESURFACE spline file.

c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c
c
#	include		<common.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
#endif
C     	DIMENSION	CSPL (2,101,2,101),X(101),Y(101),PDS(6)
C Below, the CSPL, X, and Y have been changed to allow a maximum of
C 201 points instead of 101.
C
     	DIMENSION	CSPL (2,201,2,201),X(201),Y(201),PDS(6)

	INTEGER		SERR
D	CHARACTER*80	FILE_RIP
	EXTERNAL	DBCEVL
C     	DIMENSION	XIN(3),YIN(3),VVIN(3),VVOUT(4)
     	DIMENSION	VVOUT(3)
C     	DIMENSION	VTX(3),VTY(3)
C
C SAVE the variables that need to be saved across subsequent invocations
C of this subroutine. Note: D_SPACING is not included in the SAVE block
C because it's included in the COMMON.BLK file.
C
	SAVE		NX, NY, X, Y, CSPL
D
D	FILE_RIP	= 'SURFACE'
D
	SERR = 0
     	IF (IERR.EQ.-1) THEN
C 
C Replace OPEN calls with library routine FOPENR()
C	  CALL FOPENR(20, FILE_RIP, 'UNFORMATTED', IFERR, IOSTAT)
C
     	  OPEN  (20, FILE=FILE_RIP, STATUS='OLD', FORM='UNFORMATTED',
     $		IOSTAT=IOSTAT)
	  IF (IOSTAT.NE.0) THEN
	    CALL LEAVE ('SUR_SPLINE',
     $			'Error opening file "' // 
     $			FILE_RIP(1:IBLANK(FILE_RIP)) // '".',
     $			IOSTAT)
          ENDIF
     	  READ  (20) NX, NY
     	  READ  (20) X,Y
     	  READ  (20) CSPL
     	  CLOSE (20)
C
C Succesful completion
C
D	  WRITE(6,*)'Read ',NX,' by ',NY,' array.'
     	  IERR = 0
     	 RETURN
     	ELSE IF (IERR.EQ.-2) THEN
     	  RETURN
     	ELSE 
C
C Compute the spline and derivatives at {x,y}. 
C Use 201 points maximum instead of 101 as earlier.
C If there is an error in this calculation, set the SERR variable
C to -9 to indicate this fact.
C
C      	CALL	DBCEVL (X,NX,Y,NY,CSPL,101,XIN,YIN,PDS,IER)
     	CALL	DBCEVL (X,NX,Y,NY,CSPL,201,XIN,YIN,PDS,IER)
C
     	IF (IER.NE.0) THEN
    	  IER = -9
	  SERR = IER
C   The 2 lines below are old stuff.
C     	  CALL	MSSG ('SURF_SPLINE','Return error # ',IER)
C     $	  CALL LEAVE ('SURF_SPLINE','Error in Spline Interpolation',IER)
C
     	  RETURN
     	END IF
     	DSDX	=   PDS(2)
     	DSDY	=   PDS(3)
C
C Compute now direction cosines of normal; 
C
     	VVOUT(1)=   -DSDX
     	VVOUT(2)=   -DSDY
     	VVOUT(3)=   1.0D0
C
C     	CALL	NORM	(VVOUT,VVOUT)
C
C Clean up
C
     	ZOUT = PDS(1)
C
C All done; return to caller
C
     	IERR = 0
     	RETURN
     	END IF
     	END
