C +++
C
C Source: src/trace/shadowit.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: shadowit.F
C Revision 1.8  1991/07/06  20:07:38  khan
C Grenoble and after. Minor changes
C
C Revision 1.7  91/04/05  15:06:06  cwelnak
C changed quotes on #includes
C 
C Revision 1.6  91/03/22  11:03:33  cwelnak
C SUN version -- INCLUDe to #include
C 
C Revision 1.5  90/11/13  14:02:00  khan
C Cleanup and SAVE statements
C 
C Revision 1.4  90/07/19  11:16:38  khan
C Standar VMS => Unix changes (DO loops, OPEN statements, etc).
C 
C Revision 1.3  90/07/14  22:51:21  khan
C All public include files (common.blk, etc) are now in ./../include/ dir.
C 
C Revision 1.2  90/07/14  12:17:29  khan
C Added binary flag to WRITE_OFF.
C Open files with STATUS='UNKNOWN'.
C 
C Revision 1.1  90/07/10  14:57:00  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif


C+++
C	PROGRAM		SHADOWIT
C
C	PURPOSE		Retrace backward or forward a beam to determine
C			the effect at other positions along the OS of an
C			aperture located elsewhere.
C
C	CAPABILITIES	Prepares a file for TOPDRAWER
C
C	OUTPUT		To disk.
C---
     	PROGRAM 	SHADOWIT
	IMPLICIT        REAL*8          (A-E,G-H,O-Z)
	IMPLICIT        INTEGER*4       (F,I-N)
 
#if defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#elif defined(vms)
	INCLUDE		'SHADOW$INC:DIM.PAR/LIST'
#endif

     	REAL 	*8	RAY (12,N_DIM),PHASE(3,N_DIM),AP(3,N_DIM)
     	DIMENSION	BEAM (10,12,N_DIM),PTEST(2),KOL(2,10)
     	DIMENSION	KPL (2), KCOL (2), FLAG(N_DIM), IFILE(10)
	DIMENSION	XMIN(10),XMAX(10),YMIN(10),YMAX(10),KIND(10)
     	CHARACTER *80	FILEIN (10)
     	CHARACTER *80	INFILE
     	CHARACTER *80	CREDATE,FILEOUT
     	CHARACTER *80	FILE1,FILE2
     	CHARACTER *80	TEXTOUT,COMMENT
     	CHARACTER *80	RSTRING
C
C Save some local large arrays to avoid overflowing stack.
C
	SAVE		RAY, PHASE, AP, BEAM, FLAG

     	
     	NAMELIST/ INPUT	/ FILEIN,XMAX,YMAX,XMIN,YMIN,KIND,NFILE,NPOINT,
     $			  IFILE,KOL,NCHECK,TRANS

10	IMODE = IYES ('Interactive [ Y ] or batch session ? ')
     	IF (IMODE.EQ.1) THEN
     	  WRITE(6,*)'Parameters input. This version is interactive.'
     	  NFILE	= IRINT	('How many files to read in ? ')
     	 DO 99 I=1,NFILE
     	   FILEIN(I) = RSTRING ('File-name : ')
 99  	 CONTINUE
     	  WRITE(6,*)'How many of the following files: '
     	 DO 199 I=1,NFILE
     	   WRITE (6,2222) I,FILEIN(I)
 199 	 CONTINUE
2222	FORMAT	(1X,I4,T10,A)
     	  NCHECK =  IRINT ('do you want to use as defining apertures? ')
     	  WRITE(6,*)'Please specify each one ( by index number ) : '
     	 DO 299 I=1,NCHECK
	   WRITE(6,*)'Aperture # ',I,' : '
     	   IFILE(I) = IRINT (' Index number ? ')
     	   WRITE(6,*)'Column to use for intercept testing ? '
     	   KOL(1,IFILE(I)) = IRINT ('" X "-column: ')
     	   KOL(2,IFILE(I)) = IRINT ('" Y "-column: ')
112	   WRITE(6,*)'Rectangular             1'
     	   WRITE(6,*)'Elliptical              2'
     	   WRITE(6,*)'Elliptical with hole    3 '
     	   KIND(I)  = IRINT ('Aperture type [1-3] ? ')
	  IF (KIND(I).EQ.1) THEN
     	   XMIN(I) = RNUMBER ('Xmin = ')
     	   XMAX(I) = RNUMBER ('Xmax = ')
     	   YMIN(I) = RNUMBER ('Ymin = ')
     	   YMAX(I) = RNUMBER ('Ymax = ')
	  ELSE IF (KIND(I).EQ.2) THEN
	   XMAX(I) = RNUMBER ('Full width along 1st column? ')
	   YMAX(I) = RNUMBER ('                 2nd       ? ')
	  ELSE IF (KIND(I).EQ.3) THEN
	   XMAX(I) = RNUMBER ('Outside full width along 1st column ? ')
	   YMAX(I) = RNUMBER ('                         2nd        ? ')
	   XMIN(I) = RNUMBER ('Inside full width along 1st column  ? ')
	   YMIN(I) = RNUMBER ('                        2nd         ? ')
	  ELSE
	   WRITE(6,*)'<What ? >'
	   GO TO 112
	  END IF
 299 	 CONTINUE
     	  NPOINT	= IRINT	('Use how many rays ? ')
     	ELSE
     	  WRITE(6,*)'Enter filename (TT: for keyboard) :'
     	  INFILE = RSTRING ('<?> ')
     	 IF (INFILE.EQ.'TT:'.OR.INFILE.EQ.'tt:') THEN
111  	   WRITE(6,*)'Actual parameters list:'
     	   WRITE (6,NML=INPUT)
     	   WRITE(6,*)'Please enter new values:'
     	 END IF
#ifdef vms
     	  OPEN (20,FILE=INFILE,STATUS='OLD',READONLY)
#else
     	  OPEN (20,FILE=INFILE,STATUS='OLD')
#endif
     	  READ (20,NML=INPUT)
     	  CLOSE (20)
     	  WRITE(6,*)'Starting parameters:'
     	  WRITE	(6,NML=INPUT)
     	  IMODIF = IYES ('Modify [ Y/N ] ? ')
     	 IF (IMODIF.EQ.1) THEN
     	   WRITE(6,*)'OK. Then ?'
     	   READ 	(5,NML=INPUT,ERR=111)
     	 END IF
     	END IF
     	DO 399 I=1,NFILE
	  CALL	RBEAM	(FILEIN(I),RAY,PHASE,AP,NCOL,NP,IFLAG,IERR)
  	  IF (IERR.NE.0)    THEN
	    WRITE(6,*)'Error reading ',FILEIN(I)
	    STOP
	  ELSE
     	    WRITE(6,*)'Read from ',FILEIN(I)
     	    DO 1799 K=1,NPOINT
     	      DO 1899 J=1,12
     	        BEAM (I,J,K)	=   RAY (J,K)
 1899	      CONTINUE
 1799	    CONTINUE
	  END IF
 399 	CONTINUE

     	WRITE(6,*)'Array is ready.'
** The array is now ready for processing.

106	CONTINUE
     	DO 499 I=1,NPOINT
     	  FLAG(I) = 1
 499 	CONTINUE
     	DO 599 J=1,NCHECK
		DO 699 I=1,NPOINT
     	 		PTEST(1) =   BEAM (IFILE(J),KOL(1,IFILE(J)),I)
      	 		PTEST(2) =   BEAM (IFILE(J),KOL(2,IFILE(J)),I)
     	 		IF (KIND(J).EQ.1) THEN
C
C KIND = 1 is rectangular slit
C
  		  TESTX 	= (PTEST(1) - XMIN(J))*(XMAX(J) -
     $				 PTEST(1))
  		  TESTY 	= (PTEST(2) - YMIN(J))*(YMAX(J) -
     $				 PTEST(2))
     	 		ELSE 	IF (KIND(J).EQ.2) THEN
C
C      = 2 is elliptical slit
C
     	  	TESTX	= 4*PTEST(1)**2/XMAX(J)**2 + 4*PTEST(2)**2
     $				/YMAX(J)**2 
     $			- 1.0D0
     	  	TESTX	= - TESTX
     	  	TESTY	= TESTX
	 	ELSE 	IF (KIND(J).EQ.3) THEN
C
C      = 3 is elliptical + elliptical hole ( xxMAX is outside,
C	   xxMIN is hole)
C
     	  	  TESTX	= 4*PTEST(1)**2/XMAX(J)**2 + 4*PTEST(2)**2/
     $				YMAX(J)**2 
     $			- 1.0D0
     	  	  TESTX = - TESTX
     	  	  TESTY	= 4*PTEST(1)**2/XMIN(J)**2 + 4*PTEST(2)**2/
     $				YMIN(J)**2 
     $			- 1.0D0
     	 ELSE
     	  TESTX	=  1.0D0
     	  TESTY	=  1.0D0
     	 END IF

		IF(TESTX.LT.(0.0).OR.TESTY.LT.(0.0)) FLAG(I)=-1
 699	  CONTINUE
 599 	CONTINUE

	DO 799 J=1,NFILE
		DO 899 K=1,NPOINT
		  BEAM(J,10,K)=FLAG(K)
 899		CONTINUE
 799	CONTINUE

101	CONTINUE
     	GOOD	= 0
     	BAD	= 0
     	DO 999 I=1,NPOINT
     	IF (FLAG(I).GE.0.0) GOOD	=   GOOD + 1
     	IF (FLAG(I).LT.0.0) BAD	=   BAD + 1
 999 	CONTINUE
     	TRANS	=   GOOD/NPOINT
#ifdef vms
    	OPEN (22,FILE='SHADOWIT.NML',STATUS='NEW')
#else
     	OPEN (22,FILE='SHADOWIT.NML',STATUS='UNKNOWN')
	REWIND (22)
#endif
     	WRITE (22,NML=INPUT)
     	CLOSE (22)
     	WRITE(6,*)'Accounting situation:'
     	WRITE(6,*)'Total rays : ',NPOINT
     	WRITE(6,*)'Good ones  : ',GOOD
     	WRITE(6,*)'Lost ones  : ',BAD
     	WRITE(6,*)'Transm.	   : ',TRANS
50     	WRITE(6,*)'Options. Enter :'
     	WRITE(6,*)'2	file out  (e.g., for TOPDRAWER)'
     	WRITE(6,*)'3	redefine the limits'
     	WRITE(6,*)'4	restart with other files'
     	WRITE(6,*)'5	rewrite the RAYs files'
     	WRITE(6,*)'6	exit.'
     	IGO  = IRINT ('<?> ')

     	GO TO (101,102,103,104,107,105)	IGO
102	CONTINUE
     	WRITE(6,*)'The HIT rays will be in a file of type *.HIT'
     	WRITE(6,*)'the others in a file type *.NHT'
     	WRITE(6,*)'Files available:'
     	DO 1099 I=1,NFILE
     	  WRITE(6,*)I,'  ',FILEIN(I)
 1099  	CONTINUE

     	IFILPLOT = IRINT ('Index of file to prepare ? ')
	WRITE(6,*)'Which columns to write to file ? '
	KPL(1) = IRINT ('First :: ')
     	KPL(2) = IRINT ('Second:: ')
     	WRITE(6,*)'Filename (max 9 letters, no specifier) ?'
     	READ (5,1000,IOSTAT=IREAD)	LFILE,FILEOUT
     	IF (IREAD.NE.0) THEN
     	  WRITE(6,*)'Error reading file name. Default used instead.'
     	  FILEOUT(1:9) = 'RESHADE'
     	END IF
     	IF (LFILE.GT.9) LFILE = 9
     	FILE1	=   FILEOUT(1:LFILE)//'.HIT'
     	FILE2	=   FILEOUT(1:LFILE)//'.NHT'
#ifdef vms
    	OPEN (21,FILE=FILE1,STATUS='NEW')
    	OPEN (22,FILE=FILE2,STATUS='NEW')
#else
     	OPEN (21,FILE=FILE1,STATUS='UNKNOWN')
	REWIND (21)
     	OPEN (22,FILE=FILE2,STATUS='UNKNOWN')
	REWIND (22)
#endif
     	DO 1199 I = 1,NPOINT
     	IF (BEAM(IFILPLOT,10,I).GE.0.0D0) THEN
     	 WRITE (21,*)	BEAM(IFILPLOT,KPL(1),I),BEAM(IFILPLOT,KPL(2),I)
     	ELSE
     	 WRITE (22,*)	BEAM(IFILPLOT,KPL(1),I),BEAM(IFILPLOT,KPL(2),I)
     	END IF
 1199	CONTINUE
     	CLOSE	(21)
     	CLOSE	(22)
     	GO TO 50

103	CONTINUE
     	WRITE(6,*)'Enter the new limits, please. Namelist is INPUT'
     	WRITE	(6,NML=INPUT)
     	READ 	(5,NML=INPUT)
     	GO TO 106

104	CONTINUE
     	GO TO 10

105	STOP

107	CONTINUE
     	DO 1299 I=1,1000
     	 DO 1399 J=1,12
     	  RAY(I,J) = 0.0D0
 1399	 CONTINUE
 1299	CONTINUE

     	DO 1499 I=1,NFILE
     	  KNT = 0
     	 DO 1599 J=1,NPOINT
     	   IF (BEAM(I,10,J).GE.0.0) THEN
     	     KNT = KNT + 1
     	    DO 1699 K=1,12
     	     RAY(K,KNT) = BEAM (I,K,J)
 1699	    CONTINUE
     	   END IF
 1599    CONTINUE
	 NCOL	= 12
	 IFLAG	= 0
	 CALL 	WRITE_OFF ('RERAY',RAY,PHASE,AP,NCOL,KNT,IFLAG,0,IERR)
     	 WRITE(6,*)'Written file :',I,' with ',KNT,' rays.'
 1499	CONTINUE
#if G77
1000	FORMAT	(A)
#else
1000	FORMAT	(Q,A)
#endif
1100	FORMAT (A)
     	END
