C +++
C
C Source: src/trace/optaxis.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: optaxis.F
C Revision 1.8  1991/07/06  20:07:38  khan
C Grenoble and after. Minor changes
C
C Revision 1.7  91/04/05  15:05:57  cwelnak
C changed quotes on #includes
C 
C Revision 1.6  91/03/22  10:42:05  cwelnak
C SUN version -- INLCUDe to #include
C 
C Revision 1.5  90/11/13  14:01:54  khan
C Cleanup and SAVE statements
C 
C Revision 1.4  90/07/19  21:37:56  khan
C Put #ifdef's to make it work on BOTH VMS and Ultrix
C 
C Revision 1.3  90/07/14  22:51:14  khan
C All public include files (common.blk, etc) are now in ./../include/ dir.
C 
C Revision 1.2  90/07/14  12:15:45  khan
C All files opened with STATUS=UNKNOWN (as opposed to NEW as in VMS).
C 
C Revision 1.1  90/07/10  14:56:37  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	SUBROUTINE	OPTAXIS
C
C	PURPOSE		Defines the optical axis in the lab reference
C			frame.
C---
	SUBROUTINE OPTAXIS (I_MIRROR)

** This Subroutine keeps the accounting of the optycal system in the
** source reference frame. This is done by means of the array OPTAXIS
**	CENTRAL (I,1:3)   Source coordinates for the 'I' mirror
**	CENTRAL (I,4:6)   Mirror optical center coordinates
**	CENTRAL (I,7:9)   Image position.
**	CENTRAL (I,10:12) Binormal vector 	>> U_VEC
**	CENTRAL (I,13:15) Tangent vector  	>> V_VEC
**	CENTRAL (I,16:18) Mirror normal   	>> W_VEC
**	CENTRAL (I,19:21) Reflected versor 	>> V_REF
**	CENTRAL (I,22:24) Normal to reflec.	>> V_PERP
** The outputs are in the source reference frame.
** We use T_REFLECTION to take in account the case of the grating.

#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c
c
#	include		<common.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
#endif

	DIMENSION 	V_REF(3),V_TEMP(3),U_VEC(3),V_VEC(3),W_VEC(3),
     $			V_PERP(3),U_OLD(3),V_OLD(3),W_OLD(3),R_OLD(3),
     $			RP_OLD(3)
     	WRITE(6,*)'Call to OPTAXIS'
#ifdef vms
     	CALL	FNAME (FFILE,'OPTAX',I_MIRROR,2)
#else
     	CALL	FNAME (FFILE,'optax',I_MIRROR,2)
#endif
     	DEFLECTION	=   T_INCIDENCE + T_REFLECTION
     		IF (I_MIRROR.EQ.1) THEN
     	U_VEC (1)	=   COSAL
     	 U_VEC (2)	=   0.0D0
     	  U_VEC (3)     =   SINAL
     	V_VEC (1)     	= - SIN(PIHALF - T_INCIDENCE)*SINAL
     	 V_VEC (2)     	=   COS(PIHALF - T_INCIDENCE)
     	  V_VEC (3)     =   SIN(PIHALF - T_INCIDENCE)*COSAL
     	W_VEC (1)    	= - SIN(PI - T_INCIDENCE)*SINAL
     	 W_VEC (2)    	=   COS(PI - T_INCIDENCE)
     	  W_VEC (3)    	=   SIN(PI - T_INCIDENCE)*COSAL
     	V_REF (1)     	= - SIN(PI - DEFLECTION)*SINAL
     	 V_REF (2)     	=   COS(PI - DEFLECTION)
     	  V_REF (3)     =   SIN(PI - DEFLECTION)*COSAL
     	V_PERP (1)     	= - SIN(3*PIHALF - DEFLECTION)*SINAL
     	 V_PERP (2)     =   COS(3*PIHALF - DEFLECTION)
     	  V_PERP (3)    =   SIN(3*PIHALF - DEFLECTION)*COSAL

	CENTRAL(1,1)  	=   .0D0
	CENTRAL(1,2)  	=   .0D0
	CENTRAL(1,3)  	=   .0D0
	CENTRAL(1,4)  	=   .0D0
	CENTRAL(1,5)  	=   T_SOURCE
	CENTRAL(1,6)  	=   .0D0
     	CENTRAL(1,7) 	=   T_IMAGE*V_REF(1)
     	CENTRAL(1,8) 	=   T_IMAGE*V_REF(2) + T_SOURCE
     	CENTRAL(1,9) 	=   T_IMAGE*V_REF(3)
     	CENTRAL(1,10)	=   U_VEC(1)
     	CENTRAL(1,11)	=    U_VEC(2)
     	CENTRAL(1,12)	=     U_VEC(3)
     	CENTRAL(1,13)	=   V_VEC(1)
     	CENTRAL(1,14)	=    V_VEC(2)
     	CENTRAL(1,15)	=     V_VEC(3)
     	CENTRAL(1,16)	=   W_VEC(1)
     	CENTRAL(1,17)	=    W_VEC(2)
     	CENTRAL(1,18)	=     W_VEC(3)
     	CENTRAL(1,19)	=   V_REF(1)
     	CENTRAL(1,20)	=    V_REF(2)
     	CENTRAL(1,21)	=     V_REF(3)
     	CENTRAL(1,22) 	=   V_PERP(1)
     	CENTRAL(1,23) 	=    V_PERP(2)
     	CENTRAL(1,24) 	=     V_PERP(3)
     	  	ELSE
     	KOUNT	=   I_MIRROR
     	IWHICH  =   I_MIRROR - 1
** Computes now the OLD mirror reference frame in the lab. coordinates
** system. The rotation angle ALPHA of the current mirror is defined in
** this reference frame, as ALPHA measure the angle between the two
** incidence planes (not necessarily the same).

     	U_OLD (1)	=   CENTRAL (IWHICH,10)
     	 U_OLD (2)	=   CENTRAL (IWHICH,11)
     	  U_OLD (3)	=   CENTRAL (IWHICH,12)
*     	V_OLD (1)	=   CENTRAL (IWHICH,13)
*     	 V_OLD (2)	=   CENTRAL (IWHICH,14)
*     	  V_OLD (3)	=   CENTRAL (IWHICH,15)
*     	W_OLD (1)	=   CENTRAL (IWHICH,16)
*     	 W_OLD (2)	=   CENTRAL (IWHICH,17)
*     	  W_OLD (3)	=   CENTRAL (IWHICH,18)
     	R_OLD (1)     	=   CENTRAL (IWHICH,19)
     	 R_OLD (2)     	=   CENTRAL (IWHICH,20)
     	  R_OLD (3)    	=   CENTRAL (IWHICH,21)
     	RP_OLD (1)     	=   CENTRAL (IWHICH,22)
     	 RP_OLD (2)    	=   CENTRAL (IWHICH,23)
     	  RP_OLD (3)   	=   CENTRAL (IWHICH,24)
** This vector is the NORMAL of the new mirror in the OMRF (U,R_OLD,RP_OLD) **
	V_TEMP (1)	= - SIN(PI - T_INCIDENCE)*SINAL
	V_TEMP (2)	=   COS(PI - T_INCIDENCE)
	V_TEMP (3)	=   SIN(PI - T_INCIDENCE)*COSAL
** Rotate it finally to (x,y,z) SRF **
     	W_VEC (1)	=    V_TEMP(1)*U_OLD(1) +
     $			     V_TEMP(2)*R_OLD(1) +
     $			     V_TEMP(3)*RP_OLD(1)
     	W_VEC (2)	=    V_TEMP(1)*U_OLD(2) +
     $			     V_TEMP(2)*R_OLD(2) +
     $			     V_TEMP(3)*RP_OLD(2)
     	W_VEC (3)	=    V_TEMP(1)*U_OLD(3) +
     $			     V_TEMP(2)*R_OLD(3) +
     $			     V_TEMP(3)*RP_OLD(3)
** This vector is the reflected beam from the new mirror in the OMRF **
	V_TEMP (1)    	= -  SIN(PI - DEFLECTION)*SINAL
	V_TEMP (2)    	=    COS(PI - DEFLECTION)
	V_TEMP (3)    	=    SIN(PI - DEFLECTION)*COSAL
** Express it now in the (x,y,z) SRF
     	V_REF (1)	=    V_TEMP(1)*U_OLD(1) +
     $			     V_TEMP(2)*R_OLD(1) +
     $			     V_TEMP(3)*RP_OLD(1)
     	V_REF (2)	=    V_TEMP(1)*U_OLD(2) +
     $			     V_TEMP(2)*R_OLD(2) +
     $			     V_TEMP(3)*RP_OLD(2)
     	V_REF (3)	=    V_TEMP(1)*U_OLD(3) +
     $			     V_TEMP(2)*R_OLD(3) +
     $			     V_TEMP(3)*RP_OLD(3)
** This is now the perp. vector in the OMRF **
	V_TEMP (1)     = - SIN(3*PIHALF - DEFLECTION)*SINAL 
	V_TEMP (2)     =   COS(3*PIHALF - DEFLECTION)
	V_TEMP (3)     =   SIN(3*PIHALF - DEFLECTION)*COSAL
** Rotate it to the SRF
     	V_PERP (1)	=    V_TEMP(1)*U_OLD(1) +
     $			     V_TEMP(2)*R_OLD(1) +
     $			     V_TEMP(3)*RP_OLD(1)
     	V_PERP (2)	=    V_TEMP(1)*U_OLD(2) +
     $			     V_TEMP(2)*R_OLD(2) +
     $			     V_TEMP(3)*RP_OLD(2)
     	V_PERP (3)	=    V_TEMP(1)*U_OLD(3) +
     $			     V_TEMP(2)*R_OLD(3) +
     $			     V_TEMP(3)*RP_OLD(3)
** This is the tangent vector in the OMRF **
     	V_TEMP (1)	= - SIN(PIHALF - T_INCIDENCE)*SINAL
     	V_TEMP (2)	=   COS(PIHALF - T_INCIDENCE)
     	V_TEMP (3)	=   SIN(PIHALF - T_INCIDENCE)*COSAL
** Rotate it to the SRF.
     	V_VEC (1)	=    V_TEMP(1)*U_OLD(1) +
     $			     V_TEMP(2)*R_OLD(1) +
     $			     V_TEMP(3)*RP_OLD(1)
     	V_VEC (2)	=    V_TEMP(1)*U_OLD(2) +
     $			     V_TEMP(2)*R_OLD(2) +
     $			     V_TEMP(3)*RP_OLD(2)
     	V_VEC (3)	=    V_TEMP(1)*U_OLD(3) +
     $			     V_TEMP(2)*R_OLD(3) +
     $			     V_TEMP(3)*RP_OLD(3)
** Last, we generate U_VEC in the OMRF **
     	V_TEMP (1)	=   COSAL
     	V_TEMP (2)	=   .0D0
     	V_TEMP (3)	=   SINAL
** rotate to SRF
     	U_VEC (1)	=    V_TEMP(1)*U_OLD(1) +
     $			     V_TEMP(2)*R_OLD(1) +
     $			     V_TEMP(3)*RP_OLD(1)
     	U_VEC (2)	=    V_TEMP(1)*U_OLD(2) +
     $			     V_TEMP(2)*R_OLD(2) +
     $			     V_TEMP(3)*RP_OLD(2)
     	U_VEC (3)	=    V_TEMP(1)*U_OLD(3) +
     $			     V_TEMP(2)*R_OLD(3) +
     $			     V_TEMP(3)*RP_OLD(3)
** All done. Write to the array and leave.

     	CENTRAL (KOUNT,1)   =   CENTRAL (IWHICH,7)
     	CENTRAL (KOUNT,2)   =   CENTRAL (IWHICH,8)
     	CENTRAL (KOUNT,3)   =   CENTRAL (IWHICH,9)
     	CENTRAL (KOUNT,4)   =  T_SOURCE*R_OLD(1) + CENTRAL(KOUNT,1)
     	CENTRAL (KOUNT,5)   =  T_SOURCE*R_OLD(2) + CENTRAL(KOUNT,2)
     	CENTRAL (KOUNT,6)   =  T_SOURCE*R_OLD(3) + CENTRAL(KOUNT,3)
     	CENTRAL (KOUNT,7)   =   T_IMAGE*V_REF(1) + CENTRAL(KOUNT,4)
     	CENTRAL (KOUNT,8)   =   T_IMAGE*V_REF(2) + CENTRAL(KOUNT,5)
     	CENTRAL (KOUNT,9)   =   T_IMAGE*V_REF(3) + CENTRAL(KOUNT,6)
     	CENTRAL (KOUNT,10)  =   U_VEC(1)
     	CENTRAL (KOUNT,11)  =    U_VEC(2)
     	CENTRAL (KOUNT,12)  =     U_VEC(3)
     	CENTRAL (KOUNT,13)  =   V_VEC(1)
     	CENTRAL (KOUNT,14)  =    V_VEC(2)
     	CENTRAL (KOUNT,15)  =     V_VEC(3)
     	CENTRAL (KOUNT,16)  =   W_VEC(1)
     	CENTRAL (KOUNT,17)  =    W_VEC(2)
     	CENTRAL (KOUNT,18)  =     W_VEC(3)
     	CENTRAL (KOUNT,19)  =   V_REF(1)
     	CENTRAL (KOUNT,20)  =    V_REF(2)
     	CENTRAL (KOUNT,21)  =     V_REF(3)
     	CENTRAL (KOUNT,22)  =   V_PERP(1)
     	CENTRAL (KOUNT,23)  =    V_PERP(2)
     	CENTRAL (KOUNT,24)  =     V_PERP(3)

	END IF

#ifdef vms vms
    	OPEN (UNIT=23,FILE= FFILE,STATUS='NEW',DISPOSE='SAVE')
#else
     	OPEN (UNIT=23,FILE= FFILE,STATUS='UNKNOWN')
	REWIND (23)
#endif
     	 DO 100 I_WRITE=1,I_MIRROR
     	   WRITE (23,*) I_WRITE
     	   WRITE (23,*) ( CENTRAL(I_WRITE,J), J =  1,3)
     	   WRITE (23,*) ( CENTRAL(I_WRITE,J), J =  4,6)
     	   WRITE (23,*) ( CENTRAL(I_WRITE,J), J =  7,9)
     	   WRITE (23,*) ( CENTRAL(I_WRITE,J), J =10,12)
     	   WRITE (23,*) ( CENTRAL(I_WRITE,J), J =13,15)
     	   WRITE (23,*) ( CENTRAL(I_WRITE,J), J =16,18)
     	   WRITE (23,*) ( CENTRAL(I_WRITE,J), J =19,21)
     	   WRITE (23,*) ( CENTRAL(I_WRITE,J), J =22,24)
100	CONTINUE
     	CLOSE (23)
     	WRITE(6,*)'Exit from OPTAXIS'
	END
