C +++
C
C Source: src/trace/mosaic.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: mosaic.F
C Revision 1.6  1991/07/06  20:07:38  khan
C Grenoble and after. Minor changes
C
C Revision 1.5  91/04/05  15:05:53  cwelnak
C changed quotes on #includes
C 
C Revision 1.4  91/03/22  10:37:06  cwelnak
C SUN version -- INCLUDE to #include
C 
C Revision 1.3  91/03/15  15:37:55  khan
C Getting ready for Sun port...
C 
C Revision 1.2  91/02/21  14:48:41  khan
C Wrapper for Random number generator.
C 
C Revision 1.1  91/01/24  10:39:44  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	SUBROUTINE	MOSAIC
C
C	PURPOSE 	To compute the individual normal of the
C			mosaic piece inside the crystal
C			with which the ray is reflected.
C
C	ALGORITHM	We force the normal to verify both the Bragg law
C			and the gaussian distribution law around the 
C			crystal surface normal.
C
C	INPUT		a) incident ray direction
C			b) crystal surface normal
C			c) energy of the ray
C
C	OUTPUT		a) the new normal for calculate the refl ray
C			
C			
C			
C---
	Subroutine 	MOSAIC (VVIN,VNOR,WAVEN,VNORG)

#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c	INCLUDE         './../include/warning.blk'
c
c
#	include		<common.blk>
#	include		<warning.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
     	INCLUDE		'SHADOW$INC:WARNING.BLK/LIST'
#endif


	DIMENSION 	VNORG(3),AA(3),AA1(3),VVIN(3),VNOR(3)

	CALL DOT (VVIN,VNOR,SIN_VAL)
     	SIN_VAL	=   ABS(SIN_VAL)
	   R_LAMBDA = TWOPI/WAVEN *1.0D8
*
* next, compute the Bragg angle without index of refraction corrections
*
	  GRAZE =  ASIN(R_LAMBDA*0.5D-8/D_SPACING)
	  SINN  =  SIN(GRAZE)
*
* Compute now the correct Bragg angle (including N)
*
	  CALL CRYSTAL	(WAVEN,SINN,SINN,DUMM,DUMM,DUMM,
     $			DUMM,DUMM,DUMM,DUMM,DUMM,THETA_B,1)
*
* redefinition of bragg angle and incident angle. Now refered to 
* the surfece normal
*
	THETA_B  =  PI/2 - THETA_B
	COS_B   = COS(THETA_B)
	SIN_B   = SIN(THETA_B)
	TAN_B   = SIN_B/COS_B
	SIN_VAL = SQRT(1-SIN_VAL**2)
	COS_VAL = SQRT(1-SIN_VAL**2)
	TAN_VAL = SIN_VAL/COS_VAL
	EPSILON = -ASIN(SIN_VAL) + THETA_B   ! RADS.
*
* rotation of surface normal an angle epsilon around an axis
* perpendicular to the surface normal and incident ray
*
	CALL CROSS (VVIN,VNOR,AA)
	CALL ROTVECTOR (VNOR,AA,EPSILON,AA1)
*
* generation of a random spread angle XX fitting with Bragg law
*
	ARGMAX = (EPSILON + 2.0D0*THETA_B)/SPREAD_MOS
	IF (EPSILON.GE.0) THEN
	 ARGMIN = EPSILON/SPREAD_MOS
	ELSE IF (EPSILON.LT.0) THEN
	 ARGMIN = -EPSILON/SPREAD_MOS
	END IF
	CALL GNORMAL (ARGMIN,MOSAIC_SEED,-2) 
	CALL GNORMAL (ARGMAX,MOSAIC_SEED,-1) 
	CALL GNORMAL (XX,MOSAIC_SEED,0)
*
*if a ray comes very far from Bragg position, GNORMAL fails to
*give a value in the correct interval, because it goes to infinity
*Then we consider the most probably value for avoiding the code stops.
*
	IF ((XX.LT.ARGMIN).OR.(XX.GT.ARGMAX)) THEN 
	XXX = 0
	GO TO 444
	END IF

	XX = SPREAD_MOS*XX
*
* rotation of AA1 an angle XXX around the incident ray axis VVIN
* for having the normal we look for.
*
	HH2 = ABS(TAN_VAL - TAN_B)
	HHH = SQRT(COS_B**(-2)+COS_VAL**(-2)-2*COS(XX)/COS_B/COS_VAL)
	COS_XXX = (HHH**2-TAN_VAL**2-TAN_B**2)/(-2*TAN_VAL*TAN_B)
	IF (ABS(COS_XXX).GT.1) CALL MSSG('Error in MOSAIC','cos>1',0)
	XXX = ACOS(COS_XXX)
	XXX = ABS(XXX)
*next lines give the random direction (ccw or acw) for the rotation
	IPP = MOSAIC_SEED
	DUMM = WRAN (IPP)
	IF (IPP.LT.0) XXX=-XXX

444	CALL ROTVECTOR (AA1,VVIN,XXX,VNORG)
    	CALL NORM (VNORG, VNORG)
	RETURN 
	END
*That's all. This part is done in MIRROR:
*  	  CALL PROJ (VVIN,VNORG,VTEMP)
*	  RAY(4,ITIK) 	= VVIN(1) - 2*VTEMP(1)
*	  RAY(5,ITIK) 	= VVIN(2) - 2*VTEMP(2)
*	  RAY(6,ITIK) 	= VVIN(3) - 2*VTEMP(3)
