
#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++


	SUBROUTINE       KOMA11(BVEC,ROT,HLINE,PAR,BPAR,EXIT_TEMP)
	
#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c	INCLUDE         './../include/namelist.blk'
c
c
#	include		<common.blk>
#	include		<namelist.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
	INCLUDE	        'SHADOW$INC:WARNING.BLK/LIST'
#endif

	real*8 bvec(6),rot(5),HLINE(11),PAR(8),BPAR(14,14,6)
	real*8 a(3),b(3),c(3),na(3),nb(3),nc(3)
	real*8 p(3),TX(4),EXIT_TEMP(6)

	real*8 rint(2),rtep(2)
	real*8 int1(2),int2(2)
	real*8 tep(2),tnb(2),tna(2),tb(2),ta(2)
	real*8 la1(3),la(3),la2(3),lb(3),lt(3)
	real*8 cint(2),cin(2),te1(2),te2(2)

	real*8 mvb,mva,theac,rm,rn
	real*8 mvc,sa,sb,sc,lnx1,lnx2,lny1,lny2
	real*8 lnyc1,lnyc2,intu1,intu2,intl1,intl2
	real*8 lnx,lny,test
	real*8 wi,wj,lnh1,lnh2,lnhc1,lnhc2,px,py
	real*8 trm,trn,temp
	real*8 dot_bc,dotab,dotac
	real*8 rq,pcos
	real*8 aa11,aa12,aa21,aa22
        integer*4  ha,rot_sta,IQ(2)
	integer*4  i,i1,KIQ

	CHARACTER*80 INFILE2
	INFILE2='koko2.dat'
C	CHARACTER*80 INFILE
C	INFILE='KILE_KOMA.DAT'
C
C Key in the two dimensional basis vector for the
C construction of your Wigner-Seitz cell
C

	F_BUNDLE = 0
	IF (F_BUNDLE.NE.1) THEN
	  IF (F_KOMA_CA.EQ.1) THEN 
	    CALL READMEM(FILE_KOMA_CA,IERR,TX,PAR,Iq)
	  ELSE
	    CALL README(FILE_KOMA,IERR,TX,PAR,Iq,EXIT_TEMP)
	  ENDIF
	ELSE
	CALL READMEII(INFILE2,IERR,TX,BPAR,Iq,KIQ)
	END IF 
	IF (IERR.NE.0) THEN
          CALL LEAVE     ('KOMA','Error from README in KOMA',IERR)

	END IF

C	WRITE(6,*) 'your komakofu parameter'
C	WRITE(6,*) 'basis vector',TX
C	WRITE(6,*) 'tube shape',PAR
C	WRITE(6,*) 'NDEG and F_POLSEL',IQ(1),IQ(2)

C
C   originally, i have the par(4) equal r0, since the demand for the
C single capillary make me change this definition when F_KOMA_CA = 1
C I use par(1) as length par(2) as radius par(3)-par(7) as coefficient 
C of the h(z) = r(z)**2 , when F_KOMA_CA = 0 all the definition
C stay the same that are
C par(2)-(3) as g(z) par(4) as radius par(5)-(6) as f(z) = r(z)
C

	ZKO_LENGTH = PAR(1)
C	R0_KOMA = PAR(4)
	NDEG=IQ(1)
	F_POLSEL=IQ(2)
	ta(1) =TX(1)
	ta(2)= TX(2)
	tb(1) = TX(3)
	tb(2) = TX(4)

	if(ta(1).lt.0.0.or.ta(2).lt.0.0) then
	 WRITE(6,*) 'two positive values please(for ta)'
          CALL LEAVE     ('KOMA','Error from  KOMA1 Basis ',IERR)
	end if
	call kdot(ta,ta,mva)
	if (mva.eq.0.) then
	 WRITE(6,*) 'bad basis (zero length)'
          CALL LEAVE     ('KOMA','Error from  KOMA1 Basis ',IERR)
	endif
C	WRITE(6,*) tb(1),tb(2)
	call kdot(tb,tb,mvb)
	if (mvb.eq.0.) then
	WRITE(6,*) 'bad basis (zero length)'
          CALL LEAVE     ('KOMA','Error from basis choicE',IERR)
	endif

	call knorm(ta,tna)
	call knorm(tb,tnb)
C       WRITE(6,*) 'tna',tna
C	WRITE(6,*) 'tnb',tnb

C
C If your two basis vectors parallel, you will be asked to
C change them
C

	call kdot(tna,tnb,test)
	if (abs(test).eq.1.0) then
	 WRITE(6,*) 'bad basis vector (parallel vectors)'
          CALL LEAVE     ('KOMA','Error from basis choicE',IERR)
	endif

C
C test whether the angle of your basis vectors is larger than 90 degree
C

	call kdot(tna,tnb,pcos)
	if (pcos.lt.0.0) then
	 tmp = -1.0
	 call kscalar(tnb,tmp,tnb)
	end if
C
C I put your first basis as (1 0)  (note: a vector has not been changed yet)
C
	na(1)=1.0
	na(2)=0.0

C
C test whether b(user input)  basis is in first quadrant
C

	if (tnb(2).ge.0.) then

C
C test if it is the case I will interchange the name
C of the basis vectors
C

	 if (tnb(1).gt.tna(1)) then
	  tep(1)=tb(1)
	  tep(2)=tb(2)
	  tb(1)=ta(1)
	  tb(2)=ta(2)
	  ta(1)=tep(1)
	  ta(2)=tep(2)
	  call knorm(ta,tna)
	  call knorm(tb,tnb)
	  temp=mva
	  mva=mvb
	  mvb=temp
	  nb(1) = tnb(1)
	  nb(2) = tnb(2)
	 end if

C
C Test the rotation flag: I will rotate your picture
C back after I generate the correct WS cell
C

	 if(tna(2).ne.0.) then
	  rot_sta=1
	  aa11=tna(1)
	  aa12=sqrt(1-tna(1)**2)
	  aa21=-1.*aa12
	  aa22=tna(1)
	  nb(1)=aa11*tnb(1)+aa12*tnb(2)
	  nb(2)=aa21*tnb(1)+aa22*tnb(2)
	 else

C
C no rotation
C

	  nb(1)=tnb(1)
	  nb(2)=tnb(2)
	 end if

C
C In the fourth quardant
C

	else
	 rot_sta=1
	 aa11=tnb(1)
	 aa12=-1*sqrt(1.-tnb(1)**2)
	 aa21=-1*aa12
	 aa22=aa11
	 nb(1)=aa11*tna(1)+aa12*tna(2)
	 nb(2)=aa21*tna(1)+aa22*tna(2)
	 temp=mva
	 mva=mvb
	 mvb=temp
	end if

	sa=sqrt(mva)
	sb=sqrt(mvb)
	a(1)=sa*na(1)
	a(2)=sa*na(2)
	b(1)=sb*nb(1)
	b(2)=sb*nb(2)
	c(1)=a(1)-b(1)
	c(2)=a(2)-b(2)
C
C the angle between a and b is smaller than 90 degree now
C we want to check the angle between -b and c, a and c, and
C a and b
C

	call knorm(c,nc)
	call kdot(c,c,mvc)
	sc=sqrt(mvc)
C	WRITE(6,*) 'a',sa*na(1),sa*na(2)
C	WRITE(6,*) ' b',sb*nb(1),sb*nb(2)
	tmp = -1.0
	call kscalar(nb,tmp,tep)
	call kdot(nc,tep,dot_bc)
	call kdot(na,nb,dotab)
	call kdot(na,nc,dotac)
C	WRITE(6,*) 'dotbc ab ac ',dot_bc,dotab,dotac
	ha=0

C
C 90 degree between basis vectors
C ha=1 is its flag
C

	if (dotab.eq.0.0) then
	 ha=1
	 lnx=sa
	 lny=sb
	else if(dotac.eq.0) then
	 ha=1
	 lnx=sa
	 lny=sc
	else if (dot_bc.lt.0.0) then

C
C where only four sides has to be considered
C

	 ha=2

C
C lines la1 and la2 are prependicular to basis b
C

	 la1(1)=nb(1)
	 la1(2)=nb(2)
	 la1(3)=0.5*sb
	 la2(1)=nb(1)
	 la2(1)=nb(2)
	 la2(3)=-0.5*sb
	else if (dotac.lt.0.0) then
	 ha=2

C
C lines la1 and la2 are prependicular to basis a
C

	 la1(1)=na(1)
	 la1(2)=na(2)
	 la1(3)=0.5*sa
	 la2(1)=na(1)
	 la2(2)=na(2)
	 la2(3)=-0.5*sa
	else

C
C Where we consider six sides
C

C
C lines perpendicular to baiss a
C

	 lnx1=0.5*sa
	 lnx2=-0.5*sa

C
C lines perpendicular to baiss b
C

	 lny1=nb(1)
	 lny2=nb(2)
	 lnyc1=0.5*sb
	 lnyc2=-0.5*sb

C
C intersection points between the above lines
C

	 intu1=lnx1
	 intu2=-1.*(nb(1)*intu1-lnyc1)/nb(2)
	 intl1=lnx2
	 intl2=-1.*(nb(1)*intl1-lnyc2)/nb(2)

C
C lines perpendicular to vector c
C

	 lnh1=nc(1)
	 lnh2=nc(2)
	 lnhc1=nc(1)*intu1+nc(2)*intu2
	 lnhc2=nc(1)*intl1+nc(2)*intl2
	endif
	if (ha.eq.2) then
	 lb(1)=nc(1)
	 lb(2)=nc(2)
	 lb(3)=0.5*sc

C
C intersection points between la1 and lb (line perpendicular
C to vector c, and la2 and lb
C

	 call line(la1,lb,int1)
	 call line(la2,lb,int2)
	 cin(1)=int1(1)-int2(1)
	 cin(2)=int1(2)-int2(2)
	 cint(1)=int2(1)+0.5*cin(1)
	 cint(2)=int2(2)+0.5*cin(2)
	 call knorm(cint,te1)
	 call knorm(cin,te2)
	 call kdot(te1,te2,test)
	 if (abs(test).eq.1.0) then
	WRITE(6,*) 'bad basis vector'
          CALL LEAVE     ('KOMA','Error from basis choicE ',IERR)
	end if

C
C the factor 2 is to compensate for the anint function
C

	a(1)=2.*cint(1)
	a(2)=cint(2)*2.
	b(1)=cin(1)
	b(2)=cin(2)

C
C prepare to solve the equation p=m a + n b
C

	la(1)=a(1)
	la(2)=b(1)
	lt(1)=a(2)
	lt(2)=b(2)
C	WRITE(6,*) '4 sides case a b',a(1),a(2),b(1),b(2)
	temp=a(1)*b(2)-a(2)*b(1)
	if (temp.eq.0) then
	WRITE(6,*) 'bad vector choice'
          CALL LEAVE     ('KOMA','Error from basis choice ',IERR)
	end if
	end if
	
	BVEC(1) = a(1)
	BVEC(2) = a(2)
	BVEC(3) = lnx
	BVEC(4) = b(1)
	BVEC(5) = b(2)
	BVEC(6) = lny

	rot(1)= rot_sta
	IF (rot_sta.ne.0) then
	
	  rot(2) = aa11
	  rot(3) = aa12
	  rot(4) = aa21
	  rot(5) = aa22
	endif

	hline(1) = ha
	hline(2) = lnx1
	hline(3) = lnx2
	hline(4) = lny1
	hline(5) = lny2
	hline(6) = lnyc1
	hline(7) = lnyc2
	hline(8) = lnh1
	hline(9) = lnh2
	hline(10)= lnhc1
	hline(11)= lnhc2

	


	DO 101 I= 0,4
	   DO 101 J=0,4
	     DO 101 K= 0,4

	      PCOEFF (I,J,K)   =0.0D0

101	CONTINUE

	RETURN
	END

	SUBROUTINE README (INFILE,IERR,TX,P_OUT,IQ,EXIT_TEMP)

#if defined(unix) || HAVE_F77_CPP
#	include		<common.blk>
#	include		<namelist.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
	INCLUDE	        'SHADOW$INC:WARNING.BLK/LIST'
#endif
	CHARACTER*80 INFILE
        REAl*8	TX(4),P_OUT(6),EXIT_TEMP(6)
	INTEGER*4 IQ(2),IQA

	OPEN (20,FILE=INFILE,STATUS='OLD',FORM='FORMATTED')

	READ(20,*)(TX(I),I=1,4)
	READ(20,*)(P_OUT(I),I=1,6)
	READ(20,*)(IQ(I),I=1,2)

        IF(F_EXIT_SHAPE.EQ.1) THEN
        READ(20,*)exit_temp(1)
C        iqa= jidint(exit_temp(1)) + 2
        iqa= idint(exit_temp(1)) + 2
        READ(20,*)(exit_temp(I),I=2,iqa)
        ENDIF

10	CLOSE(20)
	IERR=0

        RETURN

     	END


	SUBROUTINE READMEII (INFILE,IERR,BTX,BP_OUT,IQ,KIQ)

	CHARACTER*80 INFILE
        REAl*8	BTX(4),BP_OUT(14,14,6)
	INTEGER*4 IQ(2),KIQ

	OPEN (20,FILE=INFILE,STATUS='OLD')
	
	READ(20,*) KIQ
	READ(20,*)(BTX(I),I=1,4)
	DO 25 I=1,KIQ
	DO 25 J=1,KIQ
	READ(20,*)(BP_OUT(I,J,K),K=1,6)
25	continue
	READ(20,*)(IQ(I),I=1,2)


	CLOSE(20)
	IERR=0

        RETURN

     	END

        SUBROUTINE READMEM (INFILE,IERR,TX,P_OUT,IQ)
	 
	CHARACTER*80 INFILE
	REAL*8  TX(4),P_OUT(8)
	INTEGER*4 IQ(2),iqa
	OPEN (20,FILE=INFILE,STATUS='OLD',FORM='FORMATTED')
					  
	READ(20,*)(TX(I),I=1,4)
	READ(20,*)(P_OUT(I),I=1,7)
	READ(20,*)(IQ(I),I=1,2)

        CLOSE(20)
	IERR=0

        RETURN
	END


