C +++
C
C Source: src/trace/intercept.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: intercept.F
C Revision 1.7  1991/07/06  20:07:38  khan
C Grenoble and after. Minor changes
C
C Revision 1.6  91/04/05  15:05:51  cwelnak
C changed quotes on #includes
C 
C Revision 1.5  91/03/21  16:28:44  cwelnak
C SUN version -- INCLUDE to #include
C 
C Revision 1.4  90/11/13  14:01:51  khan
C Cleanup and SAVE statements
C 
C Revision 1.3  90/07/19  21:37:52  khan
C Put #ifdef's to make it work on BOTH VMS and Ultrix
C 
C Revision 1.2  90/07/14  22:51:11  khan
C All public include files (common.blk, etc) are now in ./../include/ dir.
C 
C Revision 1.1  90/07/10  14:56:19  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C	subroutine	intercept	( xin, vin, tpar, iflag)
C
C	purpose		computes the intercepts onto the mirror surface
C
C	arguments	xin	ray starting position     mirror RF
C			vin	ray direction		  mirror RF
C			tpar	distance from start of
C				intercept
C			iflag   input		1	ordinary case
C					       -1	ripple case
C			iflag	output		0	success
C					       -1       complex sol.
C
     	SUBROUTINE	INTERCEPT	(XIN, VIN, TPAR, IFLAG)

#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c
c
#	include		<common.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
#endif
     	DIMENSION	XIN(3),VIN(3)
C
C tests for non-conic mirrors
C
       	IF (FMIRR.EQ.3) THEN				! Torus
     	  CALL QUARTIC	( XIN, VIN, TPAR, IFLAG)
     	  IF (IFLAG.LT.0)	RETURN
       	ELSE IF (FMIRR.EQ.9) THEN			! Gen poly
	  IF (F_KOMA.NE.1) THEN
       	  CALL POLY	( XIN, VIN, TPAR, IFLAG)
	  ELSE
	  CALL SPOLY	( XIN, VIN, TPAR, IFLAG)
C	  type *,'IFLAG',IFLAG
C	  type *,'TPAR',TPAR
	  ENDIF
     	  IF (IFLAG.LT.0)	RETURN
     	ELSE 
C
C conic mirrors
C
	AA 	=   CCC(1)*VIN(1)**2 
     $		  + CCC(2)*VIN(2)**2 
     $		  + CCC(3)*VIN(3)**2
     $		  + CCC(4)*VIN(1)*VIN(2) 
     $		  + CCC(5)*VIN(2)*VIN(3)
     $            + CCC(6)*VIN(1)*VIN(3)
	BB 	=   CCC(1)*XIN(1)*VIN(1)*2
     $		  + CCC(2)*XIN(2)*VIN(2)*2
     $ 		  + CCC(3)*XIN(3)*VIN(3)*2
     $		  + CCC(4)*(XIN(2)*VIN(1) 
     $			  + XIN(1)*VIN(2))
     $  	  + CCC(5)*(XIN(3)*VIN(2) 
     $			  + XIN(2)*VIN(3))
     $  	  + CCC(6)*(XIN(1)*VIN(3) 
     $		  	  + XIN(3)*VIN(1)) 
     $  	  + CCC(7)*VIN(1) 
     $		  + CCC(8)*VIN(2) 
     $		  + CCC(9)*VIN(3) 
     $		  + CCC(10)
	CC 	=   CCC(1)*XIN(1)**2 
     $		  + CCC(2)*XIN(2)**2 
     $		  + CCC(3)*XIN(3)**2  
     $  	  + CCC(4)*XIN(2)*XIN(1) 
     $            + CCC(5)*XIN(2)*XIN(3) 
     $		  + CCC(6)*XIN(1)*XIN(3)
     $    	  + CCC(7)*XIN(1)
     $		  + CCC(8)*XIN(2)
     $		  + CCC(9)*XIN(3)
     $		  + CCC(10)
C
C Solve now the second deg. equation **
C
	 IF (ABS(AA).GT.1.0D-15) THEN
	   DENOM 	= 0.5D0/AA
	 ELSE IF (BB.NE.0.0D0) THEN
     	   TPAR   	= - CC/BB
	   GO TO 100
     	 ELSE
      	   WRITE(6,*)'Intercept error. All coefficients were zero'
     	   GO TO 200
	 END IF
C
	  DETER 	= BB**2 - CC*AA*4
C
	 IF (DETER.LT.0.0) THEN
    	   GO TO 200
	 ELSE
	   TPAR1 	= -(BB + SQRT(DETER))*DENOM
	   TPAR2 	= -(BB - SQRT(DETER))*DENOM
	 END IF
	 IF (IFLAG.LT.0) THEN
C
C Ripple case : always take the closest intercept onto the ideal surface.
C
	   IF (ABS(TPAR1).LT.ABS(TPAR2)) THEN
	     TPAR	= TPAR1
	   ELSE
	     TPAR	= TPAR2
	   END IF
	 ELSE 
C
C tests for convexity
C
     	   IF (FMIRR.NE.7.AND.F_CONVEX.NE.1) THEN
     	     TPAR	=   MAX (TPAR1,TPAR2)
     	   ELSE
     	     TPAR	=   MIN (TPAR1,TPAR2)
     	   END IF
	 END IF
     	END IF
C
C Success
C
100	IFLAG =  0
     	RETURN
C
C failure
C
200	IFLAG = -1
     	RETURN
     	END
