C +++
C
C Source: src/trace/crystal.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: crystal.F
C Revision 1.9  1992/08/26  20:28:02  sanchez
C Crystals in transmission (Laue) mode
C
C Revision 1.8  1991/07/06  20:07:38  khan
C Grenoble and after. Minor changes
C
C Revision 1.7  91/04/05  15:05:42  cwelnak
C changed quotes on #includes
C 
C Revision 1.6  91/03/21  16:11:05  cwelnak
C SUN version -- INCLUDE to #include
C 
C Revision 1.5  91/02/14  11:36:57  khan
C Latest VMS version (and a new bug...)
C 
C Revision 1.4  90/11/13  14:01:44  khan
C Cleanup and SAVE statements
C 
C Revision 1.3  90/07/19  21:37:45  khan
C Put #ifdef's to make it work on BOTH VMS and Ultrix
C 
C Revision 1.2  90/07/14  22:51:04  khan
C All public include files (common.blk, etc) are now in ./../include/ dir.
C 
C Revision 1.1  90/07/10  14:55:59  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C
C
C+++
C	SUBROUTINE	CRYSTAL
C
C	PURPOSE		Computes the reflectivity of a symmetric Bragg crystal 
C			according to the dynamic theory of x-ray diffraction.
C
C	ALGORITHM	Reference B.E.Warren, X-Ray Diffraction, 
C			Addison-Wesley 1969.  See also M.J.Bedzyk, G.Materlik 
C			and M.V.Kovalchuk, Phy. Rev. B30, 2453(1984).
C			For mosaic crystal reflectivity see Zachariasen, 
C			Theory of x-ray diffraction in crystals, Dover (1966)
C			formula 4.24, and Bacon and Lowde, Acta Crystall.1
C			pag 303 (1948) formula 17. 
C
C	MODIFIED	July 1989, M. Sanchez del Rio for asymmetry part,
C			July 1990, mosaic part.
C			August 1992, laue part.
C
C---
     	SUBROUTINE	CRYSTAL	 (Q_PHOT, SIN_Q_ANG, SIN_Q_REF, SIN_BRG,
     $R_S, R_P,PHASE_S, PHASE_P, DEPHT_MFP_S, DEPHT_MFP_P, 
     $DELTA_REF, THETA_B, KWHAT)

#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c
c
#	include		<common.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
#endif

     	REAL*8		ENERGY(1000)
	REAL*8		FP_A(1000),FPP_A(1000),FP_B(1000),FPP_B(1000)
	COMPLEX*16	CI,FA,FB,STRUCT,F_0,REFRAC
	COMPLEX*16	RCS1,RCP1,RCS2,RCP2,RCS,RCP
	COMPLEX*16	ETA_S,ETA_P
	COMPLEX*16	GA,GA_BAR,GB,GB_BAR,FH,FH_BAR
	COMPLEX*16	psi_h,psi_hbar,psi_0,psi_conj       !laue&perfect
	COMPLEX*16	ctemp,cry_q,cry_z                   !laue&perfect
	COMPLEX*16	br_x1,br_x2,br_delta1,br_delta2     !laue&perfect
	COMPLEX*16	br_c1,br_c2                         !laue&perfect
	REAL*8		CA(3),CB(3),FOA,F1A,F2A,FOB,F1B,F2B
	INTEGER*4	ATNUM_A,ATNUM_B
C
C SAVE the variables that need to be saved across subsequent invocations
C of this subroutine. Note: D_SPACING is not included in the SAVE block
C because it's included in the COMMON.BLK file.
C
	SAVE		I_LATT,RN,
     $			ATNUM_A,ATNUM_B,TEMPER,
     $			GA,GA_BAR,GB,GB_BAR,
     $			CA,CB,
     $			NREFL, ENERGY, FP_A, FPP_A, FP_B, FPP_B
C
	CI	= (0.0D0,1.0D0)
C
C If flag is < 0, reads in the reflectivity data
C
     	IF (KWHAT.LT.0) THEN
#ifdef vms
	  OPEN	(25,FILE=FILE_REFL,STATUS='OLD',READONLY,
     $FORM='FORMATTED')
#else
	  OPEN	(25,FILE=FILE_REFL,STATUS='OLD', FORM='FORMATTED')
#endif
	  READ	(25,*)	I_LATT,RN,D_SPACING
	  READ	(25,*)	ATNUM_A,ATNUM_B,TEMPER
	  READ	(25,*)	GA
	  READ	(25,*)	GA_BAR
	  READ	(25,*)	GB
	  READ	(25,*)	GB_BAR
	  READ	(25,*)	CA(1),CA(2),CA(3)
	  READ	(25,*)	CB(1),CB(2),CB(3)
	  READ	(25,*)	NREFL
	  DO 199 I = 1, NREFL
 	    READ (25,*)	ENERGY(I), FP_A(I), FPP_A(I)
 199	    READ (25,*)	FP_B(I), FPP_B(I)
	  CLOSE	(25)
     	  RETURN
     	ELSE
C
C Computes reflectivities at given wavelength and angle.
C
	PHOT	= Q_PHOT/TWOPI*TOCM
	IF (PHOT.LT.ENERGY(1).OR.PHOT.GT.ENERGY(NREFL)) THEN
 	  CALL	MSSG ('CRYSTAL ',
     $			'Incoming photon energy is out of range.',IERR)
	  R_S	= 0.0D0
	  R_P	= 0.0D0
	  PHASE_S = 0.0D0
	  PHASE_P = 0.0D0
	  THETA_B = 0.0D0
	  RETURN
	END IF	  
C
C Interpolate for the atomic scattering factor.
C
	DO 299 I = 1, NREFL
 299	  IF (ENERGY(I).GT.PHOT)	GO TO 101
C
	I	= NREFL
101	NENER	= I - 1	
	F1A	= FP_A(NENER) + (FP_A(NENER+1) - FP_A(NENER)) * 
     $		  (PHOT - ENERGY(NENER)) / 
     $		      (ENERGY(NENER+1) - ENERGY(NENER))
	F2A	= FPP_A(NENER) + (FPP_A(NENER+1) - FPP_A(NENER)) * 
     $		  (PHOT - ENERGY(NENER)) / 
     $		      (ENERGY(NENER+1) - ENERGY(NENER))
	F1B	= FP_B(NENER) + (FP_B(NENER+1) - FP_B(NENER)) * 
     $		  (PHOT - ENERGY(NENER)) / 
     $		      (ENERGY(NENER+1) - ENERGY(NENER))
	F2B	= FPP_B(NENER) + (FPP_B(NENER+1) - FPP_B(NENER)) * 
     $		  (PHOT - ENERGY(NENER)) / 
     $		      (ENERGY(NENER+1) - ENERGY(NENER))
	R_LAM0 	= TWOPI/Q_PHOT
C
C Calculates the reflection algles and other useful parameters
C
	SIN_ALFA  = SIN(A_BRAGG)
	COS_ALFA  = SQRT(1.0D0-SIN_ALFA**2)
	COS_Q_ANG = SQRT(1.0D0-SIN_Q_ANG**2)
C	Debugging: COSS_Q_REF is passed in the arguments to take into 
C	account the possible crystal movements in the asymmetrical case.
C	COS_Q_REF = COS_Q_ANG + R_LAM0*SIN_ALFA/D_SPACING
	COS_Q_REF = SQRT(1.0D0-SIN_Q_REF**2)
     	IF (COS_Q_REF.GT.1.0) THEN
	  CALL MSSG ('Error in Crystal','cos>1',IERR)
	  R_S	= 0.0D0
	  R_P	= 0.0D0
	  PHASE_S = 0.0D0
	  PHASE_P = 0.0D0
	  GO TO 1122
	END IF
C	SIN_Q_REF = SQRT(1.0D0-COS_Q_REF**2)
     	SIN_GRA	  = R_LAM0/D_SPACING/2.0D0
     	GRAZE	  = ASIN(SIN_GRA)
	ASS_FAC	  = SIN_Q_ANG/SIN_Q_REF
C
C Interpolation
C
	if (f_refrac.eq.1.and.f_mosaic.eq.1) then
	 sin_q   = sin_brg
	else 
	 SIN_Q   = SIN_Q_ANG*COS_ALFA - COS_Q_ANG*SIN_ALFA
	endif
c
c MSR 92/10/24 for the inclined monochromator the above definition of
c sin_q does not work. Set as in Mosaic Laue. To be confirmed
c and check with the Laue case
c
	if (f_refrac.ne.1.and.f_bragg_a.eq.1) sin_q=sin_brg
	RATIO	= abs(SIN_Q/R_LAM0*1.0D-8)
C
C
C
	FOA	= CA(3)*RATIO**2 + CA(2)*RATIO + CA(1)
	FOB	= CB(3)*RATIO**2 + CB(2)*RATIO + CB(1)
	FA	= FOA + F1A + CI*F2A
	FB	= FOB + F1B + CI*F2B
C
C Compute the ABSORPtion coefficient and Fo.
C
	IF (I_LATT.EQ.0) THEN
	  ABSORP = 2.0D0*RN*R_LAM0*(4.0D0*(DIMAG(FA)+DIMAG(FB)))
     	  F_0 = 4*((F1A + ATNUM_A + F1B + ATNUM_B) + CI*(F2A + F2B))
	ELSE IF (I_LATT.EQ.1) THEN
	  ABSORP = 2.0D0*RN*R_LAM0*(4.0D0*(DIMAG(FA)+DIMAG(FB)))
     	  F_0 = 4*((F1A + ATNUM_A + F1B + ATNUM_B) + CI*(F2A + F2B))
	ELSE IF (I_LATT.EQ.2) THEN
	  FB	 = (0.0D0,0.0D0)
	  ABSORP = 2.0D0*RN*R_LAM0*(4.0D0*DIMAG(FA))
     	  F_0 = 4*(F1A + ATNUM_A + CI*F2A)
	ELSE IF (I_LATT.EQ.3) THEN
	  ABSORP = 2.0D0*RN*R_LAM0*(DIMAG(FA)+DIMAG(FB))
     	  F_0 = (F1A + ATNUM_A + F1B + ATNUM_B) + CI*(F2A + F2B)
        ELSE IF (I_LATT.EQ.4) THEN
          FB     = (0.0D0,0.0D0)
          ABSORP = 2.0D0*RN*R_LAM0*(2.0D0*(DIMAG(FA)))
          F_0 = 2*(F1A+ CI*F2A )
        ELSE IF (I_LATT.EQ.5) THEN
          FB     = (0.0D0,0.0D0)
          ABSORP = 2.0D0*RN*R_LAM0*(4.0D0*(DIMAG(FA)))
          F_0 = 4*(F1A + CI*F2A )
	END IF
C	
C FH and FH_BAR are the structure factors for (h,k,l) and (-h,-k,-l).
C
c srio, Added TEMPER here (95/01/19)
	FH 	= ( (GA * FA) + (GB * FB) )*TEMPER
	FH_BAR	= ( (GA_BAR * FA) + (GB_BAR * FB) )*TEMPER
	STRUCT 	= SQRT(FH * FH_BAR) 
C
C computes refractive index.
C
     	REFRAC = (1.0D0,0.0D0) - R_LAM0**2*RN*F_0/TWOPI
	DELTA_REF  = 1.0D0 - DREAL(REFRAC)
C
C THETA_B is the Bragg angle corrected for refraction for sym case,
C following Warren
C
	if (f_refrac.ne.1) then
	THETA_B = R_LAM0/(1-(DELTA_REF/SIN_GRA**2))/2.0D0/D_SPACING
	THETA_B = ASIN(THETA_B)
C
C Now THETA_B is the Bragg angle corrected for refraction for asym case
C following Handbook of SR
C
	if (f_refrac.eq.1) ass_fac = -1.0d0*ass_fac
	THETA_INC_O = 0.5D0*(1.0D0+1.0D0/ASS_FAC)*(THETA_B-GRAZE)
	THETA_B = GRAZE + A_BRAGG + THETA_INC_O   
	else
	  theta_b = graze
	endif
C
        IF (F_MOSAIC.EQ.1) THEN
C
C >>>>>>>>>>>>>>>>>>>> Mosaic crystal calculation <<<<<<<<<<<<<<<<<<<<<<
C
	R_STRUCT = DREAL(STRUCT)
c srio, remove the TEMPER factor from here and placed in FH and FH_BAR
C srio        QS_MOSAIC=(RN*R_STRUCT*TEMPER)**2*R_LAM0**3
        QS_MOSAIC=(RN*R_STRUCT)**2*R_LAM0**3
     $             /SIN(2*(ASIN(SIN_brg)))
        QP_MOSAIC = QS_MOSAIC*(COS(2.0D0*GRAZE))**2
        A_MOSAIC  = THICKNESS*ABSORP/SIN_Q_ANG
        EP        = ASIN(SIN_brg) - THETA_B
        OMEGA =(DEXP(-EP**2/2.0D0/SPREAD_MOS**2))
     $               /SQRT(TWOPI)/SPREAD_MOS
        AAS_MOSAIC = OMEGA*QS_MOSAIC/ABSORP
        AAP_MOSAIC = OMEGA*QP_MOSAIC/ABSORP
*
* Transmission case
*
	if (f_refrac.eq.1) then
	 rs_mosaic = sinh(aas_mosaic*a_mosaic) * 
     $     exp(-a_mosaic*(1+aas_mosaic))
	 rp_mosaic = sinh(aap_mosaic*a_mosaic) * 
     $     exp(-a_mosaic*(1+aap_mosaic))
*
* Reflection case
*
	else 
        RS_MOSAIC = 1+AAS_MOSAIC+(SQRT(1+2*AAS_MOSAIC))/
     $    DTANH(A_MOSAIC*SQRT(1+2*AAS_MOSAIC))
        RP_MOSAIC = 1+AAP_MOSAIC+(SQRT(1+2*AAP_MOSAIC))/
     $    DTANH(A_MOSAIC*SQRT(1+2*AAP_MOSAIC))
        RS_MOSAIC = AAS_MOSAIC / RS_MOSAIC
        RP_MOSAIC = AAP_MOSAIC / RP_MOSAIC
	endif
        R_S     = SQRT(RS_MOSAIC)
        R_P     = SQRT(RP_MOSAIC)
*
* Mean value of depht into the crystal. To be used in MIRROR
*
        DEPHT_MFP_S = 1.0D0 /OMEGA /QS_MOSAIC
        DEPHT_MFP_P = 1.0D0 /OMEGA /QP_MOSAIC
*
*No phase change are introduced by now. (The formulae of reflectivity 
*are already intensity, and no complex coefficient are considered).
*This is not important because a mosaic crystal breaks always coherence
*
        PHASE_S = 0.0D0
        PHASE_P = 0.0D0
        ELSE
C
C >>>>>>>>>>>>>>>>>>>> Perfect crystal calculation <<<<<<<<<<<<<<<<<<<
C
C Main calculation (symmetrical case and asym incident case)
C I change to reflectivity formulae of Zachariasen,
C for a definition of ETA taking into account the angle with
C Bragg planes. MSR 6/28/90
C
C	EP	= -abs(ASIN(SIN_BRG)) + graze ! scalar def      
C	ALPHA_ZAC = -2.0D0*EP*SIN(2*GRAZE)    ! of alpha_zac
C
	ALPHA_ZAC =-((R_LAM0/D_SPACING)**2-2*R_LAM0*
     $SIN_BRG/D_SPACING)
D
D MK's debugging. Don't touch!!
D
D	XXX1 = R_LAM0/D_SPACING
D	XXX2 = XXX1**2
D	XXX3 = 2.0D0*R_LAM0*SIN_BRG
D	XXX4 = XXX3/D_SPACING
D	XXX5 = XXX2 - XXX4
D	ALPHA_ZAC = -XXX5
C
	IF (F_REFRAC.EQ.1) THEN
*
* Transmission (Laue) case and general Reflection (Bragg) case
* NB: The general Bragg case is commented (cc). It is not yet being
* used. We still use the Thick Crystal Approximation case.
*
C
C   PSI_CONJ = F*( note: PSI_HBAR is PSI at -H position and is
C   proportional to fh_bar but PSI_CONJ is complex conjugate os PSI_H) 
C
C   This part has been written by G.J. Chen and M. Sanchez del Rio. 
C   We use the formula [3.130] of Zachariasen's book.
C
	gamma_0 = -1.0D0*sin_q_ang
	gamma_h = -1.0D0*sin_q_ref
	sin_brg   = -1.0D0*sin_brg

	if (f_refrac.eq.0) gamma_h = - gamma_h
	cry_b = gamma_0/gamma_h

	cry_t = 0.5D0*(-1.D0/abs(gamma_0) +1.D0/abs(gamma_h))*thickness 
	cry_a = pi/r_lam0*(thickness/gamma_0)
	cry_alpha = -((r_lam0/d_spacing)**2+2D0*r_lam0*
     $sin_brg/d_spacing)

	psi_h = rn*r_lam0**2/pi*fh
	psi_hbar = rn*r_lam0**2/pi*fh_bar
	psi_0 = rn*r_lam0**2/pi*f_0
	psi_conj = rn*r_lam0**2/pi*dconjg(fh)

	cry_q = cry_b*psi_h*psi_hbar
	cry_z = (1.0D0-cry_b)*0.50D0*psi_0 + cry_b*0.50D0*cry_alpha

c
c s-polarization
c
	ctemp = cdsqrt(cry_q  + cry_z**2)
	br_x1 = (-1.0d0*cry_z+ctemp)/psi_hbar
	br_x2 = (-1.0d0*cry_z-ctemp)/psi_hbar
	br_delta1 = 0.5d0*(psi_0-cry_z+ctemp)
	br_delta2 = 0.5d0*(psi_0-cry_z-ctemp)
	br_c1 = -1.d0*ci*thickness*twopi/(-1.0D0*abs(gamma_0))/r_lam0*
     $          br_delta1
	br_c2 = -1.d0*ci*thickness*twopi/(-1.0D0*abs(gamma_0))/r_lam0*
     $          br_delta2
c
c a very big exponential produces numerical overflow. If so, the value
c is changed artificially to avoid the overflow. This is equivalent to 
c use the thick crystal approximation
C changed 700 -> 100 as per MSR.  3/24/95
c
	if (dreal(br_c1).gt.100.or.dreal(br_c2).gt.100) then 
	  if (dreal(br_c1).gt.100) br_c1 = 100.0d0+ci*dimag(br_c1)
	  if (dreal(br_c2).gt.100) br_c2 = 100.0d0+ci*dimag(br_c2)
	endif

	br_c1 = cdexp(br_c1)
	br_c2 = cdexp(br_c2)

cc	if (f_refrac.eq.1) then 
	  rcs = br_x1*br_x2*(br_c1-br_c2)/(br_x2-br_x1)             ! laue
cc	else if (f_refrac.eq.0) then
cc	  rcs = br_x1*br_x2*(br_c1-br_c2)/(br_c2*br_x2-br_c1*br_x1) ! bragg
cc	endif
c
c	r_s = (1.0d0/abs(cry_b))*rcs*dconjg(rcs)
	r_s1 = sqrt((1.0d0/abs(cry_b))*rcs*dconjg(rcs))
	rcs = rcs/sqrt(abs(cry_b))
c
c p-polarization
c
	c_ppol = abs(cos(torad*2.0d0*graze))

	ctemp = cdsqrt(cry_q*c_ppol**2  + cry_z**2)
	br_x1 = (-1.0d0*cry_z+ctemp)/(psi_hbar*c_ppol)
	br_x2 = (-1.0d0*cry_z-ctemp)/(psi_hbar*c_ppol)
	br_delta1 = 0.5d0*(psi_0-cry_z+ctemp)
	br_delta2 = 0.5d0*(psi_0-cry_z-ctemp)
	br_c1 = -1.0d0*ci*thickness*twopi/(-1.0d0*abs(gamma_0))/r_lam0*
     $          br_delta1
	br_c2 = -1.0d0*ci*thickness*twopi/(-1.0d0*abs(gamma_0))/r_lam0*
     $          br_delta2
c
c a very big exponential produces numerical overflow. If so the value
c is changed to avoid the overflow. This is equivalent to the thick
c crystal approximation
C changed 700 -> 100 as per MSR.  3/24/95
c
	if (dreal(br_c1).gt.100.or.dreal(br_c2).gt.100) then 
	  if (dreal(br_c1).gt.100) br_c1 = 100.0d0+ci*dimag(br_c1)
	  if (dreal(br_c2).gt.100) br_c2 = 100.0d0+ci*dimag(br_c2)
	endif

	br_c1 = cdexp(br_c1)
	br_c2 = cdexp(br_c2)

cc	if (f_refrac.eq.1) then
	  rcp = br_x1*br_x2*(br_c1-br_c2)/(br_x2-br_x1)             ! laue
cc	else if (f_refrac.eq.0) then
cc	  rcp = br_x1*br_x2*(br_c1-br_c2)/(br_c2*br_x2-br_c1*br_x1) ! bragg
cc	endif
c
c	r_p = (1.0d0/abs(cry_b))*rcp*dconjg(rcp)
	r_p1 = sqrt( (1.0d0/abs(cry_b))*rcp*dconjg(rcp) )
	rcp = rcp/dsqrt(abs(cry_b))

	ELSE IF (F_REFRAC.EQ.0) THEN
*
* Reflection case
*
	GAMMA = RN*R_LAM0**2/PI
	ETA_S = -0.5D0*ASS_FAC*ALPHA_ZAC+0.5D0*GAMMA*F_0*(1.D0+ASS_FAC)
	ETA_S = ETA_S/(GAMMA*SQRT(ASS_FAC)*STRUCT)
	ETA_P = ETA_S/(ABS(COS_Q_ANG*COS_Q_REF-SIN_Q_ANG*SIN_Q_REF))
	RCS1= ETA_S+SQRT(ETA_S**2-1)
	RCP1= ETA_P+SQRT(ETA_P**2-1)
	RCS2= ETA_S-SQRT(ETA_S**2-1)
	RCP2= ETA_P-SQRT(ETA_P**2-1)
	  IF (((CDABS(RCS1))**2).LE.1) THEN
	    RCS	= RCS1
	  ELSE 
	    RCS	= RCS2
	  END IF
	  RCS	= RCS*SQRT(FH/FH_BAR)
	  IF (((CDABS(RCP1))**2).LE.1) THEN
	    RCP	= RCP1
	  ELSE 
	    RCP	= RCP2
	  END IF
	  RCP	= RCP*SQRT(FH/FH_BAR)
	ENDIF

	  IF (GRAZE.GT.45*TORAD) 	RCP = -RCP

	R_S	= CDABS(RCS)
	PP	= DREAL(RCS)
	QQ	= DIMAG(RCS)
	CALL	ATAN_2	(QQ,PP,PHASE_S)
	R_P	= CDABS(RCP)
	PP	= DREAL(RCP)
	QQ	= DIMAG(RCP)
	CALL	ATAN_2	(QQ,PP,PHASE_P)

	END IF
1122   	RETURN
	END IF
     	END
