C +++
C
C Source: src/tools/tek-graphics/set_screen.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: set_screen.F
C Revision 1.3  1991/04/22  00:06:47  khan
C Fixed #include quotes
C
C Revision 1.2  1991/03/25  14:45:59  khan
C SUN port -- INCLUDE -> #include
C
C Revision 1.1  90/11/01  11:24:11  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

#ifndef vms
	subroutine set_screen ()
	return
	end

#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'

C+++
C	SUBROUTINE	SET_SCREEN
C
C	PURPOSE		To set various types of terminal into :
C			(a) TEK mode, if INTRY=-1, ITERM from calling program
C			(b) TEK mode, if IENTRY=0, ITERM from this subroutine
C			(c) ANSI mode, if IENTRY=1, ITERM from calling program
C
C
C !!! NOTE: ONLY USED FOR SHADOW/VMS !!!
C
C---
	SUBROUTINE	SET_SCREEN	(PROMPT,IENTRY,ITERM)
	CHARACTER*(*)	PROMPT
	CHARACTER*80	TEXT
     	CHARACTER*6	ESC220
	CHARACTER*14	ESCTON4107
	CHARACTER*8	ESCTOFF4107
	CHARACTER*2	ESCANSI
C	DATA	ESCMIME	/27,91,50,74,27,49,27,42/
C
C Define all the escape sequences.
C
     	ESC220 (1:1) =  CHAR(27)
     	ESC220 (2:2) =  CHAR(91)
     	ESC220 (3:3) =  CHAR(63)
     	ESC220 (4:4) =  CHAR(51)
     	ESC220 (5:5) =  CHAR(56)
     	ESC220 (6:6) =  CHAR(104)
	ESCANSI(1:1) =  CHAR(27)
	ESCANSI(2:2) =  CHAR(50)
	ESCTON4107(1:1)	= CHAR(27)		! Select TEK mode
	ESCTON4107(2:2)	= CHAR(37)		! 
	ESCTON4107(3:3)	= CHAR(33)		!
	ESCTON4107(4:4)	= CHAR(48)		!
	ESCTON4107(5:5)	= CHAR(27)		! Disable dialog area
	ESCTON4107(6:6)	= CHAR(75)		!
	ESCTON4107(7:7)	= CHAR(65)		!
	ESCTON4107(8:8)	= CHAR(48)		!
	ESCTON4107(9:9)	= CHAR(27)		! Set color mode
	ESCTON4107(10:10) = CHAR(84)		!
	ESCTON4107(11:11) = CHAR(77)		!
	ESCTON4107(12:12) = CHAR(51)		!
	ESCTON4107(13:13) = CHAR(51)		!
	ESCTON4107(14:14) = CHAR(49)		!
	ESCTOFF4107(1:1) = CHAR(27)		! Select ANSI mode
	ESCTOFF4107(2:2) = CHAR(37)		!
	ESCTOFF4107(3:3) = CHAR(33)		!
	ESCTOFF4107(4:4) = CHAR(49)		!
	ESCTOFF4107(5:5) = CHAR(27)		! Enable dialog area
	ESCTOFF4107(6:6) = CHAR(75)		!
	ESCTOFF4107(7:7) = CHAR(65)		!
	ESCTOFF4107(8:8) = CHAR(49)		!
	IF (IENTRY.EQ.1) GO TO 100
C
C Inquire the type of terminal.
C
	IF (IENTRY.EQ.0) THEN
	  TEXT	= PROMPT//' Terminal type:
     $ [ 0 ] VT240, [ 1 ] TEK 40xx, [ 2 ] HIREZ, [ 3 ] TEK 4107 : '
	  ITERM = IRINT (TEXT)
	END IF
C  
C Write the appropriate <ESC> sequence.
C
	IF (ITERM.EQ.0) THEN
	  WRITE (6,1111) ESC220
	ELSE IF (ITERM.EQ.3) THEN
	  WRITE (6,1111) ESCTON4107
	END IF
1111	FORMAT  (1X,A,$)
	RETURN
C
C Return the terminal to ANSI mode.
C
100	CONTINUE
	IF (ITERM.EQ.2) THEN
	 WRITE (6,1111) ESCANSI
	ELSE IF (ITERM.EQ.3) THEN
	 WRITE (6,1111) ESCTOFF4107
	END IF
	RETURN
	END

#endif
