/*****************************************************************************
 *                                                                           *
 *  PRIMVS - Graphic Interpreter for X-Ray Lithography
 *                                                                           *
 ***************************************************************************** 
 *
 *  Author:   Luigi Capodieci
 *  Project:  PLPLOT based graphic interpreter
 *
 *  $Source: 
 *  $Revision:
 *  $Date: 
 *  $Log: parser.c,v $
 *  Revision 1.1.1.1  1996/07/11 13:52:45  khan
 *  Initial checkin of SHADOW 2.1 distribution sources
 *
 * Revision 1.1.1.1  1996/01/02  17:07:39  khan
 * Toolset 2.0 release
 *
 *****************************************************************************/ 

/* PARSER core for PLPLOT based Graphic Language */

/*****************************************************************************/ 

#include "allinclude.h"

/*** GLOBAL VARIABLES ********************************************************/ 

token_type	curr_token;
int		get_next_lex;

/*** TEMPORARY VALUES ********************************************************/


/*** Variables for REGIONP,REGIONM,XYRANGE,REGIONR ***/
double		temp_xmin,temp_xmax,temp_ymin,temp_ymax;
double		temp_ratio;

/*** Variables for XYZRANGE ***/
double		temp_zmin,temp_zmax;

/*** Variables for VIEWBOX, VIEW ***/
double		temp_basex,temp_basey,temp_height;
double		temp_alt,temp_azi;

/*** Variables for PLOT3D ***/
int		temp_opt3d;

/*** Variables for INITPAGE,INITMULTIPAGE ***/
char		temp_device_name[MAX_WORD_LENGTH];
int		temp_cnx,temp_cny;
FILE		*graphfile;
char		graph_filename[MAX_WORD_LENGTH]="primvs.out";
int		temp_orientation=LANDSCAPE;

/*** Variables for SUBPAGE ***/
int		temp_subpage;

/*** Variables for BOX ***/
char		temp_xoptions[MAX_WORD_LENGTH];
char		temp_yoptions[MAX_WORD_LENGTH];
double		temp_xtickint,temp_ytickint;
int		temp_xticksub,temp_yticksub;

/*** Variables for BOX3D ***/
char		temp_zoptions[MAX_WORD_LENGTH];
double		temp_ztickint;

/*** Variables for COLOR ***/
int		temp_color;

/*** Variables for LABEL ***/
char		temp_xlabel[MAX_WORD_LENGTH];
char		temp_ylabel[MAX_WORD_LENGTH];
char		temp_tlabel[MAX_WORD_LENGTH];

/*** Variables for LABEL3D ***/
char		temp_zlabel[MAX_WORD_LENGTH];

/*** Variables for LINESTYLE,LINEWIDTH ***/
int		temp_linestyle;
int		temp_linewidth;

/*** Variables for RESOLUTION ***/
float		temp_resol;

/*** Variables for SYMBOL ***/
int		temp_symbol;

/*** Variables for LINE ***/
double		temp_x1,temp_y1,temp_x2,temp_y2;

/*** Variables for FORMAT, FORMAT3D ***/
int		temp_xcol;
int		temp_ycol;
int		temp_zcol;
int		temp_ccol;
int		temp_bnp,temp_fnp;

/*** Variables for TEXT, GTEXT ***/
char		temp_side[MAX_WORD_LENGTH];
double		temp_ref_ypos,temp_ref_xpos,temp_ref_just;
char		temp_text[MAX_WORD_LENGTH];

double		temp_txpos,temp_typos,temp_tdxpos,temp_tdypos;

/*** Variables for SCALECHR, SCALESYM ***/
double		temp_scalechr;
double		temp_scalesym;

/*** Variables for PLOTGREY, PLOTCOLOR ***/
int		temp_dataformat;

/*** Variables for AUTOSCALE ***/
int		scaleflag=FALSE;

/*** Variables for PLOTCONT ***/
int		temp_nlevel;

/*** Variables for SYSTEM ***/
char		temp_unixcmd[MAX_WORD_LENGTH];

/*** Variables for CIRCLE,PARCIRCLE,WAFER ***/
double		temp_xc,temp_yc,temp_radius;
double		temp_arc;
int		temp_wafertype;

/*** Variables for MAGNIVECT ***/
double		temp_magx,temp_magy;

/*** Variables for MARK ***/
double		temp_xm,temp_ym;
int		temp_mark;

/*** FLAGS *******************************************************************/
int		parse_error;
int		atcommand;
int		ccol_flag;
int		xcol_flag;
int		ycol_flag;
int		bnp_flag,fnp_flag,endformat;

int		style_flag,ranges_flag;

/*** Parser MACROS ***********************************************************/

#define		next_token	if (get_next_lex) curr_token=lexical()
#define		check_openpar	(curr_token != OPENPAR) {parse_error=TRUE;error_msg("Open parenthesis expected");}
#define		check_closepar  (curr_token != CLOSEPAR) {parse_error=TRUE;error_msg("Missing closed parenthesis");}
#define		check_comma 	(curr_token != COMMA) {parse_error=TRUE;error_msg("Comma expected");}
#define		check_colon 	(curr_token != COLON) {parse_error=TRUE;error_msg("Colon expected");}

/*****************************************************************************
*
*  Utilities for the PLOTL,PLOTP command
*
******************************************************************************/ 

int	checkranges()

/* { return(FALSE); } */

{
	ranges_flag=FALSE;
	next_token;
	if (curr_token == CLOSEPAR) {
		get_next_lex=FALSE;
		return(FALSE);
		}
	if (curr_token == COMMA) next_token;
	if (curr_token != OPENSQUARE) {
		  parse_error=TRUE;
		  error_msg("Open square bracket expected");
		  }
		 else {
		  get_next_lex=TRUE;
		  next_token;
		  if (curr_token != NUMBER) {
		    parse_error=TRUE;
		    error_msg("Missing XMIN position");
		    }
		   else {
		    temp_xmin = (double) lex_number;
		    next_token;
		    if (curr_token != COMMA) {
		      parse_error=TRUE;
		      error_msg("Comma expected");
		      }
		     else {
		      next_token;	
		      if (curr_token != NUMBER) {
		        parse_error=TRUE;
		        error_msg("Missing XMAX position");
		        }
		       else {
		        temp_xmax = (double) lex_number;
		        next_token;
		        if (curr_token != COMMA) {
		          parse_error=TRUE;
		          error_msg("Comma expected");
		          }
		         else {
		          next_token;
		          if (curr_token != NUMBER) {
		            parse_error=TRUE;
		            error_msg("Missing YMIN position");
		            }
		           else {
		            temp_ymin = (double) lex_number;
		            next_token;
		            if (curr_token != COMMA) {
		              parse_error=TRUE;
		              error_msg("Comma expected");
		              }
		             else {
		              next_token;	
		              if (curr_token != NUMBER) {
		                parse_error=TRUE;
		                error_msg("Missing YMAX position");
		                }
		               else {
		                temp_ymax = (double) lex_number;
		                next_token;
			        if (curr_token != CLOSESQUARE) {
			          parse_error=TRUE;
		                  error_msg("Missing closed square brackett");
			          }
			        }
			      }
			    }
		          }
		        }
		      }
		     }
		   }

		if (!parse_error) 
			return(TRUE);
		  else
			return(FALSE);

}


/*****************************************************************************/ 

int	checkfunction()
{
next_token;
if (curr_token != STRING) {
	parse_error=TRUE;
	error_msg("Missing function");
	return(FALSE);
	}
  else {
	get_next_lex=TRUE;
	return(TRUE);
	}
}


void	setfunction()
{
	if (lex_buffer[0]=='\0') {
	   if (datain) return;
	   parse_error=TRUE;
	   error_msg("Empty function filename");
	   return;
	   }
	 else {
	  strcpy(function_filename,lex_buffer);
	  datain=FALSE;
	  }

/*** Open the file that contains the function to be plotted *****************/

        if ((functionfile=fopen(function_filename,"r")) == NULL) {
		parse_error=TRUE;
                error_msg("Cannot find function file");
                return;
                }

return;
}

/*****************************************************************************/ 

int	checkstyle()
{
	style_flag=FALSE;
	next_token;
	if (curr_token == COMMA) {
		next_token;
		if (curr_token == NUMBER) {
			temp_linestyle=(int) floor(lex_number);
			return(TRUE);
			}
		if (curr_token == OPENSQUARE) {
			get_next_lex=FALSE;
			return(FALSE);
			}
  	   	   else {
		  	parse_error=TRUE;
			error_msg("Missing closed parenthesis");
			return(FALSE);
			}
		}
	   else {
		get_next_lex=FALSE;
		return(FALSE);
		}
}


/*****************************************************************************/ 

int	checkend()
{
	next_token;
	if (curr_token != SEMICOLON) 
		return(FALSE);
	  else
		return(TRUE);
}

/*****************************************************************************
*
*   SYNTACTICAL ANALYSIS
*
******************************************************************************/ 

void interpret()

{

/*** Local variables (used for recursion in AT command) ***/
char	command_filename[MAX_WORD_LENGTH];
FILE	*commandfile,*rinfile;
int	i;
int	atline;


/*** Start parsing a new command: get the first token ***/

get_next_lex=TRUE;
prompt();
/* if (get_next_lex) curr_token = lexical();*/
next_token;

switch(curr_token) {


/*** INITIALIZATION commands **********************************************
 *
 * initpage(device-name {,"<graph_filename>"})  
 *
 * initmultipage(pages-on-x,pages-on-y,device-name {,"<graph_filename>"})
 *
 *************************************************************************/

	case INITPAGE: {
		parse_error=FALSE;
		next_token;
		if (curr_token != OPENPAR) {
			parse_error=TRUE;
			error_msg("Open parenthesis expected");
			}
		  else {
		   next_token;
		   if (curr_token != DEVICE) {
		     parse_error=TRUE;
		     error_msg("Not a device");
		     }
		    else {
		     next_token;
		     if ((curr_token == COMMA)&&
		         (((strcmp(temp_device_name,C_PS))==0)||
		          ((strcmp(temp_device_name,C_XFIG))==0)||
		          ((strcmp(temp_device_name,C_TEKF))==0))) {
			next_token;
			if (curr_token != STRING) {
		   	  parse_error=TRUE;
			  error_msg("Missing graph filename");
			  }
			 else {
			     strcpy(graph_filename,lex_buffer);
			     next_token;
			    }
			   }
		     if check_closepar
			  }
		     }
		if (!parse_error) exec_initpage();
		  else {
			error_msg_nl("Error in INITPAGE command");
			flushcommand();
			}
		flushcommand();
		break;
		}
		
/*************************************************************************/
			
	case INITMULTIPAGE: {
		parse_error=FALSE;
		next_token;
		if (curr_token != OPENPAR) {
		  parse_error=TRUE;
		  error_msg("Open parenthesis expected");
		  }
		 else {
		  next_token;
		  if (curr_token != NUMBER) {
		    parse_error=TRUE;
		    error_msg("Missing X subpages");
		    }
		   else {
		    temp_cnx = (int) floor(lex_number);
		    next_token;
		    if (curr_token != COMMA) {
		      parse_error=TRUE;
		      error_msg("Comma expected");
		      }
		     else {
		      next_token;	
		      if (curr_token != NUMBER) {
		        parse_error=TRUE;
		        error_msg("Missing Y subpages");
		        }
		       else {
		        temp_cny = (int) floor(lex_number);
		        next_token;
		        if (curr_token != COMMA) {
		          parse_error=TRUE;
		          error_msg("Comma expected");
		          }
		         else {
			  next_token;
			  if (curr_token != DEVICE) {
			    parse_error=TRUE;
			    error_msg("Not a device");
			    }
			   else {
			    next_token;
		            if ((curr_token == COMMA)&&
		                (((strcmp(temp_device_name,C_PS))==0)||
		                ((strcmp(temp_device_name,C_XFIG))==0)||
		                ((strcmp(temp_device_name,C_TEKF))==0))) {
			      next_token;
			      if (curr_token != STRING) {
		   	         parse_error=TRUE;
			         error_msg("Missing graph filename");
			         }
			        else {
			         strcpy(graph_filename,lex_buffer);
			         next_token;
			         }
			        }
			    if check_closepar
		               }
		              }
			     }
			    }
			   }
			  }
		if (!parse_error) exec_initmultipage();
		  else {
			error_msg_nl("Error in INITMULTIPAGE command");
			flushcommand();
			}
		flushcommand();
		break;
	}

/**************************************************************************
*
* subpage(<subpage_number>)
*
**************************************************************************/
	
	case SUBPAGE: {
		parse_error=FALSE;
		next_token;
		if check_openpar
		  else {
		   next_token;
		   if (curr_token != NUMBER) {
			parse_error=TRUE;
			error_msg("Missing subpage number");
			}
		    else {
			temp_subpage=(int) floor(lex_number);
		        next_token;
			if check_closepar
			}
		    }
		if (!parse_error) exec_subpage();
		  else {
			error_msg_nl("Error in SUBPAGE command");
			flushcommand();
			}
		flushcommand();
		break;
		}	


/**************************************************************************
*
* orientation(<an_orientation>)  [landscape or portrait]
*
**************************************************************************/
	
	case ORIENTATION: {
		parse_error=FALSE;
		next_token;
		if check_openpar
		  else {
		   next_token;
		   if (curr_token != ANORIENTATION) {
			parse_error=TRUE;
			error_msg("Missing orientation [landscape/portrait]");
			}
		    else {
			temp_orientation = (int) floor(lex_number);
		        next_token;
			if check_closepar
			}
		    }
		if (!parse_error) exec_orientation();
		  else {
			error_msg_nl("Error in ORIENTATION command");
			flushcommand();
			}
		flushcommand();
		break;
		}	


/*** REGION ***************************************************************
 *
 * regionp(pposxmin,pposymin,pposxmax,pposymax)
 * [positions are in percentage 0.0 to 1.0 relative to the page size]
 *
 * regionm(mposxmin,mposymin,mposxmax,mposymax)
 * [positions are in millimiter (absolute positioning)]
 *
 *************************************************************************/

	case REGIONP: {
		parse_error=FALSE;
		next_token;
		if (curr_token != OPENPAR) {
		  parse_error=TRUE;
		  error_msg("Open parenthesis expected");
		  }
		 else {
		  next_token;
		  if (curr_token != NUMBER) {
		    parse_error=TRUE;
		    error_msg("Missing XMIN position");
		    }
		   else {
		    temp_xmin = (double) lex_number;
		    next_token;
		    if (curr_token != COMMA) {
		      parse_error=TRUE;
		      error_msg("Comma expected");
		      }
		     else {
		      next_token;	
		      if (curr_token != NUMBER) {
		        parse_error=TRUE;
		        error_msg("Missing YMIN position");
		        }
		       else {
		        temp_ymin = (double) lex_number;
		        next_token;
		        if (curr_token != COMMA) {
		          parse_error=TRUE;
		          error_msg("Comma expected");
		          }
		         else {
		          next_token;
		          if (curr_token != NUMBER) {
		            parse_error=TRUE;
		            error_msg("Missing XMAX position");
		            }
		           else {
		            temp_xmax = (double) lex_number;
		            next_token;
		            if (curr_token != COMMA) {
		              parse_error=TRUE;
		              error_msg("Comma expected");
		              }
		             else {
		              next_token;	
		              if (curr_token != NUMBER) {
		                parse_error=TRUE;
		                error_msg("Missing YMAX position");
		                }
		               else {
		                temp_ymax = (double) lex_number;
		                next_token;
			        if (curr_token != CLOSEPAR) {
			          parse_error=TRUE;
		                  error_msg("Missing closed parenthesis");
			          }
			        }
			      }
			    }
		          }
		        }
		      }
		     }
		   }
		if (!parse_error) exec_regionp();
		  else {
			error_msg_nl("Error in REGIONP command");
			flushcommand();
			}
		flushcommand();
		break;
	}

/*** REGIONM **************************************************************/

	case REGIONM: {
		parse_error=FALSE;
		next_token;
		if (curr_token != OPENPAR) {
		  parse_error=TRUE;
		  error_msg("Open parenthesis expected");
		  }
		 else {
		  next_token;
		  if (curr_token != NUMBER) {
		    parse_error=TRUE;
		    error_msg("Missing XMIN position");
		    }
		   else {
		    temp_xmin = (double) lex_number;
		    next_token;
		    if (curr_token != COMMA) {
		      parse_error=TRUE;
		      error_msg("Comma expected");
		      }
		     else {
		      next_token;	
		      if (curr_token != NUMBER) {
		        parse_error=TRUE;
		        error_msg("Missing YMIN position");
		        }
		       else {
		        temp_ymin = (double) lex_number;
		        next_token;
		        if (curr_token != COMMA) {
		          parse_error=TRUE;
		          error_msg("Comma expected");
		          }
		         else {
		          next_token;
		          if (curr_token != NUMBER) {
		            parse_error=TRUE;
		            error_msg("Missing XMAX position");
		            }
		           else {
		            temp_xmax = (double) lex_number;
		            next_token;
		            if (curr_token != COMMA) {
		              parse_error=TRUE;
		              error_msg("Comma expected");
		              }
		             else {
		              next_token;	
		              if (curr_token != NUMBER) {
		                parse_error=TRUE;
		                error_msg("Missing YMAX position");
		                }
		               else {
		                temp_ymax = (double) lex_number;
		                next_token;
			        if (curr_token != CLOSEPAR) {
			          parse_error=TRUE;
		                  error_msg("Missing closed parenthesis");
			          }
			        }
			      }
			    }
		          }
		        }
		      }
		     }
		   }
		if (!parse_error) exec_regionm();
		  else {
			error_msg_nl("Error in REGIONM command");
			flushcommand();
			}
		flushcommand();
		break;
	}


/*** REGIONR **************************************************************/

	case REGIONR: {
		parse_error=FALSE;
		next_token;
		if (curr_token != OPENPAR) {
		  parse_error=TRUE;
		  error_msg("Open parenthesis expected");
		  }
		 else {
		  next_token;
		  if (curr_token != NUMBER) {
		    parse_error=TRUE;
		    error_msg("Missing XMIN position");
		    }
		   else {
		    temp_xmin = (double) lex_number;
		    next_token;
		    if (curr_token != COMMA) {
		      parse_error=TRUE;
		      error_msg("Comma expected");
		      }
		     else {
		      next_token;	
		      if (curr_token != NUMBER) {
		        parse_error=TRUE;
		        error_msg("Missing YMIN position");
		        }
		       else {
		        temp_ymin = (double) lex_number;
		        next_token;
		        if (curr_token != COMMA) {
		          parse_error=TRUE;
		          error_msg("Comma expected");
		          }
		         else {
		          next_token;
		          if (curr_token != NUMBER) {
		            parse_error=TRUE;
		            error_msg("Missing XMAX position");
		            }
		           else {
		            temp_xmax = (double) lex_number;
		            next_token;
		            if (curr_token != COMMA) {
		              parse_error=TRUE;
		              error_msg("Comma expected");
		              }
		             else {
		              next_token;	
		              if (curr_token != NUMBER) {
		                parse_error=TRUE;
		                error_msg("Missing YMAX position");
		                }
		               else {
		                temp_ymax = (double) lex_number;
		                next_token;
				if check_comma 
				 else {
				  next_token;
				  if (curr_token != NUMBER) {
				     parse_error=TRUE;
				     error_msg("Missing RATIO value");
				     }
				    else {
		                     temp_ratio = (double) lex_number;
		                     next_token;
			             if (curr_token != CLOSEPAR) {
			              parse_error=TRUE;
		                      error_msg("Missing closed parenthesis");
			              }
				    }
				 }
			        }
			      }
			    }
		          }
		        }
		      }
		     }
		   }
		if (!parse_error) exec_regionr();
		  else {
			error_msg_nl("Error in REGIONR command");
			flushcommand();
			}
		flushcommand();
		break;
	}

/*** XYRANGE **************************************************************
 *
 * xyrange (xmin,xmax,ymin,ymax)
 *
 *************************************************************************/

	case XYRANGE: {
		parse_error=FALSE;
		next_token;
		if (curr_token != OPENPAR) {
		  parse_error=TRUE;
		  error_msg("Open parenthesis expected");
		  }
		 else {
		  next_token;
		  if (curr_token != NUMBER) {
		    parse_error=TRUE;
		    error_msg("Missing XMIN value");
		    }
		   else {
		    temp_xmin = (double) lex_number;
		    next_token;
		    if (curr_token != COMMA) {
		      parse_error=TRUE;
		      error_msg("Comma expected");
		      }
		     else {
		      next_token;	
		      if (curr_token != NUMBER) {
		        parse_error=TRUE;
		        error_msg("Missing XMAX value");
		        }
		       else {
		        temp_xmax = (double) lex_number;
		        next_token;
		        if (curr_token != COMMA) {
		          parse_error=TRUE;
		          error_msg("Comma expected");
		          }
		         else {
		          next_token;
		          if (curr_token != NUMBER) {
		            parse_error=TRUE;
		            error_msg("Missing YMIN value");
		            }
		           else {
		            temp_ymin = (double) lex_number;
		            next_token;
		            if (curr_token != COMMA) {
		              parse_error=TRUE;
		              error_msg("Comma expected");
		              }
		             else {
		              next_token;	
		              if (curr_token != NUMBER) {
		                parse_error=TRUE;
		                error_msg("Missing YMAX value");
		                }
		               else {
		                temp_ymax = (double) lex_number;
		                next_token;
			        if (curr_token != CLOSEPAR) {
			          parse_error=TRUE;
		                  error_msg("Missing closed parenthesis");
			          }
			        }
			      }
			    }
		          }
		        }
		      }
		     }
		   }
		if (!parse_error) exec_xyrange();
		  else {
			error_msg_nl("Error in XYRANGE command");
			flushcommand();
			}
		flushcommand();
		break;
	}

/*** XYZRANGE *************************************************************
 *
 * xyzrange (xmin,xmax,ymin,ymax,zmin,zmax)
 *
 *************************************************************************/

	case XYZRANGE: {
		parse_error=FALSE;
		next_token;
		if (curr_token != OPENPAR) {
		  parse_error=TRUE;
		  error_msg("Open parenthesis expected");
		  }
		 else {
		  next_token;
		  if (curr_token != NUMBER) {
		    parse_error=TRUE;
		    error_msg("Missing XMIN position");
		    }
		   else {
		    temp_xmin = (double) lex_number;
		    next_token;
		    if (curr_token != COMMA) {
		      parse_error=TRUE;
		      error_msg("Comma expected");
		      }
		     else {
		      next_token;	
		      if (curr_token != NUMBER) {
		        parse_error=TRUE;
		        error_msg("Missing XMAX position");
		        }
		       else {
		        temp_xmax = (double) lex_number;
		        next_token;
		        if (curr_token != COMMA) {
		          parse_error=TRUE;
		          error_msg("Comma expected");
		          }
		         else {
		          next_token;
		          if (curr_token != NUMBER) {
		            parse_error=TRUE;
		            error_msg("Missing YMIN position");
		            }
		           else {
		            temp_ymin = (double) lex_number;
		            next_token;
		            if (curr_token != COMMA) {
		              parse_error=TRUE;
		              error_msg("Comma expected");
		              }
		             else {
		              next_token;	
		              if (curr_token != NUMBER) {
		                parse_error=TRUE;
		                error_msg("Missing YMAX position");
		                }
		               else {
		                temp_ymax = (double) lex_number;
		                next_token;
				if check_comma
		 		 else {
		  		   next_token;
		  		   if (curr_token != NUMBER) {
		    		     parse_error=TRUE;
		    		     error_msg("Missing ZMIN position");
		    		     }
		   		    else {
		    		     temp_zmin = (double) lex_number;
		                     next_token;
				     if check_comma
		     		      else {
		     		       next_token;	
		                       if (curr_token != NUMBER) {
		                         parse_error=TRUE;
		         		 error_msg("Missing ZMAX position");
		                         }
		       		        else {
		            		 temp_zmax = (double) lex_number;
		                         next_token;
			                 if (curr_token != CLOSEPAR) {
			                  parse_error=TRUE;
		                          error_msg("Missing closed parenthesis");
					  }
					 }
					}
				      }
			          }
			        }
			      }
			    }
		          }
		        }
		      }
		     }
		   }
		if (!parse_error) exec_xyzrange();
		  else {
			error_msg_nl("Error in XYZRANGE command");
			flushcommand();
			}
		flushcommand();
		break;
	}


/**************************************************************************
*
* viewbox(<basex>,<basey>,<height>)
*
**************************************************************************/

	case VIEWBOX: {
		parse_error=FALSE;	
		next_token;
		if check_openpar
		  else {
		   next_token;
		   if (curr_token != NUMBER) {
		      parse_error=TRUE;
		      error_msg("Missing BASE X");
		      }
		     else {
		      temp_basex = (double) lex_number;
		      next_token;
		      if check_comma
		        else {
			 next_token;
			 if (curr_token != NUMBER) {
			    parse_error=TRUE;
			    error_msg("Missing BASE Y");
			    }
			   else {
			    temp_basey = (double) lex_number;
			    next_token;
			    if check_comma
			      else {
				next_token;
				if (curr_token != NUMBER) {
				   parse_error=TRUE;
				   error_msg("Missing HEIGHT");
				   }
				  else {
				   temp_height = (double) lex_number;
				   next_token;
				   if check_closepar
				   }
				}
			     }
			   }
		    	 }
		      }
	    	if (!parse_error) exec_viewbox();
	      	  else {
			error_msg_nl("Error in VIEWBOX command");
			flushcommand();
			}
		flushcommand();
		break;
	} 
				        

/**************************************************************************
*
* view(<altitude>,<azimut>)
*
**************************************************************************/

	case VIEW: {
		parse_error=FALSE;	
		next_token;
		if check_openpar
		  else {
		   next_token;
		   if (curr_token != NUMBER) {
		      parse_error=TRUE;
		      error_msg("Missing ALTITUDE");
		      }
		     else {
		      temp_alt = (double) lex_number;
		      next_token;
		      if check_comma
		        else {
			 next_token;
			 if (curr_token != NUMBER) {
			    parse_error=TRUE;
			    error_msg("Missing AZIMUT");
			    }
			   else {
			    temp_azi = (double) lex_number;
			    next_token;
			    if check_closepar
			    }
			   }
		    	 }
		      }
	    	if (!parse_error) exec_view();
	      	  else {
			error_msg_nl("Error in VIEW command");
			flushcommand();
			}
		flushcommand();
		break;
	} 
		
		        
/*** PLOTL, PLOTP *********************************************************
 *
 * plotl("<function>" {,<style>} {,[xrange,yrange]})
 * plotp("<function>" {,<style>} {,[xrange,yrange]})
 *
 *************************************************************************/

	case PLOTL: {
		parse_error=FALSE;
		next_token;
		if check_openpar
		  else {
		   if (checkfunction() && !(parse_error)) setfunction();
		   if (checkstyle() && !(parse_error)) style_flag=TRUE;
		   if (checkranges() && !(parse_error)) ranges_flag=TRUE;
		   if (!parse_error) {
			next_token;
		   	get_next_lex=TRUE;
		   	if check_closepar
		   	}
		   }

		if (!parse_error) {
		    if (style_flag) exec_linestyle();
		    if (ranges_flag) exec_xyrange();
		    exec_plotl();
		    }
		  else {
			error_msg_nl("Error in PLOTL command");
			flushcommand();
			}
		flushcommand();
		break;
		}


	case PLOTP: {
		parse_error=FALSE;
		next_token;
		if check_openpar
		  else {
		   if (checkfunction() && !(parse_error)) setfunction();
		   if (checkstyle() && !(parse_error)) style_flag=TRUE;
		   if (checkranges() && !(parse_error)) ranges_flag=TRUE;
		   if (!parse_error) {
			next_token;
		   	get_next_lex=TRUE;
		   	if check_closepar
		   	}
		   }

		if (!parse_error) {
		    if (style_flag) point_symbol=temp_linestyle; 
		    if (ranges_flag) exec_xyrange();
		    exec_plotp();
		    }
		  else {
			error_msg_nl("Error in PLOTP command");
			flushcommand();
			}
		flushcommand();
		break;
		}


/*** PLOTGREY, PLOTCOLOR **************************************************
 *
 * plotgrey("<function>",<data-format>{,[xrange,yrange]})
 * plotcolor("<function>",<data-format>{,[xrange,yrange]})
 *
 *************************************************************************/

	case PLOTGREY: {
		parse_error=FALSE;
		next_token;
		if check_openpar
		  else {
		   if (checkfunction() && !(parse_error)) setfunction();
		   next_token;
		   if check_comma 
		     else {
		      next_token;
		      if (curr_token != NUMBER) {
			parse_error=TRUE;
			error_msg("Missing data-format number");
			}
		       else {
			temp_dataformat=(int) floor(lex_number);
		        if (checkranges() && !(parse_error)) ranges_flag=TRUE;
		          if (!parse_error) {
			   next_token;
		   	   get_next_lex=TRUE;
		   	   if check_closepar
		   	   }
		        }
		     }
		 }

		if (!parse_error) {
		    if (ranges_flag) exec_xyrange();
		    exec_plotgrey();
		    }
		  else {
			error_msg_nl("Error in PLOTGREY command");
			flushcommand();
			}
		flushcommand();
		break;
		}

	case PLOTCOLOR: {
		parse_error=FALSE;
		next_token;
		if check_openpar
		  else {
		   if (checkfunction() && !(parse_error)) setfunction();
		   next_token;
		   if check_comma 
		     else {
		      next_token;
		      if (curr_token != NUMBER) {
			parse_error=TRUE;
			error_msg("Missing data-format number");
			}
		       else {
			temp_dataformat=(int) floor(lex_number);
		        if (checkranges() && !(parse_error)) ranges_flag=TRUE;
		          if (!parse_error) {
			   next_token;
		   	   get_next_lex=TRUE;
		   	   if check_closepar
		   	   }
		        }
		     }
		 }

		if (!parse_error) {
		    if (ranges_flag) exec_xyrange();
		    exec_plotcolor();
		    }
		  else {
			error_msg_nl("Error in PLOTCOLOR command");
			flushcommand();
			}
		flushcommand();
		break;
		}

/*** GREYBAR COLORBAR *****************************************************
 *
 * colorbar(pposxmin,pposymin,pposxmax,pposymax)
 * greybar(pposxmin,pposymin,pposxmax,pposymax)
 * [positions are in percentage 0.0 to 1.0 relative to the page size]
 *
 **************************************************************************/

	case COLORBAR: {
		parse_error=FALSE;
		next_token;
		if (curr_token != OPENPAR) {
		  parse_error=TRUE;
		  error_msg("Open parenthesis expected");
		  }
		 else {
		  next_token;
		  if (curr_token != NUMBER) {
		    parse_error=TRUE;
		    error_msg("Missing XMIN position");
		    }
		   else {
		    temp_xmin = (double) lex_number;
		    next_token;
		    if (curr_token != COMMA) {
		      parse_error=TRUE;
		      error_msg("Comma expected");
		      }
		     else {
		      next_token;	
		      if (curr_token != NUMBER) {
		        parse_error=TRUE;
		        error_msg("Missing YMIN position");
		        }
		       else {
		        temp_ymin = (double) lex_number;
		        next_token;
		        if (curr_token != COMMA) {
		          parse_error=TRUE;
		          error_msg("Comma expected");
		          }
		         else {
		          next_token;
		          if (curr_token != NUMBER) {
		            parse_error=TRUE;
		            error_msg("Missing XMAX position");
		            }
		           else {
		            temp_xmax = (double) lex_number;
		            next_token;
		            if (curr_token != COMMA) {
		              parse_error=TRUE;
		              error_msg("Comma expected");
		              }
		             else {
		              next_token;	
		              if (curr_token != NUMBER) {
		                parse_error=TRUE;
		                error_msg("Missing YMAX position");
		                }
		               else {
		                temp_ymax = (double) lex_number;
		                next_token;
			        if (curr_token != CLOSEPAR) {
			          parse_error=TRUE;
		                  error_msg("Missing closed parenthesis");
			          }
			        }
			      }
			    }
		          }
		        }
		      }
		     }
		   }
		if (!parse_error) exec_colorbar();
		  else {
			error_msg_nl("Error in COLORBAR command");
			flushcommand();
			}
		flushcommand();
		break;
	}

	case GREYBAR: {
		parse_error=FALSE;
		next_token;
		if (curr_token != OPENPAR) {
		  parse_error=TRUE;
		  error_msg("Open parenthesis expected");
		  }
		 else {
		  next_token;
		  if (curr_token != NUMBER) {
		    parse_error=TRUE;
		    error_msg("Missing XMIN position");
		    }
		   else {
		    temp_xmin = (double) lex_number;
		    next_token;
		    if (curr_token != COMMA) {
		      parse_error=TRUE;
		      error_msg("Comma expected");
		      }
		     else {
		      next_token;	
		      if (curr_token != NUMBER) {
		        parse_error=TRUE;
		        error_msg("Missing YMIN position");
		        }
		       else {
		        temp_ymin = (double) lex_number;
		        next_token;
		        if (curr_token != COMMA) {
		          parse_error=TRUE;
		          error_msg("Comma expected");
		          }
		         else {
		          next_token;
		          if (curr_token != NUMBER) {
		            parse_error=TRUE;
		            error_msg("Missing XMAX position");
		            }
		           else {
		            temp_xmax = (double) lex_number;
		            next_token;
		            if (curr_token != COMMA) {
		              parse_error=TRUE;
		              error_msg("Comma expected");
		              }
		             else {
		              next_token;	
		              if (curr_token != NUMBER) {
		                parse_error=TRUE;
		                error_msg("Missing YMAX position");
		                }
		               else {
		                temp_ymax = (double) lex_number;
		                next_token;
			        if (curr_token != CLOSEPAR) {
			          parse_error=TRUE;
		                  error_msg("Missing closed parenthesis");
			          }
			        }
			      }
			    }
		          }
		        }
		      }
		     }
		   }
		if (!parse_error) exec_greybar();
		  else {
			error_msg_nl("Error in GREYBAR command");
			flushcommand();
			}
		flushcommand();
		break;
		}

/*** PLOT3D ***************************************************************
 *
 * plot3d("<function>",<data-format>,<options>)
 *
 *************************************************************************/

	case PLOT3D: {
		parse_error=FALSE;	
		next_token;
		if check_openpar
		  else {
		   if (checkfunction() && !(parse_error)) setfunction();
		   next_token;
		   if check_comma 
		     else {
		       next_token;
		       if (curr_token != NUMBER) {
			    parse_error=TRUE;
			    error_msg("Missing data-format");
			    }
			   else {
			    temp_dataformat = (int) floor(lex_number);
			    next_token;
			    if check_comma
			      else {
				next_token;
				if (curr_token != NUMBER) {
				   parse_error=TRUE;
				   error_msg("Missing 3D options");
				   }
				  else {
				   temp_opt3d = (int) floor(lex_number);
				   next_token;
				   if check_closepar
				   }
				 }
			       }
			     }
			   }

		if (!parse_error) {
		    exec_plot3d();
		    }
		  else {
			error_msg_nl("Error in PLOT3D command");
			flushcommand();
			}
		flushcommand();
		break;
		}


/*** PLOTCONT *************************************************************
 *
 * plotcont("<function>",<data-format>,<nlevels>)
 *
 *************************************************************************/

	case PLOTCONT: {
		parse_error=FALSE;	
		next_token;
		if check_openpar
		  else {
		   if (checkfunction() && !(parse_error)) setfunction();
		   next_token;
		   if check_comma 
		     else {
		       next_token;
		       if (curr_token != NUMBER) {
			    parse_error=TRUE;
			    error_msg("Missing data-format");
			    }
			   else {
			    temp_dataformat = (int) floor(lex_number);
			    next_token;
			    if check_comma
			      else {
				next_token;
				if (curr_token != NUMBER) {
				   parse_error=TRUE;
				   error_msg("Missing number of contour levels");
				   }
				  else {
				   temp_nlevel = (int) floor(lex_number);
				   next_token;
				   if check_closepar
				   }
				 }
			       }
			     }
			   }

		if (!parse_error) {
		    exec_plotcont();
		    }
		  else {
			error_msg_nl("Error in PLOTCONT command");
			flushcommand();
			}
		flushcommand();
		break;
		}


/*** PLOTVECT *************************************************************
 *
 * plotvect("<function>",<data-format>,<symbol>)
 *
 *************************************************************************/

	case PLOTVECT: {
		parse_error=FALSE;	
		next_token;
		if check_openpar
		  else {
		   if (checkfunction() && !(parse_error)) setfunction();
		   next_token;
		   if check_comma 
		     else {
		       next_token;
		       if (curr_token != NUMBER) {
			    parse_error=TRUE;
			    error_msg("Missing data-format");
			    }
			   else {
			    temp_dataformat = (int) floor(lex_number);
			    next_token;
			    if check_comma
			      else {
				next_token;
				if (curr_token != NUMBER) {
				   parse_error=TRUE;
				   error_msg("Missing SYMBOL value");
				   }
				  else {
				   temp_mark = (int) floor(lex_number);
				   next_token;
				   if check_closepar
				   }
				 }
			       }
			     }
			   }

		if (!parse_error) {
		    exec_plotvect();
		    }
		  else {
			error_msg_nl("Error in PLOTVECT command");
			flushcommand();
			}
		flushcommand();
		break;
		}

/*** MAGNIVECT ************************************************************
 *
 * magnivect(magx,magy)		
 *
 *************************************************************************/

	case MAGNIVECT: {
		parse_error=FALSE;
		next_token;
		if (curr_token != OPENPAR) {
		  parse_error=TRUE;
		  error_msg("Open parenthesis expected");
		  }
		 else {
		  next_token;
		  if (curr_token != NUMBER) {
		    parse_error=TRUE;
		    error_msg("Missing X MAGNIFICATION");
		    }
		   else {
		    temp_magx = (double) lex_number;
		    next_token;
		    if (curr_token != COMMA) {
		      parse_error=TRUE;
		      error_msg("Comma expected");
		      }
		     else {
		      next_token;	
		      if (curr_token != NUMBER) {
		        parse_error=TRUE;
		        error_msg("Missing Y MAGNIFICATION");
		        }
		       else {
		        temp_magy = (double) lex_number;
		        next_token;
			if (curr_token != CLOSEPAR) {
			     parse_error=TRUE;
		             error_msg("Missing closed parenthesis");
			     }
		        }
		       }
		      }
		     }
		if (!parse_error) {
			magx=temp_magx;
			magy=temp_magy;
			}
		  else {
			error_msg_nl("Error in MAGNIVECT command");
			flushcommand();
			}
		flushcommand();
		break;
		}


/**************************************************************************
*
* format(x:<x_column>, y:<y_column>, c:<color_column>)
*
**************************************************************************/

	case FORMAT: {
		temp_xcol=0;
		temp_ycol=0;
		temp_ccol=0;
		temp_bnp=0;
		temp_fnp=0;

		ccol_flag=FALSE;
		xcol_flag=FALSE;
		ycol_flag=FALSE;
		bnp_flag=FALSE;
		fnp_flag=FALSE;
		endformat=FALSE;

		parse_error=FALSE;
		next_token;
		if check_openpar
		  else {
		   i=1;
		   next_token;
		   while ((i<=5)&&(!parse_error)&&(!endformat)) {
		    switch (curr_token){

			case FORMX: {
			  if (xcol_flag) {
			    parse_error=TRUE;
			    error_msg("x column already defined");
			    }
			  else {
		          next_token;
		          if check_colon
		           else {
		       	    next_token;
			    if (curr_token != NUMBER) {
			      parse_error=TRUE;
			      error_msg("Missing x column value");
			      }
			     else {
			      temp_xcol=(int) floor(lex_number);
			      xcol_flag=TRUE;
			      }
			     }
			    }
			   break;
			   }

			case FORMY: {
			  if (ycol_flag) {
			    parse_error=TRUE;
			    error_msg("y column already defined");
			    }
			  else {
		          next_token;
		          if check_colon
		           else {
		       	    next_token;
			    if (curr_token != NUMBER) {
			      parse_error=TRUE;
			      error_msg("Missing y column value");
			      }
			     else {
			      temp_ycol=(int) floor(lex_number);
			      ycol_flag=TRUE;
			      }
			     }
			    }
			   break;
			   }

			case FORMC: {
			  if (ccol_flag) {
			    parse_error=TRUE;
			    error_msg("c column already defined");
			    }
			  else {
		          next_token;
		          if check_colon
		           else {
		       	    next_token;
			    if (curr_token != NUMBER) {
			      parse_error=TRUE;
			      error_msg("Missing c column value");
			      }
			     else {
			      temp_ccol=(int) floor(lex_number);
			      ccol_flag=TRUE;
			      }
			     }
			    }
			   break;
			   }

			case FORMBNP: {
			  if (bnp_flag) {
			    parse_error=TRUE;
			    error_msg("beginning line already defined");
			    }
			  else {
		          next_token;
		          if check_colon
		           else {
		       	    next_token;
			    if (curr_token != NUMBER) {
			      parse_error=TRUE;
			      error_msg("Missing b column value");
			      }
			     else {
			      temp_bnp=(int) floor(lex_number);
			      bnp_flag=TRUE;
			      }
			     }
			    }
			   break;
			   }

			case FORMFNP: {
			  if (fnp_flag) {
			    parse_error=TRUE;
			    error_msg("Ending line already defined");
			    }
			  else {
		          next_token;
		          if check_colon
		           else {
		       	    next_token;
			    if (curr_token != NUMBER) {
			      parse_error=TRUE;
			      error_msg("Missing e column value");
			      }
			     else {
			      temp_fnp=(int) floor(lex_number);
			      fnp_flag=TRUE;
			      }
			     }
			    }
			   break;
			   }

			default: {
			   parse_error=TRUE;
			   error_msg("x y or c column identifier expected");
			   break;
			   }

			}
		    if (parse_error) break;
		    next_token;
		    if (curr_token == COMMA) {
			i++;
			next_token;
			}
		     else {
			if check_closepar
			endformat=TRUE;
			}
		    }
		   }

		if (!parse_error) exec_format();
		  else {
			error_msg_nl("Error in FORMAT command");
			flushcommand();
			}
		flushcommand();
		break;
		}

/**************************************************************************
*
*
*
**************************************************************************/

	case AT: {
		parse_error=FALSE;
		next_token;
		if (curr_token != STRING) {
        		parse_error=TRUE;
        		error_msg("Missing command file name");
			error_msg_nl("Error in AT command");
                	flushcommand();
        		}
		  else {
			strcpy(command_filename,lex_buffer);
			if ((commandfile=fopen(command_filename,"r"))==NULL){
			   parse_error=TRUE;
			   error_msg("Cannot find command file");
			   }
			if (!parse_error) {
			   rinfile=infile;
			   infile=commandfile;
			   atcommand=TRUE;
			   atline=1;
			   while (! ((int)feof(infile))) {
			   interpret();
			   if (parse_error) {
			      fprintf(errfile,"\t^--- Error in command file: ");
			      fprintf(errfile,"%s ",command_filename);
			      fprintf(errfile,"  [at line: %d]\n",atline);
			      break;
			      }
			    else
			      atline++;
			   }
			   infile=rinfile;
			   atcommand=FALSE;
			   flushcommand();
			   }
			  else {
				error_msg_nl("Error in AT command");
				flushcommand();
				}
			}
		break;
		} 

/**************************************************************************
*
*
*
**************************************************************************/
	
	case ENDOFLINE: {
		break; /* Do nothing: just return */
		}

/**************************************************************************
*
*
*
**************************************************************************/
	
	case ENDOFFILE: {
		if (!atcommand) infile=stdin;     
		break; /* Do nothing: just return */
		}

/**************************************************************************
*
* system   "<unix-command>"
*
**************************************************************************/
	
	case SYSTEM: {
		if (!parse_error) system("/bin/tcsh");
		  else {
			error_msg_nl("Error in SYSTEM command");
			flushcommand();
			}
		flushcommand();
		break;
		}

	case SYS: {
		nc=0;
		while (ch!='\n'){
		  if ((ch=fgetc(infile))!=EOF) {
			temp_unixcmd[nc]=ch;
			nc++;
			}
		  }
		nc--;
		temp_unixcmd[nc]='\0';
		system(temp_unixcmd);
		break;
		}

/**************************************************************************
*
*
*
**************************************************************************/
	
	case PAUSE: {
		if ((screen_active)&&(atcommand)) {
			error_msg_nl("");
			error_msg_nl("Strike ENTER to continue ...");
			(void) getkey();
			(void) getkey();
			/* while (getchar()!='\n'); */
			}
		flushcommand();
		break; 
		}

/**************************************************************************
*
*
*
**************************************************************************/
	
	case EXIT: {
		plend();
		exit(0);
		break; /* Terminate Primvs session */
		}

/**************************************************************************
*
* box("<xoptions>,<xtick_interval>,<xtick_subinterval>,
*     "<yoptions",<ytick_interval>,<ytick_subinterval>)
*
**************************************************************************/

	case BOX: {
		parse_error=FALSE;	
		next_token;
		if check_openpar
		  else {
		   next_token;
		   if (curr_token != STRING) {
		      parse_error=TRUE;
		      error_msg("Missing x-options");
		      }
		     else {
		      strcpy(temp_xoptions,lex_buffer);
		      next_token;
		      if check_comma
		        else {
			 next_token;
			 if (curr_token != NUMBER) {
			    parse_error=TRUE;
			    error_msg("Missing xtick-interval");
			    }
			   else {
			    temp_xtickint= (double) lex_number;
			    next_token;
			    if check_comma
			      else {
				next_token;
				if (curr_token != NUMBER) {
				   parse_error=TRUE;
				   error_msg("Missing xtick-subinterval");
				   }
				  else {
				   temp_xticksub=(int) floor(lex_number);
				   next_token;
				   if check_comma
				     else {
				      next_token;
		                      if (curr_token != STRING) {
		                        parse_error=TRUE;
		                        error_msg("Missing y-options");
		                        }
		                       else {
		                        strcpy(temp_yoptions,lex_buffer);
		                        next_token;
		                        if check_comma
		                          else {
			                   next_token;
			                   if (curr_token != NUMBER) {
			                     parse_error=TRUE;
			                     error_msg("Missing ytick-interval");
			                     }
			                    else {
			                     temp_ytickint= (double) lex_number;
			                     next_token;
			                     if check_comma
			                       else {
				                next_token;
				                if (curr_token != NUMBER) {
				                  parse_error=TRUE;
				                  error_msg("Missing ytick-subinterval");
				                  }
				                 else {
				                  temp_yticksub=(int) floor(lex_number);
				                  next_token;
				                  if check_closepar
				       		  }
						 }
						}
					       }
					      }
					     }
					    }
					   }
					  }
					 }
					}
				       }
	    	if (!parse_error) exec_box();
	      	  else {
			error_msg_nl("Error in BOX command");
			flushcommand();
			}
		flushcommand();
		break;
	} 
				        
 
/**************************************************************************
*
* box3d("<xoptions>,<xtick_interval>,
*       "<yoptions",<ytick_interval>,
*       "<zoptions",<ztick_interval>,
*
**************************************************************************/

	case BOX3D: {
		parse_error=FALSE;	
		next_token;
		if check_openpar
		  else {
		   next_token;
		   if (curr_token != STRING) {
		      parse_error=TRUE;
		      error_msg("Missing x-options");
		      }
		     else {
		      strcpy(temp_xoptions,lex_buffer);
		      next_token;
		      if check_comma
		        else {
			 next_token;
			 if (curr_token != NUMBER) {
			    parse_error=TRUE;
			    error_msg("Missing xtick-interval");
			    }
			   else {
			    temp_xtickint= (double) lex_number;
			    next_token;
			    if check_comma
			      else {
				next_token;
		                if (curr_token != STRING) {
		                   parse_error=TRUE;
		                   error_msg("Missing y-options");
		                   }
		                  else {
		                   strcpy(temp_yoptions,lex_buffer);
		                   next_token;
		                   if check_comma
		                     else {
			              next_token;
			              if (curr_token != NUMBER) {
			                 parse_error=TRUE;
			                 error_msg("Missing ytick-interval");
			                 }
			                else {
			                 temp_ytickint= (double) lex_number;
			                 next_token;
			                 if check_comma
			                   else {
				             next_token;
		                	     if (curr_token != STRING) {
		                               parse_error=TRUE;
		                               error_msg("Missing z-options");
		                               }
		                              else {
		                               strcpy(temp_zoptions,lex_buffer);
		                               next_token;
		                               if check_comma
		                                else {
			                         next_token;
			                         if (curr_token != NUMBER) {
			                           parse_error=TRUE;
			                           error_msg("Missing ztick-interval");
			                           }
			                          else {
			                           temp_ztickint= (double) lex_number;
			                           next_token;
				                   if check_closepar
				       		   }
						 }
						}
					       }
					      }
					     }
					    }
					   }
					  }
					 }
					}
				       }
	    	if (!parse_error) exec_box3d();
	      	  else {
			error_msg_nl("Error in BOX3D command");
			flushcommand();
			}
		flushcommand();
		break;
	} 
				        
/**************************************************************************
*
* color(<color>)  [number or name]
*
**************************************************************************/
	
	case COLOR: {
		parse_error=FALSE;
		next_token;
		if check_openpar
		  else {
		   next_token;
		   if ((curr_token != ACOLOR)&&(curr_token != NUMBER)) {
			parse_error=TRUE;
			error_msg("Missing color");
			}
		    else {
			temp_color=(int) floor(lex_number);
		        next_token;
			if check_closepar
			}
		    }
		if (!parse_error) exec_color();
		  else {
			error_msg_nl("Error in COLOR command");
			flushcommand();
			}
		flushcommand();
		break;
		}	

/**************************************************************************
*
* setcolor(<0>|<1>)  [set color or black and white]
*
**************************************************************************/
	
	case SETCOLOR: {
		parse_error=FALSE;
		next_token;
		if check_openpar
		  else {
		   next_token;
		   if (curr_token != NUMBER) {
			parse_error=TRUE;
			error_msg("Missing switch value (0/1)");
			}
		    else {
			temp_color=(int) floor(lex_number);
		        next_token;
			if check_closepar
			}
		    }
		if (!parse_error) exec_setcolor();
		  else {
			error_msg_nl("Error in SETCOLOR command");
			flushcommand();
			}
		flushcommand();
		break;
		}
	
/**************************************************************************
*
* background(<color>)  [number or name]
*
**************************************************************************/
	
	case BACKGROUND: {
		parse_error=FALSE;
		next_token;
		if check_openpar
		  else {
		   next_token;
		   if ((curr_token != ACOLOR)&&(curr_token != NUMBER)) {
			parse_error=TRUE;
			error_msg("Missing background color");
			}
		    else {
			temp_color=(int) floor(lex_number);
		        next_token;
			if check_closepar
			}
		    }
		if (!parse_error) exec_background();
		  else {
			error_msg_nl("Error in BACKGROUND command");
			flushcommand();
			}
		flushcommand();
		break;
		}	

/**************************************************************************
*
* scalechr(<scaling_factor>)
*
**************************************************************************/
	
	case SCALECHR: {
		parse_error=FALSE;
		next_token;
		if check_openpar
		  else {
		   next_token;
		   if (curr_token != NUMBER) {
			parse_error=TRUE;
			error_msg("Missing scaling factor");
			}
		    else {
			temp_scalechr = (double) lex_number;
		        next_token;
			if check_closepar
			}
		    }
		if (!parse_error) exec_scalechr();
		  else {
			error_msg_nl("Error in SCALECHR command");
			flushcommand();
			}
		flushcommand();
		break;
		}	

/**************************************************************************
*
* scalesym(<scaling_factor>)
*
**************************************************************************/
	
	case SCALESYM: {
		parse_error=FALSE;
		next_token;
		if check_openpar
		  else {
		   next_token;
		   if (curr_token != NUMBER) {
			parse_error=TRUE;
			error_msg("Missing scaling factor");
			}
		    else {
			temp_scalesym = (double) lex_number;
		        next_token;
			if check_closepar
			}
		    }
		if (!parse_error) exec_scalesym();
		  else {
			error_msg_nl("Error in SCALESYM command");
			flushcommand();
			}
		flushcommand();
		break;
		}	

/**************************************************************************
*
* label("<x_label>","<y_label>","<top_label>")
*
**************************************************************************/
	
	case LABEL: {
		parse_error=FALSE;
		next_token;
		if check_openpar
		  else {
		   next_token;
		   if (curr_token != STRING) {
		      parse_error=TRUE;
		      error_msg("Missing x label");
		      }
		     else {
		      strcpy(temp_xlabel,lex_buffer);
		      next_token;
		      if check_comma
		        else {
			 next_token;
			 if (curr_token != STRING) {
			    parse_error=TRUE;
			    error_msg("Missing y label");
			    }
			   else {
			    strcpy(temp_ylabel,lex_buffer);
			    next_token;
			    if check_comma
			      else {
				next_token;
				if (curr_token != STRING) {
				   parse_error=TRUE;
				   error_msg("Missing top label");
				   }
				  else {
				   strcpy(temp_tlabel,lex_buffer);
				   next_token;
				   if check_closepar
				   }
				  }
				 }
				}
			       }
			      }

		if (!parse_error) exec_label();
		  else {
			error_msg_nl("Error in LABEL command");
			flushcommand();
			}
		flushcommand();
		break;
		}

/**************************************************************************
*
* label3d("<x_label>","<y_label>","<z_label>")
*
**************************************************************************/
	
	case LABEL3D: {
		parse_error=FALSE;
		next_token;
		if check_openpar
		  else {
		   next_token;
		   if (curr_token != STRING) {
		      parse_error=TRUE;
		      error_msg("Missing x label");
		      }
		     else {
		      strcpy(temp_xlabel,lex_buffer);
		      next_token;
		      if check_comma
		        else {
			 next_token;
			 if (curr_token != STRING) {
			    parse_error=TRUE;
			    error_msg("Missing y label");
			    }
			   else {
			    strcpy(temp_ylabel,lex_buffer);
			    next_token;
			    if check_comma
			      else {
				next_token;
				if (curr_token != STRING) {
				   parse_error=TRUE;
				   error_msg("Missing z label");
				   }
				  else {
				   strcpy(temp_zlabel,lex_buffer);
				   next_token;
				   if check_closepar
				   }
				  }
				 }
				}
			       }
			      }

		if (!parse_error) exec_label3d();
		  else {
			error_msg_nl("Error in LABEL3D command");
			flushcommand();
			}
		flushcommand();
		break;
		}


/**************************************************************************
*
* text("<side>,<ref_ypos>,<ref_xpos>,<ref_just>,"<string_of_text>")
*
**************************************************************************/

	case TEXT: {
		parse_error=FALSE;	
		next_token;
		if check_openpar
		  else {
		   next_token;
		   if (curr_token != STRING) {
		      parse_error=TRUE;
		      error_msg("Missing side specification");
		      }
		     else {
		      strcpy(temp_side,lex_buffer);
		      next_token;
		      if check_comma
		        else {
			 next_token;
			 if (curr_token != NUMBER) {
			    parse_error=TRUE;
			    error_msg("Missing Y position of reference point");
			    }
			   else {
			    temp_ref_ypos = (double) lex_number;
			    next_token;
			    if check_comma
			      else {
				next_token;
				if (curr_token != NUMBER) {
				   parse_error=TRUE;
				   error_msg("Missing X position of reference point");
				   }
				  else {
				   temp_ref_xpos = (double) lex_number;
				   next_token;
				   if check_comma
				     else {
				      next_token;
		                      if (curr_token != NUMBER) {
		                        parse_error=TRUE;
		                        error_msg("Missing justification of reference point");
		                        }
		                       else {
		                        temp_ref_just = (double) lex_number;
		                        next_token;
		                        if check_comma
		                          else {
			                   next_token;
			                   if (curr_token != STRING) {
			                     parse_error=TRUE;
			                     error_msg("Missing text");
			                     }
			                    else {
			                     strcpy(temp_text,lex_buffer);
			                     next_token;
				             if check_closepar
				       		  }
						 }
						}
					       }
					      }
					     }
					    }
					   }
					  }
					 }
	    	if (!parse_error) exec_text();
	      	  else {
			error_msg_nl("Error in TEXT command");
			flushcommand();
			}
		flushcommand();
		break;
	} 
				        
/**************************************************************************
*
* gtext(<xposition>,<yposition>,<dxposition>,<dyposition>,
*       <justification>,"<string_of_text>")
*
**************************************************************************/

	case GTEXT: {
		parse_error=FALSE;	
		next_token;
		if check_openpar
		  else {
		   next_token;
		   if (curr_token != NUMBER) {
		      parse_error=TRUE;
		      error_msg("Missing X position");
		      }
		     else {
		      temp_txpos = (double) lex_number;
		      next_token;
		      if check_comma
		        else {
			 next_token;
			 if (curr_token != NUMBER) {
			    parse_error=TRUE;
			    error_msg("Missing Y position");
			    }
			   else {
			    temp_typos = (double) lex_number;
			    next_token;
			    if check_comma
			      else {
				next_token;
				if (curr_token != NUMBER) {
				   parse_error=TRUE;
				   error_msg("Missing DX position");
				   }
				  else {
				   temp_tdxpos = (double) lex_number;
				   next_token;
				   if check_comma
				     else {
				      next_token;
		                      if (curr_token != NUMBER) {
		                        parse_error=TRUE;
		                        error_msg("Missing DY position");
		                        }
		                       else {
				        temp_tdypos = (double) lex_number;
		                        next_token;
		                        if check_comma
		                          else {
			                   next_token;
			                   if (curr_token != NUMBER) {
			                     parse_error=TRUE;
			                     error_msg("Missing justification of reference point");
			                     }
			                    else {
			                     temp_ref_just = (double) lex_number;
			                     next_token;
			                     if check_comma
			                       else {
				                next_token;
				                if (curr_token != STRING) {
				                  parse_error=TRUE;
				                  error_msg("Missing text");
				                  }
				                 else {
				                  strcpy(temp_text,lex_buffer);
				                  next_token;
				                  if check_closepar
				       		  }
						 }
						}
					       }
					      }
					     }
					    }
					   }
					  }
					 }
					}
				       }
	    	if (!parse_error) exec_gtext();
	      	  else {
			error_msg_nl("Error in GTEXT command");
			flushcommand();
			}
		flushcommand();
		break;
	} 

				        
/**************************************************************************
*
* linestyle(<style>)  [1-8]
*
**************************************************************************/
	
	case LINESTYLE: {
		parse_error=FALSE;
		next_token;
		if check_openpar
		  else {
		   next_token;
		   if (curr_token != NUMBER) {
			parse_error=TRUE;
			error_msg("Missing style number");
			}
		    else {
			temp_linestyle=(int) floor(lex_number);
		        next_token;
			if check_closepar
			}
		    }
		if (!parse_error) exec_linestyle();
		  else {
			error_msg_nl("Error in LINESTYLE command");
			flushcommand();
			}
		flushcommand();
		break;
		}	

/**************************************************************************
*
* linewidth(<width>)  [1-10] (device dependent)
*
**************************************************************************/
	
	case LINEWIDTH: {
		parse_error=FALSE;
		next_token;
		if check_openpar
		  else {
		   next_token;
		   if (curr_token != NUMBER) {
			parse_error=TRUE;
			error_msg("Missing width value");
			}
		    else {
			temp_linewidth=(int) floor(lex_number);
		        next_token;
			if check_closepar
			}
		    }
		if (!parse_error) exec_linewidth();
		  else {
			error_msg_nl("Error in LINEWIDTH command");
			flushcommand();
			}
		flushcommand();
		break;
		}	

/**************************************************************************
*
* resolution(<resol>)  [0.1-10.0] (device dependent)
*
**************************************************************************/
	
	case RESOLUTION: {
		parse_error=FALSE;
		next_token;
		if check_openpar
		  else {
		   next_token;
		   if (curr_token != NUMBER) {
			parse_error=TRUE;
			error_msg("Missing resolution value");
			}
		    else {
			temp_resol=lex_number;
		        next_token;
			if check_closepar
			}
		    }
		if (!parse_error) exec_resolution();
		  else {
			error_msg_nl("Error in RESOLUTION command");
			flushcommand();
			}
		flushcommand();
		break;
		}	

/**************************************************************************
*
* symbol(symbol_number) [0-127]
*
**************************************************************************/
	
	case SYMBOL: {
		parse_error=FALSE;
		next_token;
		if check_openpar
		  else {
		   next_token;
		   if (curr_token != NUMBER) {
			parse_error=TRUE;
			error_msg("Missing symbol number");
			}
		    else {
			temp_symbol=(int) floor(lex_number);
		        next_token;
			if check_closepar
			}
		    }
		if (!parse_error) point_symbol=temp_symbol;
		  else {
			error_msg_nl("Error in SYMBOL command");
			flushcommand();
			}
		flushcommand();
		break;
		}	

/**************************************************************************
*
* autoscale, noautoscale
*
**************************************************************************/
	
	case AUTOSCALE: {
		scaleflag=TRUE;
		flushcommand();
		break;
		}

	case NOAUTOSCALE: {
		scaleflag=FALSE;
		flushcommand();
		break;
		}

/**************************************************************************
*
* breakpage 
*
**************************************************************************/
	
	case BREAKPAGE: {
		exec_breakpage();
		flushcommand();
		break;
		}

/**************************************************************************
*
* closepage 
*
**************************************************************************/
	
	case CLOSEPAGE: {
		exec_closepage();
		flushcommand();
		break;
		}

/**************************************************************************
*
* # Any comment is preceded by the pound sign
*
**************************************************************************/
	
	case COMMENT: {
		flushcommand();
		break;
		}

/**************************************************************************
*
* line(x1,y1,x2,y2)
*
**************************************************************************/
	
	case LINE: {
		parse_error=FALSE;
		next_token;
		if (curr_token != OPENPAR) {
		  parse_error=TRUE;
		  error_msg("Open parenthesis expected");
		  }
		 else {
		  next_token;
		  if (curr_token != NUMBER) {
		    parse_error=TRUE;
		    error_msg("Missing X1 position");
		    }
		   else {
		    temp_x1 = (double) lex_number;
		    next_token;
		    if (curr_token != COMMA) {
		      parse_error=TRUE;
		      error_msg("Comma expected");
		      }
		     else {
		      next_token;	
		      if (curr_token != NUMBER) {
		        parse_error=TRUE;
		        error_msg("Missing Y1 position");
		        }
		       else {
		        temp_y1 = (double) lex_number;
		        next_token;
		        if (curr_token != COMMA) {
		          parse_error=TRUE;
		          error_msg("Comma expected");
		          }
		         else {
		          next_token;
		          if (curr_token != NUMBER) {
		            parse_error=TRUE;
		            error_msg("Missing X2 position");
		            }
		           else {
		            temp_x2 = (double) lex_number;
		            next_token;
		            if (curr_token != COMMA) {
		              parse_error=TRUE;
		              error_msg("Comma expected");
		              }
		             else {
		              next_token;	
		              if (curr_token != NUMBER) {
		                parse_error=TRUE;
		                error_msg("Missing Y2 position");
		                }
		               else {
		                temp_y2 = (double) lex_number;
		                next_token;
			        if (curr_token != CLOSEPAR) {
			          parse_error=TRUE;
		                  error_msg("Missing closed parenthesis");
			          }
			        }
			      }
			    }
		          }
		        }
		      }
		     }
		   }
		if (!parse_error) exec_line();
		  else {
			error_msg_nl("Error in LINE command");
			flushcommand();
			}
		flushcommand();
		break;
	}


/*** CIRCLE ***************************************************************
 *
 * circle(xc,yc,radius)
 *
 *************************************************************************/

	case CIRCLE: {
		parse_error=FALSE;
		next_token;
		if (curr_token != OPENPAR) {
		  parse_error=TRUE;
		  error_msg("Open parenthesis expected");
		  }
		 else {
		  next_token;
		  if (curr_token != NUMBER) {
		    parse_error=TRUE;
		    error_msg("Missing XC coordinate");
		    }
		   else {
		    temp_xc = (double) lex_number;
		    next_token;
		    if (curr_token != COMMA) {
		      parse_error=TRUE;
		      error_msg("Comma expected");
		      }
		     else {
		      next_token;	
		      if (curr_token != NUMBER) {
		        parse_error=TRUE;
		        error_msg("Missing YC coordinate");
		        }
		       else {
		        temp_yc = (double) lex_number;
		        next_token;
		        if (curr_token != COMMA) {
		          parse_error=TRUE;
		          error_msg("Comma expected");
		          }
		         else {
		          next_token;
		          if (curr_token != NUMBER) {
		            parse_error=TRUE;
		            error_msg("Missing RADIUS value");
		            }
		           else {
		            temp_radius = (double) lex_number;
		            next_token;
			    if (curr_token != CLOSEPAR) {
			       parse_error=TRUE;
		               error_msg("Missing closed parenthesis");
			       }
			    }
			   }
		          }
		        }
		      }
		     }
		if (!parse_error) exec_circle();
		  else {
			error_msg_nl("Error in CIRCLE command");
			flushcommand();
			}
		flushcommand();
		break;
	}

/*** WAFER ****************************************************************
 *
 * wafer(xc,yc,radius,type)
 *
 *************************************************************************/

	case WAFER: {
		parse_error=FALSE;
		next_token;
		if (curr_token != OPENPAR) {
		  parse_error=TRUE;
		  error_msg("Open parenthesis expected");
		  }
		 else {
		  next_token;
		  if (curr_token != NUMBER) {
		    parse_error=TRUE;
		    error_msg("Missing XC position");
		    }
		   else {
		    temp_xc = (double) lex_number;
		    next_token;
		    if (curr_token != COMMA) {
		      parse_error=TRUE;
		      error_msg("Comma expected");
		      }
		     else {
		      next_token;	
		      if (curr_token != NUMBER) {
		        parse_error=TRUE;
		        error_msg("Missing YC position");
		        }
		       else {
		        temp_yc = (double) lex_number;
		        next_token;
		        if (curr_token != COMMA) {
		          parse_error=TRUE;
		          error_msg("Comma expected");
		          }
		         else {
		          next_token;
		          if (curr_token != NUMBER) {
		            parse_error=TRUE;
		            error_msg("Missing RADIUS");
		            }
		           else {
		            temp_radius= (double) lex_number;
		            next_token;
		            if (curr_token != COMMA) {
		              parse_error=TRUE;
		              error_msg("Comma expected");
		              }
		             else {
		              next_token;	
		              if (curr_token != NUMBER) {
		                parse_error=TRUE;
		                error_msg("Missing WAFER TYPE number");
		                }
		               else {
		                temp_wafertype= (int) floor(lex_number);
		                next_token;
			        if (curr_token != CLOSEPAR) {
			          parse_error=TRUE;
		                  error_msg("Missing closed parenthesis");
			          }
			        }
			      }
			    }
		          }
		        }
		      }
		     }
		   }
		if (!parse_error) exec_wafer();
		  else {
			error_msg_nl("Error in WAFER command");
			flushcommand();
			}
		flushcommand();
		break;
	}


/*** MARK *****************************************************************
 *
 * mark(xm,ym,symbol_mark)
 *
 *************************************************************************/

	case MARK: {
		parse_error=FALSE;
		next_token;
		if (curr_token != OPENPAR) {
		  parse_error=TRUE;
		  error_msg("Open parenthesis expected");
		  }
		 else {
		  next_token;
		  if (curr_token != NUMBER) {
		    parse_error=TRUE;
		    error_msg("Missing XM coordinate");
		    }
		   else {
		    temp_xm = (double) lex_number;
		    next_token;
		    if (curr_token != COMMA) {
		      parse_error=TRUE;
		      error_msg("Comma expected");
		      }
		     else {
		      next_token;	
		      if (curr_token != NUMBER) {
		        parse_error=TRUE;
		        error_msg("Missing YM coordinate");
		        }
		       else {
		        temp_ym = (double) lex_number;
		        next_token;
		        if (curr_token != COMMA) {
		          parse_error=TRUE;
		          error_msg("Comma expected");
		          }
		         else {
		          next_token;
		          if (curr_token != NUMBER) {
		            parse_error=TRUE;
		            error_msg("Missing SYMBOL MARK");
		            }
		           else {
		            temp_mark = (int) floor(lex_number);
		            next_token;
			    if (curr_token != CLOSEPAR) {
			       parse_error=TRUE;
		               error_msg("Missing closed parenthesis");
			       }
			    }
			   }
		          }
		        }
		      }
		     }
		if (!parse_error) exec_mark();
		  else {
			error_msg_nl("Error in MARK command");
			flushcommand();
			}
		flushcommand();
		break;
	}

/*** HIC SUNT LEONES ! ***************************************************/
	case SET: {
		printf("Command SET\n");
		break;
		}

	case SHOW: {
		printf("Command SHOW\n");
		break;
		}

	case IDENTIFIER: {
		parse_error=FALSE;
		next_token;
		if (curr_token != EQUAL){
			error_msg("Missing '='");
			parse_error=TRUE;
			}
		  else {
			next_token;
			if (curr_token != NUMBER){
				error_msg("Missing value");
				parse_error=TRUE;
				}
			  else {
				if (!checkend()) parse_error=TRUE;
				}
			}
		if (!parse_error) exec_assign();
		   else {
			error_msg("Error in ASSIGNMENT");
			flushcommand();
			}
		break;
		}
	default:{
		parse_error=TRUE;
		error_msg_nl("(Unrecognized command !)");
		flushcommand();
		break;
		}
	}

}
