/*****************************************************************************
 *                                                                           *
 *  PRIMVS - Graphic Interpreter for X-Ray Lithography
 *                                                                           *
 ***************************************************************************** 
 *
 *  Author:   Luigi Capodieci
 *  Project:  PLPLOT based graphic interpreter
 *
 *  $Source: 
 *  $Revision:
 *  $Date: 
 *  $Log: lexic.c,v $
 *  Revision 1.1.1.1  1996/07/11 13:52:45  khan
 *  Initial checkin of SHADOW 2.1 distribution sources
 *
 * Revision 1.1.1.1  1996/01/02  17:07:39  khan
 * Toolset 2.0 release
 *
 *****************************************************************************/ 

/* LEXICAL ANALIZER for PLPLOT based Graphic Language */

/*****************************************************************************/ 

#include "allinclude.h"


/*** GLOBAL VARIABLES ********************************************************/

char	lex_buffer[MAX_WORD_LENGTH];
double	lex_number;
int	ch,lex_sep;
int	nc;

var_type	avar;

/*** Skip spaces in front of a stream of characters **************************/ 

void	skipspace()
{
if ((ch=fgetc(infile))==EOF) { ungetc(ch, infile); return; }
	while (((ch==' ')||(ch=='\t'))&&(ch!=EOF)) 
	  ch=fgetc(infile);	/*** Skip spaces until a non-space is found */

	ungetc(ch,infile);	/*** Put back the last character */
}


/***Return TRUE if the character is a SEPARATOR ******************************/ 

int	isminusplus(ch)
		int	ch;
{
if ((ch=='-')||(ch=='+'))
		return(TRUE);
	else
		return(FALSE);
}


/***Return TRUE if the character is a SEPARATOR ******************************/ 

int	isseparator(ch)
		int	ch;
{
if ((isspace(ch))||(iscntrl(ch))||(ispunct(ch)))
		return(TRUE);
	else
		return(FALSE);
}

/*** LEXICAL ANALYZER ********************************************************/ 

token_type	lexical()

{
	lex_state_type	lex_state,lex_go;
	int		firstdot,seconddot,minusplus,scientific;
	int		scientificdot;

/*** Initialize variables for lexical analysis ***/

nc = 0;
lex_state = L_START;
lex_go = L_START;
firstdot = TRUE;
seconddot = TRUE;
minusplus = FALSE;
scientific = FALSE;
scientificdot = FALSE;

skipspace();

/*** Analyze a stream of characters ***/
while (lex_go != L_END) {
	if ((ch=fgetc(infile)) != EOF) {
	   switch(lex_state) {
		case L_START: {
			if (isalpha(ch)) {
				lex_state=L_ALPHA;
				lex_buffer[nc]=ch;
				nc++;
				break;
				}
			if ((isdigit(ch))||(isminusplus(ch))||(ch=='.')) {
				lex_state=L_DIGIT;
				if (isminusplus(ch)) minusplus=TRUE;
				if (ch=='.') firstdot=FALSE;
				lex_buffer[nc]=ch;
				nc++;
				break;
				}
			if (ch=='\"') {
				lex_state=L_STRING;
				break;
				}
			if (isseparator(ch)) {
				lex_state=L_PUNCT;
				lex_go=L_END;
				lex_buffer[nc]=ch;
				nc++;
				break;
				}
			}

		case L_STRING: {
			if (ch != '\"') {
				lex_buffer[nc]=ch;
				nc++;
				break;
				}
			  else {
				lex_go=L_END;
				break;
				}
			}

		case L_ALPHA: {
			if ((isalpha(ch))||(isdigit(ch))) {
				lex_buffer[nc]=ch;
				nc++;
				break;
				}
			if (isseparator(ch)) {
				lex_go=L_END;
				lex_buffer[nc]=0;
				ungetc(ch,infile);
				break;
				}
			} 

		case L_DIGIT: {
			if (isdigit(ch)) {
				lex_buffer[nc]=ch;
				nc++;
				break;
				}
			if ((ch=='.')&&(firstdot)) {
				lex_buffer[nc]=ch;
				nc++;
				firstdot=FALSE;
				break;
				}
			if ((ch=='.')&&(seconddot)&&(scientificdot)) {
				lex_buffer[nc]=ch;
				nc++;
				seconddot=FALSE;
				break;
				}
			if (isminusplus(ch)&&scientific) {
				lex_buffer[nc]=ch;
				nc++;
				scientific=FALSE;
				break;
				}
			if ((ch=='e')||(ch=='E')) {
				lex_buffer[nc]=ch;
				nc++;
				scientific = TRUE;
				scientificdot = TRUE;
				break;
				}
			if (((isalpha(ch))||(isseparator(ch)))&&(minusplus)){
				lex_go=L_END;
				if (nc==1) lex_state=L_PUNCT;
				lex_buffer[nc]=0;
				ungetc(ch,infile);
				break;
				}
			if ((isalpha(ch))||(isseparator(ch))){
				lex_go=L_END;
				lex_buffer[nc]=0;
				ungetc(ch,infile);
				break;
				}
			}
		}
	}
      else {
	return(ENDOFFILE);
/***
	fprintf(outfile,"\nERROR: Unexpected EOF\n");
	exit(-1);
***/
	}
     }

/*** End of a stream of characters -> return the TOKEN ***/
	switch(lex_state) {
		case L_ALPHA: {

/*** KEYWORDS ********************************************/

			if ((strcmp(lex_buffer,K_INITPAGE))==0)
				return(INITPAGE);
			if ((strcmp(lex_buffer,K_INITMULTIPAGE))==0)
				return(INITMULTIPAGE);
			if ((strcmp(lex_buffer,K_ORIENTATION))==0)
				return(ORIENTATION);
			if ((strcmp(lex_buffer,K_SUBPAGE))==0)
				return(SUBPAGE);
			if ((strcmp(lex_buffer,K_REGIONP))==0)
				return(REGIONP);
			if ((strcmp(lex_buffer,K_REGIONM))==0)
				return(REGIONM);
			if ((strcmp(lex_buffer,K_REGIONR))==0)
				return(REGIONR);
			if ((strcmp(lex_buffer,K_XYRANGE))==0)
				return(XYRANGE);
			if ((strcmp(lex_buffer,K_XYZRANGE))==0)
				return(XYZRANGE);
			if ((strcmp(lex_buffer,K_VIEWBOX))==0)
				return(VIEWBOX);
			if ((strcmp(lex_buffer,K_VIEW))==0)
				return(VIEW);
			if ((strcmp(lex_buffer,K_PLOT3D))==0)
				return(PLOT3D);
			if ((strcmp(lex_buffer,K_PLOTL))==0)
				return(PLOTL);
			if ((strcmp(lex_buffer,K_PLOTP))==0)
				return(PLOTP);
			if ((strcmp(lex_buffer,K_PLOTGREY))==0)
				return(PLOTGREY);
			if ((strcmp(lex_buffer,K_PLOTCOLOR))==0)
				return(PLOTCOLOR);
			if ((strcmp(lex_buffer,K_PLOTCONT))==0)
				return(PLOTCONT);
			if ((strcmp(lex_buffer,K_PLOTVECT))==0)
				return(PLOTVECT);
			if ((strcmp(lex_buffer,K_MAGNIVECT))==0)
				return(MAGNIVECT);
			if ((strcmp(lex_buffer,K_AUTOSCALE))==0)
				return(AUTOSCALE);
			if ((strcmp(lex_buffer,K_NOAUTOSCALE))==0)
				return(NOAUTOSCALE);
			if ((strcmp(lex_buffer,K_COLORBAR))==0)
				return(COLORBAR);
			if ((strcmp(lex_buffer,K_GREYBAR))==0)
				return(GREYBAR);
			if ((strcmp(lex_buffer,K_AT))==0)
				return(AT);
			if ((strcmp(lex_buffer,K_SYSTEM))==0)
				return(SYSTEM);
			if ((strcmp(lex_buffer,K_BOX))==0)
				return(BOX);
			if ((strcmp(lex_buffer,K_BOX3D))==0)
				return(BOX3D);
			if ((strcmp(lex_buffer,K_COLOR))==0)
				return(COLOR);
			if ((strcmp(lex_buffer,K_FONT))==0)
				return(FONT);
			if ((strcmp(lex_buffer,K_SETCOLOR))==0)
				return(SETCOLOR);
			if ((strcmp(lex_buffer,K_BACKGROUND))==0)
				return(BACKGROUND);
			if ((strcmp(lex_buffer,K_LABEL))==0)
				return(LABEL);
			if ((strcmp(lex_buffer,K_LABEL3D))==0)
				return(LABEL3D);
			if ((strcmp(lex_buffer,K_TEXT))==0)
				return(TEXT);
			if ((strcmp(lex_buffer,K_GTEXT))==0)
				return(GTEXT);
			if ((strcmp(lex_buffer,K_LINESTYLE))==0)
				return(LINESTYLE);
			if ((strcmp(lex_buffer,K_LINEWIDTH))==0)
				return(LINEWIDTH);
			if ((strcmp(lex_buffer,K_RESOLUTION))==0)
				return(RESOLUTION);
			if ((strcmp(lex_buffer,K_SYMBOL))==0)
				return(SYMBOL);
			if ((strcmp(lex_buffer,K_LINE))==0)
				return(LINE);
			if ((strcmp(lex_buffer,K_BREAKPAGE))==0)
				return(BREAKPAGE);
			if ((strcmp(lex_buffer,K_CLOSEPAGE))==0)
				return(CLOSEPAGE);
			if ((strcmp(lex_buffer,K_FORMAT))==0)
				return(FORMAT);
			if ((strcmp(lex_buffer,K_FORMAT3D))==0)
				return(FORMAT3D);
			if ((strcmp(lex_buffer,K_PAUSE))==0)
				return(PAUSE);
			if ((strcmp(lex_buffer,K_SCALECHR))==0)
				return(SCALECHR);
			if ((strcmp(lex_buffer,K_SCALESYM))==0)
				return(SCALESYM);
			if ((strcmp(lex_buffer,K_CIRCLE))==0)
				return(CIRCLE);
			if ((strcmp(lex_buffer,K_CIRCLEP))==0)
				return(CIRCLEP);
			if ((strcmp(lex_buffer,K_PARCIRCLE))==0)
				return(PARCIRCLE);
			if ((strcmp(lex_buffer,K_WAFER))==0)
				return(WAFER);
			if ((strcmp(lex_buffer,K_MARK))==0)
				return(MARK);

			if ((strcmp(lex_buffer,K_EXIT))==0)
				return(EXIT);





			if ((strcmp(lex_buffer,K_SET))==0)
				return(SET);
			if ((strcmp(lex_buffer,K_SHOW))==0)
				return(SHOW);

/*** CONSTANTS **************************************************************/

/*** OUTPUT DEVICES ***/

			if ((strcmp(lex_buffer,C_XWIN))==0) {
				strcpy(temp_device_name,lex_buffer);
				return(DEVICE);}
			if ((strcmp(lex_buffer,C_PS))==0) {
				strcpy(temp_device_name,lex_buffer);
				return(DEVICE);}
			if ((strcmp(lex_buffer,C_XTERM))==0) {
				strcpy(temp_device_name,lex_buffer);
				return(DEVICE);}
			if ((strcmp(lex_buffer,C_XFIG))==0) {
				strcpy(temp_device_name,lex_buffer);
				return(DEVICE);}
			if ((strcmp(lex_buffer,C_TEKT))==0) {
				strcpy(temp_device_name,lex_buffer);
				return(DEVICE);}
			if ((strcmp(lex_buffer,C_TEKF))==0) {
				strcpy(temp_device_name,lex_buffer);
				return(DEVICE);}

/*** COLUMN IDENTIFIERS ***/

			if ((strcmp(lex_buffer,C_XCOL))==0) {
				return(FORMX);}
			if ((strcmp(lex_buffer,C_YCOL))==0) {
				return(FORMY);}
			if ((strcmp(lex_buffer,C_ZCOL))==0) {
				return(FORMZ);}
			if ((strcmp(lex_buffer,C_CCOL))==0) {
				return(FORMC);}
			if ((strcmp(lex_buffer,C_BNP))==0) {
				return(FORMBNP);}
			if ((strcmp(lex_buffer,C_FNP))==0) {
				return(FORMFNP);}

/*** COLORS ***/

			if ((strcmp(lex_buffer,K_CORAL))==0) {
				lex_number=0;
				return(ACOLOR);}
			if ((strcmp(lex_buffer,K_RED))==0) {
				lex_number=1;
				return(ACOLOR);}
			if ((strcmp(lex_buffer,K_YELLOW))==0) {
				lex_number=2;
				return(ACOLOR);}
			if ((strcmp(lex_buffer,K_GREEN))==0) {
				lex_number=3 ;
				return(ACOLOR);}
			if ((strcmp(lex_buffer,K_AQUAMARINE))==0) {
				lex_number=4 ;
				return(ACOLOR);}
			if ((strcmp(lex_buffer,K_PINK))==0) {
				lex_number=5 ;
				return(ACOLOR);}
			if ((strcmp(lex_buffer,K_WHEAT))==0) {
				lex_number=6 ;
				return(ACOLOR);}
			if ((strcmp(lex_buffer,K_GREY))==0) {
				lex_number=7 ;
				return(ACOLOR);}
			if ((strcmp(lex_buffer,K_BROWN))==0) {
				lex_number=8 ;
				return(ACOLOR);}
			if ((strcmp(lex_buffer,K_BLUE))==0) {
				lex_number=9 ;
				return(ACOLOR);}
			if ((strcmp(lex_buffer,K_BLUEVIOLET))==0) {
				lex_number=10;
				return(ACOLOR);}
			if ((strcmp(lex_buffer,K_CYAN))==0) {
				lex_number=11;
				return(ACOLOR);}
			if ((strcmp(lex_buffer,K_TURQUOISE))==0) {
				lex_number=12;
				return(ACOLOR);}
			if ((strcmp(lex_buffer,K_MAGENTA))==0) {
				lex_number=13;
				return(ACOLOR);}
			if ((strcmp(lex_buffer,K_SALMON))==0) {
				lex_number=14;
				return(ACOLOR);}
			if ((strcmp(lex_buffer,K_WHITE))==0) {
				lex_number=15;
				return(ACOLOR);}
			if ((strcmp(lex_buffer,K_BLACK))==0) {
				lex_number=16;
				return(ACOLOR);}

/*** FONTS ***/

			if ((strcmp(lex_buffer,K_NORMAL))==0) {
				lex_number=1;
				return(AFONT);}
			if ((strcmp(lex_buffer,K_ROMAN))==0) {
				lex_number=2;
				return(AFONT);}
			if ((strcmp(lex_buffer,K_ITALIC))==0) {
				lex_number=3;
				return(AFONT);}
			if ((strcmp(lex_buffer,K_SCRIPT))==0) {
				lex_number=4;
				return(AFONT);}


/*** ORIENTATIONS ***/

			if ((strcmp(lex_buffer,K_LANDSCAPE))==0) {
				lex_number=LANDSCAPE;
				return(ANORIENTATION);}
			if ((strcmp(lex_buffer,K_PORTRAIT))==0) {
				lex_number=PORTRAIT;
				return(ANORIENTATION);}

			
/*** VARIABLES ***************************************************************/

			if ((strcmp(lex_buffer,V_CXMIN))==0){
				avar = CXMIN;
				return(IDENTIFIER);}
			if ((strcmp(lex_buffer,V_CYMIN))==0){
				avar = CYMIN;
				return(IDENTIFIER);}
			if ((strcmp(lex_buffer,V_CXMAX))==0){
				avar = CXMAX;
				return(IDENTIFIER);}
			if ((strcmp(lex_buffer,V_CYMAX))==0){
				avar = CYMAX;
				return(IDENTIFIER);}
			return(UNKNOWN);
			break;
			}

/*****************************************************************************/

		case L_DIGIT: {
			lex_number= (double) atof(lex_buffer); 
/*			sscanf(lex_buffer,"%lf",&lex_number); */
			return(NUMBER);
			break;
			}	
		case (L_STRING): {
			lex_buffer[nc]=0;
			return(STRING);
			break;
			}
		case L_PUNCT: {
			lex_sep=lex_buffer[0];
			if (lex_sep=='!') {
				return(SYS);
				break;
				plend();
				exit(0);
				}
			  else {
				switch(lex_sep) {
					case '"': {return(QUOTE);break;}
					case '(': {return(OPENPAR);break;}
					case ')': {return(CLOSEPAR);break;}
					case '[': {return(OPENSQUARE);break;}
					case ']': {return(CLOSESQUARE);break;}
					case ',': {return(COMMA);break;}
					case ':': {return(COLON);break;}
					case ';': {return(SEMICOLON);break;}
					case '=': {return(EQUAL);break;}
					case '#': {return(COMMENT);break;}
					case '\n': {return(ENDOFLINE);break;}
				}
				return(SEPARATOR);
			       }
			break;
			}
		}
}

