/*
   Getkey.c

   Written 01/16/1991 by John Gordon, adapted from code supplied by Tim Evans

   The purpose of this program is to set ioctl to "raw" mode, read a keypress,
   reset the ioctl mode, and return the character read.

   History:
   01/16/91 by John Gordon - initial version adapted from Tim's code
*/

#ifndef __CYGWIN32__
#if __linux
# include <termios.h>
#else
# include <termio.h>
#endif
#endif
#include <stdio.h>
#include <string.h>

int getkey()
{
  int c;
#ifndef __CYGWIN32__
#if defined(____hpux) || defined(__linux)
  struct termios tsav, tchg;
#else
  struct termio tsav, tchg;
#endif

  if (ioctl(0, TCGETA, &tsav) == -1)
  {
    perror("getkey: can't get original settings");
    exit(2);
  }

  tchg = tsav;

  tchg.c_lflag &= ~(ICANON | ECHO);
  tchg.c_cc[VMIN] = 1;
  tchg.c_cc[VTIME] = 0;

  if (ioctl(0, TCSETA, &tchg) == -1)
  { 
    perror("getkey: can't initiate new settings");
    exit (3);
  }
#endif

  c = getchar();

#ifndef __CYGWIN32__
  if(ioctl( 0, TCSETA, &tsav) == -1)
  {
    perror("getkey: can't reset original settings");
    exit(4);
  }
#endif

  return(c);

} /* end getkey() */


#if NOTDEF

/*
 * getopt - get option letter from argv
 *      This software is in the public domain
 *      Originally written by Henry Spencer at the U. of Toronto
 */

#include <stdio.h>

char    *optarg;        /* Global argument pointer. */
int     optind = 0;     /* Global argv index. */

static char     *scan = NULL;   /* Private scan pointer. */

/* extern char     *index();  obsolete, used strchr (JDC). */

int
getopt(argc, argv, optstring)
int argc;
char *argv[];
char *optstring;
{
        register char c;
        register char *place;

        optarg = NULL;

        if (scan == NULL || *scan == '\0') {
                if (optind == 0)
                        optind++;

                if (optind >= argc || argv[optind][0] != '-' || argv[optind][1] == '\0')
                        return(EOF);
                if (strcmp(argv[optind], "--")==0) {
                        optind++;
                        return(EOF);
                }

                scan = argv[optind]+1;
                optind++;
        }

        c = *scan++;
        place = strchr(optstring, c);

        if (place == NULL || c == ':') {
                fprintf(stderr, "%s: unknown option -%c\n", argv[0], c);
                return('?');
        }

        place++;
        if (*place == ':') {
                if (*scan != '\0') {
                        optarg = scan;
                        scan = NULL;
                } else {
                        optarg = argv[optind];
                        optind++;
                }
        }

        return(c);
}

#endif

