/*****************************************************************************
 *                                                                           *
 *  PRIMVS - Graphic Interpreter for X-Ray Lithography
 *                                                                           *
 ***************************************************************************** 
 *
 *  Author:   Luigi Capodieci
 *  Project:  PLPLOT based graphic interpreter
 *
 *  $Source: 
 *  $Revision:
 *  $Date: 
 *  $Log: externs.h,v $
 *  Revision 1.1.1.1  1996/07/11 13:52:44  khan
 *  Initial checkin of SHADOW 2.1 distribution sources
 *
 * Revision 1.1.1.1  1996/01/02  17:07:39  khan
 * Toolset 2.0 release
 *
 *****************************************************************************/ 

/****** External variables ***************************************************/

extern  char	*optarg;

extern  int	optind, opterr;
extern	int	SEED;

extern	FILE	*infile,*outfile,*errfile,*gfile;
extern	FILE	*deftablefile;
extern	char	deftable_name[MAX_WORD_LENGTH];

extern	char		lex_buffer[MAX_WORD_LENGTH];
extern	double		lex_number;
extern	int		ch,lex_sep;
extern	int		nc;
extern	var_type	avar;

extern	int		curr_page;
extern	int		temp_subpage;
extern	int		window_ok,multiwindow_ok;
extern	int		charset;

extern	char	function_filename[MAX_WORD_LENGTH];
extern	FILE	*functionfile;

extern	char	device_name[MAX_WORD_LENGTH];
extern	char	graph_filename[MAX_WORD_LENGTH];
extern	FILE	*graphfile;
extern	int	temp_orientation,orientation;

extern	int             curr_win;
extern	double          cxmin,cxmax,cymin,cymax;
extern	double		czmin,czmax;
extern	int             cnx,cny;

extern	double		pposxmin,pposxmax,pposymin,pposymax;
extern	double		mposxmin,mposxmax,mposymin,mposymax;
extern	double		pratio;
extern	double		scalechr,scalesym;

extern	int		screen_active,text_active;

extern	double		temp_xmin,temp_xmax,temp_ymin,temp_ymax;
extern	double		temp_zmin,temp_zmax;
extern	double		temp_ratio;
extern	double		temp_scalechr,temp_scalesym;
extern	int		temp_cnx,temp_cny;
extern	char		temp_device_name[MAX_WORD_LENGTH];

extern	char		temp_xoptions[MAX_WORD_LENGTH],temp_yoptions[MAX_WORD_LENGTH];
extern	char		xoptions[MAX_WORD_LENGTH],yoptions[MAX_WORD_LENGTH];

extern	char		temp_zoptions[MAX_WORD_LENGTH], zoptions[MAX_WORD_LENGTH];

extern	double		temp_xtickint,temp_ytickint,xtickint,ytickint;
extern	int		temp_xticksub,temp_yticksub,xticksub,yticksub;
extern	double		temp_ztickint,ztickint;

extern	int		temp_color,color;

extern	char		temp_xlabel[MAX_WORD_LENGTH];
extern	char		temp_ylabel[MAX_WORD_LENGTH];
extern	char		temp_tlabel[MAX_WORD_LENGTH];
extern	char		temp_zlabel[MAX_WORD_LENGTH];
extern	char		xlabel[MAX_WORD_LENGTH];
extern	char		ylabel[MAX_WORD_LENGTH];
extern	char		tlabel[MAX_WORD_LENGTH];
extern	char		zlabel[MAX_WORD_LENGTH];

extern	char		temp_side[MAX_WORD_LENGTH];
extern	double		temp_ref_ypos,temp_ref_xpos,temp_ref_just;
extern	char		temp_text[MAX_WORD_LENGTH];
extern	double          temp_txpos,temp_typos,temp_tdxpos,temp_tdypos;

extern	char		side[MAX_WORD_LENGTH];
extern	double		ref_ypos,ref_xpos,ref_just;
extern	char		text[MAX_WORD_LENGTH];
extern	double          txpos,typos,tdxpos,tdypos;


extern	int		temp_linestyle,temp_linewidth;
extern	int		linestyle,linewidth;
extern	float		temp_resol,resol;

extern	int		parse_error,atcommand,ccol_flag,xcol_flag,ycol_flag;
extern	int		bnp_flag,fnp_flag,endformat;
extern	int		style_flag,ranges_flag;

extern	int             temp_xcol;
extern	int             temp_ycol;
extern	int             temp_zcol;
extern	int             temp_ccol;
extern	int		temp_bnp,temp_fnp;

extern	int             xcol;
extern	int             ycol;
extern	int             zcol;
extern	int             ccol;
extern	int		bnp,fnp;

extern	float		xx[MAX_X],yy[MAX_Y];
extern	float		dx[MAX_X],dy[MAX_Y];
extern	double		magx,magy;
extern	float		cc[MAX_C];
extern	int		temp_symbol,point_symbol;

extern	float 		*xxx, *yyy, **zzz;
extern	float		xxxmin,xxxmax,yyymin,yyymax,zzzmin,zzzmax;
extern	int		alloc3d,datain;
extern	int		np,nx,ny;
extern	int		temp_dataformat;

extern	double		lx1,ly1,lx2,ly2;
extern	double		temp_x1,temp_y1,temp_x2,temp_y2;

extern	double		temp_xc,temp_yc,temp_radius,temp_arc;
extern	double		xc,yc,radius,arc;
extern	int		temp_wafertype,wafertype;

extern	double		temp_xm,temp_ym;
extern	int		temp_mark;

extern	int		scaleflag;

extern	double		temp_basex,temp_basey,temp_height;
extern	double		basex,basey,height;
extern	double		temp_alt,temp_azi;
extern	double		alt,azi;

extern	int		temp_opt3d;
extern	int		opt3d;

extern	int		temp_nlevel,nlevel;


/****** External functions *************************************************/

extern	void		initialize();

extern	token_type	lexical();

extern	void		skipspace();

extern	int		isminusplus();

extern	int		isseparator();

extern	void		interpret();

extern	void		exec_plotl();
extern	void		exec_plotp();
extern	void		exec_plotgrey();
extern	void		exec_plotcolor();
extern	void		exec_greybar();
extern	void		exec_colorbar();

extern	void		error_msg();
extern	void		error_msg_nl();
extern	void		flushcommand();
extern	void		prompt();

extern	int		total_subpages();

extern	void		exec_assign();

extern	void		exec_initpage();

extern	void		exec_initmultipage();
 
extern	void		exec_regionp();
extern	void		exec_regionm();
extern	void		exec_regionr();

extern	void		exec_xyrange();
extern	void		exec_xyzrange();
extern	void		exec_viewbox();
extern	void		exec_view();
extern	void		exec_plot3d();
extern	void		exec_plotcont();

extern	void		exec_box();
extern	void		exec_box3d();

extern	void		exec_color();
extern	void		exec_setcolor();
extern	void		exec_background();
extern	void		exec_scalechr();
extern	void		exec_scalesym();

extern	void		exec_label();
extern	void		exec_label3d();
extern	void		exec_text();
extern	void		exec_gtext();

extern	void		exec_linestyle();
extern	void		exec_linewidth();
extern	void		exec_resolution();

extern	void		exec_format();

extern	int		read_xyc();
extern	int		read_image();

extern	void		exec_breakpage();
extern	void		exec_closepage();
extern	void		exec_line();

extern	void		exec_circle();
extern	void		exec_parcircle();
extern	void		exec_wafer();

extern	void		exec_mark();

extern	void		plotvect();

extern	var_type	findvar();
extern	void		read_default();
extern	void		read_built_in();

extern	void		exec_orientation();

extern	int		getkey();
extern	int		getopt();

extern	void		xwesc_rgb();
extern	void		setgrey();
/*****************************************************************************/ 
