/*****************************************************************************
 *                                                                           *
 *  PRIMVS - Graphic Interpreter for X-Ray Lithography
 *                                                                           *
 ***************************************************************************** 
 *
 *  Author:   Luigi Capodieci
 *  Project:  PLPLOT based graphic interpreter
 *
 *  $Source: 
 *  $Revision:
 *  $Date: 
 *  $Log: define.h,v $
 *  Revision 1.1.1.1  1996/07/11 13:52:44  khan
 *  Initial checkin of SHADOW 2.1 distribution sources
 *
 * Revision 1.1.1.1  1996/01/02  17:07:39  khan
 * Toolset 2.0 release
 *
 *****************************************************************************/ 

/* #define		TRUE		(1) */
/* #define		FALSE		(0) */

#define		RANDOM_MAX		(0x7FFFFFFF)
#define		GREYLEVELS		(99)

#define		NORMAL_CHARSET		(0)
#define		EXT_CHARSET		(1)

#define		K_INITPAGE		"initpage"
#define		K_INITMULTIPAGE		"initmultipage"
#define		K_ORIENTATION		"orientation"
#define		K_LANDSCAPE		"landscape"
#define		K_PORTRAIT 		"portrait"
#define		K_SUBPAGE		"subpage"
#define		K_REGIONP		"regionp"
#define		K_REGIONM		"regionm"
#define		K_REGIONR		"regionr"
#define		K_XYRANGE		"xyrange"
#define		K_XYZRANGE		"xyzrange"
#define		K_VIEWBOX		"viewbox"
#define		K_VIEW			"view"
#define		K_PLOT3D		"plot3d"
#define		K_PLOTL			"plotl"
#define		K_PLOTP			"plotp"
#define		K_PLOTGREY		"plotgrey"
#define		K_PLOTCOLOR		"plotcolor"
#define		K_PLOTCONT		"plotcont"
#define		K_PLOTVECT		"plotvect"
#define		K_MAGNIVECT		"magnivect"
#define		K_AUTOSCALE		"autoscale"
#define		K_NOAUTOSCALE		"noautoscale"
#define		K_COLORBAR		"colorbar"
#define		K_GREYBAR		"greybar"
#define		K_AT			"at"
#define		K_SYSTEM		"system"
#define		K_FONT			"font"

#define		K_BOX			"box"
#define		K_BOX3D			"box3d"
#define		K_COLOR			"color"
#define		K_SETCOLOR		"setcolor"
#define		K_BACKGROUND		"background"
#define		K_LABEL			"label"
#define		K_LABEL3D		"label3d"
#define		K_TEXT			"text"
#define		K_GTEXT			"gtext"
#define		K_LINESTYLE		"linestyle"
#define		K_LINEWIDTH		"linewidth"
#define		K_RESOLUTION		"resolution"
#define		K_SYMBOL		"symbol"
#define		K_LINE			"line"
#define		K_BREAKPAGE		"breakpage"
#define		K_CLOSEPAGE		"closepage"
#define		K_PAUSE			"pause"
#define		K_EXIT			"exit"
#define		K_SCALECHR		"scalechr"
#define		K_SCALESYM		"scalesym"

#define		K_CIRCLE		"circle"
#define		K_CIRCLEP		"circlep"
#define		K_PARCIRCLE		"parcircle"
#define		K_WAFER			"wafer"
#define		K_MARK			"mark"

#define		K_FORMAT		"format"
#define		K_FORMAT3D		"format3d"
#define		C_XCOL			"x"
#define		C_YCOL			"y"
#define		C_ZCOL			"z"
#define		C_CCOL			"c"
#define		C_BNP			"b"
#define		C_FNP			"e"

/*** Colors ***/

#define		K_CORAL			"coral"
#define		K_RED			"red"
#define		K_YELLOW		"yellow"
#define		K_GREEN			"green"
#define		K_AQUAMARINE		"aquamarine"
#define		K_PINK			"pink"
#define		K_WHEAT			"wheat"
#define		K_GREY			"grey"
#define		K_BROWN			"brown"
#define		K_BLUE			"blue"
#define		K_BLUEVIOLET		"blueviolet"
#define		K_CYAN			"cyan"
#define		K_TURQUOISE		"turquoise"
#define		K_MAGENTA		"magenta"
#define		K_SALMON		"salmon"
#define		K_WHITE			"white"
#define		K_BLACK			"black"

/*** Fonts ***/

#define		K_NORMAL		"normal"
#define		K_ROMAN			"roman"
#define		K_ITALIC		"italic"
#define		K_SCRIPT		"script"


#define		LANDSCAPE		(0)
#define		PORTRAIT		(1)


/*** Hic sunt leones ***/
#define		K_SET			"set"
#define		K_SHOW			"show"

/*** OUTPUT DEVICES **********************************************************/

#define		C_XWIN			"xwin"
#define		C_XTERM			"xterm"
#define		C_TEKT			"tekt"
#define		C_PS			"ps"
#define		C_XFIG			"xfig"
#define		C_TEKF			"tekf"

/*** VARIABLES ***************************************************************/ 

#define		V_CXMIN			"cxmin"
#define		V_CXMAX			"cxmax"
#define		V_CYMIN			"cymin"
#define		V_CYMAX			"cymax"
#define		V_PPOSXMIN		"pposxmin"
#define		V_PPOSXMAX		"pposxmax"
#define		V_PPOSYMIN		"pposymin"
#define		V_PPOSYMAX		"pposymax"
#define		V_MPOSXMIN		"mposxmin"
#define		V_MPOSXMAX		"mposxmax"
#define		V_MPOSYMIN		"mposymin"
#define		V_MPOSYMAX		"mposymax"
#define		V_CNX			"cnx"
#define		V_CNY			"cny"
#define		V_XOPTIONS		"xoptions"
#define		V_YOPTIONS		"yoptions"
#define		V_XTICKINT		"xtickint"
#define		V_YTICKINT		"ytickint"
#define		V_XTICKSUB		"xticksub"
#define		V_YTICKSUB		"yticksub"
#define		V_CLR			"clr"
#define		V_XLABEL		"xlabel"
#define		V_YLABEL		"ylabel"
#define		V_TLABEL		"tlabel"
#define		V_ZLABEL		"zlabel"
#define		V_LSTY			"lsty"
#define		V_LWID			"lwid"
#define		V_LSYM			"lsym"
#define		V_DEVNAME		"devname"
#define		V_GRAPHNAME		"graphname"


/*****************************************************************************/ 

typedef	enum tokens {
			INITPAGE,
			INITMULTIPAGE,
			ORIENTATION,
			ANORIENTATION,
			SUBPAGE,
			REGIONP,
			REGIONM,
			REGIONR,
			XYRANGE,
			XYZRANGE,
			VIEWBOX,
			VIEW,
			PLOT3D,
			PLOTP,
			PLOTL,
			PLOTGREY,
			PLOTCOLOR,
			PLOTCONT,
			PLOTVECT,
			MAGNIVECT,
			AUTOSCALE,
			NOAUTOSCALE,
			COLORBAR,
			GREYBAR,
			AT,
			SYSTEM,
			FONT,
			AFONT,
			SYS,
			BOX,
			BOX3D,
			SETCOLOR,
			COLOR,
			ACOLOR,
			BACKGROUND,
			LABEL,
			LABEL3D,
			TEXT,
			GTEXT,
			LINESTYLE,
			LINEWIDTH,
			RESOLUTION,
			SYMBOL,
			LINE,
			BREAKPAGE,
			CLOSEPAGE,
			COMMENT,
			ENDOFLINE,
			FORMAT,
			FORMAT3D,
			FORMX,
			FORMY,
			FORMZ,
			FORMC,
			FORMBNP,
			FORMFNP,
			PAUSE,
			EXIT,
			SCALECHR,
			SCALESYM,
			CIRCLE,
			CIRCLEP,
			PARCIRCLE,
			WAFER,
			MARK,

			SHOW,
			SET,
			DEVICE,
			IDENTIFIER,
			UNKNOWN,
			NUMBER,
			SEPARATOR,
			STRING,
			OPENPAR,CLOSEPAR,
			OPENSQUARE,CLOSESQUARE,
			COMMA,COLON,SEMICOLON,
			QUOTE,EQUAL,ENDOFFILE
		    } token_type;

typedef enum lex_st {
			L_START,
			L_END,
			L_ALPHA,
			L_DIGIT,
			L_PUNCT,
			L_STRING
		    } lex_state_type;

typedef enum vars {
	PPOSXMIN,PPOSXMAX,PPOSYMIN,PPOSYMAX,
	MPOSXMIN, MPOSXMAX,MPOSYMIN,MPOSYMAX,
	CXMIN,CXMAX,CYMIN,CYMAX,CNX,CNY,
	XOPTIONS,YOPTIONS,XTICKINT,YTICKINT,XTICKSUB,YTICKSUB,
	CLR,LSTY,LWID,PSYM,DEVNAME,GRAPHNAME,
	XLABEL,YLABEL,TLABEL,ZLABEL
		} var_type;

		
/*****************************************************************************
*
*   Declaration of the g-routines (patch for reading an EXCON gfile)
*
 *****************************************************************************/ 

    void g_file(const char*);
    void g_close();
    double g_number(const char*, const char*, double*);
    int g_int(const char*, const char*, int*);
    char* g_string(const char*, const char*, char[]);
    int	g_peek(const char*);

/*****************************************************************************/ 
