/* Test of drawing a histogram */
/* $Id: x05c.c,v 1.1.1.1 1996/07/11 13:53:21 khan Exp $
   $Log: x05c.c,v $
   Revision 1.1.1.1  1996/07/11 13:53:21  khan
   Initial checkin of SHADOW 2.1 distribution sources

 * Revision 1.5  1993/02/22  23:16:13  mjl
 * Changed over to new style of initialization using plinit(), and added
 * function to parse plplot command line flags.
 *
 * Revision 1.4  1993/01/23  06:10:25  mjl
 * Instituted exit codes for all example codes.  Also deleted color functions
 * no longer supported (plancol).  Enhanced x09c to exploit new contour
 * capabilities.
 *
 * Revision 1.3  1992/09/30  18:25:17  furnish
 * Massive cleanup to irradicate garbage code.  Almost everything is now
 * prototyped correctly.  Builds on HPUX, SUNOS (gcc), AIX, and UNICOS.
 *
 * Revision 1.2  1992/09/29  04:45:13  furnish
 * Massive clean up effort to remove support for garbage compilers (K&R).
 *
 * Revision 1.1  1992/05/20  21:32:53  furnish
 * Initial checkin of the whole PLPLOT project.
 *
*/

/* Note the compiler should automatically convert all non-pointer arguments
   to satisfy the prototype, but some have problems with constants. */

#include "plplot.h"
#include <stdlib.h>
#include <math.h>

int
main(int argc, char *argv[])
{
    int i;
    static PLFLT data[2048];

/* Parse and process command line arguments */

    (void) plParseInternalOpts(&argc, argv, PL_PARSE_FULL);

/* Initialize plplot */

    plinit();

/* Fill up data points */

    for (i = 0; i < 2048; i++)
	data[i] = sin(0.01 * (i + 1));

    plcol(1);
    plhist(2048, data, (PLFLT) -1.1, (PLFLT) 1.1, 44, 0);
    plcol(2);
    pllab("#frValue", "#frFrequency",
	  "#frPLPLOT Example 5 - Probability function of Oscillator");

    plend();
    exit(0);
}
