C +++
C
C Source: src/tools/opcon/genlib.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	genlib.F
C Revision 1.3  90/11/13  14:02:47  khan
C Cleanup and SAVE statements
C 
C Revision 1.2  90/10/10  11:28:17  khan
C Fix for off by 1 error in record number.
C 
C Revision 1.1  90/10/08  21:50:30  khan
C Initial revision
C 
C 
C ---

C+++
C	PROGRAM		GENLIB
C
C	PURPOSE		To generate an indexed library of f1 and f2, using
C			CXRO table for lower energy (10eV-10KeV) and 
C			Cromer's for higher energy (10-100KeV).
C
C---
	INTEGER AT_NUMBER1,AT_NUMBER2
C
C REALBUF = at_number + at_wt + rmu + emf + f1(420) + f2(420) = 844 elements
C
	REAL*4 REALBUF(844), ENG(420), F1(420), F2(420)
C
C  4bytes*REALBUF(844) = 3376bytes
C
        CHARACTER*1 ELEMENT(2)
	CHARACTER*2	ELE1,ELE2
C
C  Open the low energy file.
C
#ifdef vms
	OPEN (UNIT=21,FILE='PRELIB1.DAT',STATUS='OLD',READONLY)
#else
	OPEN (UNIT=21,FILE='PRELIB1.DAT',STATUS='OLD')
#endif

C
C  Open the high energy file.
C
#ifdef vms
	OPEN (UNIT=22,FILE='PRELIB2.DAT',STATUS='OLD',READONLY)
#else
	OPEN (UNIT=22,FILE='PRELIB2.DAT',STATUS='OLD')
#endif
C
C  OPEN THE FILE TO HOLD THE KEYED ACCESS LIBRARY
C
#ifdef vms
	OPEN(UNIT=23,FILE='F12LIB.FULL',STATUS = 'NEW',
     $	ACCESS='DIRECT',RECL=3376)
#else
	OPEN(UNIT=23,FILE='F12LIB.FULL',STATUS = 'UNKNOWN',
     $	ACCESS='DIRECT',RECL=3376)
#endif
C
C Read the energy scale, then write it out to the library with index '99'.
C
	READ	(21,*)	(ENG(I), I = 1, 301)
	READ	(22,*)	(ENG(I), I = 301, 420)
	DO 11 I = 1, 420
	  REALBUF(I)	= ENG(I)
11 	CONTINUE
	WRITE	(23, REC=1)	REALBUF
C
C  READ IN A SET OF DATA FOR AN ELEMENT FROM THE SOURCE LIBRARY
C  AND PUT IT INTO ARRAY REALBUF, THEN TO BUFFER.
C
	DO 100 I=1,100
	READ(21,111,END=999)	ELE1
111	FORMAT (1X,A2)
	READ(21,*,ERR=1000) 	AT_NUMBER1,NSTEP,AT_WT,RMU,EMF

	READ(22,112,END=999)	ELE2
112	FORMAT	(1X,A2)
	READ(22,*,ERR=1000) 	AT_NUMBER2,NSTEP
	IF (ELE1.NE.ELE2) WRITE(6,*) 'Error ! Unequal atomic symbol.'
	IF (AT_NUMBER1.NE.AT_NUMBER2) 
     $		WRITE(6,*) 'Error ! Unequal atomic number.'
C
C  PUT THIS DATA INTO BUFFER AND REALBUF
C
        READ (ELE1,113) 	ELEMENT(1),ELEMENT(2)
113     FORMAT(2A1)
	REALBUF(1) = AT_NUMBER1
	REALBUF(2) = AT_WT
	REALBUF(3) = RMU
	REALBUF(4) = EMF
C
C  READ IN THE F1 ARRAY
C
	READ(22,*) (F1(K),K=301,420)
	READ(21,*) (F1(K),K=1,301)
C
C  READ IN THE F2 ARRAY
C
	READ(22,*) (F2(K),K=301,420)
	READ(21,*) (F2(K),K=1,301)
C
C  TRANSPOSE THE F1, F2 DATA INTO REALBUF
C
	DO 12 K=1,420
	REALBUF(K+4) = F1(K)
12	CONTINUE
	DO 13 K=1,420
	REALBUF(K+424) = F2(K)
13 	CONTINUE
C
C  WRITE THE DATA FOR THE ELEMENT INTO THE SINGLE ACCESS FILE
C
	WRITE (23, REC=I+1) REALBUF
C
C INDICATE ON THE TERMINAL ENTRY HAS BEEN MADE
C
	WRITE(6,10)(ELEMENT(J),J=1,2),AT_NUMBER1
10	FORMAT(3X,'COMPLETED ENTRY FOR:',2A1,1X,'AT_NUMBER:',I2)
100	CONTINUE
	GO TO 999
1000	WRITE (6,1001)
1001	FORMAT(3X,'ERROR READING SOURCE FILE')
	GO TO 999
99	WRITE (6,101)(ELEMENT(J),J=1,2)
101	FORMAT(3X,'ERROR AT:',2A1)
999	CLOSE(21)
	CLOSE(23)
	CLOSE (22)
	END 	
