	subroutine whatx
	implicit integer (a-z)
c++
c  Implements the following subroutines:
c
c	what_a		- get alpha value 
c			  this is valid for any data type
c
c	what_i		- get integer value
c			  this is valid only for int/enumerated/yesno types
c
c	what_r		- get double precision real value
c			  this is valid only for data type real
c--
#if defined(unix) || HAVE_F77_CPP
#       include "parms.inc"
#       include "nldata.inc"
#elif defined(vms)
	include 'parms.inc'
	include 'nldata.inc'
#endif
c
	double precision rval
	character*(*) name,string
	character*(*) rec
c
c  find integer
c
	entry what_i (rec,name,own1,own2,ival)
	key=0
	call nl_find (key,rec,name,own1,own2)
	if (key .eq. 0) goto 900
	if (nl_datatype .ne. 'I' .and. nl_datatype .ne. 'E' .and.
     *			nl_datatype .ne. 'Y') goto 920
	ival=nl_int
	return
c
c  find string
c
	entry what_a (rec,name,own1,own2,string)
	key=0
	call nl_find (key,rec,name,own1,own2)
	if (key .eq. 0) goto 900
	string=nl_string
	return
c
c  find double precision real number
c
	entry what_r (rec,name,own1,own2,rval)
	key=0
	call nl_find (key,rec,name,own1,own2)
	if (key .eq. 0) goto 900
	if (nl_datatype .ne. 'R') goto 910
	rval=nl_real
	return
c
c  find yes/no (just like integer)
c
	entry what_y (rec,name,own1,own2,ival)
	key=0
	call nl_find (key,rec,name,own1,own2)
	if (key .eq. 0) goto 900
	if (nl_datatype .ne. 'Y') goto 920
	ival=nl_int
	return
c	
c  fatal error - variable not found
c
 900	write (message,901) rec,name,own1,own2
 901	format ('WHAT_X: Could not find record "',a,
     *		'" Variable "',a,'" Own1/Own2= "',i4,' / ',i4,'"')
	call fatal
c
 910	write (message,911) rec,name,nl_datatype
 911	format ('WHAT_R: Datatype of ',a,' / ',a,' is "',a,
     *			'" - not "R"')
	call fatal
c
 920	write (message,921) rec,name,nl_datatype
 921	format ('WHAT_I: Datatype of ',a,' / ',a,' is "',a,
     *			'" - neither "I","E", or "Y"')
	call fatal
	end

	subroutine storex
	implicit integer (a-z)
c++
c
c  Implements the following routines which convert the internal
c    representation to external representation and store both in
c    the namelist tables.
c
c	store_a (rec,name,own1,own2,string) - store alpha value
c	store_ei(rec,name,own1,own2,number) - store enumerated data type values
c	store_ea(rec,name,own1,own2,string) - store enumerated data type values
c	store_i	(rec,name,own1,own2,number) - store integer value
c	store_r	(rec,name,own1,own2,d.p. real)	- store real value
c	store_y	(rec,name,own1,own2,number)	- store yes/no values
c--
	character*(*) rec
	character*(*) name
	character*(*) string
c
	double precision dreal
c
#if defined(unix) || HAVE_F77_CPP
#       include "parms.inc"
#       include "nldata.inc"
#elif defined(vms)
	include 'parms.inc'
	include 'nldata.inc'
#endif
c
c  alphanumeric
c
	entry store_a (rec,name,own1,own2,string)
	key=0
	call nl_find (key,rec,name,own1,own2)
	if (key .eq. 0) goto 900
	nl_datatype='A'
	nl_string=string
	nl_int=0
	nl_real=0.0d0
	call nl_update (key)
	return
c
c  enumerated with numeric argument
c
	entry store_ei (rec,name,own1,own2,number)
	key=0
	call nl_find (key,rec,name,own1,own2)
	if (key .eq. 0) goto 900
	nl_datatype='E'
	call format_e (name,number,nl_string)
	nl_int=number
	nl_real=0.0d0
	call nl_update (key)
	return
c
c  enumerated with string argument
c
	entry store_ea (rec,name,own1,own2,string)
	key=0
	call nl_find (key,rec,name,own1,own2)
	if (key .eq. 0) goto 900
	call translate_synonym (name,string,nl_int,nl_string)
	nl_datatype='E'
	nl_real=0.0d0
	if (nl_int .lt. 0) nl_string='<Undefined>'
	call nl_update (key)
	return
c
c  integer
c
	entry store_I (rec,name,own1,own2,number)
	key=0
	call nl_find (key,rec,name,own1,own2)
	if (key .eq. 0) goto 900
	nl_datatype='I'
	call format_i (number,nl_string)
	nl_int=number
	nl_real=0.0d0
	call nl_update (key)
	return
c
c  real double precision
c
	entry store_r (rec,name,own1,own2,dreal)
	key=0
	call nl_find (key,rec,name,own1,own2)
	if (key .eq. 0) goto 900
	nl_datatype='R'
	call format_r (dreal,nl_string)
	nl_int=0
	nl_real=dreal
	call nl_update (key)
	return
c
c  yes/no
c
	entry store_y (rec,name,own1,own2,number)
	key=0
	call nl_find (key,rec,name,own1,own2)
	if (key .eq. 0) goto 900
	call format_y (number,nl_string)
	nl_datatype='Y'
     	nl_int=number
	nl_real=0.0d0
	call nl_update (key)
	return
c
 900	write (message,901) rec,name
 901	format ('STORE_X: Can''t locate ',a,' / ',a)
	call fatal
	stop
	end
