	subroutine erase_page (row,col)
	implicit none 
c++
c  subroutine erase_page (row,col)
c
c  Erases from specified cursor position to the end of display
c
c  row		- input/integer*4
c  col		- input/integer*4
c--
	integer*4	row
	integer*4	col
#ifdef vms
c
	include		'io.inc'
c
	integer*4	code
c
	integer*4	smg$erase_display
c
	code=smg$erase_display (displayID,row,col, , )
	call check (code)
#else
	call curses_erase_page (row, col)
#endif
	return
	end

	subroutine erase_line (row,col)
	implicit none 
c++
c  subroutine erase_line (row,col)
c
c  Erases from specified cursor position to the end of line
c
c  row		- input/integer*4
c  col		- input/integer*4
c--
	integer*4	row
	integer*4	col
#ifdef vms
c
	include		'io.inc'
c
	integer*4	code
c
	integer*4	smg$erase_line
c
	code=smg$erase_line (displayID,row,col)
	call check (code)

#else
	call curses_erase_line (row, col)
#endif
	return
	end

	subroutine set_cursor (row,col)
	implicit none 
c++
c  subroutine set_cursor (row,col)
c
c  Moves cursor to the specified position
c
c  row		- input/integer*4
c  col		- input/integer*4
c--
	integer*4	row
	integer*4	col
#ifdef vms
c
	include		'io.inc'
c
	integer*4	code
c
	integer*4	smg$set_cursor_abs
c
	code=smg$set_cursor_abs (displayID,row,col)
	call check (code)
#else
	call curses_set_cursor (row, col)
#endif
	return
	end

	subroutine put_screen (text,row,col)
	implicit none 
c++
c  subroutine put_screen (text,row,col)
c
c  Displays text at the specified position
c
c  row		- input/integer*4
c  col		- input/integer*4
c--
	character*(*)	text
	integer*4	row
	integer*4	col
#ifdef vms
c
	include		'io.inc'
c
	integer*4	code
c
	integer*4	smg$put_chars
c
	code=smg$put_chars (displayID,text,row,col)
	call check (code)
#else	
	call curses_put_screen (text, row, col)
#endif
	return
	end

	subroutine put_buffer
	implicit none
c++
c  subroutine put_buffer
c
c  Flush SMG$ buffer
c--
#ifdef vms
	include		'io.inc'
c
	integer*4	code
c
	integer*4	smg$end_display_update
	integer*4	smg$flush_buffer
c
	code=smg$end_display_update (displayID)
	call check (code)
	code=smg$flush_buffer (pasteID)
	call check (code)
#else
	call curses_put_buffer
#endif
	return
	end

	subroutine set_buffer
	implicit none
c++
c  subroutine set_buffer
c
c  Enables batching of output
c--
#ifdef vms
	include		'io.inc'
c
	integer*4	code
c
	integer*4	smg$begin_display_update
c
	code=smg$begin_display_update (displayID)
	call check (code)
#endif
	return
	end

	subroutine scroll (line)
	implicit none
c++
c  subroutine scroll (line)
c
c  onoff	- input/integer
c		    0 => scroll off
c		    else scroll on starting at line specified
c--
	integer*4	line
#ifdef vms
c
	include	'io.inc'
c
	integer*4	code
	integer*4	smg$set_display_scroll_region
c
	if (line .eq. 0) then
	  code=smg$set_display_scroll_region (displayID,1,24)
	else
	  code=smg$set_display_scroll_region (displayID,line,24)
	endif
	call check (code)
#else
	if (line .eq. 0) then
	    call curses_scrollok (0)
	else
	    call curses_scrollok (1)
	endif
#endif
	return
	end
