	subroutine read_verb 
	implicit integer (a-z)
c++
c	subroutine read_verb
c
c  Read from menudata file into verb table
c
c--
#if defined(unix) || HAVE_F77_CPP
#	include "parms.inc"
#	include "verb.inc"
#	include "io.inc"
#elif defined(vms)
	include 'parms.inc'
	include 'verb.inc'
	include 'io.inc'
#endif
c
c  input line image
c
	character*80 data
c
c  copies of data before addition to tables
c
	character*(l_symbol) thisVerb,thisModifier
c
c  count input records and errors
c
	record=0
	errors=0
c
c  read next record
c
 100	record=record+1
	read (menu_unit,1000,end=900) data
 1000	format (a)
c
c  comment indicated by blank in column one
c
	if (data(1:1) .eq. ' ' .or. data(1:1) .eq. '*') goto 100
c
c  end-of-file indicated by '=' in column one
c
	if (data(1:1) .eq. '=') goto 900
c
c  convert to upper case
c
	call upcase (data)
	read (data,1001,err=200) thisVerb,thisModifier,iverb,imodifier
 1001	format (a16,a16,i2,i2)
c
c  room in tables
c
	if (n_verb .lt. max_verb) then
	   n_verb=n_verb+1
	   v_name(n_verb)=thisVerb
	   v_modifier(n_verb)=thisModifier
	   v_verbCode(n_verb)=iverb
	   v_modifierCode(n_verb)=imodifier
	else
	   write (message,1002) n_verb
 1002	   format ('READVERB: Can''t handle more than ',i4,
     *			' verb/modifier combinations')
	   call fatal
	endif
	goto 100
c
c  conversion error
c
 200	errors=errors+1
	write (message,201) record
	call warning
 201	format ('READVERB: Error converting numbers on record ',i3)
	goto 100
c
c  end-of-list
c
 900	if (errors .ne. 0) then
	  message='READVERB: One or more errors reading Command table'
	  call fatal
	endif
c
c  check that they are in alphabetical order
c
	if (n_verb .gt. 1) then
	  do i=1,n_verb-1
	    if (v_name(i) .gt. v_name(i+1)) goto 920
	    if (v_name(i) .eq. v_name(i+1)) then
	      if (v_modifier(i) .ge. v_modifier(i+1)) goto 920
	    endif
	  enddo
	endif
	goto 999
c
 920	write (message,921) i,i+1
 921	format ('READ_VERB: Verb/Modifier ',i4,' and ',i4,
     *			' are either duplicates or not in ',
     *			'alphabetical order')
	call fatal
c	
 999	return
	end
