	integer function ltrim (string)
	implicit integer (a-z)
c++
c	integer function ltrim (string)
c
c  Returns the length of the string less any trailing blanks
c
c	string		- input/string
c			  string whose length is to be measured
c--
	character*(*) string
c
	l=len(string)
c
	if (l .eq. 0) then
	  i=0
	  goto 99
	endif
c
	do i=l,1,-1
	  if (string(i:i) .ne. ' ') goto 99
	end do
c
c  string is blank
c
	i=1
c
c  return string length
c
 99	ltrim=i
	return
	end

	subroutine verify (string,code)
	implicit integer (a-z)
c++
c	subroutine verify (string,code)
c
c  Verifies that string consists entirely of printing characters
c
c	string		- input/string
c			  string to be checked
c
c	code		- output/integer
c			  0 => string is okay
c			  -1 => contains non-printing characters
c--
	character*(*) string
#ifdef vms
c
c  this table is based on the ascii character codes
c
	byte illegal (0:255)
	data illegal /32*1,95*0,1*1,128*1/
c
c  assume success
c
	code=0
c
	index=lib$scanc (string,illegal,1)
c
	if (index .ne. 0) code=-1
c
#else
	call printable(string, code)
#endif
	return
	end

	subroutine upcase (string)
	implicit integer (a-z)
c++
c	subroutine upcase (string)
c
c  Convert string to upper case
c  Warning: Blows up if passed string in read-only memory (literal)
c
c	string		- transput/string
c			  string is converted to uppercase
c--
	character*(*) string
c
#ifdef vms
	call str$upcase (string,string)
#else
	do 101 i = 1, len(string)
	    ival = ichar(string(i:i))
	    if (ival .ge. ichar('a') .and. ival .le. ichar('z')) then
		ival = ival - (ichar('a')-ichar('A'))
		string(i:i) = char(ival)
	    endif
 101	continue
#endif
c
	return
	end

	subroutine user_message
	implicit integer (a-z)
c++
c	subroutine user_message
c
c  Displays error message on last line of CRT
c    when user enters carr return returns to caller
c
c--
#if defined(unix) || HAVE_F77_CPP
#       include "parms.inc"
#elif defined(vms)
	include 'parms.inc'
#endif
c
	call squish (message,message,lstring)
	message=message(1:lstring) // ' (Return)'
	call put_trim (message,24,1)
	call flush_buffer
	call tt_return (message,lstring,icode)
	call controlc (iflag)
	call erase_line (24,1)
	call flush_buffer
	return
	end

	subroutine simpleMessage 
	implicit integer (a-z)
c++
c	subroutine simpleMessage 
c
c  Displays error message on CRT from message
c
c	string		- input/string
c			  error message to be displayed
c--
#if defined(unix) || HAVE_F77_CPP
#       include "parms.inc"
#elif defined(vms)
	include 'parms.inc'
#endif
c
	call squish (message,message,lstring)
#ifdef vms
	write (6,1000) message(:lstring)
 1000	format (1x,a)
#else
	call curses_put_chars (message (:lstring))
	call curses_put_nl
#endif
	return
	end

	subroutine put_trim (string,row,col)
	implicit integer (a-z)
c++
c	subroutine put_trim (string,row,col)
c
c  Display string using put_screen after trimming string
c
c	string		- input/string
c			  string to be displayed
c
c	row		- input/integer
c			  row number of CRT
c
c	col		- input/integer
c			  column number of CRT
c--
	character*(*) string
c
	l=ltrim (string)
	call put_screen (string(:l),row,col)
	return
	end

	subroutine flush_buffer
	implicit integer (a-z)
c++
c	subroutine flush_buffer
c
c  Forces buffer to CRT and then reenables buffer mode
c
c--
#if defined(unix) || HAVE_F77_CPP
#       include "io.inc"
#elif defined(vms)
	include 'io.inc'
#endif
c
	call put_buffer (0)
	call set_buffer (buffer)
	return
	end

	subroutine squish (message_in,message_out,l_out)
	implicit integer*4 (a-z)
c+
c	subroutine squish (message_in,message_out,l_out)
c
c	Removes redundant spaces from string
c
c	message_in	- input/string
c	message_out	- output/string
c	l_out		- output/integer
c			  length of message_out
c--
	character*(*) message_in,message_out
c
	message_out=message_in
c
c  eliminate duplicate spaces and spaces before/after (")
c
	l=ltrim(message_in)
	i=0
	j=0
c
 10	i=i+1
	if (i .gt. l) goto 91
	if (message_in(i:i) .ne. '"') goto 90
	goto 60
c
 50	j=j+1
	message_out(j:j)=message_in(i:i)
 55	i=i+1
	if (message_in(i:i) .eq. ' ') goto 55
 60	j=j+1
	message_out(j:j)=message_in(i:i)
	i=i+1
	if (message_in(i:i) .ne. '"') goto 60
 70	if (message_out(j:j) .ne. ' ') goto 90
	j=j-1
	goto 70
c
c  copy the character
c
 90	j=j+1
	message_out(j:j)=message_in(i:i)
	goto 10
c
c  second pass - elimiate duplicate spaces
c
 91	i=1
	k=0
 92	if (i .gt. j) goto 100
	if (message_out(i:i+1) .ne. '  ') then
	  k=k+1
	  message_out(k:k)=message_out(i:i)
	endif
	i=i+1
	goto 92
c
 100	l_out=k
	end

	subroutine leftjustify (string)
	implicit integer (a-z)
c++
c	subroutine leftjustify (string)
c
c	string		- transput/string
c			  string to be left justified
c--
	character*(*) string
c
	l=len(string)
	if (l .ne. 0) then
	  if (string(1:1) .ne. ' ') goto 99
	  do i=1,l
	   if (string(i:i) .ne. ' ') goto 20
	  end do
	endif
	goto 99
c
 20	string=string(i:l)
 99	return
	end

	subroutine noSpaces (message_in,message_out,l_out)
	implicit integer*4 (a-z)
c++
c	subroutine noSpaces (message_in,message_out,l_out)
c
c	Removes all spaces from string
c
c	message_in	- input/string
c	message_out	- output/string
c	l_out		- output/integer
c			  length of message_out
c--
	character*(*) message_in,message_out
c
	l=len(message_out)
	j=0
c
	do i=1,len(message_in)
	  if (message_in(i:i) .ne. ' ') then
	    j=j+1
	    if (j .gt. l) goto 90
	    message_out(j:j)=message_in(i:i)
	  endif
	end do
c
 90	l_out=j
	return
	end
