	subroutine loadSource (filespec,iFound)
	implicit integer (a-z)
c++
c  Loads Source variable tables from namelist like file
c
c	filespec	- input/string
c			  name of file and directory
c
c	iFound		- output/integer
c			    -1 => could not open file
c			     0 => able to open and read file
c--
	character*(*) filespec
c
#if defined(unix) || HAVE_F77_CPP
#       include "parms.inc"
#       include "io.inc"
#elif defined(vms)
	include 'parms.inc'
	include 'io.inc'
#endif
c
c  local variables containing copy of input record
c
	character*(l_name) name
	character*1 dollar
	character*(l_val) string
c
c  try to open file
c
c	call openLoadSave (menu_unit2,filespec,0,'IN',iFound)
c	if (iFound .lt. 0) goto 9000
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c  Add a source template record
c
 2000	call deleteSource
	call addSource
C
C     	call readline (menu_unit2,dollar,name,subscript,string,iflag)
C
     	call	read_nml  (filespec, 'SOURCE', 0, 0, ifound)
     	if (ifound.eq.-1) goto 9000
c
c
c 2005	read (menu_unit2,1005,end=9000) dollar,name,subscript,string
c
c  namelist end indicated by '$END'
c
c	if (dollar .eq. '$') then
c	  if (name .eq. 'END') goto 9000
c	  goto 2005
c	endif
c
c  find the name and change value
c
c	call store_string ('SRC',name,0,0,string)
c
c	goto 2005
c
 9000	if (iFound .eq. 0) then
     	  close (unit=menu_unit2)
     	else
     	  call	mssg ('Error reading SOURCE from ',filespec,ifound)
     	end if
	return
 1005	format (1x,a,a,1x,i2,1x,1x,1x,a,1x)
	end

	subroutine loadAllOe (filespec, exitCode)
	implicit integer (a-z)
c++
c	subroutine loadAllOe (filespec, exitCode)
c
c  Loads all optical elements matching filename of optical system
c
c	filespec	- input/string
c			  filename without extension
c--
	character*(*)	filespec
#if defined(unix) || HAVE_F77_CPP
#       include "parms.inc"
#elif defined(vms)
	include 'parms.inc'
#endif
	i=0
c
	call deleteAllOe
c
 100	i=i+1
	call LoadOe (filespec,i,i,iFound)
	if (iFound .ge. 0) goto 100
#ifdef vms
	write	(6,101)	'The system consists of ',i-1,' OE.'
 101	format	(1x,a,i2,a)
#else
	write	(message,101)	'The system consists of ',i-1,' OE.'
	call simpleMessage
 101	format	(1x,a,i2,a)
#endif
	return
	end

	subroutine loadOe (filespec,old_oe,requested_oe,iFound)
	implicit integer (a-z)
c++
c  Loads Optical Element variable tables from Namelist like file
c
c	filespec	- input/string
c			  name of file
c
c	old_oe		- input/integer
c			  number of optical element when stored
c
c	requested_oe	- input/integer
c			  element number to assign in new optical system
c
c	iFound		- output/integer
c			    -1 => could not open file
c			     0 => file opened and read
c--
	character*(*) filespec
c
#if defined(unix) || HAVE_F77_CPP
#       include "parms.inc"
#       include "io.inc"
#elif defined(vms)
	include 'parms.inc'
	include 'io.inc'
#endif
c
c  local variables containing copy of input record
c
	character*(l_name) name
	character*(l_val) string
	character*1 dollar
c
c  keep track of top screen
c
	new_scr=0
c
c  test for file existence
c
	call openLoadSave (menu_unit2,filespec,old_oe,'IN',iFound)
     	if (ifound.lt.0) goto 9000
     	close (unit=menu_unit2)
c
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c  Now an optical element
c  Add an optical element template
c
 2000	continue
     	call addOe (requested_oe,new_oe)
     	call	read_nml (filespec, 'OE', new_oe, old_oe, iflag)
        if (iflag.lt.0) then
	  call	mssg ('Error reading namelist from file.',
     *						filespec,iflag)
	  goto 9000
	end if
c
c 2005	read (menu_unit2,1005,end=9000) dollar,name,subscript,string
c
c  namelist end indicated by '$END'
c
c	if (dollar .eq. '$') then
c	  if (name .eq. 'END') goto 9000
c	  goto 2005
c	endif
c
c  subscript non-zero => screen
c
c	if (subscript .ne. 0) goto 3000
c
c  OE_NUMBER is special case
c  Value user specifies over-rides what is in file
c
c	if (name .eq. 'OE_NUMBER') then
c	  call store_i ('OE','OE_NUMBER',new_oe,0,new_oe)
c	else
c
c  find the name and change value
c
c	  call store_string ('OE',name,new_oe,0,string)
c	endif
c
c	goto 2005
c
c  Now a screen element
c
c 3000	if (subscript .gt. new_scr) then
c	  call exist (new_oe,subscript,iflag)
c
c  Add a screen template if does not yet exist
c
c	  if (iflag .eq. 0) then
c	    new_scr=subscript
c	    call addScr (new_oe,new_scr,new_scr)
c	  endif
c	endif
c
c	call store_string ('SCR',name,new_oe,subscript,string)
c	goto 2005
c
 9000	continue
c     	if (ifound.lt.0) then
c     	  call mssg ('Error reading OE from file ',filespec, ifound)
c     	end if
c9000	if (iFound .eq. 0) close (unit=menu_unit2)
	return
c
 1005 	format (1x,a,a,1x,i2,1x,1x,1x,a,1x)
	end

	subroutine openLoadSave (unit,filespec,suffix,inout,iFound)
	implicit integer (a-z)
c++
c	subroutine openLoadSave (unit,filespec,suffix,inout,iFound)
c
c  Opens a source or optical element file for read or write
c
c	unit		- input/integer
c			  Fortran logical unit number
c
c	filespec	- input/string
c			  name of file to open
c
c	suffix		- input/integer
c			  number to use as extension (0 to 99 only)
c
c	inout		- input/integer
c			   'IN' => input
c			   'OUT' => output
c
c	iFound		- output/integer
c			    -1 => failure
c			     0 => success
c--
	character*(*) filespec,inout
c
#if defined(unix) || HAVE_F77_CPP
#       include "parms.inc"
#elif defined(vms)
	include 'parms.inc'
#endif
#ifdef vms
	include '($foriosdef)'
#endif
c
c  assume failure
c
	iFound=-1
c
c  format number
c
	if (suffix .lt. 0 .or. suffix .gt. 99) goto 900
	if (filespec .ne. ' ') then
	  write (message,1005) filespec,suffix
	else
	  write (message,1005) 'NONAME',suffix
	endif
 1005	format (a,'.',i2.2)
c
c  remove spaces
c
	call noSpaces (message,message,l)
c
c  open file
c
	if (inout .eq. 'IN') then
#ifdef vms
	  open (unit=unit,name=message(1:l),status='old',readonly,
     *		iostat=ierr)
#else
	  open (unit=unit,file=message(1:l),status='old',
     *		iostat=ierr)
#endif
	else if (inout .eq. 'OUT') then
#ifdef vms
	  open (unit=unit,name=message(1:l),status='new',
     *		carriagecontrol='list',iostat=ierr)
#else
	  open (unit=unit,file=message(1:l),status='unknown',
     *		iostat=ierr)
#endif
	else
	  pause 'Illegal INOUT value'
	endif
c
c  check error code
c
	if (ierr .eq. 0) then
	  iFound=0
#ifdef vms
	elseif (ierr .eq. for$ios_filnotfou) then
	  iFound=-1
	elseif (ierr .eq. for$ios_opefai) then
	  iFound=-2
	elseif (ierr .eq. for$ios_no_sucdef) then
	  iFound=-3
	elseif (ierr .eq. for$ios_filnamspe) then
	  iFound=-4
	else
	  iFound=-5
#else
	else
	  iFound=-1
#endif
	endif
c
 900	return
	end
	subroutine saveSource (filespec,iError)
	implicit integer (a-z)
c++
c	subroutine saveSource (filespec,iError)
c
c  Save source descriptions in specified file with extension of ".00"
c
c	filespec	- input/string
c			  file name without extension
c
c	iError		- output/integer
c			   0 => success
c			   -1 => error
c--
	character*(*) filespec
c
#if defined(unix) || HAVE_F77_CPP
#       include "io.inc"
#elif defined(vms)
	include 'io.inc'
#endif
c
c	call openLoadSave (menu_unit2,filespec,0,'OUT',iError)
c	if (iError .lt. 0) goto 900
c
c	key=0
c	write (menu_unit2,40) ' $TSOUR'
c 20	call nl_find (key,'SRC',' ',-1,-1)
c	if (key .ne. 0) then
c	  call saveFmt
c	  goto 20
c	endif
c	write (menu_unit2,40) ' $END'
c	close (unit=menu_unit2)
c	iError=0
c
     	call	write_nml (filespec, 'SOURCE', 0, 0, iflag)
     	if (iflag.lt.0) then
     	  call mssg ('Error writing SOURCE to file ',filespec, iflag)
     	end if
 900	return
c
 40	format (a)
	end

	subroutine saveAllOe (filespec,iError)
	implicit integer (a-z)
c++
c	subroutine saveAllOe (filespec,iError)
c
c  Save all Optical Element descriptions in specified file with extension
c  of ".01", ".02", ...
c
c	filespec	- input/string
c			  file name
c
c	iError		- output/integer
c			   0 => success
c			   -1 => error
c--
	character*(*) filespec
c
c  get number of optical elements
c
	call LastOne (0,countOe)
c
c  for each optical element
c  save under original element number
c
	do i=1,countOe
	  call saveOe (filespec,i,i,iError)
	  if (ierror .lt. 0) goto 900
	end do
c
 900	return
	end

	subroutine saveOe (filespec,cur_oe,new_oe,iError)
	implicit integer (a-z)
c++
c	subroutine saveOe (filespec,cur_oe,new_oe,iError)
c
c  Save specific optical element (possibly with different oe number)
c
c	filespec	- input/string
c			  file name
c
c	cur_oe		- input/integer
c			  current element number
c
c	new_oe		- input/integer
c			  pretend optical element for filename
c
c	iError		- output/integer
c			   0 => success
c			   -1 => error
c--
	character*(*) filespec
c
#if defined(unix) || HAVE_F77_CPP
#       include "io.inc"
#elif defined(vms)
	include 'io.inc'
#endif
c
c	call openLoadSave (menu_unit2,filespec,new_oe,'OUT',iError)
c	if (iError .lt. 0) goto 90
c
c	write (menu_unit2,95) ' $TOTOE'
c
c  open the next optical element file
c  put in the namelist header
c
c	key=0
c
c20	call nl_find (key,'OE',' ',cur_oe,0)
c	if (key .eq. 0) goto 40
c	call saveFmt
c	goto 20
c
c  get number of screens
c
c 40	call LastOne (cur_oe,countScr)
c
c  now for the screen corresponding to this optical element
c  get next screen variable
c
c	do j=1,countScr
c	  key=0
c 60	  call nl_find (key,'SCR',' ',cur_oe,j)
c	  if (key .ne. 0) then
c	    call saveFmt
c	    goto 60
c	  endif
c	end do
c
c	write (menu_unit2,95) ' $END'
c	close (unit=menu_unit2)
     	call	write_nml (filespec, 'OE', cur_oe, new_oe, iflag)
     	if (iflag.lt.0) then
     	  call	mssg ('Error writing OE to file ',filespec, iflag)
     	end if
	iError=0
c
c  process next oe
c
 90	return
 95	format (a)
	end
