	subroutine evalFlags (imenu)
	implicit integer (a-z)
c++
c	subroutine evalFlags (imenu)
c
c  for the specified menu evaluates all the flags
c
c--
#if defined(unix) || HAVE_F77_CPP
#       include "parms.inc"
#       include "menu.inc"
#       include "nldata.inc"
#       include "acc.inc"
#elif defined(vms)
	include 'parms.inc'
	include 'menu.inc'
	include 'nldata.inc'
	include 'acc.inc'
#endif
c
	character*(l_rec) rec1,rec2
	character*(l_name) name1,name2,fullname
c
c  initialize flag values to true
c  and copy them to previous value area - used to look for changes
c
	do i=1,26
	  f_value(i)=1
	end do
c
c  get index of flag statements applicable to this menu
c
	start=m_flag_start(imenu)
	stop=m_flag_stop(imenu)
c
c  check for case of no flag statements
c
	if (start .eq. 0) goto 9000
c
	do 5000 i=start,stop
c
c  make local copies of variable to reduce subscripting for character vars
c
	rec1=f_rec1(i)
	rec2=f_rec2(i)
	name1=f_name1(i)
	name2=f_name2(i)
c
	key1=0
	key2=0
c
c  is this a flag var
c
	if (rec1(1:1) .eq. '%') then
	  val1=f_value(iFlagNumber(rec1(2:2)))
c
c  is must be a namelist table variable of some kind
c
	elseif (rec1 .ne. ' ') then
c
c  look in namelist table for it
c
	  key1=0
	  call nl_find (key1,rec1,name1,0,0)
	  if (key1 .eq. 0) then
c
c  it wasn't found
c
	    write (message,1005) rec1,name1
 1005	    format ('evalFlags: Could not locate "',a,'"/"',a,'"')
	    call fatal
	  endif
c
c  is it a yes/no type which can be interpreted directly as flag
c
	  if (nl_datatype .eq. 'Y') then
c
c  yes
c
	    key1=0
	    val1=nl_int
	  elseif (nl_datatype .eq. 'E') then
c
c  not a yes/no type - check that other side is a value
c  perhaps an enumerated data type
c
	    goto 2000
	  else
	    write (message,1025) rec1,name1
 1025	    format ('evalFlag: Var "',a,'"/"',a,'" must be of type ',
     *		    '"Yes/No" or of type "Enumerated"')
	    call fatal
	  endif
	else
	  message='Record type for flag field 1 must not be blank'
	  call fatal
	endif
c
c  now look at the second part of the expression
c  is this a flag var
c
	if (rec2(1:1) .eq. '%') then
c
c  yes
c
	  val2=f_value(iFlagNumber(rec2(2:2)))
c
c  it must be a namelist table variable of some kind
c
	elseif (rec2 .eq. ' ' .and. nl_datatype .eq. 'Y') then
	  call convert (name1,'Y',name2,iCode)
	  if (icode .lt. 0) then
	     write (message,1018) rec1,name1,name2
 1018	     format ('evalFlag: Var "',a,'"/"',a,'" cannot have ',
     *			'the value "',a,'"')
	     call fatal
	  endif
	  val2=acc_int
	elseif (rec2 .ne. ' ') then
c
c  look in namelist table for it
c
	  key2=0
	  call nl_find (key2,rec2,name2,0,0)
	  if (key2 .eq. 0) then
c
c  it wasn't found
c
	    write (message,1005) rec2,name2
	    call fatal
	  endif
c
c  is it a yes/no type which can be interpreted directly as flag
c
	  if (nl_datatype .eq. 'Y') then
	    key2=0
	    val2=nl_int
	  else
c
c  not a yes/no type nor a flag variable - this format is illegal
c
	    write (message,1020) rec2,name2
 1020	    format ('evalFlags: Right hand side must be flag or ',
     *		   '"Yes/No" type of variable - not  "',a,'"/"',a,'"')
	    call fatal
	  endif
	endif
c
c  evaluate comparison
c
 1500	result=0
	if (f_rel(i) .eq. 'EQ') then
	  if (val1 .eq. val2) result=1
	else if (f_rel(i) .eq. 'NE') then
	  if (val1 .ne. val2) result=1
	else if (f_rel(i) .eq. 'AND') then
          if (val1 .ne. 0 .and. val2 .ne. 0) result=1
	else if (f_rel(i) .eq. 'OR') then
	  if (val1 .ne. 0 .or. val2 .ne. 0) result=1
	else
	  write (message,1015) f_rel(i)
 1015	  format ('evalFlags: Unrecognized operator "',a,'"')
	  call fatal
	endif
	goto 4000
c
c  try and translate name/value field as synonym data type
c
 2000 	call translate_synonym (name1,name2,val2,fullname)
	if (val2 .lt. 0) then
	  write (message,1010) rec1,name1,name2
 1010	  format ('evalFlags: Var "',a,'"/"',a,'" cannot have the ',
     *		  'value "',a,'"')
	  call fatal
	endif
c
c  compare values
c
	result=0
	if (f_rel(i) .eq. 'EQ') then
	  if (nl_int .eq. val2) result=1
	elseif (f_rel(i) .eq. 'NE') then
	  if (nl_int .ne. val2) result=1
	else
	  write (message,1015) f_rel(i)
	  call fatal
	endif
c
c  store result
c
 4000	f_value(iFlagNumber(f_result(i)))=result
c
c  next flag statement
c
 5000	continue
c
 9000	return	
	end

	integer function iFlagNumber (flagName)
	implicit integer (a-z)
c++
c	integer function iFlagNumber (flagName)
c
c  this returns a number between 1 and 26 corresponding to a flag number
c  a space is flag number 0
c  any other character is a fatal error
c  flag names are the capital letters of the alphabet
c
c	flagName	- input/character*1
c			  name of flag
c--
	character*1 flagName
c
#if defined(unix) || HAVE_F77_CPP
#       include "parms.inc"
#elif defined(vms)
	include 'parms.inc'
#endif
c
	call checkFlagName (flagname,i)
	if (i .lt. 0) then
	  write (message,1000) ichar(flagName)
 1000	  format ('iFlagNumber: Illegal character for name - octal ',i3)
	  call fatal
	endif
c
	iFlagNumber=i
	return
	end

	subroutine CheckFlagName(flagName,flagNumber)
	implicit integer (a-z)
c++
c	subroutine CheckFlagName(flagName,flagNumber)
c
c  this returns a number between 1 and 26 corresponding to a flag number
c  any other character set flag number to (-1)
c  flag names are the capital letters of the alphabet
c
c	flagName	- input/character*1
c			  name of flag
c
c	flagNumber	- output/integer
c			  number of flag or (-1)
c--
	character*1 flagName
c
#if defined(unix) || HAVE_F77_CPP
#       include "parms.inc"
#       include "menu.inc"
#elif defined(vms)
	include 'parms.inc'
	include 'menu.inc'
#endif
c
	character*26 allNames
	data allnames /'ABCDEFGHIJKLMNOPQRSTUVWXYZ'/
c
	data first /0/
c
c  initialize flag names
c
	if (first .eq. 0) then
	  first=1
	  do i=1,26
	    f_name(i)=allnames(i:i)
	  enddo
	endif
c
	flagNumber=index (allnames,flagName)
	if (flagNumber .eq. 0) flagNumber=-1
	return
	end
