	subroutine do1menu (imenu,detail_in,
     *			new_menu,detail_out,exit_code)
	implicit integer (a-z)
c++
c	subroutine do1menu (imenu,detail,new_menu,detail_out,exit_code)
c
c  Displays and processes a single menu
c
c	imenu		- input/integer
c			  menu to be displayed
c
c	detail_in	- input/integer
c			  starting detail position (or zero)
c
c	new_menu	- output/integer
c			  next menu to be processed if user selects submenu
c
c	detail_out	- output/integer
c			  final detail position (or zero)
c
c	exit_code	- output/integer
c				-1	=> downtree
c				0	=> uptree
c				1	=> EXIT/STOP/RETURN
c				2	=> control/C
c
c--
#if defined(unix) || HAVE_F77_CPP
#       include "parms.inc"
#       include "menu.inc"
#       include "context.inc"
#       include "io.inc"
#elif defined(vms)
	include 'parms.inc'
	include 'menu.inc'
	include 'context.inc'
	include 'io.inc'
#endif
c
	character*(l_menuname) submenu_name
c
	detail=detail_in
c
 10	call display1 (imenu)
c
c  DO1LINE exit codes
c	(-1)	=> right arrow - down menu
c	   0	=> left arrow - up menu
c	   1	=> EXIT/STOP/QUIT
c	   2    => control/c
c
 100	call do1line (detail,detail_out,submenu_name,exit_code)
	detail=detail_out
	if (exit_code .eq. -1) goto 2100
	if (exit_code .eq. 0) goto 9000
	if (exit_code .lt. 1 .or. exit_code .gt. 2) stop 'Exit Code'
	goto (1100,1200), exit_code
c
c  EXIT/STOP/RETURN/QUIT
c
 1100	goto 9000
c
c  Control/C
c
 1200	goto 9000
c
c  Down tree
c
 2100	call translate_menuname (submenu_name,new_menu)
	if (new_menu .lt. 0) then
	  write (message,1020) submenu_name
 1020	  format ('Menu requested ("',a,'") has not been implemented')
	  call user_message
	  goto 100
	endif
	exit_code=-1
c
 9000	return
	end
