	subroutine do1line (detail_in,detail_out,submenu,exit_code)
	implicit integer (a-z)
c++
c	subroutine do1line (detail_in,detail_out,exit_code)
c
c  Moves cursor around screen and displays data on display
c
c	detail_int	- input/integer
c			  where to initially position cursor
c
c	detail_out	- output/integer
c			  next detail to process when routine called again
c
c	submenu		- output/string
c			  name of submenu if requested, else blanks
c
c	exit_code	- output/integer
c			  reason for exit
c			    (-1) => right arrow key (down menu)
c			      0  => left arrow key (up menu)
c			      1  => EXIT/STOP/QUIT/RETURN
c			      2  => control/c
c--
	character*(*) submenu
c
#if defined(unix) || HAVE_F77_CPP
#       include "parms.inc"
#       include "context.inc"
#       include "nldata.inc"
#       include "i.inc"
#       include "menu.inc"
#       include "acc.inc"
#       include "helplib.inc"
#elif defined(vms)
	include 'parms.inc'
	include 'context.inc'
	include 'nldata.inc'
	include 'i.inc'
	include 'menu.inc'
	include 'acc.inc'
	include 'helplib.inc'
#endif
c
#ifndef vms
	logical lstr_eq
#endif
c
	character*6 special_word (6)
	integer	    special_exit (6)
	data special_word /'EXIT','QUIT','RETURN','STOP','HELP','?'/
	data special_exit / 1   , 1    , 1      , 1    , 3     , 3 /
c
c  next action based on TT_READ code (+1)
c
	integer next_action (7)
c
c  for "N/A" text
c
	character*3 note
c
c  TT_CODE
c			   0  1  2  3  4  5  6
	data next_action /99,99,-1,99, 0,99, 4/
c
	character*(l_val+10) string
c
	submenu=' '
c
c  disable terminal driver interpretation of arrow keys as line editing
c
	call setMenuMode (1)
c
c  determine which line to process
c
	detail=detail_in
	if (detail .eq. 0) then
	  do i=cur_detail_start,cur_detail_stop
	    if (d_readonly(i) .eq. 'N' .and.  d_name(i) .ne. ' ') then
	      detail=i
	      goto 110
	    endif
	  enddo
c
c  no writeable fields - return to caller
c
	  exit_code=0
	  goto 900
	endif
c
c  solicit input for this line
c
 110	call set_cursor (d_line(detail),c_newval)
	call flush_buffer
	call tt_read (string,linput,tt_code)
c
c  check for control/C
c
	if (tt_code .eq. 5) then
	  exit_code=2
	  goto 900
	endif
c
c  normal termination of read
c    remove leading spaces
c    translate to uppercase
c
 300	if (linput .eq. 0) then
	  string=' '
	  goto 400
	else if (linput .lt. len(string) ) then
	  string (linput+1:)=' '
	endif
c
	call leftjustify (string)
#ifdef vms
	call upcase (string)
c
c  look for special words
c
	do i=1,6
	  if (string .eq. special_word(i)) then
	    exit_code=special_exit (i)
	    goto 800
	  endif
	end do
#else
c
c  look for special words
c
	do i=1,6
	  if (lstr_eq (string, special_word(i))) then
	    exit_code=special_exit (i)
	    goto 800
	  endif
	end do
#endif
c
c  convert to internal value
c
 	call nl_unpack (d_key(detail))

c
c why is this here?? Todo/fixme/check -- MK 11/18/96
c
#ifndef vms
	if (nl_datatype .ne. 'A') then
	    call upcase (string)
	endif
#endif
c
c  don't accept space for numeric input fields
c
	if (nl_datatype .ne. 'A' .and. string .eq. ' ') goto 400
	call convert (d_name(detail),nl_datatype,string,code)
	if (code .lt. 0) then
c
c  display message and await response
c
	  message=acc_message
	  call user_message
c
c  erase previous value
c
	  call erase_line (d_line(detail),c_newval)
	  goto 110
	endif
c
c  Special case
c     GOTO_OE and GOTO_SCR
c     See if they exist before allowing goto
c  Note
c     In moving to a different optical element you cannot
c       specify a particular screen
c     In moving to a different screen you cannot specify a different
c       optical element
c
	if (d_name(detail) .eq. 'GOTO_OE') then
	  if (acc_int .gt. 0) then
	    call exist (acc_int,0,iflag)
	  else
	    iflag=0
	  endif
	  if (iflag .ne. 0) goto 375
	  write (message,321) acc_int
 321	  format ('Optical element ',i10,' does not exist')
	  call user_message
	  call erase_line (d_line(detail),c_newval)
	  goto 110
	endif
c
c  If GOTO_SCR is an option assume that GOTO_OE is NOT an option
c    search for name list data for the specified screen and the current oe
c
	if (d_name(detail) .eq. 'GOTO_SCR') then
	  if (acc_int .gt. 0) then
	    call exist (cur_oe,acc_int,iflag)
	  else
	    iflag=0
	  endif
	  if (iflag .ne. 0) goto 375
	  write (message,322) cur_oe,acc_int
 322	  format ('Optical element ',i10,' Screen ',i10,
     *		' does not exist')
	  call user_message
	  call erase_line (d_line(detail),c_newval)
	  goto 110
	endif
c
c  store new value
c
 375	nl_int=acc_int
	nl_real=acc_real
	nl_string=acc_string
	call nl_update (d_key(detail),d_rec(detail),d_name(detail),
     *			d_own1(detail),d_own2(detail))
c
c  erase from new value field and old
c
	call erase_line (d_line(detail),c_curval)
c
c  display new value in current value field
c
	call put_trim (acc_string,d_line(detail),c_curval)
c
c  does a change in this field require "n/a" fields to be updated ?
c
	if (d_force(detail) .eq. 'Y') then
c
c  evaluate menu flag
c
	  call evalFlags (cur_menu)
	  menuFlag=f_value(iFlagNumber('M'))
	  do i=cur_detail_start,cur_detail_stop
c
c  assume note is blank
c
	    note=' '
c
c  check for simple text
c
	    if (d_name(i) .eq. ' ') goto 390
c
c  menuFlag is always anded with the crt line flag
c
     	    if (menuFlag .eq. 0) then
	      note='n/a'
	    else
	      if (d_flag(i) .ne. ' ') then
	        if (f_value(iFlagNumber(d_flag(i))) .eq. 0) note='n/a'
	      endif
	    endif

	    if (note .ne. i_oldNote (d_line(i))) then
	      call put_screen (note,d_line(i),c_note)
	      i_oldNote (d_line(i))=note
	    endif
 390	  enddo
c
c  force ouput to display
c
	call flush_buffer
	endif
c
c  up or down screen
c
 400	code=tt_code+1
c
c  save name of submenu before changing detail line
c  when submenu undefined then treat submenu request as c/r
c
	if (tt_code .eq. 2) then
	  if (d_submenu(detail) .ne. ' ') then
	    submenu=d_submenu (detail)
	  else
	    code=1
	  endif
	endif
c
	if (code .lt. 1 .or. code .gt. 7) stop 'Computed GOTO'
	goto (500,600,500,500,700,700,700) code
c
c  move down screen
c
 500	detail=detail+1
 	if (detail .gt. cur_detail_stop) detail=cur_detail_start
 510	do i=detail,cur_detail_stop
	  if (d_readonly(i) .eq. 'N' .and.  d_name(i) .ne. ' ') then
	    detail=i
	    goto 700
	  endif
	enddo
	detail=cur_detail_start
	goto 510
c
c  move upscreen 
c
 600	detail=detail-1
 	if (detail .lt. cur_detail_start) detail=cur_detail_stop
 610	do i=detail,cur_detail_start,-1
	  if (d_readonly(i) .eq. 'N' .and.  d_name(i) .ne. ' ') then
	    detail=i
	    goto 700
	  endif
	enddo
	detail=cur_detail_stop
	goto 610
c
c  action routines for tt_codes
c
 700	exit_code=next_action (code)
	if (exit_code .eq. 99) goto 110
c
c  special case: REFRESH
c
	if (exit_code .eq. 4) then
	   call display1 (cur_menu)
	   goto 110
	endif
c
	goto 900
c
c  special case: HELP
c
 800	if (exit_code .eq. 3) then
ccc    	  call erase_page (cur_scroll_line,1)
ccc	  call set_cursor (cur_scroll_line,1)
     	  call erase_page (1,1)
	  call scroll (0)
	  call flush_buffer
	  call help (helplibm,1,d_name(detail) )
     	  call display1 (cur_menu)
ccc	  call erase_line (d_line(detail),c_newval)
ccc	  call set_cursor (d_line(detail),c_newval)
	  call controlc (iflag)
	  call setMenuMode (1)
	  if (iflag .ne. 0) then
	    exit_code=2
	    goto 900
	  endif
	  goto 110
	endif
c
c  exit
c
 900	detail_out=detail
	return
	end
