	subroutine display1 (imenu)
	implicit integer (a-z)
c++
c	subroutine display1 (imenu)
c
c  Displays a single menu
c
c	imenu		- input/integer
c			  menu to be displayed
c
c--
#if defined(unix) || HAVE_F77_CPP
#       include "parms.inc"
#       include "menu.inc"
#       include "context.inc"
#       include "nldata.inc"
#       include "i.inc"
#       include "io.inc"
#elif defined(vms)
	include 'parms.inc'
	include 'menu.inc'
	include 'context.inc'
	include 'nldata.inc'
	include 'i.inc'
	include	'io.inc'
#endif
c
c  this stores the line that is to be written out
c
	character*60 image
	data image /' '/
c
c  prompt with optional '(+)'
c
	character*(l_prompt) prompt
c
c  contains note column contents
c
	character*3 note
c
c  contains plus sign if more can go in column
c
	character*3 more
c
c  evaluate flags
c
	call evalFlags (imenu)
c
c  what is the menu flag set to
c
	menuFlag=f_value(iFlagNumber('M'))
c
c  keep track of last line used
c
	cur_scroll_line=0
c
	call erase_page (1,1)
#ifdef vms
	call smg$invalidate_display (displayID)
#endif
	call put_trim (m_title(imenu),1,1)
c
c  what kind of title
c	Optical Element 5
c	Optical Element 5 / Screen 2
c	Source
c
	if (m_type(imenu) .eq. 'OE') then
	  write (message,1000) cur_oe
 1000	  format ('Optical Element ',i2)
	  call put_trim (message(1:30),1,45)
	endif
	if (m_type(imenu) .eq. 'SCR') then
	  write (message,1010) cur_oe,cur_scr
 1010	  format ('Optical Element ',i2,'   Screen ',i2)
	  call put_trim (message(1:30),1,45)
	endif
c
c  display each detail line
c
	do i=cur_detail_start,cur_detail_stop
c
c  check for simple text
c
	  if (d_name(i) .eq. ' ') then
	     call put_trim (d_prompt(i),d_line(i),c_prompt)
	     goto 900
	  endif
c
c  assume no note
c
	note=' '
c
c  check flag to see if 'N/A' attached
c  menuFlag is always anded with the crt line flag
c
	if (d_flag(i) .ne. ' ') then
	  if (menuFlag .eq. 0 .or.
     *		f_value(iFlagNumber(d_flag(i))) .eq. 0) note='n/a'
	endif
c
c  check for read/only
c
	if (d_readonly(i) .eq. 'Y' ) note='r/o'
c
c  get a value
c  
	key=0
	call nl_find (key,d_rec(i),d_name(i),d_own1(i),d_own2(i))
c
c  did it find a match
c
	  if (key .eq. 0) then
	    write (message,1020) d_rec(i),d_name(i)
 1020	    format ('DISPLAY1: Record type "',a,'" Variable "',a,
     *		'" is undefined')
	    call fatal 
	  endif
c
c  copy key for quick update
c
	d_key(i)=nl_key
c
	if (d_submenu(i) .ne. ' ') then
	  more='(+)'
	else
	  more=' '
	endif
c
c  get position where '(+)' will be appended
c
	prompt=d_prompt(i)
	lprompt=min ( ltrim(prompt)+2 , len(prompt)-len(more))
	prompt(lprompt:)=more
c
	image(c_prompt:c_note)=prompt
	image(c_note:c_curval)=note
	i_oldNote (d_line(i))=note
	image(c_curval:)=nl_string
	call put_trim (image,d_line(i),c_prompt)
c
c  get next line to display
c
 900	cur_scroll_line=max (cur_scroll_line,d_line(i))
	continue
	end do
c
	cur_scroll_line=cur_scroll_line+2
	call scroll (cur_scroll_line)
	call flush_buffer
	return
	end
