	subroutine controlc (iflag)
	implicit integer*4 (a-z)
c++
c	subroutine controlc (iflag)
c
c  Performs two functions:
c    Arms control/c AST
c    Sets return argument to indicate if control/C AST
c      was issued.  Flag is cleared and control/C rearmed
c      once it is reported
c
c	iflag		- output/integer
c			    0 => no control/C received
c			    1 => control/C received and now rearmed
c--
#if defined(unix) || HAVE_F77_CPP
#       include "io.inc"
#elif defined(vms)
	include 'io.inc'
#endif
#ifdef vms
c
	include '($iodef)'
#endif
c
	external controlc_ast
c++
c SIGNAL is an intrinsic RS/6000 AIX 3.2 FORTRAN and it doesn't take the
c standard 3rd parameter (flag) in the signal call that we need.
c+++
	external signal
	integer first
	save first
	data first / 0 /
c
c  assume no control/C
c
	iflag=0
c
c  if first time through just arm the AST
c
	if (first .eq. 0) then
	  first=1
	  goto 100
	end if
c
	if (controlc_received .eq. 0) goto 999
c
c  control/C received
c  set output flag; clear internal flag
c
	iflag=1
	controlc_received=0
#ifdef vms
c
c  rearm AST
c
 100	return_code=sys$qiow ( ,%val(TT_channel),
     *			%val(io$_setmode+io$m_ctrlcast)
     *			, , , ,controlc_ast, , , , , )
	call check (return_code)
#else
 100	call signal (2, controlc_ast, -1)
#endif
c
 999	return
	end

	subroutine controlc_ast
	implicit integer*4 (a-z)
c++
c	subroutine controlc_ast
c
c  This is an internal routine not for users to call
c  It is called by the system when someon types a control/c or control/y
c  It merely sets a flag in common and then returns to the executive
c--
#if defined(unix) || HAVE_F77_CPP
#       include "io.inc"
#elif defined(vms)
	include 'io.inc'
#endif
c
	controlc_received=1
	return
	end
