C +++
C
C Source: src/tools/math/gg123.f
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	gg123.f
C Revision 1.2  90/11/13  14:03:02  khan
C Cleanup and SAVE statements
C 
C Revision 1.1  90/07/17  13:54:54  khan
C Initial revision
C 
C 
C ---

C******************* GAMMA TEST ******************************
	IMPLICIT REAL*8 (A-H,O-Z)
	DIMENSION ARRP(31,2),ARRM(31,2)
	OPEN(UNIT=20,FILE='GGGG',STATUS='UNKNOWN')
C	OPEN(UNIT=20,FILE='GGGG',STATUS='NEW',DISPOSE='SAVE')
	DO 100  IQ= 1,2
	DO 100  K=0,30
	CALL GAMMA(K,IQ,GP,GM)
	ARRP(K+1,IQ)=GP
	ARRM(K+1,IQ)=GM
100	CONTINUE
	WRITE(20,1000) (L-1,(ARRP(L,M),M=1,2),(ARRM(L,M),M=1,2),L=1,31)
	CLOSE (20,DISPOSE='SAVE')
1000	FORMAT(1X,I4,T20,G17.10,T40,G17.10,T60,G17.10,T80,G17.10)
	STOP
	END

	SUBROUTINE GAMMA(K,IQ,GP,GM)
	IMPLICIT REAL*8 (A-H,O-Z)
	G13=2.678938534707748D0
	G23=1.354117939426400D0
	GG=1.0D0
	GOTO (10,20,30), IQ
C************************ GAMMA FOR ORD=1/3 **************************
10	IF (K.EQ.0)THEN
	  GM=G23
	  GP=G13/3
	ELSE
	KK=K+1
	  DO100I1=1,KK
100	  GG=(3*I1-2)/3.0D0*GG
	  GP=GG*G13
	GG=1.0D0
	  DO200I1=1,K
200	  GG=(3*I1-1)/3.0D0*GG
	  GM=GG*G23
	END IF
	RETURN
C**************************GAMMA FOR ORD=2/3**********************
20	IF (K.EQ.0)THEN
	  GM=G13
	  GP=2/3.0D0*G23
	ELSE
	KK=K+1
	  DO 300 I1=1,KK
300	  GG=(3*I1-1)/3.0D0*GG
	  GP=GG*G23
	GG=1.0D0
	  DO 400 I1=1,K
400	  GG=(3*I1-2)/3.0D0*GG
	  GM=GG*G13
	END IF
	RETURN
C********************GAMMA FOR ORD=5/3********************************
30	CONTINUE
C****** NOT READY *********
	RETURN
	END
	
