C +++
C
C Source: src/tools/math/erf.f
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	erf.f
C Revision 1.1  90/07/17  13:54:52  khan
C Initial revision
C 
C 
C ---

C+++
C	FUNCTION	ERF8
C
C---
       	FUNCTION	ERF (X)
       	IMPLICIT	REAL*8	(A-H,O-Z)
       	PARAMETER	P  =   .32759 11
       	PARAMETER	A1 =   .25482 9592
       	PARAMETER	A2 =  -.28449 6736
       	PARAMETER	A3 =  1.42141 3741
       	PARAMETER	A4 = -1.45315 2027
       	PARAMETER	A5 =  1.06140 5429
C
       	TPAR	=   1 / (1 + P*ABS(X))
C
	RES	=   1 - TPAR*(A1 + TPAR*(A2 + TPAR*(A3 +
     $  		  TPAR*(A4 + TPAR*A5))))*EXP(-X**2)
       	IF (X.LT.0) RES = -RES
       	ERF	=   RES
       	RETURN
       	END
