C +++
C
C Source: src/tools/math/double.f
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	double.f
C Revision 1.2  90/11/13  14:02:58  khan
C Cleanup and SAVE statements
C 
C Revision 1.1  90/07/17  13:54:50  khan
C Initial revision
C 
C 
C ---

C+++
C	program		double
C
C	purpose		to create a mirror image of an {x,y} table; i.e.
C			to extend a file from [-1,0] to [-1,1]
C
C---
     	PROGRAM		DOUBLE
     	IMPLICIT	REAL*8 (A-H,O-Z)
#if defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#elif defined(vms)
	INCLUDE		'SHADOW$INC:DIM.PAR/LIST'
#endif
     	DIMENSION	X(N_DIM),Y(N_DIM)
     	CHARACTER*80	INFILE,OUTFILE,RSTRING
100	INFILE	=   RSTRING ('Input file ? ')
     	OUTFILE	=   RSTRING ('Output file ? ')
     	OPEN (20, FILE=INFILE, STATUS='OLD', READONLY, ERR=100)
     	IERR = 0
     	I = 0

C     	DO WHILE (IERR.EQ.0)
1    	IF (.NOT.(IERR.EQ.0)) GOTO 2
     	  I = I + 1
     	  READ (20,*,IOSTAT=IERR) X(I),Y(I)
          GOTO 1
2        CONTINUE
C    	CONTINUE

     	CLOSE (20)
     	NP = I-1
     	WRITE(6,*)'Read ',NP,' records.'
     	OPEN (21, FILE=OUTFILE, STATUS='UNKNOWN')
C     	OPEN (21, FILE=OUTFILE, STATUS='NEW')
     	DO 10 I=1,NP
     	  WRITE (21,*) X(I),Y(I)
10      CONTINUE
     	XSTEP = X(2) - X(1)
     	XS = X(NP)
     	DO 20 I=NP-1,1,-1
     	  XS = XS + XSTEP
     	  WRITE (21,*) XS, Y(I)
20      CONTINUE
     	CLOSE (21)
     	STOP
     	END
