//
// xrlstring.h: interface to simple string class
//
// ------------------------------------------------
// Mumit Khan <khan@xraylith.wisc.edu>
// Center for X-ray Lithography
// University of Wisconsin-Madison
// 3731 Schneider Dr., Stoughton, WI, 53589
// ------------------------------------------------
//
// Copyright (c) 1991-1996 Mumit Khan
//
//

#ifndef excon_batch_string_h
#define excon_batch_string_h

#include "xrtypes.h"
#include <string.h>

#ifdef USE_XRSTRING_IO
#include <iostream.h>
#endif

class xrlString {
private:
    struct srep {
	char* _s;
	int   _n;
	srep()				{ _s = 0, _n = 1; }
    };
    srep* _p;

public:
    xrlString(const char* = nil);
    xrlString(const xrlString&);
    xrlString& operator=(const char*);
    xrlString& operator=(const xrlString&);

    ~xrlString();
    char& operator[](int i);		// str[i] = 'x'; l-value
    char operator[](int i) const;	// x = str[i]; r-value

    operator const char*() const	{ return _p->_s; }

#ifdef USE_XRSTRING_IO
    friend ostream& operator<<(ostream&, const xrlString&);
    friend istream& operator>>(istream&, xrlString&);
#endif

#ifndef __GNUG__
    friend boolean operator==(const xrlString& x, const char* s)
		{ return strcmp (x._p->_s, s) == 0; }
    friend boolean operator==(const xrlString& x, const xrlString& y)
		{ return strcmp (x._p->_s, y._p->_s) == 0; }

    friend boolean operator!=(const xrlString& x, const char* s)
		{ return strcmp (x._p->_s, s) != 0; }
    friend boolean operator!=(const xrlString& x, const xrlString& y)
		{ return strcmp (x._p->_s, y._p->_s) != 0; }
#endif

};

#endif /*excon_batch_string_h*/
