//
// xrlstring.cc: simple string class
//
// ------------------------------------------------
// Mumit Khan <khan@xraylith.wisc.edu>
// Center for X-ray Lithography
// University of Wisconsin-Madison
// 3731 Schneider Dr., Stoughton, WI, 53589
// ------------------------------------------------
//
// Copyright (c) 1991-1996 Mumit Khan
//
//

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#ifdef USE_XRSTRING_IO
#include <iostream.h>
#endif

#include "xrlstring.h"

xrlString::xrlString (const char* s) {
    _p = new srep;
    if (s) {
	_p->_s = new char[strlen(s) + 1];
	strcpy (_p->_s, s);
    }
}

xrlString::xrlString (const xrlString& x) {
    x._p->_n++;
    _p = x._p;
}

xrlString::~xrlString () {
    if (--_p->_n == 0) {
	delete[] _p->_s;
	delete _p;
    }
}

char xrlString::operator[](int index) const {
    if (index < 0 || index >= strlen(_p->_s)) {
	abort ();
    }

    return _p->_s[index];
}


char& xrlString::operator[](int index) {
    if (index < 0 || index >= strlen(_p->_s)) {
	abort ();
    }

    char* buf = new char[strlen(_p->_s) + 1];
    strcpy (buf, _p->_s);
    if (--_p->_n == 0) {
	delete[] _p->_s;
	delete _p;
    }
    _p = new srep;
    _p->_s = buf;
    return _p->_s[index];
}

xrlString& xrlString::operator=(const char* s) {
    if (_p->_n > 1) {
	_p->_n--;
	_p = new srep;
    }
    else {
	delete[] _p->_s;
    }
    
    _p->_s = new char[strlen(s) + 1];
    strcpy (_p->_s, s);
    return *this;
}

xrlString& xrlString::operator=(const xrlString& x) {
    if (this != &x) {
	x._p->_n++;
	if (--_p->_n == 0) {
	    delete[] _p->_s;
	    delete _p;
	}
	_p = x._p;
    }
    return *this;
}


#ifdef USE_XRSTRING_IO
ostream& operator<<(ostream& s, const xrlString& x) {
    return s << x._p->_s << " [" << x._p->_n << "]" << endl;
}

istream& operator>>(istream& s, xrlString& x) {
    char buf[BUFSIZ];
    s.get(buf, BUFSIZ, '\n');
    x = buf;
    return s;
}
#endif
