#! /bin/sh
#
# RUN test
#
#

# environment variables that this shell script sets/changes:
# export VARIABLES.

# error message function
error () {
    echo "`basename $0`: $@" 1>&2
    exit 1
}

# usage message function
usage () {
    if [ ! -z "$@" ]; then
	echo "`basename $0`: $@" 1>&2
    fi
    echo "Usage: `basename $0` -iteration iteration" 1>&2
    exit 1
}


#
# set up the variables, including the ones from EXCON.
#
GFILE=				# name of gfile to read from.
RETVAL=0			# return codes from programs.
ITERATION=

# Parse command line args.
while [ $# -gt 0 ]; do
    case "$1" in
	-g)
	    if [ $# -lt 2 ]; then
		usage "$1 option requires a gfile name"
	    fi
	    shift
	    GFILE="$1"
	    ;;
	-debug|-d)
	    set -x
	    ;;
	-iteration|-i)
	    if [ $# -lt 2 ]; then
		usage "$1 option requires an iteration id"
	    fi
	    shift
	    ITERATION=$1
	    ;;
	-help|-h)
	    usage ""
	    ;;
	*)
	    usage "Illegal command line option $1"
	    ;;
    esac
    shift
done

if test -z "$ITERATION"; then
    usage "Must specify an iteration id"
    exit 1
fi


RETVAL=0
if test $ITERATION = 9; then
    RETVAL=2
fi

echo "Current iteration = $ITERATION"

exit ${RETVAL}
