//
// misc.h: misc helper classes
//
// ------------------------------------------------
// Mumit Khan <khan@xraylith.wisc.edu>
// Center for X-ray Lithography
// University of Wisconsin-Madison
// 3731 Schneider Dr., Stoughton, WI, 53589
// ------------------------------------------------
//
// Copyright (c) 1991-1996 Mumit Khan
//
//

#ifndef excon_batch_misc_h
#define excon_batch_misc_h

/**************************************************************************/

class Hashtable;
class Stq;

/**************************************************************************/

/****************************************************************************
 *
 *  STATS
 *
 ****************************************************************************/

class Stats {
public:
    Stats();
    void ranprogram()		{ nprograms_++; }
    void editedinputfile()	{ ninputfiles_++; }
    void searchedoutputfile()	{ noutputfiles_++; }
    void report();

private:
    int nprograms_;    // NUMBER OF PROGRAMS RUN
    int ninputfiles_;  // NUMBER OF FILES CREATED AS INPUTS
    int noutputfiles_; // NUMBER OF FILES SEARCHED FOR OUTPUTS
};   

/****************************************************************************
 *
 *  CLEANUP
 *
 ****************************************************************************/

class CleanupMgr {
public:
    CleanupMgr();
    ~CleanupMgr();
    void addunlink(const char* path, int iteration);
    void cleanup(int iteration);
private:
    Hashtable* find_unlinktable(int iteration);
private:
    Stq* unlinktablist_;
};   

#endif/*excon_batch_misc_h*/
