C +++
C
C Source: src/source/id/uread.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	uread.F
C Revision 1.5  91/12/19  17:39:54  cwelnak
C Barry's 1990 undulator changes
C 
C Revision 1.4  1991/07/06  20:03:58  khan
C Grenoble and after. Minor changes
C
C Revision 1.3  90/10/30  00:01:51  khan
C Fix Ultrix -> VMS things that got screwed up in VMS -> Ultrix.
C 
C Revision 1.2  90/07/17  23:04:58  khan
C Fixed STATUS=NEW in OPEN statements to UNKNOWN for Unix.
C Substitue pre_rad.blk for PRE_RAD.BLK
C 
C Revision 1.1  90/07/17  15:36:40  khan
C Initial revision
C 
C 
C ---

C+++
C
C	SUBROUTINE	UREAD
C
C	PURPOSE:	To read in the trajectory file generated by EPATH, and
C			the parameter namelist file.
C
C	OUTPUT:		It defines all the common blocks
C
C---
	SUBROUTINE		UREAD 
	IMPLICIT REAL*8		(A-H,O-Z)

#if defined(unix) || HAVE_F77_CPP
#	include 	"pre_rad.blk"
#elif defined(vms)
	INCLUDE		'PRE_RAD.BLK/LIST'
#endif

C
C  read file generated from EPATH
C
#if vms
	OPEN (21,FILE=FTRAJ,STATUS='OLD',FORM='UNFORMATTED',READONLY)
#elif unix
	OPEN (21,FILE=FTRAJ,STATUS='OLD',FORM='UNFORMATTED')
C	OPEN (21,FILE=FTRAJ,STATUS='OLD',FORM='FORMATTED')
C	OPEN (41,FILE='TEST',STATUS='UNKNOWN',FORM='FORMATTED')
#endif
	READ (21) N0,RLAU,ENERGY1
	READ (21) RLA1,RK,GA0,BETA0
	READ (21) BETAX0,BETAY0,BETAZ0
	READ (21) B0,ER,RLEN,NPoint,rb0dumm
	READ (21) PHI_E,THE_E	!Initial velocity angles for EPATH
C
C  This is the part for the (N-1) periods of ideal sinusoidal trajectory.
C
	READ (21) TAU,Z0,ZSTEP
	DO 19 I = 1,NPoint
C	   WRITE(41,*) I
	   READ (21) XOFZ(I),YOFZ,Z(I)
C	   WRITE(41,*) XOFZ(I),YOFZ,Z(I)
	   READ (21) BETAX(I),BETAY,BETAZ(I)
C	   WRITE(41,*) BETAX(I),BETAY,BETAZ(I)
	   READ (21) TOFZ(I),BETAZPRIME
C	   WRITE(41,*) TOFZ(I),BETAZPRIME
19	CONTINUE	
C
C  Now the part for the two ends of the undulator.
C
C	NC 	= 0.5*(NPOINT+1)
	READ (21) ETAU, EZ0, EZSTEP, NC
	DO 29 I=1,NC
	   READ (21) XOFZ1(I), YOFZ, Z1(I)
	   READ (21) BETAX1(I), BETAY, BETAZ1(I)
	   READ (21) TOFZ1(I), BETAZPRIME
29	CONTINUE

	DO 39 I = 1,NC
	   READ (21) XOFZ2(I), YOFZ, Z2(I)
	   READ (21) BETAX2(I), BETAY, BETAZ2(I)
	   READ (21) TOFZ2(I), BETAZPRIME
	   Z2(I)	= Z2(I) + (NCOMP-1)*RLAU
	   TOFZ2(I)	= TOFZ2(I) + (NCOMP-1)*TAU
39	CONTINUE
	CLOSE (21)
	CLOSE (41)
C
	RETURN
	END

