C +++
C
C Source: src/source/id/undul_shadow_io.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: undul_shadow_io.F
C Revision 1.4  1991/07/06  20:03:58  khan
C Grenoble and after. Minor changes
C
C Revision 1.3  90/10/30  00:01:47  khan
C Fix Ultrix -> VMS things that got screwed up in VMS -> Ultrix.
C 
C Revision 1.2  90/07/17  23:04:55  khan
C Fixed STATUS=NEW in OPEN statements to UNKNOWN for Unix.
C Substitue pre_rad.blk for PRE_RAD.BLK
C 
C Revision 1.1  90/07/17  15:36:39  khan
C Initial revision
C 
C 
C ---

C+++
C	SUBROUTINE		UNDUL_SHADOW_IO
C
C	PURPOSE			Act as a user friendly input routine 
C				to obtain parameters otherwise defined
C				using a NAMELIST file
C
C	INPUT			see NAMELIST
C
C	OUTPUT			Parameters passed through COMMON block
C
C---
	SUBROUTINE 		UNDUL_SHADOW_IO

	IMPLICIT REAL*8		(A-H,O-Z)
	CHARACTER *80 		RSTRING
C
#if defined(unix) || HAVE_F77_CPP
#	include 	"pre_rad.blk"
#elif defined(vms)
	INCLUDE		'PRE_RAD.BLK/LIST'
#endif
C
	DATA	PI	/  3.1415 92653 58979 32384 62643 D0 /
	DATA	PIHALF	/  1.5707 96326 79489 66192 31322 D0 /
	DATA	TWOPI	/  6.2831 85307 17958 64769 25287 D0 /
	DATA	TODEG	/ 57.2957 79513 08232 08767 98155 D0 /
	DATA	TORAD	/  0.0174 53292 51994 32957 69237 D0 /
	DATA	TOCM	/  1.239 852    D-4		     /
	DATA	TOANGS	/  1.239 852    D+4		     /
C
	c     = 2.998D8		!M/SEC
	e     = 1.602D-19	!COULOMB
	h     = 6.626D-34	!PLANCK'S CONSTANT  JOULE*SEC
	hh    = H/E		!  "         "	    eV*sec
	hbar  = H/TWOPI		!  "         "      joule*sec
	hhbar = HH/TWOPI	!  "	     "	    eV*sec
     	EPSI    = 8.854D-12	!FARAD/METER
     	EPSI_FAC = 16.0D0*PI**3*EPSI*C
     	EPSI_FAC = 1/EPSI_FAC	! {4 pi epsi_0 * 4 pi^2}
C
C Internal or external computation base
C
	WRITE(6,*) 'Computation done by :'
	WRITE(6,*) '       supplied program        (0)'
	WRITE(6,*) '       user''s program          (1)'
	IEXTERNAL	= IRINT ('Choice : ')
C
     	WRITE(6,*) ' '
     	WRITE(6,*) '----------------------------',
     $'-----------------------------------------------'
     	WRITE(6,*) ' '
	WRITE(6,*) ' '
	WRITE(6,*) 'Define Radiation Computational parameters:'
	WRITE(6,*) ' '
	WRITE(6,*) 'Polar coordinate is used here.'
	NE	= IRINT ('Number of points in energy (51 max) : ')
	NT	= IRINT ('                     theta (31 max) : ')
	NP	= IRINT ('                       phi (31 max) : ')
     	WRITE(6,*) ' '
     	WRITE(6,*) '----------------------------',
     $'-----------------------------------------------'
     	WRITE(6,*) ' '
C
C  read file generated from EPATH
C
     	  WRITE(6,*) '----------------------------',
     $'-----------------------------------------------'
     	  WRITE(6,*) ' '
	  FTRAJ   = 
     $ RSTRING('Enter name of trajectory file from EPATH (input ):')
     	  WRITE(6,*) ' '
     	  WRITE(6,*) '----------------------------',
     $'-----------------------------------------------'
C
C Read in trajectory file
C
	  CALL	UREAD
C
C Let the user know the parameters from the trajectory file.
C
	  WRITE(6,*) ' '
     	  WRITE(6,*) 'Undulator case.'
	  WRITE(6,*) 
     $	  'Trajectory computed by EPATH with following parameters:'
	  WRITE(6,*) ' '
     	  WRITE(6,*) 'Number of points       :',NPoint
	  WRITE(6,*) 'Undulator wavelength   :',RLAU,'  meters'
	  WRITE(6,*) 'Deflection parameter   :',RK
	  WRITE(6,*) 'Peak magnetic field    :',B0,'  tesla'
	  WRITE(6,*) 'Electron energy	       :',ER/1.602D-19/1.D9,
     $	  '  GeV'
	  WRITE(6,*) 'Gamma		       :',GA0
     	  WRITE(6,*) '******'
	  WRITE(6,*) 'Fundamental energy     :',ENERGY1/1.602D-19,'  eV'
	  WRITE(6,*) 'Fundamental wavelength :',RLA1*1.0d10,'  Angstrom'
     	  WRITE(6,*) '******'
C
C  band pass case:  energy range: EMIN,EMAX,ESTEP
C
     	WRITE(6,*) ' '
     	WRITE(6,*) '----------------------------',
     $'-----------------------------------------------'
     	WRITE(6,*) ' Parameters for Radiation Computation.'
	IF (IEXTERNAL.EQ.0) WRITE(6,*) 
     $ 'Please note value of first harmonic from above table.'
	WRITE(6,*) ' '
     	NCOMP	= IRINT  ('  Enter number of periods: ')
	EMIN    = RNUMBER('        spectrum starting energy [ eV ] : ')
	EMAX    = RNUMBER('                 final           [ eV ] : ')
     	RCURR	= RNUMBER('        electron current         [ A  ] : ')
C
C Sets ICOMP to # of photons per energy interval (=1), bandpass case is (=0).
C
     	ICOMP	= 1
C
C Selects polar angles (=1), cartesian angle (=2).
C
     	IANGLE	= 1
C
C Region in which to generate angles (first quadrant of x',z')
C
     	IAPERTURE = 2
C
     	   THEMAX = RNUMBER
     $ ('Maximum angle between radiation and undulator axis [ mrad ]: ')
	   THEMIN    = 0.0d0
C
C     	   WRITE(6,*) 'Maximum angle between radiation and undulator axis 
C     $ NORMAL to undulator plane (i.e., parallel to magnetic field) '
C     	   WRITE(6,*) '(i.e., in the vertical plane)'
	   PHIMIN    = 0.0d0
	   PHIMAX    = PIHALF
C
C  convert units (mrad to rad)
C
	THEMAX   = THEMAX*1.D-3
C
C No. of optimization
C
	WRITE(6,*) 'All undulator parameters defined.'
	IOPT	= IRINT	('How many times of optimization ? ')

	RETURN
	END
